/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.debughelpers.OpsDebugKt;
import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.FormattingOptions;
import com.facebook.ktfmt.format.KotlinInput;
import com.facebook.ktfmt.format.KotlinInputAstVisitor;
import com.facebook.ktfmt.format.ParseError;
import com.facebook.ktfmt.format.Parser;
import com.facebook.ktfmt.format.RedundantElementRemover;
import com.facebook.ktfmt.format.WhitespaceTombstones;
import com.facebook.ktfmt.kdoc.Escaping;
import com.facebook.ktfmt.kdoc.KDocCommentsHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineColumn;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/ktfmt/format/Formatter;", "", "()V", "DROPBOX_FORMAT", "Lcom/facebook/ktfmt/format/FormattingOptions;", "GOOGLE_FORMAT", "KOTLINLANG_FORMAT", "MINIMUM_KOTLIN_VERSION", "Lkotlin/KotlinVersion;", "checkEscapeSequences", "", "code", "", "createAstVisitor", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElementVisitor;", "options", "builder", "Lcom/google/googlejavaformat/OpsBuilder;", "format", "removeUnusedImports", "", "prettyPrint", "lineSeparator", "sortedAndDistinctImports", "ktfmt"})
public final class Formatter {
    @NotNull
    public static final Formatter INSTANCE = new Formatter();
    @JvmField
    @NotNull
    public static final FormattingOptions GOOGLE_FORMAT = new FormattingOptions(FormattingOptions.Style.GOOGLE, 0, 2, 2, false, false, 50, null);
    @JvmField
    @NotNull
    public static final FormattingOptions KOTLINLANG_FORMAT = new FormattingOptions(FormattingOptions.Style.GOOGLE, 0, 4, 4, false, false, 50, null);
    @JvmField
    @NotNull
    public static final FormattingOptions DROPBOX_FORMAT = new FormattingOptions(FormattingOptions.Style.DROPBOX, 0, 4, 4, false, false, 50, null);
    @NotNull
    private static final KotlinVersion MINIMUM_KOTLIN_VERSION = new KotlinVersion(1, 4);

    private Formatter() {
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull String code) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return Formatter.format(new FormattingOptions(null, 0, 0, 0, false, false, 63, null), code);
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull String code, boolean removeUnusedImports) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return Formatter.format(new FormattingOptions(null, 0, 0, 0, removeUnusedImports, false, 47, null), code);
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull FormattingOptions options, @NotNull String code) throws FormatterException, ParseError {
        String string;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        INSTANCE.checkEscapeSequences(code);
        String string2 = StringUtilRt.convertLineSeparators((String)code);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(code)");
        String lfCode = string2;
        String sortedImports = INSTANCE.sortedAndDistinctImports(lfCode);
        String pretty = INSTANCE.prettyPrint(sortedImports, options, "\n");
        try {
            string = RedundantElementRemover.INSTANCE.dropRedundantElements(pretty, options);
        }
        catch (ParseError e) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Failed to re-parse code after pretty printing:\n ", (Object)pretty), e);
        }
        String noRedundantElements = string;
        String string3 = Newlines.guessLineSeparator((String)code);
        Intrinsics.checkNotNull((Object)string3);
        return INSTANCE.prettyPrint(noRedundantElements, options, string3);
    }

    private final String prettyPrint(String code, FormattingOptions options, String lineSeparator) {
        KtFile file = Parser.Companion.parse(code);
        KotlinInput kotlinInput = new KotlinInput(code, file);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, (Input)kotlinInput, (CommentsHelper)new KDocCommentsHelper(lineSeparator, options.getMaxWidth()));
        OpsBuilder builder = new OpsBuilder((Input)kotlinInput, (Output)javaOutput);
        file.accept(this.createAstVisitor(options, builder));
        builder.sync(kotlinInput.getText().length());
        builder.drain();
        ImmutableList ops = builder.build();
        if (options.getDebuggingPrintOpsAfterFormatting()) {
            Intrinsics.checkNotNullExpressionValue((Object)ops, (String)"ops");
            OpsDebugKt.printOps((ImmutableList<Op>)ops);
        }
        Doc doc = new DocBuilder().withOps((List)ops).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.getMaxWidth(), new Doc.State(0, 0));
        doc.write((Output)javaOutput);
        javaOutput.flush();
        Object object = ImmutableList.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(code.length())));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"of(Range.closedOpen(0, code.length))");
        RangeSet<Integer> tokenRangeSet = kotlinInput.characterRangesToTokenRanges((Collection)object);
        object = JavaOutput.applyReplacements((String)code, (List)((List)javaOutput.getFormatReplacements(tokenRangeSet)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"applyReplacements(code, \u2026lacements(tokenRangeSet))");
        return WhitespaceTombstones.INSTANCE.replaceTombstoneWithTrailingWhitespace((String)object);
    }

    private final PsiElementVisitor createAstVisitor(FormattingOptions options, OpsBuilder builder) {
        if (KotlinVersion.CURRENT.compareTo(MINIMUM_KOTLIN_VERSION) < 0) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported runtime Kotlin version: ", (Object)KotlinVersion.CURRENT));
        }
        return (PsiElementVisitor)new KotlinInputAstVisitor(options, builder);
    }

    private final void checkEscapeSequences(String code) {
        int index = WhitespaceTombstones.INSTANCE.indexOfWhitespaceTombstone(code);
        if (index == -1) {
            index = Escaping.INSTANCE.indexOfCommentEscapeSequences(code);
        }
        if (index != -1) {
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)code, (int)index);
            Intrinsics.checkNotNullExpressionValue((Object)lineColumn, (String)"offsetToLineColumn(code, index)");
            throw new ParseError("ktfmt does not support code which contains one of {\\u0003, \\u0004, \\u0005} character; escape it", lineColumn);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String sortedAndDistinctImports(String code) {
        void $this$distinctBy$iv;
        KtFile file = Parser.Companion.parse(code);
        KtImportList ktImportList = file.getImportList();
        if (ktImportList == null) {
            return code;
        }
        KtImportList importList = ktImportList;
        if (importList.getImports().isEmpty()) {
            return code;
        }
        List commentList = new ArrayList();
        for (PsiElement element = importList.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiComment) {
                commentList.add(element);
                continue;
            }
            if (element instanceof KtImportDirective || element instanceof PsiWhiteSpace) continue;
            String string = Intrinsics.stringPlus((String)"Imports not contiguous: ", (Object)element.getText());
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)code, (int)PsiUtilsKt.getStartOffset((PsiElement)element));
            Intrinsics.checkNotNullExpressionValue((Object)lineColumn, (String)"offsetToLineColumn(code, element.startOffset)");
            throw new ParseError(string, lineColumn);
        }
        List list = importList.getImports();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"importList.imports");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KtImportDirective p0 = (KtImportDirective)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)Formatter.access$sortedAndDistinctImports$canonicalText(p0));
                p0 = (KtImportDirective)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)Formatter.access$sortedAndDistinctImports$canonicalText(p0))));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtImportDirective p0 = (KtImportDirective)e$iv;
            boolean bl = false;
            String key$iv = Formatter.sortedAndDistinctImports$canonicalText(p0);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List sortedImports = list$iv;
        List importsWithComments = CollectionsKt.plus((Collection)commentList, (Iterable)sortedImports);
        String string = code;
        int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)importList));
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)importList));
        CharSequence charSequence = Intrinsics.stringPlus((String)CollectionsKt.joinToString$default((Iterable)importsWithComments, (CharSequence)"\n", null, null, (int)0, null, (Function1)sortedAndDistinctImports.1.INSTANCE, (int)30, null), (Object)"\n");
        return ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)charSequence)).toString();
    }

    private static final String sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        String string;
        FqName fqName = importDirective.getImportedFqName();
        StringBuilder stringBuilder = new StringBuilder().append(fqName == null ? null : fqName.asString()).append(' ');
        KtImportAlias ktImportAlias = importDirective.getAlias();
        if (ktImportAlias == null) {
            string = null;
        } else {
            String string2 = ktImportAlias.getText();
            string = string2 == null ? null : StringsKt.replace$default((String)string2, (String)"`", (String)"", (boolean)false, (int)4, null);
        }
        return stringBuilder.append((Object)string).append(' ').append(importDirective.isAllUnder() ? "*" : "").toString();
    }

    public static final /* synthetic */ String access$sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        return Formatter.sortedAndDistinctImports$canonicalText(importDirective);
    }
}

