/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.cli;

import com.facebook.ktfmt.cli.Main;
import com.facebook.ktfmt.cli.ParsedArgs;
import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.ParseError;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/ktfmt/cli/Main;", "", "input", "Ljava/io/InputStream;", "out", "Ljava/io/PrintStream;", "err", "args", "", "", "(Ljava/io/InputStream;Ljava/io/PrintStream;Ljava/io/PrintStream;[Ljava/lang/String;)V", "parsedArgs", "Lcom/facebook/ktfmt/cli/ParsedArgs;", "format", "", "file", "Ljava/io/File;", "handleParseError", "", "fileName", "e", "Lcom/facebook/ktfmt/format/ParseError;", "run", "", "Companion", "ktfmt"})
public final class Main {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream input;
    @NotNull
    private final PrintStream out;
    @NotNull
    private final PrintStream err;
    @NotNull
    private final ParsedArgs parsedArgs;

    public Main(@NotNull InputStream input, @NotNull PrintStream out, @NotNull PrintStream err, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(out, "out");
        Intrinsics.checkNotNullParameter(err, "err");
        Intrinsics.checkNotNullParameter(args2, "args");
        this.input = input;
        this.out = out;
        this.err = err;
        this.parsedArgs = ParsedArgs.Companion.processArgs(this.err, args2);
    }

    public final int run() {
        if (this.parsedArgs.getFileNames().isEmpty()) {
            this.err.println("Usage: ktfmt [--dropbox-style | --google-style | --kotlinlang-style] [--dry-run] [--set-exit-if-changed] File1.kt File2.kt ...");
            this.err.println("Or: ktfmt @file");
            return 1;
        }
        if (this.parsedArgs.getFileNames().size() == 1 && Intrinsics.areEqual(this.parsedArgs.getFileNames().get(0), "-")) {
            int alreadyFormatted;
            try {
                alreadyFormatted = this.format(null);
                alreadyFormatted = alreadyFormatted == 0 && this.parsedArgs.getSetExitIfChanged() ? 1 : 0;
            }
            catch (Exception e) {
                alreadyFormatted = 1;
            }
            return alreadyFormatted;
        }
        List<File> files2 = null;
        try {
            files2 = Companion.expandArgsToFileNames(this.parsedArgs.getFileNames());
        }
        catch (IllegalStateException e) {
            this.err.println(e.getMessage());
            return 1;
        }
        if (files2.isEmpty()) {
            this.err.println("Error: no .kt files found");
            return 1;
        }
        AtomicInteger retval = new AtomicInteger(0);
        files2.parallelStream().forEach(arg_0 -> Main.run$lambda-0(this, retval, arg_0));
        return retval.get();
    }

    private final boolean format(File file2) {
        String string2;
        File file3 = file2;
        if (file3 == null) {
            string2 = "<stdin>";
        } else {
            string2 = file3.toString();
            if (string2 == null) {
                string2 = "<stdin>";
            }
        }
        String fileName = string2;
        try {
            File file4 = file2;
            String string3 = file4 == null ? null : FilesKt.readText$default(file4, null, 1, null);
            if (string3 == null) {
                string3 = TextStreamsKt.readText(new BufferedReader(new InputStreamReader(this.input)));
            }
            String code = string3;
            String formattedCode = Formatter.format(this.parsedArgs.getFormattingOptions(), code);
            boolean alreadyFormatted = Intrinsics.areEqual(code, formattedCode);
            if (file2 == null) {
                if (this.parsedArgs.getDryRun()) {
                    if (!alreadyFormatted) {
                        this.out.println("<stdin>");
                    }
                } else {
                    this.out.print(formattedCode);
                }
                return alreadyFormatted;
            }
            if (this.parsedArgs.getDryRun()) {
                if (!alreadyFormatted) {
                    this.out.println(fileName);
                }
            } else {
                if (!alreadyFormatted) {
                    FilesKt.writeText$default(file2, formattedCode, null, 2, null);
                }
                this.err.println(Intrinsics.stringPlus("Done formatting ", fileName));
            }
            return alreadyFormatted;
        }
        catch (IOException e) {
            this.err.println("Error formatting " + fileName + ": " + e.getMessage() + "; skipping.");
            throw e;
        }
        catch (ParseError e) {
            this.handleParseError(fileName, e);
            throw e;
        }
        catch (FormattingError e) {
            for (FormatterDiagnostic diagnostic : e.diagnostics()) {
                System.err.println(fileName + ':' + diagnostic);
            }
            e.printStackTrace(this.err);
            throw e;
        }
    }

    private final void handleParseError(String fileName, ParseError e) {
        this.err.println(fileName + ':' + e.getMessage());
    }

    private static final void run$lambda-0(Main this$0, AtomicInteger $retval, File it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($retval, "$retval");
        try {
            if (!this$0.format(it) && this$0.parsedArgs.getSetExitIfChanged()) {
                $retval.set(1);
            }
        }
        catch (Exception e) {
            $retval.set(1);
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004J\u001b\u0010\b\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/facebook/ktfmt/cli/Main$Companion;", "", "()V", "expandArgsToFileNames", "", "Ljava/io/File;", "args", "", "main", "", "", "([Ljava/lang/String;)V", "ktfmt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            Closeable closeable = System.in;
            Intrinsics.checkNotNullExpressionValue(closeable, "`in`");
            InputStream inputStream = closeable;
            closeable = System.out;
            Intrinsics.checkNotNullExpressionValue(closeable, "out");
            Closeable closeable2 = closeable;
            closeable = System.err;
            Intrinsics.checkNotNullExpressionValue(closeable, "err");
            System.exit(new Main(inputStream, (PrintStream)closeable2, (PrintStream)closeable, args2).run());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        @NotNull
        public final List<File> expandArgsToFileNames(@NotNull List<String> args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            if (args2.size() == 1 && new File(args2.get(0)).isFile()) {
                return CollectionsKt.listOf(new File(args2.get(0)));
            }
            List result2 = new ArrayList();
            for (String arg : args2) {
                if (Intrinsics.areEqual(arg, "-")) {
                    throw new IllegalStateException("Error: '-', which causes ktfmt to read from stdin, should not be mixed with file name".toString());
                }
                CollectionsKt.addAll((Collection)result2, SequencesKt.filter(FilesKt.walkTopDown(new File(arg)), expandArgsToFileNames.1.INSTANCE));
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

