/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.debughelpers.OpsDebugKt;
import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.FormattingOptions;
import com.facebook.ktfmt.format.KotlinInput;
import com.facebook.ktfmt.format.KotlinInputAstVisitor;
import com.facebook.ktfmt.format.ParseError;
import com.facebook.ktfmt.format.Parser;
import com.facebook.ktfmt.format.RedundantElementRemover;
import com.facebook.ktfmt.format.WhitespaceTombstones;
import com.facebook.ktfmt.kdoc.Escaping;
import com.facebook.ktfmt.kdoc.KDocCommentsHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.Replacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.LineColumn;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/ktfmt/format/Formatter;", "", "()V", "DROPBOX_FORMAT", "Lcom/facebook/ktfmt/format/FormattingOptions;", "GOOGLE_FORMAT", "KOTLINLANG_FORMAT", "MINIMUM_KOTLIN_VERSION", "Lkotlin/KotlinVersion;", "checkEscapeSequences", "", "code", "", "createAstVisitor", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElementVisitor;", "options", "builder", "Lcom/google/googlejavaformat/OpsBuilder;", "format", "removeUnusedImports", "", "prettyPrint", "lineSeparator", "sortedAndDistinctImports", "ktfmt"})
public final class Formatter {
    @NotNull
    public static final Formatter INSTANCE = new Formatter();
    @JvmField
    @NotNull
    public static final FormattingOptions GOOGLE_FORMAT = new FormattingOptions(FormattingOptions.Style.GOOGLE, 0, 2, 2, false, false, 50, null);
    @JvmField
    @NotNull
    public static final FormattingOptions KOTLINLANG_FORMAT = new FormattingOptions(FormattingOptions.Style.GOOGLE, 0, 4, 4, false, false, 50, null);
    @JvmField
    @NotNull
    public static final FormattingOptions DROPBOX_FORMAT = new FormattingOptions(FormattingOptions.Style.DROPBOX, 0, 4, 4, false, false, 50, null);
    @NotNull
    private static final KotlinVersion MINIMUM_KOTLIN_VERSION = new KotlinVersion(1, 4);

    private Formatter() {
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull String code) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter(code, "code");
        return Formatter.format(new FormattingOptions(null, 0, 0, 0, false, false, 63, null), code);
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull String code, boolean removeUnusedImports2) throws FormatterException, ParseError {
        Intrinsics.checkNotNullParameter(code, "code");
        return Formatter.format(new FormattingOptions(null, 0, 0, 0, removeUnusedImports2, false, 47, null), code);
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull FormattingOptions options, @NotNull String code) throws FormatterException, ParseError {
        String string2;
        List<String> list2;
        String[] stringArray;
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(code, "code");
        if (StringsKt.startsWith$default(code, "#!", false, 2, null)) {
            stringArray = (String[])code;
            Regex regex = new Regex("\n");
            int n = 2;
            list2 = regex.split((CharSequence)stringArray, n);
        } else {
            stringArray = new String[]{"", code};
            list2 = CollectionsKt.listOf(stringArray);
        }
        List<String> list3 = list2;
        String shebang = list3.get(0);
        String kotlinCode = list3.get(1);
        INSTANCE.checkEscapeSequences(kotlinCode);
        String string3 = StringUtilRt.convertLineSeparators(kotlinCode);
        Intrinsics.checkNotNullExpressionValue(string3, "convertLineSeparators(kotlinCode)");
        String lfCode = string3;
        String sortedImports = INSTANCE.sortedAndDistinctImports(lfCode);
        String pretty = INSTANCE.prettyPrint(sortedImports, options, "\n");
        try {
            string2 = RedundantElementRemover.INSTANCE.dropRedundantElements(pretty, options);
        }
        catch (ParseError e) {
            throw new IllegalStateException(Intrinsics.stringPlus("Failed to re-parse code after pretty printing:\n ", pretty), e);
        }
        String noRedundantElements = string2;
        String string4 = Newlines.guessLineSeparator(kotlinCode);
        Intrinsics.checkNotNull(string4);
        String prettyCode = INSTANCE.prettyPrint(noRedundantElements, options, string4);
        return ((CharSequence)shebang).length() > 0 ? shebang + '\n' + prettyCode : prettyCode;
    }

    private final String prettyPrint(String code, FormattingOptions options, String lineSeparator) {
        KtFile file2 = Parser.INSTANCE.parse(code);
        KotlinInput kotlinInput = new KotlinInput(code, file2);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, kotlinInput, new KDocCommentsHelper(lineSeparator, options.getMaxWidth()));
        OpsBuilder builder2 = new OpsBuilder(kotlinInput, javaOutput);
        file2.accept(this.createAstVisitor(options, builder2));
        builder2.sync(kotlinInput.getText().length());
        builder2.drain();
        ImmutableList<Op> ops = builder2.build();
        if (options.getDebuggingPrintOpsAfterFormatting()) {
            Intrinsics.checkNotNullExpressionValue(ops, "ops");
            OpsDebugKt.printOps(ops);
        }
        Doc doc = new DocBuilder().withOps((List<Op>)ops).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.getMaxWidth(), new Doc.State(0, 0));
        doc.write(javaOutput);
        javaOutput.flush();
        Object object = ImmutableList.of(Range.closedOpen(0, code.length()));
        Intrinsics.checkNotNullExpressionValue(object, "of(Range.closedOpen(0, code.length))");
        RangeSet<Integer> tokenRangeSet = kotlinInput.characterRangesToTokenRanges((Collection)object);
        object = JavaOutput.applyReplacements(code, (List<Replacement>)javaOutput.getFormatReplacements(tokenRangeSet));
        Intrinsics.checkNotNullExpressionValue(object, "applyReplacements(code, \u2026lacements(tokenRangeSet))");
        return WhitespaceTombstones.INSTANCE.replaceTombstoneWithTrailingWhitespace((String)object);
    }

    private final PsiElementVisitor createAstVisitor(FormattingOptions options, OpsBuilder builder2) {
        if (KotlinVersion.CURRENT.compareTo(MINIMUM_KOTLIN_VERSION) < 0) {
            throw new RuntimeException(Intrinsics.stringPlus("Unsupported runtime Kotlin version: ", KotlinVersion.CURRENT));
        }
        return new KotlinInputAstVisitor(options, builder2);
    }

    private final void checkEscapeSequences(String code) {
        int index2 = WhitespaceTombstones.INSTANCE.indexOfWhitespaceTombstone(code);
        if (index2 == -1) {
            index2 = Escaping.INSTANCE.indexOfCommentEscapeSequences(code);
        }
        if (index2 != -1) {
            LineColumn lineColumn = StringUtil.offsetToLineColumn(code, index2);
            Intrinsics.checkNotNullExpressionValue(lineColumn, "offsetToLineColumn(code, index)");
            throw new ParseError("ktfmt does not support code which contains one of {\\u0003, \\u0004, \\u0005} character; escape it", lineColumn);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String sortedAndDistinctImports(String code) {
        void $this$distinctBy$iv;
        KtFile file2 = Parser.INSTANCE.parse(code);
        KtImportList ktImportList = file2.getImportList();
        if (ktImportList == null) {
            return code;
        }
        KtImportList importList = ktImportList;
        if (importList.getImports().isEmpty()) {
            return code;
        }
        List commentList = new ArrayList();
        for (PsiElement element = importList.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiComment) {
                commentList.add(element);
                continue;
            }
            if (element instanceof KtImportDirective || element instanceof PsiWhiteSpace) continue;
            String string2 = Intrinsics.stringPlus("Imports not contiguous: ", element.getText());
            LineColumn lineColumn = StringUtil.offsetToLineColumn(code, PsiUtilsKt.getStartOffset(element));
            Intrinsics.checkNotNullExpressionValue(lineColumn, "offsetToLineColumn(code, element.startOffset)");
            throw new ParseError(string2, lineColumn);
        }
        List<KtImportDirective> list2 = importList.getImports();
        Intrinsics.checkNotNullExpressionValue(list2, "importList.imports");
        Iterable $this$sortedBy$iv = list2;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                KtImportDirective p0 = (KtImportDirective)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)Formatter.access$sortedAndDistinctImports$canonicalText(p0));
                p0 = (KtImportDirective)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)Formatter.access$sortedAndDistinctImports$canonicalText(p0)));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtImportDirective p0 = (KtImportDirective)e$iv;
            boolean bl = false;
            String key$iv = Formatter.sortedAndDistinctImports$canonicalText(p0);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List sortedImports = list$iv;
        List importsWithComments = CollectionsKt.plus((Collection)commentList, (Iterable)sortedImports);
        String string3 = code;
        int n = PsiUtilsKt.getStartOffset(importList);
        int n2 = PsiUtilsKt.getEndOffset(importList);
        CharSequence charSequence2 = Intrinsics.stringPlus(CollectionsKt.joinToString$default(importsWithComments, "\n", null, null, 0, null, sortedAndDistinctImports.1.INSTANCE, 30, null), "\n");
        return ((Object)StringsKt.replaceRange((CharSequence)string3, n, n2, charSequence2)).toString();
    }

    private static final String sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        String string2;
        FqName fqName2 = importDirective.getImportedFqName();
        StringBuilder stringBuilder2 = new StringBuilder().append(fqName2 == null ? null : fqName2.asString()).append(' ');
        KtImportAlias ktImportAlias = importDirective.getAlias();
        if (ktImportAlias == null) {
            string2 = null;
        } else {
            String string3 = ktImportAlias.getText();
            string2 = string3 == null ? null : StringsKt.replace$default(string3, "`", "", false, 4, null);
        }
        return stringBuilder2.append((Object)string2).append(' ').append(importDirective.isAllUnder() ? "*" : "").toString();
    }

    public static final /* synthetic */ String access$sortedAndDistinctImports$canonicalText(KtImportDirective importDirective) {
        return Formatter.sortedAndDistinctImports$canonicalText(importDirective);
    }
}

