/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.KotlinTok;
import com.facebook.ktfmt.format.KotlinToken;
import com.facebook.ktfmt.format.Tokenizer;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001dJ \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001a0!J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0016J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J\u0016\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0010H\u0016J\b\u0010'\u001a\u00020\u0003H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010)\u001a\u00020\bH\u0016J\u0010\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0012H\u0016J\b\u0010+\u001a\u00020\bH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\"\u00100\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/facebook/ktfmt/format/KotlinInput;", "Lcom/google/googlejavaformat/Input;", "text", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFile;)V", "kN", "", "kToToken", "", "Lcom/google/googlejavaformat/Input$Token;", "[Lcom/google/googlejavaformat/Input$Token;", "positionToColumnMap", "Lcom/google/common/collect/ImmutableMap;", "positionTokenMap", "Lcom/google/common/collect/ImmutableRangeMap;", "tokens", "Lcom/google/common/collect/ImmutableList;", "buildTokens", "toks", "", "Lcom/facebook/ktfmt/format/KotlinTok;", "buildToks", "fileText", "characterRangeToTokenRange", "Lcom/google/common/collect/Range;", "offset", "length", "characterRangeToTokenRange$ktfmt", "characterRangesToTokenRanges", "Lcom/google/common/collect/RangeSet;", "characterRanges", "", "getColumnNumber", "inputPosition", "getLineNumber", "getPositionToColumnMap", "getPositionTokenMap", "getText", "getToken", "k", "getTokens", "getkN", "isParamComment", "", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "makePositionToColumnMap", "ktfmt"})
public final class KotlinInput
extends Input {
    @NotNull
    private final String text;
    @NotNull
    private final ImmutableList<Input.Token> tokens;
    @NotNull
    private final ImmutableMap<Integer, Integer> positionToColumnMap;
    @NotNull
    private final ImmutableRangeMap<Integer, Input.Token> positionTokenMap;
    private int kN;
    @NotNull
    private final Input.Token[] kToToken;

    public KotlinInput(@NotNull String text2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(file2, "file");
        this.text = text2;
        this.setLines(ImmutableList.copyOf(Newlines.lineIterator(this.text)));
        ImmutableList<KotlinTok> toks = this.buildToks(file2, this.text);
        this.positionToColumnMap = this.makePositionToColumnMap((List<KotlinTok>)toks);
        this.tokens = this.buildTokens((List<KotlinTok>)toks);
        ImmutableRangeMap.Builder<Comparable, Input.Token> tokenLocations = ImmutableRangeMap.builder();
        for (Input.Token token : this.tokens) {
            Input.Tok end = JavaOutput.endTok(token);
            int n = end.getPosition();
            String string2 = end.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "end.text");
            if (((CharSequence)string2).length() > 0) {
                n += end.length() - 1;
            }
            tokenLocations.put(Range.closed(JavaOutput.startTok(token).getPosition(), n), token);
        }
        ImmutableRangeMap immutableRangeMap = tokenLocations.build();
        Intrinsics.checkNotNullExpressionValue(immutableRangeMap, "tokenLocations.build()");
        this.positionTokenMap = immutableRangeMap;
        this.kToToken = new Input.Token[this.kN + 1];
        for (Input.Token token : this.tokens) {
            for (Input.Tok tok : token.getToksBefore()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
            this.kToToken[token.getTok().getIndex()] = token;
            for (Input.Tok tok : token.getToksAfter()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
        }
    }

    @NotNull
    public final RangeSet<Integer> characterRangesToTokenRanges(@NotNull Collection<Range<Integer>> characterRanges) throws FormatterException {
        Intrinsics.checkNotNullParameter(characterRanges, "characterRanges");
        TreeRangeSet<Integer> tokenRangeSet = TreeRangeSet.create();
        for (Range<Integer> characterRange0 : characterRanges) {
            Range<Integer> characterRange = characterRange0.canonical(DiscreteDomain.integers());
            Integer n = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue(n, "characterRange.lowerEndpoint()");
            int n2 = ((Number)n).intValue();
            int n3 = ((Number)characterRange.upperEndpoint()).intValue();
            n = characterRange.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue(n, "characterRange.lowerEndpoint()");
            tokenRangeSet.add(this.characterRangeToTokenRange$ktfmt(n2, n3 - ((Number)n).intValue()));
        }
        Intrinsics.checkNotNullExpressionValue(tokenRangeSet, "tokenRangeSet");
        return tokenRangeSet;
    }

    @NotNull
    public final Range<Integer> characterRangeToTokenRange$ktfmt(int offset2, int length) throws FormatterException {
        Range<Comparable> range;
        int requiredLength = offset2 + length;
        if (requiredLength > this.text.length()) {
            String string2 = "error: invalid length %d, offset + length (%d) is outside the file";
            Object[] objectArray = new Object[]{length, requiredLength};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            throw new FormatterException(string3);
        }
        if (length < 0) {
            Range range2 = Input.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue(range2, "EMPTY_RANGE");
            return range2;
        }
        int expandedLength = length == 0 ? 1 : length;
        Range<Comparable> range3 = ((ImmutableMap)((ImmutableRangeMap)this.getPositionTokenMap().subRangeMap(Range.closedOpen(offset2, offset2 + expandedLength))).asMapOfRanges()).values();
        Intrinsics.checkNotNullExpressionValue(range3, "getPositionTokenMap()\n  \u2026ges()\n            .values");
        ImmutableCollection enclosed = (ImmutableCollection)((Object)range3);
        if (enclosed.isEmpty()) {
            range3 = Input.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue(range3, "{\n      EMPTY_RANGE\n    }");
            range = range3;
        } else {
            range3 = Range.closedOpen(((Input.Token)enclosed.iterator().next()).getTok().getIndex(), ((Input.Token)Iterables.getLast(enclosed)).getTok().getIndex() + 1);
            Intrinsics.checkNotNullExpressionValue(range3, "closedOpen(\n            \u2026.getTok().getIndex() + 1)");
            range = range3;
        }
        return range;
    }

    private final ImmutableMap<Integer, Integer> makePositionToColumnMap(List<KotlinTok> toks) {
        LinkedHashMap<Integer, Integer> builder2 = new LinkedHashMap<Integer, Integer>();
        for (KotlinTok tok : toks) {
            builder2.put(tok.getPosition(), tok.getColumn());
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)builder2);
        Intrinsics.checkNotNullExpressionValue(immutableMap, "copyOf(builder)");
        return immutableMap;
    }

    private final ImmutableList<KotlinTok> buildToks(KtFile file2, String fileText) {
        Tokenizer tokenizer = new Tokenizer(fileText, file2);
        file2.accept(tokenizer);
        List<KotlinTok> toks = tokenizer.getToks();
        int n = tokenizer.getIndex();
        int n2 = fileText.length();
        Object object = KtTokens.EOF;
        Intrinsics.checkNotNullExpressionValue(object, "EOF");
        toks.add(new KotlinTok(n, "", "", n2, 0, true, (KtToken)object));
        this.kN = tokenizer.getIndex();
        this.computeRanges(toks);
        object = ImmutableList.copyOf((Collection)toks);
        Intrinsics.checkNotNullExpressionValue(object, "copyOf(toks)");
        return object;
    }

    private final ImmutableList<Input.Token> buildTokens(List<KotlinTok> toks) {
        ImmutableList.Builder tokens = ImmutableList.builder();
        int k = 0;
        int kN = toks.size();
        Object object = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue(object, "builder()");
        Object toksBefore = object;
        block0: while (k < kN) {
            Object object2;
            KotlinTok tok;
            int n;
            while (!toks.get(k).isToken()) {
                n = k;
                k = n + 1;
                tok = toks.get(n);
                ((ImmutableList.Builder)toksBefore).add(tok);
                if (!this.isParamComment(tok)) continue;
                while (toks.get(k).isNewline()) {
                    n = k;
                    k = n + 1;
                }
            }
            n = k;
            k = n + 1;
            tok = toks.get(n);
            ImmutableList.Builder toksAfter = ImmutableList.builder();
            while (!(k >= kN || toks.get(k).isToken() || toks.get(k).isSlashStarComment() && (Intrinsics.areEqual(tok.getText(), "(") || Intrinsics.areEqual(tok.getText(), "<") || Intrinsics.areEqual(tok.getText(), ".")) || toks.get(k).isJavadocComment() && Intrinsics.areEqual(tok.getText(), ";"))) {
                int n2;
                if (this.isParamComment(toks.get(k))) {
                    object2 = ((ImmutableList.Builder)toksBefore).build();
                    Intrinsics.checkNotNullExpressionValue(object2, "toksBefore.build()");
                    Object object3 = object2;
                    object2 = toksAfter.build();
                    Intrinsics.checkNotNullExpressionValue(object2, "toksAfter.build()");
                    tokens.add(new KotlinToken((ImmutableList<KotlinTok>)object3, tok, (ImmutableList<KotlinTok>)object2));
                    n2 = k;
                    k = n2 + 1;
                    object2 = ImmutableList.builder().add(toks.get(n2));
                    Intrinsics.checkNotNullExpressionValue(object2, "builder<KotlinTok>().add(toks[k++])");
                    toksBefore = object2;
                    while (toks.get(k).isNewline()) {
                        int n3 = k;
                        k = n3 + 1;
                    }
                    continue block0;
                }
                n2 = k;
                k = n2 + 1;
                KotlinTok nonTokenAfter = toks.get(n2);
                toksAfter.add(nonTokenAfter);
                if (!Newlines.containsBreaks(nonTokenAfter.getText())) continue;
            }
            object2 = ((ImmutableList.Builder)toksBefore).build();
            Intrinsics.checkNotNullExpressionValue(object2, "toksBefore.build()");
            ImmutableCollection immutableCollection = object2;
            object2 = toksAfter.build();
            Intrinsics.checkNotNullExpressionValue(object2, "toksAfter.build()");
            tokens.add(new KotlinToken((ImmutableList<KotlinTok>)immutableCollection, tok, (ImmutableList<KotlinTok>)object2));
            object2 = ImmutableList.builder();
            Intrinsics.checkNotNullExpressionValue(object2, "builder()");
            toksBefore = object2;
        }
        object = tokens.build();
        Intrinsics.checkNotNullExpressionValue(object, "tokens.build()");
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isParamComment(Input.Tok tok) {
        if (!tok.isSlashStarComment()) return false;
        String string2 = tok.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "tok.text");
        CharSequence charSequence2 = string2;
        if (!new Regex("/\\*[A-Za-z0-9\\s_\\-]+=\\s*\\*/").matches(charSequence2)) return false;
        return true;
    }

    @Override
    public int getkN() {
        return this.kN;
    }

    @Override
    @Nullable
    public Input.Token getToken(int k) {
        return this.kToToken[k];
    }

    @Override
    @NotNull
    public ImmutableList<? extends Input.Token> getTokens() {
        return this.tokens;
    }

    @Override
    @NotNull
    public ImmutableRangeMap<Integer, ? extends Input.Token> getPositionTokenMap() {
        return this.positionTokenMap;
    }

    @Override
    @NotNull
    public ImmutableMap<Integer, Integer> getPositionToColumnMap() {
        return this.positionToColumnMap;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    public int getLineNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).line + 1;
    }

    @Override
    public int getColumnNumber(int inputPosition) {
        return StringUtil.offsetToLineColumn((CharSequence)((CharSequence)this.text), (int)inputPosition).column;
    }
}

