/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.FormattingOptions;
import com.facebook.ktfmt.format.Parser;
import com.facebook.ktfmt.format.RedundantElementRemover;
import com.facebook.ktfmt.format.RedundantImportDetector;
import com.facebook.ktfmt.format.RedundantSemicolonDetector;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/ktfmt/format/RedundantElementRemover;", "", "()V", "dropRedundantElements", "", "code", "options", "Lcom/facebook/ktfmt/format/FormattingOptions;", "ktfmt"})
public final class RedundantElementRemover {
    @NotNull
    public static final RedundantElementRemover INSTANCE = new RedundantElementRemover();

    private RedundantElementRemover() {
    }

    @NotNull
    public final String dropRedundantElements(@NotNull String code, @NotNull FormattingOptions options) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(options, "options");
        KtFile file2 = Parser.INSTANCE.parse(code);
        RedundantImportDetector redundantImportDetector = new RedundantImportDetector(options.getRemoveUnusedImports());
        RedundantSemicolonDetector redundantSemicolonDetector = new RedundantSemicolonDetector();
        file2.accept(new KtTreeVisitorVoid(redundantImportDetector, redundantSemicolonDetector){
            final /* synthetic */ RedundantImportDetector $redundantImportDetector;
            final /* synthetic */ RedundantSemicolonDetector $redundantSemicolonDetector;
            {
                this.$redundantImportDetector = $redundantImportDetector;
                this.$redundantSemicolonDetector = $redundantSemicolonDetector;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KDocImpl) {
                    this.$redundantImportDetector.takeKdoc((KDocImpl)element);
                } else {
                    this.$redundantSemicolonDetector.takeElement(element, new Function0<Unit>(this, element){
                        final /* synthetic */ dropRedundantElements.1 this$0;
                        final /* synthetic */ PsiElement $element;
                        {
                            this.this$0 = $receiver;
                            this.$element = $element;
                            super(0);
                        }

                        public final void invoke() {
                            dropRedundantElements.1.access$visitElement$s882885595(this.this$0, this.$element);
                        }
                    });
                }
            }

            public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                Intrinsics.checkNotNullParameter(directive, "directive");
                this.$redundantImportDetector.takePackageDirective(directive, new Function0<Unit>(this, directive){
                    final /* synthetic */ dropRedundantElements.1 this$0;
                    final /* synthetic */ KtPackageDirective $directive;
                    {
                        this.this$0 = $receiver;
                        this.$directive = $directive;
                        super(0);
                    }

                    public final void invoke() {
                        dropRedundantElements.1.access$visitPackageDirective$s882885595(this.this$0, this.$directive);
                    }
                });
            }

            public void visitImportList(@NotNull KtImportList importList) {
                Intrinsics.checkNotNullParameter(importList, "importList");
                this.$redundantImportDetector.takeImportList(importList, new Function0<Unit>(this, importList){
                    final /* synthetic */ dropRedundantElements.1 this$0;
                    final /* synthetic */ KtImportList $importList;
                    {
                        this.this$0 = $receiver;
                        this.$importList = $importList;
                        super(0);
                    }

                    public final void invoke() {
                        dropRedundantElements.1.access$visitImportList$s882885595(this.this$0, this.$importList);
                    }
                });
            }

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.$redundantImportDetector.takeReferenceExpression(expression2);
                super.visitReferenceExpression(expression2);
            }

            public static final /* synthetic */ void access$visitElement$s882885595(dropRedundantElements.1 $this, PsiElement p0) {
                super.visitElement(p0);
            }

            public static final /* synthetic */ void access$visitPackageDirective$s882885595(dropRedundantElements.1 $this, KtPackageDirective p0) {
                super.visitPackageDirective(p0);
            }

            public static final /* synthetic */ void access$visitImportList$s882885595(dropRedundantElements.1 $this, KtImportList p0) {
                super.visitImportList(p0);
            }
        });
        StringBuilder result2 = new StringBuilder(code);
        List elementsToRemove = CollectionsKt.plus((Collection)redundantSemicolonDetector.getRedundantSemicolonElements(), (Iterable)redundantImportDetector.getRedundantImportElements());
        Iterable $this$sortedByDescending$iv = elementsToRemove;
        boolean $i$f$sortedByDescending = false;
        for (PsiElement element : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                PsiElement p0 = (PsiElement)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(PsiUtilsKt.getEndOffset(p0));
                p0 = (PsiElement)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, PsiUtilsKt.getEndOffset(p0));
            }
        })) {
            result2.replace(PsiUtilsKt.getStartOffset(element), PsiUtilsKt.getEndOffset(element), "");
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "result.toString()");
        return string2;
    }
}

