/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.KDocFormatter;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001e\u0010\u000e\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\u001e\u0010\u0011\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocCommentsHelper;", "Lcom/google/googlejavaformat/CommentsHelper;", "lineSeparator", "", "maxLineLength", "", "(Ljava/lang/String;I)V", "LINE_COMMENT_MISSING_SPACE_PREFIX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "indentJavadoc", "lines", "", "column0", "indentLineComments", "javadocShaped", "", "preserveIndentation", "rewrite", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "maxWidth", "wrapLineComments", "ktfmt"})
public final class KDocCommentsHelper
implements CommentsHelper {
    @NotNull
    private final String lineSeparator;
    private final int maxLineLength;
    private final Pattern LINE_COMMENT_MISSING_SPACE_PREFIX;

    public KDocCommentsHelper(@NotNull String lineSeparator, int maxLineLength) {
        Intrinsics.checkNotNullParameter(lineSeparator, "lineSeparator");
        this.lineSeparator = lineSeparator;
        this.maxLineLength = maxLineLength;
        this.LINE_COMMENT_MISSING_SPACE_PREFIX = Pattern.compile("^(//+)(?!noinspection|\\$NON-NLS-\\d+\\$)[^\\s/]");
    }

    @Override
    @NotNull
    public String rewrite(@NotNull Input.Tok tok, int maxWidth, int column0) {
        Intrinsics.checkNotNullParameter(tok, "tok");
        if (!tok.isComment()) {
            String string2 = tok.getOriginalText();
            Intrinsics.checkNotNullExpressionValue(string2, "tok.originalText");
            return string2;
        }
        String text2 = tok.getOriginalText();
        if (tok.isJavadocComment()) {
            String string3 = text2;
            Intrinsics.checkNotNullExpressionValue(string3, "text");
            text2 = KDocFormatter.INSTANCE.formatKDoc(string3, column0, this.maxLineLength);
        }
        ArrayList<String> lines = new ArrayList<String>();
        Iterator<String> it = Newlines.lineIterator(text2);
        while (it.hasNext()) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom(it.next()));
        }
        return tok.isSlashSlashComment() ? this.indentLineComments((List<String>)lines, column0) : (this.javadocShaped((List<String>)lines) ? this.indentJavadoc((List<String>)lines, column0) : this.preserveIndentation((List<String>)lines, column0));
    }

    private final String preserveIndentation(List<String> lines, int column0) {
        int i;
        StringBuilder builder2 = new StringBuilder();
        int startCol = -1;
        int n = 1;
        int n2 = lines.size();
        while (n < n2) {
            i = n++;
            int lineIdx = CharMatcher.whitespace().negate().indexIn(lines.get(i));
            if (lineIdx < 0 || startCol != -1 && lineIdx >= startCol) continue;
            startCol = lineIdx;
        }
        builder2.append(lines.get(0));
        n = 1;
        n2 = lines.size();
        while (n < n2) {
            i = n++;
            builder2.append(this.lineSeparator).append(Strings.repeat(" ", column0));
            if (lines.get(i).length() >= startCol) {
                String string2 = lines.get(i).substring(startCol);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                builder2.append(string2);
                continue;
            }
            builder2.append(lines.get(i));
        }
        String string3 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "builder.toString()");
        return string3;
    }

    private final String indentLineComments(List<String> lines, int column0) {
        List<String> wrappedLines = this.wrapLineComments(lines, column0);
        StringBuilder builder2 = new StringBuilder();
        builder2.append(((Object)StringsKt.trim((CharSequence)wrappedLines.get(0))).toString());
        String indentString = Strings.repeat(" ", column0);
        int n = 1;
        int n2 = wrappedLines.size();
        while (n < n2) {
            int i = n++;
            builder2.append(this.lineSeparator).append(indentString).append(((Object)StringsKt.trim((CharSequence)wrappedLines.get(i))).toString());
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "builder.toString()");
        return string2;
    }

    private final List<String> wrapLineComments(List<String> lines, int column0) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (String originalLine : lines) {
            String string2;
            String line2 = originalLine;
            Matcher matcher2 = this.LINE_COMMENT_MISSING_SPACE_PREFIX.matcher(line2);
            if (matcher2.find()) {
                int length = matcher2.group(1).length();
                StringBuilder stringBuilder2 = new StringBuilder().append(Strings.repeat("/", length)).append(' ');
                string2 = line2.substring(length);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                line2 = stringBuilder2.append(string2).toString();
            }
            if (StringsKt.startsWith$default(line2, "// MOE:", false, 2, null)) {
                result2.add(line2);
                continue;
            }
            while (line2.length() + column0 > 100) {
                int idx = 100 - column0;
                while (idx >= 2 && !CharMatcher.whitespace().matches(line2.charAt(idx))) {
                    int n = idx;
                    idx = n + -1;
                }
                if (idx <= 2) break;
                String string3 = line2;
                int n = 0;
                String string4 = string3.substring(n, idx);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                result2.add(string4);
                string2 = line2.substring(idx);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                line2 = Intrinsics.stringPlus("//", string2);
            }
            result2.add(line2);
        }
        return result2;
    }

    private final String indentJavadoc(List<String> lines, int column0) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(((Object)StringsKt.trim((CharSequence)lines.get(0))).toString());
        int indent = column0 + 1;
        String indentString = Strings.repeat(" ", indent);
        int n = 1;
        int n2 = lines.size();
        while (n < n2) {
            int i = n++;
            builder2.append(this.lineSeparator).append(indentString);
            String line2 = ((Object)StringsKt.trim((CharSequence)lines.get(i))).toString();
            if (!StringsKt.startsWith$default(line2, "*", false, 2, null)) {
                builder2.append("* ");
            }
            builder2.append(line2);
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "builder.toString()");
        return string2;
    }

    private final boolean javadocShaped(List<String> lines) {
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String first = ((Object)StringsKt.trim((CharSequence)it.next())).toString();
        if (StringsKt.startsWith$default(first, "/**", false, 2, null)) {
            return true;
        }
        if (!StringsKt.startsWith$default(first, "/*", false, 2, null)) {
            return false;
        }
        while (it.hasNext()) {
            if (StringsKt.startsWith$default(((Object)StringsKt.trim((CharSequence)it.next())).toString(), "*", false, 2, null)) continue;
            return false;
        }
        return true;
    }
}

