/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Comparator;

@Beta
@GwtCompatible
public final class UnsignedInts {
    static final long INT_MASK = 0xFFFFFFFFL;

    private UnsignedInts() {
    }

    static int flip(int value2) {
        return value2 ^ Integer.MIN_VALUE;
    }

    public static int compare(int a, int b) {
        return Ints.compare(UnsignedInts.flip(a), UnsignedInts.flip(b));
    }

    public static long toLong(int value2) {
        return (long)value2 & 0xFFFFFFFFL;
    }

    public static int checkedCast(long value2) {
        Preconditions.checkArgument(value2 >> 32 == 0L, "out of range: %s", value2);
        return (int)value2;
    }

    public static int saturatedCast(long value2) {
        if (value2 <= 0L) {
            return 0;
        }
        if (value2 >= 0x100000000L) {
            return -1;
        }
        return (int)value2;
    }

    public static int min(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min2 = UnsignedInts.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next = UnsignedInts.flip(array2[i]);
            if (next >= min2) continue;
            min2 = next;
        }
        return UnsignedInts.flip(min2);
    }

    public static int max(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max = UnsignedInts.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next = UnsignedInts.flip(array2[i]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedInts.flip(max);
    }

    public static String join(String separator, int ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder2 = new StringBuilder(array2.length * 5);
        builder2.append(UnsignedInts.toString(array2[0]));
        for (int i = 1; i < array2.length; ++i) {
            builder2.append(separator).append(UnsignedInts.toString(array2[i]));
        }
        return builder2.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(int[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedInts.sort(array2, 0, array2.length);
    }

    public static void sort(int[] array2, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedInts.flip(array2[i]);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedInts.flip(array2[i]);
        }
    }

    public static void sortDescending(int[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedInts.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(int[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = array2[n] ^ Integer.MAX_VALUE;
        }
        Arrays.sort(array2, fromIndex, toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = array2[n] ^ Integer.MAX_VALUE;
        }
    }

    public static int divide(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) / UnsignedInts.toLong(divisor));
    }

    public static int remainder(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) % UnsignedInts.toLong(divisor));
    }

    @CanIgnoreReturnValue
    public static int decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedInts.parseUnsignedInt(request.rawValue, request.radix);
        }
        catch (NumberFormatException e) {
            NumberFormatException decodeException = new NumberFormatException("Error parsing value: " + stringValue);
            decodeException.initCause(e);
            throw decodeException;
        }
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String s2) {
        return UnsignedInts.parseUnsignedInt(s2, 10);
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String string2, int radix) {
        Preconditions.checkNotNull(string2);
        long result2 = Long.parseLong(string2, radix);
        if ((result2 & 0xFFFFFFFFL) != result2) {
            throw new NumberFormatException("Input " + string2 + " in base " + radix + " is not in the range of an unsigned integer");
        }
        return (int)result2;
    }

    public static String toString(int x) {
        return UnsignedInts.toString(x, 10);
    }

    public static String toString(int x, int radix) {
        long asLong = (long)x & 0xFFFFFFFFL;
        return Long.toString(asLong, radix);
    }

    static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left, int[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                if (left[i] == right[i]) continue;
                return UnsignedInts.compare(left[i], right[i]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedInts.lexicographicalComparator()";
        }
    }
}

