/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.Preconditions;

public class FormatterDiagnostic {
    private final int lineNumber;
    private final String message;
    private final int column;

    public static FormatterDiagnostic create(String message2) {
        return new FormatterDiagnostic(-1, -1, message2);
    }

    public static FormatterDiagnostic create(int lineNumber, int column, String message2) {
        Preconditions.checkArgument(lineNumber >= 0);
        Preconditions.checkArgument(column >= 0);
        Preconditions.checkNotNull(message2);
        return new FormatterDiagnostic(lineNumber, column, message2);
    }

    private FormatterDiagnostic(int lineNumber, int column, String message2) {
        this.lineNumber = lineNumber;
        this.column = column;
        this.message = message2;
    }

    public int line() {
        return this.lineNumber;
    }

    public int column() {
        return this.column;
    }

    public String message() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lineNumber >= 0) {
            sb.append(this.lineNumber).append(':');
        }
        if (this.column >= 0) {
            sb.append(this.column + 1).append(':');
        }
        if (this.lineNumber >= 0 || this.column >= 0) {
            sb.append(' ');
        }
        sb.append("error: ").append(this.message);
        return sb.toString();
    }
}

