/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.googlejavaformat.java.CommandLineOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class CommandLineOptionsParser {
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private static final Splitter COLON_SPLITTER = Splitter.on(':');
    private static final Splitter ARG_SPLITTER = Splitter.on(CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();

    CommandLineOptionsParser() {
    }

    static CommandLineOptions parse(Iterable<String> options) {
        CommandLineOptions.Builder optionsBuilder = CommandLineOptions.builder();
        ArrayList<String> expandedOptions = new ArrayList<String>();
        CommandLineOptionsParser.expandParamsFiles(options, expandedOptions);
        Iterator<String> it = expandedOptions.iterator();
        block52: while (it.hasNext()) {
            String value2;
            String flag;
            String option = (String)it.next();
            if (!option.startsWith("-")) {
                ((ImmutableList.Builder)optionsBuilder.filesBuilder().add((Object)option)).addAll(it);
                break;
            }
            int idx = option.indexOf(61);
            if (idx >= 0) {
                flag = option.substring(0, idx);
                value2 = option.substring(idx + 1, option.length());
            } else {
                flag = option;
                value2 = null;
            }
            switch (flag) {
                case "-i": 
                case "-r": 
                case "-replace": 
                case "--replace": {
                    optionsBuilder.inPlace(true);
                    continue block52;
                }
                case "--lines": 
                case "-lines": 
                case "--line": 
                case "-line": {
                    CommandLineOptionsParser.parseRangeSet(optionsBuilder.linesBuilder(), CommandLineOptionsParser.getValue(flag, it, value2));
                    continue block52;
                }
                case "--offset": 
                case "-offset": {
                    optionsBuilder.addOffset(CommandLineOptionsParser.parseInteger(it, flag, value2));
                    continue block52;
                }
                case "--length": 
                case "-length": {
                    optionsBuilder.addLength(CommandLineOptionsParser.parseInteger(it, flag, value2));
                    continue block52;
                }
                case "--aosp": 
                case "-aosp": 
                case "-a": {
                    optionsBuilder.aosp(true);
                    continue block52;
                }
                case "--version": 
                case "-version": 
                case "-v": {
                    optionsBuilder.version(true);
                    continue block52;
                }
                case "--help": 
                case "-help": 
                case "-h": {
                    optionsBuilder.help(true);
                    continue block52;
                }
                case "--fix-imports-only": {
                    optionsBuilder.fixImportsOnly(true);
                    continue block52;
                }
                case "--skip-sorting-imports": {
                    optionsBuilder.sortImports(false);
                    continue block52;
                }
                case "--skip-removing-unused-imports": {
                    optionsBuilder.removeUnusedImports(false);
                    continue block52;
                }
                case "--skip-reflowing-long-strings": {
                    optionsBuilder.reflowLongStrings(false);
                    continue block52;
                }
                case "--skip-javadoc-formatting": {
                    optionsBuilder.formatJavadoc(false);
                    continue block52;
                }
                case "-": {
                    optionsBuilder.stdin(true);
                    continue block52;
                }
                case "-n": 
                case "--dry-run": {
                    optionsBuilder.dryRun(true);
                    continue block52;
                }
                case "--set-exit-if-changed": {
                    optionsBuilder.setExitIfChanged(true);
                    continue block52;
                }
                case "-assume-filename": 
                case "--assume-filename": {
                    optionsBuilder.assumeFilename(CommandLineOptionsParser.getValue(flag, it, value2));
                    continue block52;
                }
            }
            throw new IllegalArgumentException("unexpected flag: " + flag);
        }
        return optionsBuilder.build();
    }

    private static Integer parseInteger(Iterator<String> it, String flag, String value2) {
        try {
            return Integer.valueOf(CommandLineOptionsParser.getValue(flag, it, value2));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("invalid integer value for %s: %s", flag, value2), e);
        }
    }

    private static String getValue(String flag, Iterator<String> it, String value2) {
        if (value2 != null) {
            return value2;
        }
        if (!it.hasNext()) {
            throw new IllegalArgumentException("required value was not provided for: " + flag);
        }
        return it.next();
    }

    private static void parseRangeSet(ImmutableRangeSet.Builder<Integer> result2, String ranges2) {
        for (String range : COMMA_SPLITTER.split(ranges2)) {
            result2.add(CommandLineOptionsParser.parseRange(range));
        }
    }

    private static Range<Integer> parseRange(String arg) {
        List<String> args2 = COLON_SPLITTER.splitToList(arg);
        switch (args2.size()) {
            case 1: {
                int line2 = Integer.parseInt(args2.get(0)) - 1;
                return Range.closedOpen(line2, line2 + 1);
            }
            case 2: {
                int line0 = Integer.parseInt(args2.get(0)) - 1;
                int line1 = Integer.parseInt(args2.get(1)) - 1;
                return Range.closedOpen(line0, line1 + 1);
            }
        }
        throw new IllegalArgumentException(arg);
    }

    private static void expandParamsFiles(Iterable<String> args2, List<String> expanded) {
        for (String arg : args2) {
            if (arg.isEmpty()) continue;
            if (!arg.startsWith("@")) {
                expanded.add(arg);
                continue;
            }
            if (arg.startsWith("@@")) {
                expanded.add(arg.substring(1));
                continue;
            }
            Path path2 = Paths.get(arg.substring(1), new String[0]);
            try {
                String sequence2 = new String(Files.readAllBytes(path2), StandardCharsets.UTF_8);
                CommandLineOptionsParser.expandParamsFiles(ARG_SPLITTER.split(sequence2), expanded);
            }
            catch (IOException e) {
                throw new UncheckedIOException(path2 + ": could not read file: " + e.getMessage(), e);
            }
        }
    }
}

