/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

class DimensionHelpers {
    DimensionHelpers() {
    }

    static TypeWithDims extractDims(Tree node, SortedDims sorted2) {
        ArrayDeque<List<AnnotationTree>> builder2 = new ArrayDeque<List<AnnotationTree>>();
        node = DimensionHelpers.extractDims(builder2, node);
        Iterable<List<AnnotationTree>> dims = sorted2 == SortedDims.YES ? DimensionHelpers.reorderBySourcePosition(builder2) : builder2;
        return new TypeWithDims(node, ImmutableList.copyOf(dims));
    }

    private static Iterable<List<AnnotationTree>> reorderBySourcePosition(Deque<List<AnnotationTree>> dims) {
        int lastAnnotation = -1;
        int lastPos = -1;
        int idx = 0;
        for (List<AnnotationTree> dim : dims) {
            if (!dim.isEmpty()) {
                int pos = ((JCTree)((Object)dim.get(0))).getStartPosition();
                if (pos < lastPos) {
                    ArrayList<List<AnnotationTree>> list2 = new ArrayList<List<AnnotationTree>>(dims);
                    Collections.rotate(list2, -(lastAnnotation + 1));
                    return list2;
                }
                lastPos = pos;
                lastAnnotation = idx;
            }
            ++idx;
        }
        return dims;
    }

    private static Tree extractDims(Deque<List<AnnotationTree>> dims, Tree node) {
        switch (node.getKind()) {
            case ARRAY_TYPE: {
                return DimensionHelpers.extractDims(dims, ((ArrayTypeTree)node).getType());
            }
            case ANNOTATED_TYPE: {
                AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)node;
                if (annotatedTypeTree.getUnderlyingType().getKind() != Tree.Kind.ARRAY_TYPE) {
                    return node;
                }
                node = DimensionHelpers.extractDims(dims, annotatedTypeTree.getUnderlyingType());
                dims.addFirst(ImmutableList.copyOf(annotatedTypeTree.getAnnotations()));
                return node;
            }
        }
        return node;
    }

    static enum SortedDims {
        YES,
        NO;

    }

    static class TypeWithDims {
        final Tree node;
        final ImmutableList<List<AnnotationTree>> dims;

        public TypeWithDims(Tree node, ImmutableList<List<AnnotationTree>> dims) {
            this.node = node;
            this.dims = dims;
        }
    }
}

