/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.StringWrapper;
import java.util.concurrent.Callable;

class FormatFileCallable
implements Callable<String> {
    private final String input;
    private final CommandLineOptions parameters;
    private final JavaFormatterOptions options;

    public FormatFileCallable(CommandLineOptions parameters2, String input, JavaFormatterOptions options) {
        this.input = input;
        this.parameters = parameters2;
        this.options = options;
    }

    @Override
    public String call() throws FormatterException {
        if (this.parameters.fixImportsOnly()) {
            return this.fixImports(this.input);
        }
        Formatter formatter = new Formatter(this.options);
        String formatted = formatter.formatSource(this.input, this.characterRanges(this.input).asRanges());
        formatted = this.fixImports(formatted);
        if (this.parameters.reflowLongStrings()) {
            formatted = StringWrapper.wrap(100, formatted, formatter);
        }
        return formatted;
    }

    private String fixImports(String input) throws FormatterException {
        if (this.parameters.removeUnusedImports()) {
            input = RemoveUnusedImports.removeUnusedImports(input);
        }
        if (this.parameters.sortImports()) {
            input = ImportOrderer.reorderImports(input, this.options.style());
        }
        return input;
    }

    private RangeSet<Integer> characterRanges(String input) {
        TreeRangeSet<Integer> characterRanges = TreeRangeSet.create();
        if (this.parameters.lines().isEmpty() && this.parameters.offsets().isEmpty()) {
            characterRanges.add(Range.closedOpen(0, input.length()));
            return characterRanges;
        }
        characterRanges.addAll(Formatter.lineRangesToCharRanges(input, this.parameters.lines()));
        for (int i = 0; i < this.parameters.offsets().size(); ++i) {
            Integer length = (Integer)this.parameters.lengths().get(i);
            if (length == 0) {
                length = 1;
            }
            characterRanges.add(Range.closedOpen((Integer)this.parameters.offsets().get(i), (Integer)this.parameters.offsets().get(i) + length));
        }
        return characterRanges;
    }
}

