/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.FormatterDiagnostic;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class FormatterException
extends Exception {
    private ImmutableList<FormatterDiagnostic> diagnostics;

    public FormatterException(String message2) {
        this(FormatterDiagnostic.create(message2));
    }

    public FormatterException(FormatterDiagnostic diagnostic) {
        this(ImmutableList.of(diagnostic));
    }

    public FormatterException(Iterable<FormatterDiagnostic> diagnostics2) {
        super(diagnostics2.iterator().next().toString());
        this.diagnostics = ImmutableList.copyOf(diagnostics2);
    }

    public List<FormatterDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public static FormatterException fromJavacDiagnostics(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics2) {
        return new FormatterException(Iterables.transform(diagnostics2, d -> FormatterException.toFormatterDiagnostic(d)));
    }

    private static FormatterDiagnostic toFormatterDiagnostic(Diagnostic<?> input) {
        return FormatterDiagnostic.create((int)input.getLineNumber(), (int)input.getColumnNumber(), input.getMessage(Locale.ENGLISH));
    }
}

