/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.javadoc.JavadocFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaCommentsHelper
implements CommentsHelper {
    private final String lineSeparator;
    private final JavaFormatterOptions options;
    private static final Pattern LINE_COMMENT_MISSING_SPACE_PREFIX = Pattern.compile("^(//+)(?!noinspection|\\$NON-NLS-\\d+\\$)[^\\s/]");

    public JavaCommentsHelper(String lineSeparator, JavaFormatterOptions options) {
        this.lineSeparator = lineSeparator;
        this.options = options;
    }

    @Override
    public String rewrite(Input.Tok tok, int maxWidth, int column0) {
        if (!tok.isComment()) {
            return tok.getOriginalText();
        }
        String text2 = tok.getOriginalText();
        if (tok.isJavadocComment() && this.options.formatJavadoc()) {
            text2 = JavadocFormatter.formatJavadoc(text2, column0);
        }
        ArrayList<String> lines = new ArrayList<String>();
        Iterator<String> it = Newlines.lineIterator(text2);
        while (it.hasNext()) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom(it.next()));
        }
        if (tok.isSlashSlashComment()) {
            return this.indentLineComments(lines, column0);
        }
        if (JavaCommentsHelper.javadocShaped(lines)) {
            return this.indentJavadoc(lines, column0);
        }
        return this.preserveIndentation(lines, column0);
    }

    private String preserveIndentation(List<String> lines, int column0) {
        int i;
        StringBuilder builder2 = new StringBuilder();
        int startCol = -1;
        for (i = 1; i < lines.size(); ++i) {
            int lineIdx = CharMatcher.whitespace().negate().indexIn(lines.get(i));
            if (lineIdx < 0 || startCol != -1 && lineIdx >= startCol) continue;
            startCol = lineIdx;
        }
        builder2.append(lines.get(0));
        for (i = 1; i < lines.size(); ++i) {
            builder2.append(this.lineSeparator).append(Strings.repeat(" ", column0));
            if (lines.get(i).length() >= startCol) {
                builder2.append(lines.get(i).substring(startCol));
                continue;
            }
            builder2.append(lines.get(i));
        }
        return builder2.toString();
    }

    private String indentLineComments(List<String> lines, int column0) {
        lines = this.wrapLineComments(lines, column0);
        StringBuilder builder2 = new StringBuilder();
        builder2.append(lines.get(0).trim());
        String indentString = Strings.repeat(" ", column0);
        for (int i = 1; i < lines.size(); ++i) {
            builder2.append(this.lineSeparator).append(indentString).append(lines.get(i).trim());
        }
        return builder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> wrapLineComments(List<String> lines, int column0) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (String string2 : lines) {
            void var5_5;
            void var5_8;
            Matcher matcher2 = LINE_COMMENT_MISSING_SPACE_PREFIX.matcher(string2);
            if (matcher2.find()) {
                int length = matcher2.group(1).length();
                String string3 = Strings.repeat("/", length) + " " + string2.substring(length);
            }
            if (var5_8.startsWith("// MOE:")) {
                result2.add((String)var5_8);
                continue;
            }
            while (var5_5.length() + column0 > 100) {
                int idx;
                for (idx = 100 - column0; idx >= 2 && !CharMatcher.whitespace().matches(var5_5.charAt(idx)); --idx) {
                }
                if (idx <= 2) break;
                result2.add(var5_5.substring(0, idx));
                String string4 = "//" + var5_5.substring(idx);
            }
            result2.add((String)var5_5);
        }
        return result2;
    }

    private String indentJavadoc(List<String> lines, int column0) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(lines.get(0).trim());
        int indent = column0 + 1;
        String indentString = Strings.repeat(" ", indent);
        for (int i = 1; i < lines.size(); ++i) {
            builder2.append(this.lineSeparator).append(indentString);
            String line2 = lines.get(i).trim();
            if (!line2.startsWith("*")) {
                builder2.append("* ");
            }
            builder2.append(line2);
        }
        return builder2.toString();
    }

    private static boolean javadocShaped(List<String> lines) {
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String first = it.next().trim();
        if (first.startsWith("/**")) {
            return true;
        }
        if (!first.startsWith("/*")) {
            return false;
        }
        while (it.hasNext()) {
            if (it.next().trim().startsWith("*")) continue;
            return false;
        }
        return true;
    }
}

