/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.io.ByteStreams;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.CommandLineOptionsParser;
import com.google.googlejavaformat.java.FormatFileCallable;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.GoogleJavaFormatVersion;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.UsageException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class Main {
    private static final int MAX_THREADS = 20;
    private static final String STDIN_FILENAME = "<stdin>";
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final InputStream inStream;

    static final String versionString() {
        return "google-java-format: Version " + GoogleJavaFormatVersion.version();
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, InputStream inStream) {
        this.outWriter = outWriter;
        this.errWriter = errWriter;
        this.inStream = inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) {
        int result2;
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        PrintWriter err = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8));
        try {
            Main formatter = new Main(out, err, System.in);
            result2 = formatter.format(args2);
        }
        catch (UsageException e) {
            err.print(e.getMessage());
            result2 = 0;
        }
        finally {
            err.flush();
            out.flush();
        }
        System.exit(result2);
    }

    public int format(String ... args2) throws UsageException {
        CommandLineOptions parameters2 = Main.processArgs(args2);
        if (parameters2.version()) {
            this.errWriter.println(Main.versionString());
            return 0;
        }
        if (parameters2.help()) {
            throw new UsageException();
        }
        JavaFormatterOptions options = JavaFormatterOptions.builder().style(parameters2.aosp() ? JavaFormatterOptions.Style.AOSP : JavaFormatterOptions.Style.GOOGLE).formatJavadoc(parameters2.formatJavadoc()).build();
        if (parameters2.stdin()) {
            return this.formatStdin(parameters2, options);
        }
        return this.formatFiles(parameters2, options);
    }

    private int formatFiles(CommandLineOptions parameters2, JavaFormatterOptions options) {
        Path path2;
        int numThreads = Math.min(20, parameters2.files().size());
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        LinkedHashMap<Path, String> inputs = new LinkedHashMap<Path, String>();
        LinkedHashMap<Path, Future<String>> results = new LinkedHashMap<Path, Future<String>>();
        boolean allOk = true;
        for (String fileName : parameters2.files()) {
            if (!fileName.endsWith(".java")) {
                this.errWriter.println("Skipping non-Java file: " + fileName);
                continue;
            }
            path2 = Paths.get(fileName, new String[0]);
            try {
                String input = new String(Files.readAllBytes(path2), StandardCharsets.UTF_8);
                inputs.put(path2, input);
                results.put(path2, executorService.submit(new FormatFileCallable(parameters2, input, options)));
            }
            catch (IOException e) {
                this.errWriter.println(fileName + ": could not read file: " + e.getMessage());
                allOk = false;
            }
        }
        for (Map.Entry result2 : results.entrySet()) {
            boolean changed;
            String formatted;
            path2 = (Path)result2.getKey();
            try {
                formatted = (String)((Future)result2.getValue()).get();
            }
            catch (InterruptedException e) {
                this.errWriter.println(e.getMessage());
                allOk = false;
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FormatterException) {
                    for (FormatterDiagnostic diagnostic : ((FormatterException)e.getCause()).diagnostics()) {
                        this.errWriter.println(path2 + ":" + diagnostic.toString());
                    }
                } else {
                    this.errWriter.println(path2 + ": error: " + e.getCause().getMessage());
                    e.getCause().printStackTrace(this.errWriter);
                }
                allOk = false;
                continue;
            }
            boolean bl = changed = !formatted.equals(inputs.get(path2));
            if (changed && parameters2.setExitIfChanged()) {
                allOk = false;
            }
            if (parameters2.inPlace()) {
                if (!changed) continue;
                try {
                    Files.write(path2, formatted.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    this.errWriter.println(path2 + ": could not write file: " + e.getMessage());
                    allOk = false;
                }
                continue;
            }
            if (parameters2.dryRun()) {
                if (!changed) continue;
                this.outWriter.println(path2);
                continue;
            }
            this.outWriter.write(formatted);
        }
        return allOk ? 0 : 1;
    }

    private int formatStdin(CommandLineOptions parameters2, JavaFormatterOptions options) {
        String input;
        try {
            input = new String(ByteStreams.toByteArray(this.inStream), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        String stdinFilename = parameters2.assumeFilename().orElse(STDIN_FILENAME);
        boolean ok = true;
        try {
            boolean changed;
            String output2 = new FormatFileCallable(parameters2, input, options).call();
            boolean bl = changed = !input.equals(output2);
            if (changed && parameters2.setExitIfChanged()) {
                ok = false;
            }
            if (parameters2.dryRun()) {
                if (changed) {
                    this.outWriter.println(stdinFilename);
                }
            } else {
                this.outWriter.write(output2);
            }
        }
        catch (FormatterException e) {
            for (FormatterDiagnostic diagnostic : e.diagnostics()) {
                this.errWriter.println(stdinFilename + ":" + diagnostic.toString());
            }
            ok = false;
        }
        return ok ? 0 : 1;
    }

    public static CommandLineOptions processArgs(String ... args2) throws UsageException {
        CommandLineOptions parameters2;
        try {
            parameters2 = CommandLineOptionsParser.parse(Arrays.asList(args2));
        }
        catch (IllegalArgumentException e) {
            throw new UsageException(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new UsageException(t.getMessage());
        }
        int filesToFormat = parameters2.files().size();
        if (parameters2.stdin()) {
            ++filesToFormat;
        }
        if (parameters2.inPlace() && parameters2.files().isEmpty()) {
            throw new UsageException("in-place formatting was requested but no files were provided");
        }
        if (parameters2.isSelection() && filesToFormat != 1) {
            throw new UsageException("partial formatting is only support for a single file");
        }
        if (parameters2.offsets().size() != parameters2.lengths().size()) {
            throw new UsageException("-offsets and -lengths flags must be provided in matching pairs");
        }
        if (filesToFormat <= 0 && !parameters2.version() && !parameters2.help()) {
            throw new UsageException("no files were provided");
        }
        if (parameters2.stdin() && !parameters2.files().isEmpty()) {
            throw new UsageException("cannot format from standard input and files simultaneously");
        }
        if (parameters2.assumeFilename().isPresent() && !parameters2.stdin()) {
            throw new UsageException("--assume-filename is only supported when formatting standard input");
        }
        if (parameters2.dryRun() && parameters2.inPlace()) {
            throw new UsageException("cannot use --dry-run and --in-place at the same time");
        }
        return parameters2;
    }
}

