/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

public class RemoveUnusedImports {
    public static String removeUnusedImports(String contents) throws FormatterException {
        Context context2 = new Context();
        JCTree.JCCompilationUnit unit2 = RemoveUnusedImports.parse(context2, contents);
        if (unit2 == null) {
            return contents;
        }
        UnusedImportScanner scanner = new UnusedImportScanner(JavacTrees.instance(context2));
        scanner.scan((Tree)unit2, null);
        return RemoveUnusedImports.applyReplacements(contents, RemoveUnusedImports.buildReplacements(contents, unit2, scanner.usedNames, scanner.usedInJavadoc));
    }

    private static JCTree.JCCompilationUnit parse(Context context2, final String javaInput) throws FormatterException {
        DiagnosticCollector diagnostics2 = new DiagnosticCollector();
        context2.put(DiagnosticListener.class, diagnostics2);
        Options.instance(context2).put("--enable-preview", "true");
        Options.instance(context2).put("allowStringFolding", "false");
        JavacFileManager fileManager = new JavacFileManager(context2, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput;
            }
        };
        Log.instance(context2).useSource(source);
        ParserFactory parserFactory = ParserFactory.instance(context2);
        JavacParser parser = parserFactory.newParser(javaInput, true, true, true);
        JCTree.JCCompilationUnit unit2 = parser.parseCompilationUnit();
        unit2.sourcefile = source;
        Iterable<Diagnostic<? extends JavaFileObject>> errorDiagnostics = Iterables.filter(diagnostics2.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            throw FormatterException.fromJavacDiagnostics(errorDiagnostics);
        }
        return unit2;
    }

    private static RangeMap<Integer, String> buildReplacements(String contents, JCTree.JCCompilationUnit unit2, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc) {
        TreeRangeMap<Integer, String> replacements = TreeRangeMap.create();
        for (JCTree.JCImport importTree : unit2.getImports()) {
            String sep;
            String simpleName2;
            if (!RemoveUnusedImports.isUnused(unit2, usedNames, usedInJavadoc, importTree, simpleName2 = RemoveUnusedImports.getSimpleName(importTree))) continue;
            int endPosition = importTree.getEndPosition(unit2.endPositions);
            endPosition = Math.max(CharMatcher.isNot(' ').indexIn(contents, endPosition), endPosition);
            if (endPosition + (sep = Newlines.guessLineSeparator(contents)).length() < contents.length() && contents.subSequence(endPosition, endPosition + sep.length()).toString().equals(sep)) {
                endPosition += sep.length();
            }
            replacements.put(Range.closedOpen(importTree.getStartPosition(), endPosition), "");
        }
        return replacements;
    }

    private static String getSimpleName(JCTree.JCImport importTree) {
        return importTree.getQualifiedIdentifier() instanceof JCTree.JCIdent ? ((JCTree.JCIdent)importTree.getQualifiedIdentifier()).getName().toString() : ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getIdentifier().toString();
    }

    private static boolean isUnused(JCTree.JCCompilationUnit unit2, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc, JCTree.JCImport importTree, String simpleName2) {
        String qualifier = ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getExpression().toString();
        if (qualifier.equals("java.lang")) {
            return true;
        }
        if (unit2.getPackageName() != null && unit2.getPackageName().toString().equals(qualifier)) {
            return true;
        }
        if (importTree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getIdentifier().contentEquals("*")) {
            return false;
        }
        if (usedNames.contains(simpleName2)) {
            return false;
        }
        return !usedInJavadoc.containsKey(simpleName2);
    }

    private static String applyReplacements(String source, RangeMap<Integer, String> replacements) {
        TreeRangeSet<Integer> fixedRanges = TreeRangeSet.create();
        StringBuilder sb = new StringBuilder(source);
        int offset2 = 0;
        for (Map.Entry<Range<Integer>, String> replacement : replacements.asMapOfRanges().entrySet()) {
            Range<Integer> range = replacement.getKey();
            String replaceWith = replacement.getValue();
            int start = offset2 + range.lowerEndpoint();
            int end = offset2 + range.upperEndpoint();
            sb.replace(start, end, replaceWith);
            if (!replaceWith.isEmpty()) {
                fixedRanges.add(Range.closedOpen(start, end));
            }
            offset2 += replaceWith.length() - (range.upperEndpoint() - range.lowerEndpoint());
        }
        return sb.toString();
    }

    private static class UnusedImportScanner
    extends TreePathScanner<Void, Void> {
        private final Set<String> usedNames = new LinkedHashSet<String>();
        private final Multimap<String, Range<Integer>> usedInJavadoc = HashMultimap.create();
        final JavacTrees trees;
        final DocTreeScanner docTreeSymbolScanner;

        private UnusedImportScanner(JavacTrees trees) {
            this.trees = trees;
            this.docTreeSymbolScanner = new DocTreeScanner();
        }

        @Override
        public Void visitImport(ImportTree importTree, Void usedSymbols) {
            return null;
        }

        @Override
        public Void visitIdentifier(com.sun.source.tree.IdentifierTree tree, Void unused2) {
            if (tree == null) {
                return null;
            }
            this.usedNames.add(tree.getName().toString());
            return null;
        }

        @Override
        public Void scan(Tree tree, Void unused2) {
            if (tree == null) {
                return null;
            }
            this.scanJavadoc();
            return (Void)super.scan(tree, unused2);
        }

        private void scanJavadoc() {
            if (this.getCurrentPath() == null) {
                return;
            }
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree == null) {
                return;
            }
            this.docTreeSymbolScanner.scan(new DocTreePath(this.getCurrentPath(), commentTree), null);
        }

        class DocTreeScanner
        extends DocTreePathScanner<Void, Void> {
            DocTreeScanner() {
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void aVoid) {
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree referenceTree, Void unused2) {
                DCTree.DCReference reference = (DCTree.DCReference)referenceTree;
                long basePos = reference.getSourcePosition((DCTree.DCDocComment)this.getCurrentPath().getDocComment());
                if (reference.qualifierExpression != null) {
                    new ReferenceScanner(basePos).scan(reference.qualifierExpression, null);
                }
                if (reference.paramTypes != null) {
                    for (JCTree param : reference.paramTypes) {
                        new ReferenceScanner(-1L).scan(param, null);
                    }
                }
                return null;
            }

            private class ReferenceScanner
            extends TreeScanner<Void, Void> {
                private final long basePos;

                public ReferenceScanner(long basePos) {
                    this.basePos = basePos;
                }

                @Override
                public Void visitIdentifier(com.sun.source.tree.IdentifierTree node, Void aVoid) {
                    UnusedImportScanner.this.usedInJavadoc.put(node.getName().toString(), this.basePos != -1L ? Range.closedOpen((int)this.basePos, (int)this.basePos + node.getName().length()) : null);
                    return (Void)super.visitIdentifier(node, aVoid);
                }
            }
        }
    }
}

