/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

public final class StringWrapper {
    public static final CharMatcher STRING_CONCAT_DELIMITER = CharMatcher.whitespace().or(CharMatcher.anyOf("\"+"));

    public static String wrap(String input, Formatter formatter) throws FormatterException {
        return StringWrapper.wrap(100, input, formatter);
    }

    static String wrap(int columnLimit, String input, Formatter formatter) throws FormatterException {
        String actual;
        if (!StringWrapper.longLines(columnLimit, input)) {
            return input;
        }
        TreeRangeMap<Integer, String> replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        String firstPass = formatter.formatSource(input, replacements.asMapOfRanges().keySet());
        if (!firstPass.equals(input)) {
            input = firstPass;
            replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        }
        String result2 = StringWrapper.applyReplacements(input, replacements);
        String expected = StringWrapper.parse(input, true).toString();
        if (!expected.equals(actual = StringWrapper.parse(result2, true).toString())) {
            throw new FormatterException(String.format("Something has gone terribly wrong. Please file a bug: https://github.com/google/google-java-format/issues/new\n\n=== Actual: ===\n%s\n=== Expected: ===\n%s\n", actual, expected));
        }
        return result2;
    }

    private static TreeRangeMap<Integer, String> getReflowReplacements(final int columnLimit, final String input) throws FormatterException {
        final JCTree.JCCompilationUnit unit2 = StringWrapper.parse(input, false);
        String separator = Newlines.guessLineSeparator(input);
        final ArrayList toFix = new ArrayList();
        final Position.LineMap lineMap = unit2.getLineMap();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitLiteral(LiteralTree literalTree, Void aVoid) {
                int endPosition;
                if (literalTree.getKind() != Tree.Kind.STRING_LITERAL) {
                    return null;
                }
                Tree parent2 = this.getCurrentPath().getParentPath().getLeaf();
                if (parent2 instanceof MemberSelectTree && ((MemberSelectTree)parent2).getExpression().equals(literalTree)) {
                    return null;
                }
                int lineEnd = endPosition = StringWrapper.getEndPosition(unit2, literalTree);
                while (Newlines.hasNewlineAt(input, lineEnd) == -1) {
                    ++lineEnd;
                }
                if (lineMap.getColumnNumber(lineEnd) - 1 <= columnLimit) {
                    return null;
                }
                toFix.add(this.getCurrentPath());
                return null;
            }
        }.scan(new TreePath(unit2), (Void)null);
        TreeRangeMap<Integer, String> replacements = TreeRangeMap.create();
        Iterator iterator2 = toFix.iterator();
        while (iterator2.hasNext()) {
            int end;
            TreePath path2;
            TreePath enclosing = path2 = (TreePath)iterator2.next();
            while (enclosing.getParentPath().getLeaf().getKind() == Tree.Kind.PLUS) {
                enclosing = enclosing.getParentPath();
            }
            AtomicBoolean first = new AtomicBoolean(false);
            List<Tree> flat = StringWrapper.flatten(input, unit2, path2, enclosing, first);
            int startColumn = lineMap.getColumnNumber(StringWrapper.getStartPosition(flat.get(0))) - 1;
            int lineEnd = end = StringWrapper.getEndPosition(unit2, Iterables.getLast(flat));
            while (Newlines.hasNewlineAt(input, lineEnd) == -1) {
                ++lineEnd;
            }
            int trailing = lineEnd - end;
            ImmutableList<String> components2 = StringWrapper.stringComponents(input, unit2, flat);
            replacements.put(Range.closedOpen(StringWrapper.getStartPosition(flat.get(0)), StringWrapper.getEndPosition(unit2, Iterables.getLast(flat))), StringWrapper.reflow(separator, columnLimit, startColumn, trailing, components2, first.get()));
        }
        return replacements;
    }

    private static ImmutableList<String> stringComponents(String input, JCTree.JCCompilationUnit unit2, List<Tree> flat) {
        ImmutableList.Builder result2 = ImmutableList.builder();
        StringBuilder piece = new StringBuilder();
        for (Tree tree : flat) {
            String text2 = input.substring(StringWrapper.getStartPosition(tree) + 1, StringWrapper.getEndPosition(unit2, tree) - 1);
            int start = 0;
            for (int idx = 0; idx < text2.length(); ++idx) {
                if (!CharMatcher.whitespace().matches(text2.charAt(idx)) && StringWrapper.hasEscapedWhitespaceAt(text2, idx) == -1) {
                    int length;
                    if (StringWrapper.hasEscapedNewlineAt(text2, idx) == -1) continue;
                    while ((length = StringWrapper.hasEscapedNewlineAt(text2, idx)) != -1) {
                        idx += length;
                    }
                }
                piece.append(text2, start, idx);
                result2.add(piece.toString());
                piece = new StringBuilder();
                start = idx;
            }
            if (piece.length() > 0) {
                result2.add(piece.toString());
                piece = new StringBuilder();
            }
            if (start >= text2.length()) continue;
            piece.append(text2, start, text2.length());
        }
        if (piece.length() > 0) {
            result2.add(piece.toString());
        }
        return result2.build();
    }

    static int hasEscapedWhitespaceAt(String input, int idx) {
        return Stream.of("\\t").mapToInt(x -> input.startsWith((String)x, idx) ? x.length() : -1).filter(x -> x != -1).findFirst().orElse(-1);
    }

    static int hasEscapedNewlineAt(String input, int idx) {
        return Stream.of("\\r\\n", "\\r", "\\n").mapToInt(x -> input.startsWith((String)x, idx) ? x.length() : -1).filter(x -> x != -1).findFirst().orElse(-1);
    }

    private static String reflow(String separator, int columnLimit, int startColumn, int trailing, ImmutableList<String> components2, boolean first0) {
        int width = columnLimit - startColumn - 2;
        ArrayDeque<String> input = new ArrayDeque<String>(components2);
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = first0;
        while (!input.isEmpty()) {
            int length = 0;
            ArrayList<String> line2 = new ArrayList<String>();
            if (input.stream().mapToInt(x -> x.length()).sum() <= width) {
                width -= trailing;
            }
            while (!(input.isEmpty() || length > 4 && length + ((String)input.peekFirst()).length() >= width)) {
                String text2 = (String)input.removeFirst();
                line2.add(text2);
                length += text2.length();
                if (!text2.endsWith("\\n") && !text2.endsWith("\\r")) continue;
                break;
            }
            if (line2.isEmpty()) {
                line2.add((String)input.removeFirst());
            }
            lines.add(String.join((CharSequence)"", line2));
            if (!first) continue;
            width -= 6;
            first = false;
        }
        return lines.stream().collect(Collectors.joining("\"" + separator + Strings.repeat(" ", startColumn + (first0 ? 4 : -2)) + "+ \"", "\"", "\""));
    }

    private static List<Tree> flatten(String input, JCTree.JCCompilationUnit unit2, TreePath path2, TreePath parent2, AtomicBoolean firstInChain) {
        int startIdx;
        ArrayList<Tree> flat = new ArrayList<Tree>();
        ArrayDeque<Tree> todo = new ArrayDeque<Tree>();
        todo.add(parent2.getLeaf());
        while (!todo.isEmpty()) {
            Tree first = (Tree)todo.removeFirst();
            if (first.getKind() == Tree.Kind.PLUS) {
                BinaryTree bt = (BinaryTree)first;
                todo.addFirst(bt.getRightOperand());
                todo.addFirst(bt.getLeftOperand());
                continue;
            }
            flat.add(first);
        }
        int idx = flat.indexOf(path2.getLeaf());
        Verify.verify(idx != -1);
        int endIdx = idx + 1;
        for (startIdx = idx; startIdx > 0 && ((Tree)flat.get(startIdx - 1)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit2, (Tree)flat.get(startIdx - 1), (Tree)flat.get(startIdx)); --startIdx) {
        }
        while (endIdx < flat.size() && ((Tree)flat.get(endIdx)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit2, (Tree)flat.get(endIdx - 1), (Tree)flat.get(endIdx))) {
            ++endIdx;
        }
        firstInChain.set(startIdx == 0);
        return ImmutableList.copyOf(flat.subList(startIdx, endIdx));
    }

    private static boolean noComments(String input, JCTree.JCCompilationUnit unit2, Tree one, Tree two) {
        return STRING_CONCAT_DELIMITER.matchesAllOf(input.subSequence(StringWrapper.getEndPosition(unit2, one), StringWrapper.getStartPosition(two)));
    }

    private static int getEndPosition(JCTree.JCCompilationUnit unit2, Tree tree) {
        return ((JCTree)tree).getEndPosition(unit2.endPositions);
    }

    private static int getStartPosition(Tree tree) {
        return ((JCTree)tree).getStartPosition();
    }

    private static boolean longLines(int columnLimit, String input) {
        Iterator<String> it = Newlines.lineIterator(input);
        while (it.hasNext()) {
            String line2 = it.next();
            if (line2.length() <= columnLimit) continue;
            return true;
        }
        return false;
    }

    private static JCTree.JCCompilationUnit parse(final String source, boolean allowStringFolding) throws FormatterException {
        DiagnosticCollector diagnostics2 = new DiagnosticCollector();
        Context context2 = new Context();
        context2.put(DiagnosticListener.class, diagnostics2);
        Options.instance(context2).put("--enable-preview", "true");
        Options.instance(context2).put("allowStringFolding", Boolean.toString(allowStringFolding));
        JavacFileManager fileManager = new JavacFileManager(context2, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        SimpleJavaFileObject sjfo = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return source;
            }
        };
        Log.instance(context2).useSource(sjfo);
        ParserFactory parserFactory = ParserFactory.instance(context2);
        JavacParser parser = parserFactory.newParser(source, true, true, true);
        JCTree.JCCompilationUnit unit2 = parser.parseCompilationUnit();
        unit2.sourcefile = sjfo;
        Iterable<Diagnostic<? extends JavaFileObject>> errorDiagnostics = Iterables.filter(diagnostics2.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            throw FormatterException.fromJavacDiagnostics(errorDiagnostics);
        }
        return unit2;
    }

    private static String applyReplacements(String javaInput, TreeRangeMap<Integer, String> replacementMap) throws FormatterException {
        Map<Range<Integer>, String> ranges2 = replacementMap.asDescendingMapOfRanges();
        if (ranges2.isEmpty()) {
            return javaInput;
        }
        StringBuilder sb = new StringBuilder(javaInput);
        for (Map.Entry<Range<Integer>, String> entry : ranges2.entrySet()) {
            Range<Integer> range = entry.getKey();
            sb.replace(range.lowerEndpoint(), range.upperEndpoint(), entry.getValue());
        }
        return sb.toString();
    }

    private StringWrapper() {
    }
}

