/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.javadoc;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CharStream {
    String remaining;
    int toConsume;

    CharStream(String input) {
        this.remaining = Preconditions.checkNotNull(input);
    }

    boolean tryConsume(String expected) {
        if (!this.remaining.startsWith(expected)) {
            return false;
        }
        this.toConsume = expected.length();
        return true;
    }

    boolean tryConsumeRegex(Pattern pattern) {
        Matcher matcher2 = pattern.matcher(this.remaining);
        if (!matcher2.find()) {
            return false;
        }
        Preconditions.checkArgument(matcher2.start() == 0);
        this.toConsume = matcher2.end();
        return true;
    }

    String readAndResetRecorded() {
        String result2 = this.remaining.substring(0, this.toConsume);
        this.remaining = this.remaining.substring(this.toConsume);
        this.toConsume = 0;
        return result2;
    }

    boolean isExhausted() {
        return this.remaining.isEmpty();
    }
}

