/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.javadoc;

import com.google.common.collect.ImmutableList;
import com.google.googlejavaformat.java.javadoc.JavadocLexer;
import com.google.googlejavaformat.java.javadoc.JavadocWriter;
import com.google.googlejavaformat.java.javadoc.Token;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocFormatter {
    static final int MAX_LINE_LENGTH = 100;
    private static final Token STANDARD_BR_TOKEN = new Token(Token.Type.BR_TAG, "<br>");
    private static final Token STANDARD_P_TOKEN = new Token(Token.Type.PARAGRAPH_OPEN_TAG, "<p>");
    private static final Pattern SIMPLE_TAG_PATTERN = Pattern.compile("^<\\w+\\s*/?\\s*>", 2);
    private static final Pattern ONE_CONTENT_LINE_PATTERN = Pattern.compile(" */[*][*]\n *[*] (.*)\n *[*]/");

    public static String formatJavadoc(String input, int blockIndent) {
        ImmutableList<Token> tokens;
        try {
            tokens = JavadocLexer.lex(input);
        }
        catch (JavadocLexer.LexException e) {
            return input;
        }
        String result2 = JavadocFormatter.render(tokens, blockIndent);
        return JavadocFormatter.makeSingleLineIfPossible(blockIndent, result2);
    }

    private static String render(List<Token> input, int blockIndent) {
        JavadocWriter output2 = new JavadocWriter(blockIndent);
        block26: for (Token token : input) {
            switch (token.getType()) {
                case BEGIN_JAVADOC: {
                    output2.writeBeginJavadoc();
                    continue block26;
                }
                case END_JAVADOC: {
                    output2.writeEndJavadoc();
                    return output2.toString();
                }
                case FOOTER_JAVADOC_TAG_START: {
                    output2.writeFooterJavadocTagStart(token);
                    continue block26;
                }
                case LIST_OPEN_TAG: {
                    output2.writeListOpen(token);
                    continue block26;
                }
                case LIST_CLOSE_TAG: {
                    output2.writeListClose(token);
                    continue block26;
                }
                case LIST_ITEM_OPEN_TAG: {
                    output2.writeListItemOpen(token);
                    continue block26;
                }
                case HEADER_OPEN_TAG: {
                    output2.writeHeaderOpen(token);
                    continue block26;
                }
                case HEADER_CLOSE_TAG: {
                    output2.writeHeaderClose(token);
                    continue block26;
                }
                case PARAGRAPH_OPEN_TAG: {
                    output2.writeParagraphOpen(JavadocFormatter.standardizePToken(token));
                    continue block26;
                }
                case BLOCKQUOTE_OPEN_TAG: 
                case BLOCKQUOTE_CLOSE_TAG: {
                    output2.writeBlockquoteOpenOrClose(token);
                    continue block26;
                }
                case PRE_OPEN_TAG: {
                    output2.writePreOpen(token);
                    continue block26;
                }
                case PRE_CLOSE_TAG: {
                    output2.writePreClose(token);
                    continue block26;
                }
                case CODE_OPEN_TAG: {
                    output2.writeCodeOpen(token);
                    continue block26;
                }
                case CODE_CLOSE_TAG: {
                    output2.writeCodeClose(token);
                    continue block26;
                }
                case TABLE_OPEN_TAG: {
                    output2.writeTableOpen(token);
                    continue block26;
                }
                case TABLE_CLOSE_TAG: {
                    output2.writeTableClose(token);
                    continue block26;
                }
                case MOE_BEGIN_STRIP_COMMENT: {
                    output2.requestMoeBeginStripComment(token);
                    continue block26;
                }
                case MOE_END_STRIP_COMMENT: {
                    output2.writeMoeEndStripComment(token);
                    continue block26;
                }
                case HTML_COMMENT: {
                    output2.writeHtmlComment(token);
                    continue block26;
                }
                case BR_TAG: {
                    output2.writeBr(JavadocFormatter.standardizeBrToken(token));
                    continue block26;
                }
                case WHITESPACE: {
                    output2.requestWhitespace();
                    continue block26;
                }
                case FORCED_NEWLINE: {
                    output2.writeLineBreakNoAutoIndent();
                    continue block26;
                }
                case LITERAL: {
                    output2.writeLiteral(token);
                    continue block26;
                }
                case PARAGRAPH_CLOSE_TAG: 
                case LIST_ITEM_CLOSE_TAG: 
                case OPTIONAL_LINE_BREAK: {
                    continue block26;
                }
            }
            throw new AssertionError((Object)token.getType());
        }
        throw new AssertionError();
    }

    private static Token standardizeBrToken(Token token) {
        return JavadocFormatter.standardize(token, STANDARD_BR_TOKEN);
    }

    private static Token standardizePToken(Token token) {
        return JavadocFormatter.standardize(token, STANDARD_P_TOKEN);
    }

    private static Token standardize(Token token, Token standardToken) {
        return SIMPLE_TAG_PATTERN.matcher(token.getValue()).matches() ? standardToken : token;
    }

    private static String makeSingleLineIfPossible(int blockIndent, String input) {
        int oneLinerContentLength = 100 - "/**  */".length() - blockIndent;
        Matcher matcher2 = ONE_CONTENT_LINE_PATTERN.matcher(input);
        if (matcher2.matches() && matcher2.group(1).isEmpty()) {
            return "/** */";
        }
        if (matcher2.matches() && matcher2.group(1).length() <= oneLinerContentLength) {
            return "/** " + matcher2.group(1) + " */";
        }
        return input;
    }

    private JavadocFormatter() {
    }
}

