/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private String encoding;
    private List natives = new ArrayList();
    private Object[] original;

    public StringArray(String[] strings2) {
        this(strings2, false);
    }

    public StringArray(String[] strings2, boolean wide) {
        this((Object[])strings2, wide ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
    }

    public StringArray(String[] strings2, String encoding) {
        this((Object[])strings2, encoding);
    }

    public StringArray(WString[] strings2) {
        this(strings2, "--WIDE-STRING--");
    }

    private StringArray(Object[] strings2, String encoding) {
        super((strings2.length + 1) * Pointer.SIZE);
        this.original = strings2;
        this.encoding = encoding;
        for (int i = 0; i < strings2.length; ++i) {
            Pointer p = null;
            if (strings2[i] != null) {
                NativeString ns = new NativeString(strings2[i].toString(), encoding);
                this.natives.add(ns);
                p = ns.getPointer();
            }
            this.setPointer(Pointer.SIZE * i, p);
        }
        this.setPointer(Pointer.SIZE * strings2.length, null);
    }

    @Override
    public void read() {
        boolean returnWide = this.original instanceof WString[];
        boolean wide = this.encoding == "--WIDE-STRING--";
        for (int si = 0; si < this.original.length; ++si) {
            Pointer p = this.getPointer(si * Pointer.SIZE);
            CharSequence s2 = null;
            if (p != null) {
                String string2 = s2 = wide ? p.getWideString(0L) : p.getString(0L, this.encoding);
                if (returnWide) {
                    s2 = new WString((String)s2);
                }
            }
            this.original[si] = s2;
        }
    }

    @Override
    public String toString() {
        boolean wide = this.encoding == "--WIDE-STRING--";
        String s2 = wide ? "const wchar_t*[]" : "const char*[]";
        s2 = s2 + Arrays.asList(this.original);
        return s2;
    }
}

