/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TDoubleArrayList
implements Serializable,
Cloneable {
    protected transient double[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public TDoubleArrayList() {
    }

    public TDoubleArrayList(int capacity) {
        this._data = new double[capacity];
        this._pos = 0;
    }

    public TDoubleArrayList(double[] values2) {
        this(Math.max(values2.length, 4));
        this.add(values2);
    }

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new double[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            double[] tmp = new double[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data != null && this._data.length > this.size()) {
            double[] tmp = new double[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(double val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(double[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(double[] vals, int offset2, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset2, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset2, double value2) {
        if (offset2 == this._pos) {
            this.add(value2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset2, this._data, offset2 + 1, this._pos - offset2);
        this._data[offset2] = value2;
        ++this._pos;
    }

    public void insert(int offset2, double[] values2) {
        this.insert(offset2, values2, 0, values2.length);
    }

    public void insert(int offset2, double[] values2, int valOffset, int len) {
        if (offset2 == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset2, this._data, offset2 + len, this._pos - offset2);
        System.arraycopy(values2, valOffset, this._data, offset2, len);
        this._pos += len;
    }

    public double get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        return this._data[offset2];
    }

    public double getQuick(int offset2) {
        return this._data[offset2];
    }

    public void set(int offset2, double val) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        this._data[offset2] = val;
    }

    public double getSet(int offset2, double val) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        double old = this._data[offset2];
        this._data[offset2] = val;
        return old;
    }

    public void set(int offset2, double[] values2) {
        this.set(offset2, values2, 0, values2.length);
    }

    public void set(int offset2, double[] values2, int valOffset, int length) {
        if (offset2 < 0 || offset2 + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, values2, valOffset, length);
    }

    public void setQuick(int offset2, double val) {
        this._data[offset2] = val;
    }

    public void clear() {
        this._data = null;
        this._pos = 0;
    }

    public void clear(int capacity) {
        this._data = new double[capacity];
        this._pos = 0;
    }

    public void reset() {
        this.fill(0.0);
        this._pos = 0;
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public double remove(int offset2) {
        double old = this.get(offset2);
        this.remove(offset2, 1);
        return old;
    }

    public void remove(int offset2, int length) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset2) {
            System.arraycopy(this._data, offset2 + length, this._data, offset2, this._pos - (offset2 + length));
        }
        this._pos -= length;
    }

    public void transformValues(TDoubleFunction function2) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function2.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from2, int to) {
        if (from2 == to) {
            return;
        }
        if (from2 > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from2;
        for (int j = to - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private void swap(int i, int j) {
        double tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TDoubleArrayList clone = null;
        try {
            clone = (TDoubleArrayList)super.clone();
            clone._data = this._data == null ? null : (double[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public double[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public double[] toNativeArray(int offset2, int len) {
        double[] rv = new double[len];
        this.toNativeArray(rv, offset2, len);
        return rv;
    }

    public void toNativeArray(double[] dest, int offset2, int len) {
        if (len == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TDoubleArrayList) {
            TDoubleArrayList that = (TDoubleArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h2 = 0;
        int i = this._pos;
        while (i-- > 0) {
            h2 += HashFunctions.hash(this._data[i]);
        }
        return h2;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TDoubleProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, 0, this._pos);
        }
    }

    public void sort(int fromIndex, int toIndex) {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, fromIndex, toIndex);
        }
    }

    public void fill(double val) {
        if (!this.isEmpty()) {
            Arrays.fill(this._data, 0, this._pos, val);
        }
    }

    public void fill(int fromIndex, int toIndex, double val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        if (!this.isEmpty()) {
            Arrays.fill(this._data, fromIndex, toIndex, val);
        }
    }

    public int binarySearch(double value2) {
        return this.binarySearch(value2, 0, this._pos);
    }

    public int binarySearch(double value2, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = this._data[mid];
            if (midVal < value2) {
                low = mid + 1;
                continue;
            }
            if (midVal > value2) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(double value2) {
        return this.indexOf(0, value2);
    }

    public int indexOf(int offset2, double value2) {
        for (int i = offset2; i < this._pos; ++i) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double value2) {
        return this.lastIndexOf(this._pos, value2);
    }

    public int lastIndexOf(int offset2, double value2) {
        int i = offset2;
        while (i-- > 0) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(double value2) {
        return this.lastIndexOf(value2) >= 0;
    }

    public TDoubleArrayList grep(TDoubleProcedure condition) {
        TDoubleArrayList list2 = new TDoubleArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public TDoubleArrayList inverseGrep(TDoubleProcedure condition) {
        TDoubleArrayList list2 = new TDoubleArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public double max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        double max = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return max;
    }

    public double min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        double min2 = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            min2 = Math.min(min2, this._data[this._pos]);
        }
        return min2;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TDoubleProcedure(){

            public boolean execute(double val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this._data = new double[size];
        while (size-- > 0) {
            double val = stream.readDouble();
            this.add(val);
        }
    }
}

