/*
 * Decompiled with CFR 0.152.
 */
package javaslang.match.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javaslang.match.model.ClassModel;

class ImportManager {
    private final String packageNameOfClass;
    private List<String> directImports;
    private Map<FQN, Import> imports = new HashMap<FQN, Import>();

    private ImportManager(String packageNameOfClass, List<String> directImports) {
        this.packageNameOfClass = packageNameOfClass;
        this.directImports = directImports;
    }

    public static ImportManager forClass(ClassModel classModel, String ... directImports) {
        return new ImportManager(classModel.getPackageName(), ImportManager.reverseSort(directImports));
    }

    public String getType(ClassModel classModel) {
        FQN fqn = new FQN(classModel.getPackageName(), classModel.getClassName());
        return ImportManager.getType(fqn, this.imports, this.packageNameOfClass, this.directImports);
    }

    public String getType(String packageName, String className2) {
        FQN fqn = new FQN(packageName, className2);
        return ImportManager.getType(fqn, this.imports, this.packageNameOfClass, this.directImports);
    }

    public String getImports() {
        return ImportManager.optimizeImports(this.imports.values());
    }

    private static String getType(FQN fqn, Map<FQN, Import> imports, String packageNameOfClass, List<String> directImports) {
        if (fqn.packageName.isEmpty() && !packageNameOfClass.isEmpty()) {
            throw new IllegalStateException("Can't import class '" + fqn.className + "' located in default package");
        }
        if (fqn.packageName.equals(packageNameOfClass)) {
            Import _import = ImportManager.createImport(fqn, directImports);
            if (_import.type.equals(fqn.className)) {
                return fqn.className;
            }
            imports.put(fqn, _import);
            return _import.type;
        }
        if (imports.containsKey(fqn)) {
            return imports.get((Object)fqn).type;
        }
        Import _import = ImportManager.createImport(fqn, directImports);
        imports.put(fqn, _import);
        return _import.type;
    }

    private static Import createImport(FQN fqn, List<String> directImports) {
        String qualifiedName2 = fqn.qualifiedName();
        Optional<String> directImportOption = directImports.stream().filter(directImport -> qualifiedName2.equals(directImport) || qualifiedName2.startsWith(directImport + ".")).findFirst();
        if (directImportOption.isPresent()) {
            String directImport2 = directImportOption.get();
            if (qualifiedName2.equals(directImport2)) {
                String type2 = directImport2.substring(directImport2.lastIndexOf(46) + 1);
                return new Import(directImport2, type2);
            }
            String type3 = qualifiedName2.substring(directImport2.length() + 1);
            int index2 = type3.indexOf(".");
            String firstSegment = index2 < 0 ? type3 : type3.substring(0, index2);
            return new Import(directImport2 + "." + firstSegment, type3);
        }
        int index3 = fqn.className.indexOf(".");
        String firstSegment = index3 < 0 ? fqn.className : fqn.className.substring(0, index3);
        return new Import(fqn.packageName + "." + firstSegment, fqn.className);
    }

    private static String optimizeImports(Collection<Import> imports) {
        return imports.stream().filter(currentImport -> !currentImport.name.startsWith("java.lang.") || imports.stream().filter(otherImport -> !otherImport.equals(currentImport)).map(otherImport -> otherImport.type).filter(otherType -> otherType.equals(currentImport.type)).findFirst().isPresent()).map(_import -> _import.name).distinct().sorted().map(s2 -> "import " + s2 + ";").collect(Collectors.joining("\n"));
    }

    private static List<String> reverseSort(String[] strings2) {
        String[] copy2 = new String[strings2.length];
        System.arraycopy(strings2, 0, copy2, 0, strings2.length);
        Arrays.sort(copy2, (s1, s2) -> s2.compareTo((String)s1));
        return Arrays.asList(copy2);
    }

    private static class Import {
        final String name;
        final String type;

        Import(String name, String type2) {
            this.name = name;
            this.type = type2;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Import && this.toString().equals(o.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "Import(" + this.name + ", " + this.type + ")";
        }
    }

    private static class FQN {
        private final String packageName;
        private final String className;

        FQN(String packageName, String className2) {
            this.packageName = packageName;
            this.className = className2;
        }

        String qualifiedName() {
            return this.packageName.isEmpty() ? this.className : this.packageName + "." + this.className;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FQN && this.qualifiedName().equals(((FQN)o).qualifiedName());
        }

        public int hashCode() {
            return this.qualifiedName().hashCode();
        }

        public String toString() {
            return "FQN(" + this.packageName + ", " + this.className + ")";
        }
    }
}

