/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionClassKind
extends Enum<FunctionClassKind> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final FqName packageFqName;
    @NotNull
    private final String classNamePrefix;
    private final boolean isSuspendType;
    private final boolean isReflectType;
    public static final /* enum */ FunctionClassKind Function;
    public static final /* enum */ FunctionClassKind SuspendFunction;
    public static final /* enum */ FunctionClassKind KFunction;
    public static final /* enum */ FunctionClassKind KSuspendFunction;
    private static final /* synthetic */ FunctionClassKind[] $VALUES;

    private FunctionClassKind(FqName packageFqName, String classNamePrefix, boolean isSuspendType, boolean isReflectType) {
        this.packageFqName = packageFqName;
        this.classNamePrefix = classNamePrefix;
        this.isSuspendType = isSuspendType;
        this.isReflectType = isReflectType;
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    @NotNull
    public final Name numberedClassName(int arity) {
        Name name = Name.identifier(Intrinsics.stringPlus(this.classNamePrefix, arity));
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"$classNamePrefix$arity\")");
        return name;
    }

    public static FunctionClassKind[] values() {
        return (FunctionClassKind[])$VALUES.clone();
    }

    public static FunctionClassKind valueOf(String value2) {
        return Enum.valueOf(FunctionClassKind.class, value2);
    }

    static {
        Function = new FunctionClassKind(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, "Function", false, false);
        SuspendFunction = new FunctionClassKind(StandardNames.COROUTINES_PACKAGE_FQ_NAME, "SuspendFunction", true, false);
        KFunction = new FunctionClassKind(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KFunction", false, true);
        KSuspendFunction = new FunctionClassKind(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KSuspendFunction", true, true);
        $VALUES = functionClassKindArray = new FunctionClassKind[]{FunctionClassKind.Function, FunctionClassKind.SuspendFunction, FunctionClassKind.KFunction, FunctionClassKind.KSuspendFunction};
        Companion = new Companion(null);
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FunctionClassKind byClassNamePrefix(@NotNull FqName packageFqName, @NotNull String className2) {
            FunctionClassKind functionClassKind;
            block1: {
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Intrinsics.checkNotNullParameter(className2, "className");
                FunctionClassKind[] $this$firstOrNull$iv = FunctionClassKind.values();
                boolean $i$f$firstOrNull = false;
                for (FunctionClassKind element$iv : $this$firstOrNull$iv) {
                    FunctionClassKind it = element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getPackageFqName(), packageFqName) && StringsKt.startsWith$default(className2, it.getClassNamePrefix(), false, 2, null))) continue;
                    functionClassKind = element$iv;
                    break block1;
                }
                functionClassKind = null;
            }
            return functionClassKind;
        }

        @Nullable
        public final KindWithArity parseClassName(@NotNull String className2, @NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter(className2, "className");
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            FunctionClassKind functionClassKind = this.byClassNamePrefix(packageFqName, className2);
            if (functionClassKind == null) {
                return null;
            }
            FunctionClassKind kind = functionClassKind;
            String prefix = kind.getClassNamePrefix();
            String string2 = className2.substring(prefix.length());
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            Integer n = this.toInt(string2);
            if (n == null) {
                return null;
            }
            int arity = n;
            return new KindWithArity(kind, arity);
        }

        @JvmStatic
        @Nullable
        public final FunctionClassKind getFunctionalClassKind(@NotNull String className2, @NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter(className2, "className");
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            KindWithArity kindWithArity = this.parseClassName(className2, packageFqName);
            return kindWithArity == null ? null : kindWithArity.getKind();
        }

        private final Integer toInt(String s2) {
            if (((CharSequence)s2).length() == 0) {
                return null;
            }
            int result2 = 0;
            String string2 = s2;
            int n = 0;
            int n2 = string2.length();
            while (n < n2) {
                char c = string2.charAt(n);
                ++n;
                int d = c - 48;
                if (!(0 <= d ? d < 10 : false)) {
                    return null;
                }
                result2 = result2 * 10 + d;
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class KindWithArity {
            @NotNull
            private final FunctionClassKind kind;
            private final int arity;

            public KindWithArity(@NotNull FunctionClassKind kind, int arity) {
                Intrinsics.checkNotNullParameter((Object)kind, "kind");
                this.kind = kind;
                this.arity = arity;
            }

            @NotNull
            public final FunctionClassKind getKind() {
                return this.kind;
            }

            @NotNull
            public final FunctionClassKind component1() {
                return this.kind;
            }

            public final int component2() {
                return this.arity;
            }

            @NotNull
            public String toString() {
                return "KindWithArity(kind=" + (Object)((Object)this.kind) + ", arity=" + this.arity + ')';
            }

            public int hashCode() {
                int result2 = this.kind.hashCode();
                result2 = result2 * 31 + this.arity;
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof KindWithArity)) {
                    return false;
                }
                KindWithArity kindWithArity = (KindWithArity)other;
                if (this.kind != kindWithArity.kind) {
                    return false;
                }
                return this.arity == kindWithArity.arity;
            }
        }
    }
}

