/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.InvalidModuleExceptionKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleCapability;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependencies;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependenciesImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatform;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @Nullable
    private final TargetPlatform platform;
    @Nullable
    private final Name stableName;
    @NotNull
    private final Map<ModuleCapability<?>, Object> capabilities;
    @NotNull
    private final PackageViewDescriptorFactory packageViewDescriptorFactory;
    @Nullable
    private ModuleDependencies dependencies;
    @Nullable
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private boolean isValid;
    @NotNull
    private final MemoizedFunctionToNotNull<FqName, PackageViewDescriptor> packages;
    @NotNull
    private final Lazy packageFragmentProviderForWholeModuleWithDependencies$delegate;

    @JvmOverloads
    public ModuleDescriptorImpl(@NotNull Name moduleName, @NotNull StorageManager storageManager, @NotNull KotlinBuiltIns builtIns, @Nullable TargetPlatform platform, @NotNull Map<ModuleCapability<?>, ? extends Object> capabilities, @Nullable Name stableName) {
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(capabilities, "capabilities");
        super(Annotations.Companion.getEMPTY(), moduleName);
        this.storageManager = storageManager;
        this.builtIns = builtIns;
        this.platform = platform;
        this.stableName = stableName;
        if (!moduleName.isSpecial()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Module name must be special: ", moduleName));
        }
        this.capabilities = capabilities;
        PackageViewDescriptorFactory packageViewDescriptorFactory = this.getCapability(PackageViewDescriptorFactory.Companion.getCAPABILITY());
        this.packageViewDescriptorFactory = packageViewDescriptorFactory == null ? (PackageViewDescriptorFactory)PackageViewDescriptorFactory.Default.INSTANCE : packageViewDescriptorFactory;
        this.isValid = true;
        this.packages = this.storageManager.createMemoizedFunction((Function1)new Function1<FqName, PackageViewDescriptor>(this){
            final /* synthetic */ ModuleDescriptorImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PackageViewDescriptor invoke(@NotNull FqName fqName2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                return ModuleDescriptorImpl.access$getPackageViewDescriptorFactory$p(this.this$0).compute(this.this$0, fqName2, ModuleDescriptorImpl.access$getStorageManager$p(this.this$0));
            }
        });
        this.packageFragmentProviderForWholeModuleWithDependencies$delegate = LazyKt.lazy((Function0)new Function0<CompositePackageFragmentProvider>(this){
            final /* synthetic */ ModuleDescriptorImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CompositePackageFragmentProvider invoke() {
                Collection<PackageFragmentProvider> collection;
                void $this$mapTo$iv$iv;
                void $this$forEach$iv;
                void $this$sure$iv;
                ModuleDependencies moduleDependencies2 = ModuleDescriptorImpl.access$getDependencies$p(this.this$0);
                ModuleDescriptorImpl moduleDescriptorImpl = this.this$0;
                boolean $i$f$sure22 = false;
                void var5_8 = $this$sure$iv;
                if (var5_8 == null) {
                    String string2;
                    boolean bl = false;
                    String string3 = string2 = "Dependencies of module " + ModuleDescriptorImpl.access$getId(moduleDescriptorImpl) + " were not set before querying module content";
                    throw new AssertionError((Object)string3);
                }
                void moduleDependencies3 = var5_8;
                List<ModuleDescriptorImpl> dependenciesDescriptors = moduleDependencies3.getAllDependencies();
                this.this$0.assertValid();
                boolean bl = dependenciesDescriptors.contains(this.this$0);
                ModuleDescriptorImpl $i$f$sure22 = this.this$0;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2$22 = false;
                    String $i$a$-assert-ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2$22 = "Module " + ModuleDescriptorImpl.access$getId($i$f$sure22) + " is not contained in its own dependencies, this is probably a misconfiguration";
                    throw new AssertionError((Object)$i$a$-assert-ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2$22);
                }
                Iterable iterable = dependenciesDescriptors;
                $i$f$sure22 = this.this$0;
                boolean $i$f$forEach22 = false;
                for (T element$iv : $this$forEach$iv) {
                    ModuleDescriptorImpl dependency = (ModuleDescriptorImpl)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = ModuleDescriptorImpl.access$isInitialized(dependency);
                    if (!_Assertions.ENABLED || bl3) continue;
                    boolean $i$a$-assert-ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2$2$22 = false;
                    String $i$a$-assert-ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2$2$22 = "Dependency module " + ModuleDescriptorImpl.access$getId(dependency) + " was not initialized by the time contents of dependent module " + ModuleDescriptorImpl.access$getId($i$f$sure22) + " were queried";
                    throw new AssertionError((Object)$i$a$-assert-ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2$2$22);
                }
                Iterable $this$map$iv = dependenciesDescriptors;
                boolean $i$f$map = false;
                Iterable $i$f$forEach22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    PackageFragmentProvider packageFragmentProvider;
                    void it;
                    ModuleDescriptorImpl moduleDescriptorImpl2 = (ModuleDescriptorImpl)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull(ModuleDescriptorImpl.access$getPackageFragmentProviderForModuleContent$p((ModuleDescriptorImpl)it));
                    collection.add(packageFragmentProvider);
                }
                collection = (List)destination$iv$iv;
                String string4 = Intrinsics.stringPlus("CompositeProvider@ModuleDescriptor for ", this.this$0.getName());
                List list2 = collection;
                return new CompositePackageFragmentProvider(list2, string4);
            }
        });
    }

    public /* synthetic */ ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map map, Name name2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            targetPlatform = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            name2 = null;
        }
        this(name, storageManager, kotlinBuiltIns, targetPlatform, map, name2);
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void assertValid() {
        if (!this.isValid()) {
            InvalidModuleExceptionKt.moduleInvalidated(this);
        }
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getExpectedByModules() {
        ModuleDependencies $this$sure$iv = this.dependencies;
        boolean $i$f$sure = false;
        ModuleDependencies moduleDependencies2 = $this$sure$iv;
        if (moduleDependencies2 == null) {
            String string2;
            boolean bl = false;
            String string3 = string2 = "Dependencies of module " + this.getId() + " were not set";
            throw new AssertionError((Object)string3);
        }
        return moduleDependencies2.getDirectExpectedByDependencies();
    }

    @Override
    @NotNull
    public PackageViewDescriptor getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        this.assertValid();
        return (PackageViewDescriptor)this.packages.invoke(fqName2);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(nameFilter2, "nameFilter");
        this.assertValid();
        return this.getPackageFragmentProvider().getSubPackagesOf(fqName2, nameFilter2);
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        Lazy lazy = this.packageFragmentProviderForWholeModuleWithDependencies$delegate;
        Object var2_2 = null;
        return (CompositePackageFragmentProvider)lazy.getValue();
    }

    private final boolean isInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    public final void setDependencies(@NotNull ModuleDependencies dependencies2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        boolean bl2 = bl = this.dependencies == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Dependencies of " + this.getId() + " were already set";
            throw new AssertionError((Object)string2);
        }
        this.dependencies = dependencies2;
    }

    public final void setDependencies(ModuleDescriptorImpl ... descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        this.setDependencies(ArraysKt.toList(descriptors));
    }

    public final void setDependencies(@NotNull List<ModuleDescriptorImpl> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        this.setDependencies(descriptors, SetsKt.<ModuleDescriptorImpl>emptySet());
    }

    public final void setDependencies(@NotNull List<ModuleDescriptorImpl> descriptors, @NotNull Set<ModuleDescriptorImpl> friends) {
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        Intrinsics.checkNotNullParameter(friends, "friends");
        this.setDependencies(new ModuleDependenciesImpl(descriptors, friends, CollectionsKt.<ModuleDescriptorImpl>emptyList(), SetsKt.<ModuleDescriptorImpl>emptySet()));
    }

    @Override
    public boolean shouldSeeInternalsOf(@NotNull ModuleDescriptor targetModule) {
        Intrinsics.checkNotNullParameter(targetModule, "targetModule");
        if (Intrinsics.areEqual(this, targetModule)) {
            return true;
        }
        ModuleDependencies moduleDependencies2 = this.dependencies;
        Intrinsics.checkNotNull(moduleDependencies2);
        if (CollectionsKt.contains((Iterable)moduleDependencies2.getModulesWhoseInternalsAreVisible(), targetModule)) {
            return true;
        }
        if (this.getExpectedByModules().contains(targetModule)) {
            return true;
        }
        return targetModule.getExpectedByModules().contains(this);
    }

    private final String getId() {
        String string2 = this.getName().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.toString()");
        return string2;
    }

    public final void initialize(@NotNull PackageFragmentProvider providerForModuleContent) {
        boolean bl;
        Intrinsics.checkNotNullParameter(providerForModuleContent, "providerForModuleContent");
        boolean bl2 = bl = !this.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Attempt to initialize module " + this.getId() + " twice";
            throw new AssertionError((Object)string2);
        }
        this.packageFragmentProviderForModuleContent = providerForModuleContent;
    }

    @NotNull
    public final PackageFragmentProvider getPackageFragmentProvider() {
        this.assertValid();
        return this.getPackageFragmentProviderForWholeModuleWithDependencies();
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull ModuleCapability<T> capability) {
        Intrinsics.checkNotNullParameter(capability, "capability");
        Object object = this.capabilities.get(capability);
        if (object == null) {
            // empty if block
        }
        return (T)object;
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    @Override
    public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return ModuleDescriptor.DefaultImpls.accept(this, visitor2, data2);
    }

    @JvmOverloads
    public ModuleDescriptorImpl(@NotNull Name moduleName, @NotNull StorageManager storageManager, @NotNull KotlinBuiltIns builtIns, @Nullable TargetPlatform platform) {
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        this(moduleName, storageManager, builtIns, platform, null, null, 48, null);
    }

    public static final /* synthetic */ PackageViewDescriptorFactory access$getPackageViewDescriptorFactory$p(ModuleDescriptorImpl $this) {
        return $this.packageViewDescriptorFactory;
    }

    public static final /* synthetic */ StorageManager access$getStorageManager$p(ModuleDescriptorImpl $this) {
        return $this.storageManager;
    }

    public static final /* synthetic */ ModuleDependencies access$getDependencies$p(ModuleDescriptorImpl $this) {
        return $this.dependencies;
    }

    public static final /* synthetic */ String access$getId(ModuleDescriptorImpl $this) {
        return $this.getId();
    }

    public static final /* synthetic */ boolean access$isInitialized(ModuleDescriptorImpl $this) {
        return $this.isInitialized();
    }

    public static final /* synthetic */ PackageFragmentProvider access$getPackageFragmentProviderForModuleContent$p(ModuleDescriptorImpl $this) {
        return $this.packageFragmentProviderForModuleContent;
    }
}

