/*
 * Decompiled with CFR 0.152.
 */
package kotlin.test;

import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertContentEqualsImplKt;
import kotlin.test.AssertionsKt;
import kotlin.test.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\b\u001a\u00a4\u0001\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\t0\b2\u001f\u0010\n\u001a\u001b\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0002\b\r2\u0019\u0010\u000e\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\b\r2!\u0010\u000f\u001a\u001d\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\u0010\u0011\u001aV\u0010\u0012\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00022\u001b\u0010\u0014\u001a\u0017\u0012\u0004\u0012\u0002H\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\b\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\u0010\u0016\u001ak\u0010\u0017\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00022\u0019\u0010\u000e\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\b\rH\u0002\u0082\u0002\u0014\n\u0012\b\u0000\u0012\u0002\u0018\u0001\u001a\n\b\u0003\u0010\u00032\u0004\b\u0003\u0010\u0004\u00a2\u0006\u0002\u0010\u0018\u001a,\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u001d"}, d2={"assertArrayContentEquals", "", "T", "message", "", "expected", "actual", "size", "Lkotlin/Function1;", "", "get", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "contentToString", "contentEquals", "", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "assertIterableContentEquals", "typeName", "iterator", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "checkReferenceAndNullEquality", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "elementsDifferMessage", "index", "expectedElement", "actualElement", "kotlin-test"})
public final class AssertContentEqualsImplKt {
    public static final <T> void assertIterableContentEquals(@NotNull String typeName, @Nullable String message2, @Nullable T expected, @Nullable T actual, @NotNull Function1<? super T, ? extends Iterator<?>> iterator2) {
        String string2;
        Intrinsics.checkNotNullParameter(typeName, "typeName");
        Intrinsics.checkNotNullParameter(iterator2, "iterator");
        if (AssertContentEqualsImplKt.checkReferenceAndNullEquality(typeName, message2, expected, actual, assertIterableContentEquals.1.INSTANCE)) {
            return;
        }
        int index2 = 0;
        Iterator<?> expectedIt = iterator2.invoke(expected);
        Iterator<?> actualIt = iterator2.invoke(actual);
        while (expectedIt.hasNext() && actualIt.hasNext()) {
            Object actualElement;
            Object expectedElement = expectedIt.next();
            if (!Intrinsics.areEqual(expectedElement, actualElement = actualIt.next())) {
                AssertionsKt.fail(Intrinsics.stringPlus(UtilsKt.messagePrefix(message2), AssertContentEqualsImplKt.elementsDifferMessage(typeName, index2, expectedElement, actualElement)));
                throw new KotlinNothingValueException();
            }
            int n = index2;
            index2 = n + 1;
        }
        if (expectedIt.hasNext()) {
            if (!(!actualIt.hasNext())) {
                string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            AssertionsKt.fail(UtilsKt.messagePrefix(message2) + typeName + " lengths differ. Expected length is bigger than " + index2 + ", actual length is " + index2 + '.');
            throw new KotlinNothingValueException();
        }
        if (actualIt.hasNext()) {
            if (!(!expectedIt.hasNext())) {
                string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            AssertionsKt.fail(UtilsKt.messagePrefix(message2) + typeName + " lengths differ. Expected length is " + index2 + ", actual length is bigger than " + index2 + '.');
            throw new KotlinNothingValueException();
        }
    }

    public static final <T> void assertArrayContentEquals(@Nullable String message2, @Nullable T expected, @Nullable T actual, @NotNull Function1<? super T, Integer> size, @NotNull Function2<? super T, ? super Integer, ? extends Object> get2, @NotNull Function1<? super T, String> contentToString, @NotNull Function2<? super T, ? super T, Boolean> contentEquals) {
        int actualSize;
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(get2, "get");
        Intrinsics.checkNotNullParameter(contentToString, "contentToString");
        Intrinsics.checkNotNullParameter(contentEquals, "contentEquals");
        if (contentEquals.invoke(expected, actual).booleanValue()) {
            return;
        }
        String typeName = "Array";
        if (AssertContentEqualsImplKt.checkReferenceAndNullEquality(typeName, message2, expected, actual, contentToString)) {
            return;
        }
        int expectedSize = ((Number)size.invoke(expected)).intValue();
        if (expectedSize != (actualSize = ((Number)size.invoke(actual)).intValue())) {
            String sizesDifferMessage = typeName + " sizes differ. Expected size is " + expectedSize + ", actual size is " + actualSize + '.';
            String toString2 = "Expected <" + contentToString.invoke(expected) + ">, actual <" + contentToString.invoke(actual) + ">.";
            AssertionsKt.fail(UtilsKt.messagePrefix(message2) + sizesDifferMessage + '\n' + toString2);
            throw new KotlinNothingValueException();
        }
        int n = 0;
        while (n < expectedSize) {
            Object actualElement;
            int index2;
            Object expectedElement;
            if (Intrinsics.areEqual(expectedElement = get2.invoke(expected, index2 = n++), actualElement = get2.invoke(actual, index2))) continue;
            String elementsDifferMessage = AssertContentEqualsImplKt.elementsDifferMessage(typeName, index2, expectedElement, actualElement);
            String toString3 = "Expected <" + contentToString.invoke(expected) + ">, actual <" + contentToString.invoke(actual) + ">.";
            AssertionsKt.fail(UtilsKt.messagePrefix(message2) + elementsDifferMessage + '\n' + toString3);
            throw new KotlinNothingValueException();
        }
    }

    private static final <T> boolean checkReferenceAndNullEquality(String typeName, String message2, T expected, T actual, Function1<? super T, String> contentToString) {
        if (expected == actual) {
            return true;
        }
        if (expected == null) {
            AssertionsKt.fail(UtilsKt.messagePrefix(message2) + "Expected <null> " + typeName + ", actual <" + contentToString.invoke(actual) + ">.");
            throw new KotlinNothingValueException();
        }
        if (actual == null) {
            AssertionsKt.fail(UtilsKt.messagePrefix(message2) + "Expected non-null " + typeName + " <" + contentToString.invoke(expected) + ">, actual <null>.");
            throw new KotlinNothingValueException();
        }
        return false;
    }

    private static final String elementsDifferMessage(String typeName, int index2, Object expectedElement, Object actualElement) {
        return typeName + " elements differ at index " + index2 + ". Expected element <" + expectedElement + ">, actual element <" + actualElement + ">.";
    }
}

