/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.wasm.CompilerKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleFragmentGenerator;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u00a8\u0006\u000e"}, d2={"compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "depsDescriptors", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "generateJs", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "backend.wasm"})
public final class CompilerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final WasmCompilerResult compileWasm(@NotNull ModulesStructure depsDescriptors, @NotNull PhaseConfig phaseConfig, @NotNull IrFactory irFactory, @NotNull Set<FqName> exportedDeclarations) {
        void $this$flatMapTo$iv$iv;
        Object element$iv2;
        List<IrModuleFragment> list2;
        Intrinsics.checkNotNullParameter(depsDescriptors, "depsDescriptors");
        Intrinsics.checkNotNullParameter(phaseConfig, "phaseConfig");
        Intrinsics.checkNotNullParameter(irFactory, "irFactory");
        Intrinsics.checkNotNullParameter(exportedDeclarations, "exportedDeclarations");
        MainModule mainModule = depsDescriptors.getMainModule();
        CompilerConfiguration configuration = depsDescriptors.getCompilerConfiguration();
        IrModuleInfo irModuleInfo = KlibKt.loadIr(depsDescriptors, irFactory, false);
        IrModuleFragment moduleFragment = irModuleInfo.component1();
        List<IrModuleFragment> dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker deserializer = irModuleInfo.component5();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf(moduleFragment));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List<IrModuleFragment> allModules2 = list2;
        ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
        WasmBackendContext context2 = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment, exportedDeclarations, configuration);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv2;
            boolean bl = false;
            new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf(deserializer)).generateUnboundSymbolsAsDependencies();
        }
        Object $this$flatMap$iv = allModules2;
        boolean $i$f$flatMap22 = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List irFiles2 = (List)destination$iv$iv;
        moduleFragment.getFiles().clear();
        $this$flatMap$iv = moduleFragment;
        Collection $i$f$flatMap22 = ((IrModuleFragment)$this$flatMap$iv).getFiles();
        CollectionsKt.addAll($i$f$flatMap22, irFiles2);
        new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf(deserializer)).generateUnboundSymbolsAsDependencies();
        PatchDeclarationParentsKt.patchDeclarationParents$default(moduleFragment, null, 1, null);
        deserializer.postProcess();
        SymbolTableKt.noUnboundLeft(symbolTable, "Unbound symbols at the end of linker");
        CompilerPhaseKt.invokeToplevel((CompilerPhase)WasmLoweringPhasesKt.getWasmPhases(), phaseConfig, (CommonBackendContext)context2, moduleFragment);
        WasmCompiledModuleFragment compiledWasmModule = new WasmCompiledModuleFragment();
        WasmModuleFragmentGenerator codeGenerator = new WasmModuleFragmentGenerator(context2, compiledWasmModule);
        codeGenerator.generateModule(moduleFragment);
        WasmModule linkedModule = compiledWasmModule.linkWasmCompiledFragments();
        WasmIrToText watGenerator = new WasmIrToText();
        watGenerator.appendWasmModule(linkedModule);
        String wat = watGenerator.toString();
        String js2 = CompilerKt.generateJs(compiledWasmModule);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        new WasmIrToBinary(os, linkedModule).appendWasmModule();
        byte[] byteArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byteArray, "byteArray");
        return new WasmCompilerResult(wat, js2, byteArray);
    }

    public static /* synthetic */ WasmCompilerResult compileWasm$default(ModulesStructure modulesStructure, PhaseConfig phaseConfig, IrFactory irFactory, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return CompilerKt.compileWasm(modulesStructure, phaseConfig, irFactory, set);
    }

    @NotNull
    public static final String generateJs(@NotNull WasmCompiledModuleFragment $this$generateJs) {
        Intrinsics.checkNotNullParameter($this$generateJs, "<this>");
        String runtime = "var wasmInstance = null;\n\nconst runtime = {\n    identity(x) {\n        return x;\n    },\n\n    println(valueAddr) {\n        console.log(\">>>  \" + importStringFromWasm(valueAddr));\n    }\n};\n\nfunction importStringFromWasm(addr) {\n    const mem16 = new Uint16Array(wasmInstance.exports.memory.buffer);\n    const mem32 = new Int32Array(wasmInstance.exports.memory.buffer);\n    const len = mem32[addr / 4];\n    const str_start_addr = (addr + 4) / 2;\n    const slice = mem16.slice(str_start_addr, str_start_addr + len);\n    return String.fromCharCode.apply(null, slice);\n}";
        String jsCode2 = "\nconst js_code = {" + CollectionsKt.joinToString$default($this$generateJs.getJsFuns(), ",\n", null, null, 0, null, generateJs.jsCode.1.INSTANCE, 30, null) + "};";
        return Intrinsics.stringPlus(runtime, jsCode2);
    }
}

