/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.CompiledReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 **\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001*B5\u0012.\b\u0002\u0010\u0003\u001a(\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u00070\u0004j\b\u0012\u0004\u0012\u00028\u0000`\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0004j\u0004\u0018\u0001`\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0015J,\u0010\u0018\u001a(\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u00070\u0004j\b\u0012\u0004\u0012\u00028\u0000`\bJ\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00150\u0004j\u0002`\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J#\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0004j\u0004\u0018\u0001`\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010\u001f\u001a\u00020\u0013J\b\u0010 \u001a\u0004\u0018\u00010\u0006J \u0010!\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0007J\r\u0010\"\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0006J,\u0010%\u001a(\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`&0\u0004j\b\u0012\u0004\u0012\u00028\u0000`'J4\u0010(\u001a(\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`&0\u0004j\b\u0012\u0004\u0012\u00028\u0000`'2\u0006\u0010)\u001a\u00020\u001cJ4\u0010(\u001a(\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u00070\u0004j\b\u0012\u0004\u0012\u00028\u0000`\b2\u0006\u0010\u000f\u001a\u00020\u0006J4\u0010(\u001a(\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`&0\u0004j\b\u0012\u0004\u0012\u00028\u0000`'2\u0006\u0010\u000f\u001a\u00020\u0015R4\u0010\n\u001a(\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u00070\u000bj\b\u0012\u0004\u0012\u00028\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/ReplHistory;", "T", "Ljava/io/Serializable;", "startingHistory", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/cli/common/repl/CompiledReplCodeLine;", "Lorg/jetbrains/kotlin/cli/common/repl/CompiledHistoryItem;", "Lorg/jetbrains/kotlin/cli/common/repl/CompiledHistoryList;", "(Ljava/util/List;)V", "history", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/kotlin/cli/common/repl/CompiledHistoryStorage;", "add", "", "line", "value", "(Lorg/jetbrains/kotlin/cli/common/repl/CompiledReplCodeLine;Ljava/lang/Object;)V", "checkHistoryIsInSync", "", "compareHistory", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "Lorg/jetbrains/kotlin/cli/common/repl/SourceList;", "contains", "copyAll", "copySources", "copyValues", "firstMismatchingHistory", "", "(Ljava/util/List;)Ljava/lang/Integer;", "isEmpty", "isNotEmpty", "lastCodeLine", "lastItem", "lastValue", "()Ljava/lang/Object;", "removeLast", "reset", "Lorg/jetbrains/kotlin/cli/common/repl/SourceHistoryItem;", "Lorg/jetbrains/kotlin/cli/common/repl/SourceHistoryList;", "resetToLine", "lineNumber", "Companion", "cli-common"})
public final class ReplHistory<T>
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayDeque<Pair<CompiledReplCodeLine, T>> history;
    private static final long serialVersionUID = 8328353000L;

    public ReplHistory(@NotNull List<? extends Pair<CompiledReplCodeLine, ? extends T>> startingHistory) {
        Intrinsics.checkNotNullParameter(startingHistory, "startingHistory");
        this.history = new ArrayDeque(startingHistory);
    }

    public /* synthetic */ ReplHistory(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list2);
    }

    public final boolean isEmpty() {
        return this.history.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.history).isEmpty();
    }

    public final void add(@NotNull CompiledReplCodeLine line2, T value2) {
        Intrinsics.checkNotNullParameter(line2, "line");
        this.history.add(TuplesKt.to(line2, value2));
    }

    public final boolean removeLast(@NotNull CompiledReplCodeLine line2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(line2, "line");
        if (Intrinsics.areEqual(this.history.peekLast().getFirst(), line2)) {
            this.history.removeLast();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<ReplCodeLine, T>> reset() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.history;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair2 = new Pair(((CompiledReplCodeLine)it.getFirst()).getSource(), it.getSecond());
            collection.add(pair2);
        }
        List removed2 = (List)destination$iv$iv;
        this.history.clear();
        return removed2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<ReplCodeLine, T>> resetToLine(int lineNumber) {
        ArrayList removed2 = new ArrayList();
        while (true) {
            void it;
            Serializable serializable;
            int n;
            Pair<CompiledReplCodeLine, T> pair;
            if ((pair = this.history.peekLast()) == null) {
                n = -1;
            } else {
                serializable = pair.getFirst();
                ReplCodeLine replCodeLine = serializable.getSource();
                n = replCodeLine.getNo();
            }
            if (n <= lineNumber) break;
            pair = this.history.removeLast();
            serializable = pair;
            ArrayList arrayList = removed2;
            boolean bl = false;
            Pair pair2 = new Pair(((CompiledReplCodeLine)it.getFirst()).getSource(), it.getSecond());
            arrayList.add(pair2);
        }
        return CollectionsKt.reversed(removed2);
    }

    @NotNull
    public final List<Pair<ReplCodeLine, T>> resetToLine(@NotNull ReplCodeLine line2) {
        Intrinsics.checkNotNullParameter(line2, "line");
        return this.resetToLine(line2.getNo());
    }

    @NotNull
    public final List<Pair<CompiledReplCodeLine, T>> resetToLine(@NotNull CompiledReplCodeLine line2) {
        Intrinsics.checkNotNullParameter(line2, "line");
        ArrayList<Pair<CompiledReplCodeLine, T>> removed2 = new ArrayList<Pair<CompiledReplCodeLine, T>>();
        while (true) {
            int n;
            Pair<CompiledReplCodeLine, T> pair;
            if ((pair = this.history.peekLast()) == null) {
                n = -1;
            } else {
                CompiledReplCodeLine compiledReplCodeLine = pair.getFirst();
                ReplCodeLine replCodeLine = compiledReplCodeLine.getSource();
                n = replCodeLine.getNo();
            }
            if (n <= line2.getSource().getNo()) break;
            removed2.add(this.history.removeLast());
        }
        return CollectionsKt.reversed((Iterable)removed2);
    }

    public final boolean contains(@NotNull ReplCodeLine line2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(line2, "line");
            Iterable $this$any$iv = this.history;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((CompiledReplCodeLine)it.getFirst()).getSource(), line2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean contains(@NotNull CompiledReplCodeLine line2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(line2, "line");
            Iterable $this$any$iv = this.history;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getFirst(), line2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final Pair<CompiledReplCodeLine, T> lastItem() {
        return this.history.peekLast();
    }

    @Nullable
    public final CompiledReplCodeLine lastCodeLine() {
        Pair<CompiledReplCodeLine, T> pair = this.lastItem();
        return pair == null ? null : pair.getFirst();
    }

    @Nullable
    public final T lastValue() {
        Pair<CompiledReplCodeLine, T> pair = this.lastItem();
        return pair == null ? null : (T)pair.getSecond();
    }

    public final boolean checkHistoryIsInSync(@Nullable List<ReplCodeLine> compareHistory) {
        return this.firstMismatchingHistory(compareHistory) == null;
    }

    @Nullable
    public final Integer firstMismatchingHistory(@Nullable List<ReplCodeLine> compareHistory) {
        Integer n;
        if (compareHistory == null) {
            n = null;
        } else if (compareHistory.size() == this.history.size()) {
            Object v1;
            block7: {
                Iterable $this$firstOrNull$iv = CollectionsKt.zip((Iterable)this.history, (Iterable)compareHistory);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual(((CompiledReplCodeLine)((Pair)it.getFirst()).getFirst()).getSource(), it.getSecond()))) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            Pair pair = v1;
            if (pair == null) {
                n = null;
            } else {
                ReplCodeLine replCodeLine = (ReplCodeLine)pair.getSecond();
                n = replCodeLine.getNo();
            }
        } else {
            n = compareHistory.size() > this.history.size() ? Integer.valueOf(compareHistory.get(this.history.size()).getNo()) : Integer.valueOf(((CompiledReplCodeLine)((Pair)CollectionsKt.toList((Iterable)this.history).get(compareHistory.size())).getFirst()).getSource().getNo());
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ReplCodeLine> copySources() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.history;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ReplCodeLine replCodeLine = ((CompiledReplCodeLine)it.getFirst()).getSource();
            collection.add(replCodeLine);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> copyValues() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.history;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object b = it.getSecond();
            collection.add(b);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Pair<CompiledReplCodeLine, T>> copyAll() {
        return CollectionsKt.toList((Iterable)this.history);
    }

    public ReplHistory() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/ReplHistory$Companion;", "", "()V", "serialVersionUID", "", "cli-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

