/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.plugins;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ)\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0086\bJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0011\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\b2\u0006\u0010\u0013\u001a\u00020\u0014J8\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015\"\u0004\b\u0000\u0010\r2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0013\u001a\u00020\u0016J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\bJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/ServiceLoaderLite;", "", "()V", "SERVICE_DIRECTORY_LOCATION", "", "findImplementations", "", "service", "Ljava/lang/Class;", "file", "Ljava/io/File;", "files", "", "Service", "findImplementationsInDirectory", "classId", "findImplementationsInJar", "getClassIdentifier", "loadImplementations", "classLoader", "Ljava/net/URLClassLoader;", "", "Ljava/lang/ClassLoader;", "parseLine", "line", "parseLines", "lines", "Lkotlin/sequences/Sequence;", "ServiceLoadingException", "cli"})
public final class ServiceLoaderLite {
    @NotNull
    public static final ServiceLoaderLite INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <Service> List<Service> loadImplementations(@NotNull Class<? extends Service> service, @NotNull URLClassLoader classLoader) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(service, "service");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        URL[] uRLArray = classLoader.getURLs();
        Intrinsics.checkNotNullExpressionValue(uRLArray, "classLoader.urLs");
        URL[] $this$map$iv = uRLArray;
        boolean $i$f$map = false;
        URL[] uRLArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            File file2;
            void url;
            void var13_12 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                file2 = Paths.get(url.toURI()).toFile();
            }
            catch (FileSystemNotFoundException e) {
                StringBuilder stringBuilder2 = new StringBuilder().append("Only local URLs are supported, got ");
                void v2 = url;
                Intrinsics.checkNotNullExpressionValue(v2, "url");
                throw (Throwable)new IllegalArgumentException(stringBuilder2.append(v2.getProtocol()).toString());
            }
            catch (UnsupportedOperationException e) {
                StringBuilder stringBuilder3 = new StringBuilder().append("Only local URLs are supported, got ");
                void v4 = url;
                Intrinsics.checkNotNullExpressionValue(v4, "url");
                throw (Throwable)new IllegalArgumentException(stringBuilder3.append(v4.getProtocol()).toString());
            }
            File file3 = file2;
            collection.add(file3);
        }
        List files2 = (List)destination$iv$iv;
        return this.loadImplementations(service, files2, classLoader);
    }

    @NotNull
    public final <Service> List<Service> loadImplementations(@NotNull Class<? extends Service> service, @NotNull List<? extends File> files2, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(service, "service");
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        List implementations = new ArrayList();
        for (String className2 : this.findImplementations(service, files2)) {
            Object instance = Class.forName(className2, false, classLoader).newInstance();
            Collection collection = implementations;
            Service Service2 = service.cast(instance);
            collection.add(Service2);
        }
        return implementations;
    }

    public final /* synthetic */ <Service> Set<String> findImplementations(List<? extends File> files2) {
        int $i$f$findImplementations = 0;
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.reifiedOperationMarker(4, "Service");
        return this.findImplementations(Object.class, files2);
    }

    public final /* synthetic */ <Service> List<Service> loadImplementations(URLClassLoader classLoader) {
        int $i$f$loadImplementations = 0;
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        Intrinsics.reifiedOperationMarker(4, "Service");
        return this.loadImplementations(Object.class, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> findImplementations(@NotNull Class<?> service, @NotNull List<? extends File> files2) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter(service, "service");
        Intrinsics.checkNotNullParameter(files2, "files");
        Iterable iterable = files2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Iterable list$iv = INSTANCE.findImplementations(service, it);
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Set<String> findImplementations(Class<?> service, File file2) {
        Set<String> set;
        String classIdentifier = this.getClassIdentifier(service);
        if (file2.isDirectory()) {
            set = this.findImplementationsInDirectory(classIdentifier, file2);
            return set;
        }
        if (file2.isFile()) {
            String string2 = FilesKt.getExtension(file2);
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual(string3, "jar")) {
                set = this.findImplementationsInJar(classIdentifier, file2);
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Set<String> findImplementationsInDirectory(String classId, File file2) {
        File file3;
        File it = file3 = new File(file2, "META-INF/services/" + classId);
        boolean bl = false;
        File file4 = it.isFile() ? file3 : null;
        if (file4 == null) {
            return SetsKt.emptySet();
        }
        File serviceFile = file4;
        try {
            void $this$useLines$iv$iv;
            File $this$useLines_u24default$iv = serviceFile;
            Charset charset$iv = Charsets.UTF_8;
            File file5 = $this$useLines_u24default$iv;
            Charset charset$iv$iv = charset$iv;
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv$iv;
            int n = 8192;
            Object object = closeable;
            InputStream inputStream = object;
            inputStream = new FileInputStream((File)((Object)inputStream));
            object = new InputStreamReader(inputStream, charset$iv$iv);
            closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv$iv = (BufferedReader)closeable;
                boolean bl2 = false;
                Sequence<String> it2 = TextStreamsKt.lineSequence(it$iv$iv);
                boolean bl3 = false;
                object = INSTANCE.parseLines(file2, it2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return object;
        }
        catch (IOError e) {
            throw (Throwable)new ServiceLoadingException(file2, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Set<String> findImplementationsInJar(String classId, File file2) {
        Closeable closeable = new ZipFile(file2);
        Throwable throwable = null;
        try {
            Set<String> set;
            ZipEntry zipEntry;
            ZipFile zipFile2 = (ZipFile)closeable;
            boolean bl = false;
            if (zipFile2.getEntry("META-INF/services/" + classId) == null) {
                Set<String> set2 = SetsKt.emptySet();
                return set2;
            }
            ZipEntry entry = zipEntry;
            Closeable closeable2 = zipFile2.getInputStream(entry);
            Throwable throwable2 = null;
            try {
                Set<String> set3;
                void $this$useLines$iv;
                InputStream inputStream = (InputStream)closeable2;
                boolean bl2 = false;
                InputStream inputStream2 = inputStream;
                Intrinsics.checkNotNullExpressionValue(inputStream2, "inputStream");
                Closeable closeable3 = inputStream2;
                Charset charset = Charsets.UTF_8;
                Closeable closeable4 = closeable3;
                closeable4 = new InputStreamReader((InputStream)closeable4, charset);
                int n = 8192;
                closeable3 = closeable4 instanceof BufferedReader ? (BufferedReader)closeable4 : new BufferedReader((Reader)closeable4, n);
                boolean $i$f$useLines = false;
                closeable4 = $this$useLines$iv;
                n = 8192;
                closeable4 = closeable4 instanceof BufferedReader ? (BufferedReader)closeable4 : new BufferedReader((Reader)closeable4, n);
                Throwable throwable3 = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable4;
                    boolean bl3 = false;
                    Sequence<String> it = TextStreamsKt.lineSequence(it$iv);
                    boolean bl4 = false;
                    set3 = INSTANCE.parseLines(file2, it);
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable4, throwable3);
                }
                set = set3;
            }
            catch (Throwable throwable5) {
                try {
                    try {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        CloseableKt.closeFinally(closeable2, throwable2);
                        throw throwable6;
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
            }
            CloseableKt.closeFinally(closeable2, throwable2);
            Set<String> set4 = set;
            return set4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseLines(File file2, Sequence<String> lines) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Sequence<String> sequence2 = lines;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            String string3 = INSTANCE.parseLine(file2, it);
            if (string3 == null) continue;
            String it$iv = string2 = string3;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String parseLine(File file2, String line2) {
        String string2 = StringsKt.substringBefore$default(line2, '#', null, 2, null);
        String it = string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        boolean bl = false;
        CharSequence charSequence2 = it;
        String string3 = charSequence2.length() > 0 ? string2 : null;
        if (string3 == null) {
            return null;
        }
        String actualLine = string3;
        CharSequence $this$forEachIndexed$iv = actualLine;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        charSequence2 = $this$forEachIndexed$iv;
        for (int i = 0; i < charSequence2.length(); ++i) {
            void c;
            char item$iv = charSequence2.charAt(i);
            int n = index$iv;
            index$iv = n + 1;
            char c2 = item$iv;
            int index2 = n;
            boolean bl2 = false;
            boolean isValid = index2 == 0 ? Character.isJavaIdentifierStart((char)c) : Character.isJavaIdentifierPart((char)c) || c == 46;
            if (isValid) continue;
            String errorText = "Invalid Java identifier: " + line2;
            throw (Throwable)new ServiceLoadingException(file2, (Throwable)new RuntimeException(errorText));
        }
        return actualLine;
    }

    private final String getClassIdentifier(Class<?> service) {
        String string2 = service.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "service.name");
        return string2;
    }

    private ServiceLoaderLite() {
    }

    static {
        ServiceLoaderLite serviceLoaderLite;
        INSTANCE = serviceLoaderLite = new ServiceLoaderLite();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/ServiceLoaderLite$ServiceLoadingException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "file", "Ljava/io/File;", "cause", "", "(Ljava/io/File;Ljava/lang/Throwable;)V", "getFile", "()Ljava/io/File;", "cli"})
    public static final class ServiceLoadingException
    extends RuntimeException {
        @NotNull
        private final File file;

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public ServiceLoadingException(@NotNull File file2, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(cause, "cause");
            super("Error loading services from " + file2, cause);
            this.file = file2;
        }
    }
}

