/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuardImpl;
import org.jetbrains.kotlin.com.intellij.openapi.command.CommandProcessor;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.RangeMarker;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ReadOnlyModificationException;
import org.jetbrains.kotlin.com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentListener;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.DocumentWriteAccessGuard;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.LineSet;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.LockFreeCOWSortedArray;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.PersistentRangeMarker;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RangeMarkerTree;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.ShutDownTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public final class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance(DocumentImpl.class);
    private final LockFreeCOWSortedArray<DocumentListener> myDocumentListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private final Object myLineSetLock;
    private volatile LineSet myLineSet;
    private volatile ImmutableCharSequence myText;
    private volatile SoftReference<String> myTextString;
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final List<Object> myReadOnlyListeners;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence;
    private final AtomicInteger sequence;
    static final Key<Reference<RangeMarkerTree<RangeMarkerEx>>> RANGE_MARKERS_KEY = Key.create("RANGE_MARKERS_KEY");
    static final Key<Reference<RangeMarkerTree<RangeMarkerEx>>> PERSISTENT_RANGE_MARKERS_KEY = Key.create("PERSISTENT_RANGE_MARKERS_KEY");
    private static final ReferenceQueue<RangeMarkerTree<RangeMarkerEx>> rmTreeQueue = new ReferenceQueue();

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            DocumentImpl.$$$reportNull$$$0(1);
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            DocumentImpl.$$$reportNull$$$0(2);
        }
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        if (chars == null) {
            DocumentImpl.$$$reportNull$$$0(3);
        }
        this.myDocumentListeners = new LockFreeCOWSortedArray<DocumentListener>(PrioritizedDocumentListener.COMPARATOR, DocumentListener.ARRAY_FACTORY);
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myPersistentRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSetLock = new String("line set lock");
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMutableCharSequence = new CharSequence(){

            @Override
            public int length() {
                return DocumentImpl.this.myText.length();
            }

            @Override
            public char charAt(int index2) {
                return DocumentImpl.this.myText.charAt(index2);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return DocumentImpl.this.myText.subSequence(start, end);
            }

            @Override
            @NotNull
            public String toString() {
                String string2 = DocumentImpl.this.doGetText();
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/DocumentImpl$1", "toString"));
            }
        };
        this.sequence = new AtomicInteger();
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = CharArrayUtil.createImmutableCharSequence(chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet(this.myText);
                }
            }
        }
        return lineSet;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    @Override
    public boolean isWritable() {
        if (this.myIsReadOnly) {
            return false;
        }
        for (DocumentWriteAccessGuard guard : DocumentWriteAccessGuard.EP_NAME.getExtensions()) {
            if (guard.isWritable(this).isSuccess()) continue;
            return false;
        }
        return true;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            DocumentImpl.$$$reportNull$$$0(12);
        }
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            DocumentImpl.$$$reportNull$$$0(13);
        }
        return this.treeFor(rangeMarker).removeInterval(rangeMarker);
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, end, true, true, block.getStartOffset(), block.getEndOffset(), block.isGreedyToLeft(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    private static boolean rangesIntersect(int start0, int end0, boolean start0Inclusive, boolean end0Inclusive, int start1, int end1, boolean start1Inclusive, boolean end1Inclusive) {
        if (start0 > start1 || start0 == start1 && !start0Inclusive) {
            if (end1 == start0) {
                return start0Inclusive && end1Inclusive;
            }
            return end1 > start0;
        }
        if (end0 == start1) {
            return start1Inclusive && end0Inclusive;
        }
        return end0 > start1;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
        this.myFrozen = null;
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset), "");
        }
        ImmutableCharSequence newText = this.myText.delete(startOffset, endOffset);
        ImmutableCharSequence oldString = this.myText.subtext(startOffset, endOffset);
        this.updateText(newText, startOffset, oldString, "", false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset, startOffset);
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s2) {
        if (s2 == null) {
            DocumentImpl.$$$reportNull$$$0(20);
        }
        this.replaceString(startOffset, endOffset, startOffset, s2, LocalTimeCounter.currentTime(), false);
    }

    @ApiStatus.Internal
    public void replaceString(int startOffset, int endOffset, int moveOffset, @NotNull CharSequence s2, long newModificationStamp, boolean bl) {
        ImmutableCharSequence newText;
        int newEndInString;
        boolean wholeTextReplaced;
        int newStartInString;
        if (s2 == null) {
            DocumentImpl.$$$reportNull$$$0(21);
        }
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s2);
        if (moveOffset != startOffset && startOffset != endOffset && s2.length() != 0) {
            throw new IllegalArgumentException("moveOffset != startOffset for a modification which is neither an insert nor deletion. startOffset: " + startOffset + "; endOffset: " + endOffset + ";; moveOffset: " + moveOffset + ";");
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s2.length();
        ImmutableCharSequence chars = this.myText;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s2.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        if (newStartInString == newStringLength && startOffset == endOffset && !wholeTextReplaced) {
            return;
        }
        for (newEndInString = newStringLength; endOffset > startOffset && newEndInString > newStartInString && s2.charAt(newEndInString - 1) == chars.charAt(endOffset - 1); --newEndInString, --endOffset) {
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s2.subSequence(newStartInString, newEndInString);
        ImmutableCharSequence sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, sToDelete, changedPart);
        }
        if (wholeTextReplaced && s2 instanceof ImmutableCharSequence) {
            newText = (ImmutableCharSequence)s2;
        } else {
            newText = this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        boolean wasOptimized = initialStartOffset != startOffset || endOffset - startOffset != initialOldLength;
        this.updateText(newText, startOffset, sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength, wasOptimized ? startOffset : moveOffset);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(this);
            if (file2 != null && file2.isInLocalFileSystem()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            }
        }
        if (this.myIsReadOnly) {
            throw new ReadOnlyModificationException(this, CoreBundle.message("attempt.to.modify.read.only.document.error.message", new Object[0]));
        }
        for (DocumentWriteAccessGuard guard : DocumentWriteAccessGuard.EP_NAME.getExtensions()) {
            DocumentWriteAccessGuard.Result result2 = guard.isWritable(this);
            if (result2.isSuccess()) continue;
            throw new ReadOnlyModificationException(this, String.format("%s: guardClass=%s, failureReason=%s", CoreBundle.message("attempt.to.modify.read.only.document.error.message", new Object[0]), guard.getClass().getName(), result2.getFailureReason()));
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s2) {
        if (s2 == null) {
            DocumentImpl.$$$reportNull$$$0(22);
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators(s2);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString) {
        if (guard == null) {
            DocumentImpl.$$$reportNull$$$0(23);
        }
        if (oldString == null) {
            DocumentImpl.$$$reportNull$$$0(24);
        }
        if (newString == null) {
            DocumentImpl.$$$reportNull$$$0(25);
        }
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException(event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateText(@NotNull ImmutableCharSequence newText, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int initialOldLength, int n) {
        void moveOffset;
        if (newText == null) {
            DocumentImpl.$$$reportNull$$$0(27);
        }
        if (oldString == null) {
            DocumentImpl.$$$reportNull$$$0(28);
        }
        if (newString == null) {
            DocumentImpl.$$$reportNull$$$0(29);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("updating document " + this + ".\nNext string:'" + newString + "'\nOld string:'" + oldString + "'");
        }
        assert (moveOffset >= 0 && moveOffset <= this.getTextLength()) : "Invalid moveOffset: " + (int)moveOffset;
        this.assertNotNestedModification();
        this.myChangeInProgress = true;
        DelayedExceptions exceptions = new DelayedExceptions();
        try {
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, initialOldLength, (int)moveOffset);
            this.beforeChangedUpdate(event, exceptions);
            this.myTextString = null;
            ImmutableCharSequence prevText = this.myText;
            this.myText = newText;
            this.sequence.incrementAndGet();
            this.changedUpdate(event, newModificationStamp, prevText, exceptions);
        }
        finally {
            this.myChangeInProgress = false;
            exceptions.rethrowPCE();
        }
    }

    @Override
    public int getModificationSequence() {
        return this.sequence.get();
    }

    private void beforeChangedUpdate(DocumentEvent event, DelayedExceptions exceptions) {
        FileDocumentManager manager;
        VirtualFile file2;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file2 = (manager = FileDocumentManager.getInstance()).getFile(this)) != null && !file2.isValid()) {
            LOG.error("File of this document has been deleted: " + file2);
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    exceptions.register(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, @NotNull CharSequence prevText, DelayedExceptions delayedExceptions) {
        if (event == null) {
            DocumentImpl.$$$reportNull$$$0(30);
        }
        if (prevText == null) {
            DocumentImpl.$$$reportNull$$$0(31);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace(new Throwable(event.toString()));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            assert (event.getOldFragment().length() == event.getOldLength()) : "event.getOldFragment().length() = " + event.getOldFragment().length() + "; event.getOldLength() = " + event.getOldLength();
            assert (event.getNewFragment().length() == event.getNewLength()) : "event.getNewFragment().length() = " + event.getNewFragment().length() + "; event.getNewLength() = " + event.getNewLength();
            assert (prevText.length() + event.getNewLength() - event.getOldLength() == this.getTextLength()) : "prevText.length() = " + prevText.length() + "; event.getNewLength() = " + event.getNewLength() + "; event.getOldLength() = " + event.getOldLength() + "; getTextLength() = " + this.getTextLength();
            this.myLineSet = this.getLineSet().update(prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            assert (this.getTextLength() == this.myLineSet.getLength()) : "getTextLength() = " + this.getTextLength() + "; myLineSet.getLength() = " + this.myLineSet.getLength();
            this.myFrozen = null;
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        void exceptions;
                        exceptions.register(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = ReadAction.compute(this::doGetText);
        if (string2 == null) {
            DocumentImpl.$$$reportNull$$$0(32);
        }
        return string2;
    }

    @NotNull
    private String doGetText() {
        String s2 = SoftReference.dereference(this.myTextString);
        if (s2 == null) {
            s2 = this.myText.toString();
            this.myTextString = new SoftReference<String>(s2);
        }
        String string2 = s2;
        if (string2 == null) {
            DocumentImpl.$$$reportNull$$$0(33);
        }
        return string2;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence2 = this.myMutableCharSequence;
        if (charSequence2 == null) {
            DocumentImpl.$$$reportNull$$$0(36);
        }
        return charSequence2;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            DocumentImpl.$$$reportNull$$$0(37);
        }
        return immutableCharSequence;
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            DocumentImpl.$$$reportNull$$$0(38);
        }
        if (ArrayUtil.contains(listener, this.getListeners())) {
            LOG.error("Already registered: " + listener);
        }
        this.myDocumentListeners.add(listener);
    }

    @Override
    public int getLineNumber(int offset2) {
        return this.getLineSet().findLineIndex(offset2);
    }

    @Override
    public final int getLineStartOffset(int line2) {
        if (line2 == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line2);
    }

    @Override
    public final int getLineEndOffset(int line2) {
        if (this.getTextLength() == 0 && line2 == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line2) - this.getLineSeparatorLength(line2);
        assert (result2 >= 0);
        return result2;
    }

    public final int getLineSeparatorLength(int line2) {
        int separatorLength = this.getLineSet().getSeparatorLength(line2);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    @Override
    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    private DocumentListener @NotNull [] getListeners() {
        DocumentListener[] documentListenerArray = this.myDocumentListeners.getArray();
        if (documentListenerArray == null) {
            DocumentImpl.$$$reportNull$$$0(43);
        }
        return documentListenerArray;
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            DocumentImpl.$$$reportNull$$$0(48);
        }
        Runnable runnable = () -> this.replaceString(0, this.getTextLength(), 0, text2, LocalTimeCounter.currentTime(), true);
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress() || !this.myAssertThreading) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", DocCommandGroupId.noneGroupId(this));
        }
        this.clearLineModificationFlags();
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile(this) + (this.isInEventsHandling() ? ",inEventHandling" : "") + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    this.myFrozen = frozen = new FrozenDocument(this.myText, this.myLineSet, this.myModificationStamp, SoftReference.dereference(this.myTextString));
                }
            }
        }
        FrozenDocument frozenDocument = frozen;
        if (frozenDocument == null) {
            DocumentImpl.$$$reportNull$$$0(53);
        }
        return frozenDocument;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 49: 
            case 52: 
            case 53: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 49: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 49: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/DocumentImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guard";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldString";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newString";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretLines";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevText";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/DocumentImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarkerForVirtualFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardedBlock";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuardedBlocks";
                break;
            }
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetText";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsSequence";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "freeze";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentCreatedFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areRangeMarkersRetainedFor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSaveRMTree";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarkerForVirtualFile";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 49: 
            case 52: 
            case 53: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMaxSpacesToLeave";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "treeFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "throwGuardedFragment";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "clearLineModificationFlagsExcept";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdate";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addEditReadOnlyListener";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 49: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class DelayedExceptions {
        Throwable myException;

        private DelayedExceptions() {
        }

        void register(Throwable e) {
            if (this.myException == null) {
                this.myException = e;
            } else {
                this.myException.addSuppressed(e);
            }
            if (!(e instanceof ProcessCanceledException)) {
                LOG.error(e);
            } else if (DocumentImpl.this.myAssertThreading) {
                LOG.error("ProcessCanceledException must not be thrown from document listeners for real document", new Throwable(e));
            }
        }

        void rethrowPCE() {
            if (this.myException instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)this.myException;
            }
        }
    }
}

