/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExpressionUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiBlockStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiBreakStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiContinueStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDoWhileStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiForStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIfStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiThisExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiUnaryExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhileStatement;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.AnalysisCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.BranchingInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.CallInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowFactory;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.GoToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.Instruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.InstructionClientVisitor;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ReadVariableInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ReturnInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ThrowToInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.WriteVariableInstruction;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.IntStack;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntList;

public final class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance(ControlFlowUtil.class);
    public static final Class<? extends PsiStatement>[] DEFAULT_EXIT_STATEMENTS_CLASSES = new Class[]{PsiReturnStatement.class, PsiBreakStatement.class, PsiContinueStatement.class};
    public static final int NORMAL_COMPLETION_REASON = 1;

    @NotNull
    public static List<PsiVariable> getSSAVariables(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(0);
        }
        return ControlFlowUtil.getSSAVariables(flow, 0, flow.getSize(), false);
    }

    @NotNull
    public static List<PsiVariable> getSSAVariables(@NotNull ControlFlow flow, int from2, int to, boolean reportVarsIfNonInitializingPathExists) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(1);
        }
        List<Instruction> instructions = flow.getInstructions();
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, from2, to, false);
        ArrayList<PsiVariable> result2 = new ArrayList<PsiVariable>(1);
        block0: for (PsiVariable psiVariable : writtenVariables) {
            PsiManager psiManager = psiVariable.getManager();
            ArrayList<SSAInstructionState> queue = new ArrayList<SSAInstructionState>();
            queue.add(new SSAInstructionState(0, from2));
            THashSet<SSAInstructionState> processedStates = new THashSet<SSAInstructionState>();
            while (!queue.isEmpty()) {
                SSAInstructionState state = (SSAInstructionState)queue.remove(0);
                if (state.getWriteCount() > 1) continue block0;
                if (processedStates.contains(state)) continue;
                processedStates.add(state);
                int i = state.getInstructionIdx();
                if (i < to) {
                    Instruction instruction = instructions.get(i);
                    if (instruction instanceof ReturnInstruction) {
                        int[] offsets;
                        for (int offset2 : offsets = ((ReturnInstruction)instruction).getPossibleReturnOffsets()) {
                            queue.add(new SSAInstructionState(state.getWriteCount(), Math.min(offset2, to)));
                        }
                        continue;
                    }
                    if (instruction instanceof GoToInstruction) {
                        int nextOffset = ((GoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ThrowToInstruction) {
                        int nextOffset = ((ThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ConditionalGoToInstruction) {
                        int nextOffset = ((ConditionalGoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof ConditionalThrowToInstruction) {
                        int nextOffset = ((ConditionalThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction write = (WriteVariableInstruction)instruction;
                        queue.add(new SSAInstructionState(state.getWriteCount() + (psiManager.areElementsEquivalent(write.variable, psiVariable) ? 1 : 0), i + 1));
                        continue;
                    }
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction read2 = (ReadVariableInstruction)instruction;
                        if (psiManager.areElementsEquivalent(read2.variable, psiVariable) && state.getWriteCount() == 0) continue block0;
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                    continue;
                }
                if (reportVarsIfNonInitializingPathExists || state.getWriteCount() != 0) continue;
                continue block0;
            }
            result2.add(psiVariable);
        }
        ArrayList<PsiVariable> arrayList = result2;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static boolean needVariableValueAt(final @NotNull PsiVariable variable2, final @NotNull ControlFlow flow, final int offset2) {
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(3);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(4);
        }
        InstructionClientVisitor<Boolean> visitor2 = new InstructionClientVisitor<Boolean>(){
            final boolean[] neededBelow;
            {
                this.neededBelow = new boolean[flow.getSize() + 1];
            }

            @Override
            public void procedureEntered(int startOffset, int endOffset) {
                for (int i = startOffset; i < endOffset; ++i) {
                    this.neededBelow[i] = false;
                }
            }

            @Override
            public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset22, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable2)) {
                    needed = true;
                }
                int n = offset22;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset22, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable2)) {
                    needed = false;
                }
                this.neededBelow[offset22] = needed;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset22, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                int n = offset22;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public Boolean getResult() {
                return this.neededBelow[offset2];
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor2, offset2, flow.getSize());
        return (Boolean)visitor2.getResult();
    }

    @NotNull
    public static Collection<PsiVariable> getWrittenVariables(@NotNull ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(5);
        }
        HashSet<PsiVariable> set = new HashSet<PsiVariable>();
        ControlFlowUtil.getWrittenVariables(flow, start, end, ignoreNotReachingWrites, set);
        HashSet<PsiVariable> hashSet = set;
        if (hashSet == null) {
            ControlFlowUtil.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public static void getWrittenVariables(@NotNull ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites, @NotNull Collection<? super PsiVariable> set) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(7);
        }
        if (set == null) {
            ControlFlowUtil.$$$reportNull$$$0(8);
        }
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction) || ignoreNotReachingWrites && !ControlFlowUtil.isInstructionReachable(flow, end, i)) continue;
            set.add(((WriteVariableInstruction)instruction).variable);
        }
    }

    @NotNull
    public static List<PsiVariable> getUsedVariables(@NotNull ControlFlow flow, int start, int end) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PsiVariable> array2 = new ArrayList<PsiVariable>();
        if (start < 0) {
            ArrayList<PsiVariable> arrayList = array2;
            if (arrayList == null) {
                ControlFlowUtil.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            PsiVariable variable2;
            Instruction instruction = instructions.get(i);
            if (instruction instanceof ReadVariableInstruction) {
                variable2 = ((ReadVariableInstruction)instruction).variable;
                if (array2.contains(variable2)) continue;
                array2.add(variable2);
                continue;
            }
            if (!(instruction instanceof WriteVariableInstruction) || array2.contains(variable2 = ((WriteVariableInstruction)instruction).variable)) continue;
            array2.add(variable2);
        }
        ArrayList<PsiVariable> arrayList = array2;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public static boolean isVariableUsed(@NotNull ControlFlow flow, int start, int end, @NotNull PsiVariable variable2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(12);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(13);
        }
        List<Instruction> instructions = flow.getInstructions();
        LOG.assertTrue(start >= 0, "flow start");
        LOG.assertTrue(end <= instructions.size(), "flow end");
        PsiManager psiManager = variable2.getManager();
        for (int i = start; i < end; ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof ReadVariableInstruction ? psiManager.areElementsEquivalent(((ReadVariableInstruction)instruction).variable, variable2) : instruction instanceof WriteVariableInstruction && psiManager.areElementsEquivalent(((WriteVariableInstruction)instruction).variable, variable2))) continue;
            return true;
        }
        return false;
    }

    private static int findSingleReadOffset(@NotNull ControlFlow flow, int startOffset, int endOffset, @NotNull PsiVariable variable2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(14);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(15);
        }
        List<Instruction> instructions = flow.getInstructions();
        if (startOffset < 0 || endOffset < 0 || endOffset > instructions.size()) {
            return -1;
        }
        PsiManager psiManager = variable2.getManager();
        int readOffset = -1;
        for (int i = startOffset; i < endOffset; ++i) {
            Instruction instruction = instructions.get(i);
            if (instruction instanceof ReadVariableInstruction) {
                if (!psiManager.areElementsEquivalent(((ReadVariableInstruction)instruction).variable, variable2)) continue;
                if (readOffset < 0) {
                    readOffset = i;
                    continue;
                }
                return -1;
            }
            if (!(instruction instanceof WriteVariableInstruction) || !psiManager.areElementsEquivalent(((WriteVariableInstruction)instruction).variable, variable2)) continue;
            return -1;
        }
        return readOffset;
    }

    public static PsiReferenceExpression findSingleReadOccurrence(@NotNull ControlFlow flow, @NotNull PsiElement element, @NotNull PsiVariable variable2) {
        int readOffset;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(16);
        }
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(17);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(18);
        }
        if ((readOffset = ControlFlowUtil.findSingleReadOffset(flow, flow.getStartOffset(element), flow.getEndOffset(element), variable2)) >= 0) {
            PsiElement readElement = flow.getElement(readOffset);
            if ((readElement = PsiTreeUtil.findFirstParent(readElement, false, e -> e == element || e instanceof PsiReferenceExpression)) instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)readElement;
            }
        }
        return null;
    }

    public static boolean isVariableReadInFinally(@NotNull ControlFlow flow, @Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment, @NotNull PsiVariable variable2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(19);
        }
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(20);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(21);
        }
        PsiManager psiManager = variable2.getManager();
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiCodeBlock finallyBlock;
            PsiTryStatement tryStatement;
            PsiElement parent2;
            if (!(element instanceof PsiCodeBlock) || !((parent2 = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent2).getTryBlock() != element || (finallyBlock = tryStatement.getFinallyBlock()) == null) continue;
            List<Instruction> instructions = flow.getInstructions();
            int startOffset = flow.getStartOffset(finallyBlock);
            int endOffset = flow.getEndOffset(finallyBlock);
            LOG.assertTrue(startOffset >= 0, "flow start");
            LOG.assertTrue(endOffset <= instructions.size(), "flow end");
            for (int i = startOffset; i < endOffset; ++i) {
                Instruction instruction = instructions.get(i);
                if (!(instruction instanceof ReadVariableInstruction) || !psiManager.areElementsEquivalent(((ReadVariableInstruction)instruction).variable, variable2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<PsiVariable> getInputVariables(@NotNull ControlFlow flow, int start, int end) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(22);
        }
        List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(flow, start, end);
        ArrayList<PsiVariable> array2 = new ArrayList<PsiVariable>(usedVariables.size());
        for (PsiVariable variable2 : usedVariables) {
            if (!ControlFlowUtil.needVariableValueAt(variable2, flow, start)) continue;
            array2.add(variable2);
        }
        ArrayList<PsiVariable> arrayList = array2;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    public static PsiVariable @NotNull [] getOutputVariables(@NotNull ControlFlow flow, int start, int end, int @NotNull [] exitPoints) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(24);
        }
        if (exitPoints == null) {
            ControlFlowUtil.$$$reportNull$$$0(25);
        }
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, start, end, false);
        ArrayList<PsiVariable> array2 = new ArrayList<PsiVariable>();
        for (PsiVariable variable2 : writtenVariables) {
            int[] nArray = exitPoints;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int exitPoint = nArray[i];
                if (!ControlFlowUtil.needVariableValueAt(variable2, flow, exitPoint)) continue;
                array2.add(variable2);
            }
        }
        PsiVariable[] outputVariables = array2.toArray(new PsiVariable[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("output variables:");
            for (PsiVariable variable3 : outputVariables) {
                LOG.debug("  " + variable3);
            }
        }
        if (outputVariables == null) {
            ControlFlowUtil.$$$reportNull$$$0(26);
        }
        return outputVariables;
    }

    @SafeVarargs
    @NotNull
    public static Collection<PsiStatement> findExitPointsAndStatements(final @NotNull ControlFlow flow, final int start, final int end, final @NotNull IntList exitPoints, final Class<? extends PsiStatement> ... classesFilter) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(27);
        }
        if (exitPoints == null) {
            ControlFlowUtil.$$$reportNull$$$0(28);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(29);
        }
        if (end == start) {
            exitPoints.add(end);
            List<PsiStatement> list2 = Collections.emptyList();
            if (list2 == null) {
                ControlFlowUtil.$$$reportNull$$$0(30);
            }
            return list2;
        }
        final THashSet<PsiStatement> exitStatements = new THashSet<PsiStatement>();
        InstructionClientVisitor<Void> visitor2 = new InstructionClientVisitor<Void>(){

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                ControlFlowUtil.processGotoStatement(exitStatements, ControlFlowUtil.findStatement(flow, offset2), classesFilter);
            }

            @Override
            public void visitBranchingInstruction(BranchingInstruction instruction, int offset2, int nextOffset) {
                ControlFlowUtil.processGoto(flow, start, end, exitPoints, exitStatements, instruction, ControlFlowUtil.findStatement(flow, offset2), classesFilter);
            }

            @Override
            public void visitReturnInstruction(ReturnInstruction instruction, int offset2, int nextOffset) {
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                this.visitInstruction(instruction, offset2, nextOffset);
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (offset2 >= end - 1) {
                    int exitOffset = end;
                    if (!exitPoints.contains(exitOffset = ControlFlowUtil.promoteThroughGotoChain(flow, exitOffset))) {
                        exitPoints.add(exitOffset);
                    }
                }
            }

            @Override
            public Void getResult() {
                return null;
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor2, start, end);
        THashSet<PsiStatement> tHashSet = exitStatements;
        if (tHashSet == null) {
            ControlFlowUtil.$$$reportNull$$$0(31);
        }
        return tHashSet;
    }

    @SafeVarargs
    private static void processGoto(@NotNull ControlFlow flow, int start, int end, @NotNull IntList exitPoints, @NotNull Collection<? super PsiStatement> exitStatements, @NotNull BranchingInstruction instruction, PsiStatement statement2, Class<? extends PsiStatement> ... classesFilter) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(32);
        }
        if (exitPoints == null) {
            ControlFlowUtil.$$$reportNull$$$0(33);
        }
        if (exitStatements == null) {
            ControlFlowUtil.$$$reportNull$$$0(34);
        }
        if (instruction == null) {
            ControlFlowUtil.$$$reportNull$$$0(35);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(36);
        }
        if (statement2 == null) {
            return;
        }
        int gotoOffset = instruction.offset;
        if (start > gotoOffset || gotoOffset >= end || ControlFlowUtil.isElementOfClass(statement2, classesFilter)) {
            if (!((gotoOffset = ControlFlowUtil.promoteThroughGotoChain(flow, gotoOffset)) <= 0 || gotoOffset < end && gotoOffset >= start || exitPoints.contains(gotoOffset))) {
                exitPoints.add(gotoOffset);
            }
            if (gotoOffset >= end || gotoOffset < start) {
                ControlFlowUtil.processGotoStatement(exitStatements, statement2, classesFilter);
            } else {
                boolean isReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                Instruction gotoInstruction = flow.getInstructions().get(gotoOffset);
                if (isReturn |= gotoInstruction instanceof GoToInstruction && ((GoToInstruction)gotoInstruction).isReturn) {
                    ControlFlowUtil.processGotoStatement(exitStatements, statement2, classesFilter);
                }
            }
        }
    }

    @SafeVarargs
    private static void processGotoStatement(@NotNull Collection<? super PsiStatement> exitStatements, PsiStatement statement2, Class<? extends PsiStatement> ... classesFilter) {
        if (exitStatements == null) {
            ControlFlowUtil.$$$reportNull$$$0(37);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(38);
        }
        if (statement2 != null && ControlFlowUtil.isElementOfClass(statement2, classesFilter)) {
            exitStatements.add(statement2);
        }
    }

    @SafeVarargs
    private static boolean isElementOfClass(@NotNull PsiElement element, Class<? extends PsiStatement> ... classesFilter) {
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(39);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(40);
        }
        for (Class<? extends PsiStatement> aClassesFilter : classesFilter) {
            if (!ReflectionUtil.isAssignable(aClassesFilter, element.getClass())) continue;
            return true;
        }
        return false;
    }

    private static int promoteThroughGotoChain(@NotNull ControlFlow flow, int offset2) {
        Instruction instruction;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(41);
        }
        List<Instruction> instructions = flow.getInstructions();
        while (offset2 < instructions.size() && (instruction = instructions.get(offset2)) instanceof GoToInstruction && !((GoToInstruction)instruction).isReturn) {
            offset2 = ((BranchingInstruction)instruction).offset;
        }
        return offset2;
    }

    private static PsiStatement findStatement(@NotNull ControlFlow flow, int offset2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(42);
        }
        PsiElement element = flow.getElement(offset2);
        return PsiTreeUtil.getParentOfType(element, PsiStatement.class, false);
    }

    public static boolean hasObservableThrowExitPoints(@NotNull ControlFlow flow, final int flowStart, final int flowEnd, PsiElement @NotNull [] elements, @NotNull PsiElement enclosingCodeFragment) {
        List<Instruction> instructions;
        Worker worker;
        Map writeOffsets;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(43);
        }
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(44);
        }
        if (elements == null) {
            ControlFlowUtil.$$$reportNull$$$0(45);
        }
        class Worker {
            final /* synthetic */ List val$instructions;
            final /* synthetic */ ControlFlow val$flow;

            Worker() {
                this.val$instructions = list2;
                this.val$flow = controlFlow;
            }

            @NotNull
            private Map<PsiVariable, IntList> getWritesOffsets() {
                THashMap<PsiVariable, IntList> writeOffsets = new THashMap<PsiVariable, IntList>();
                for (int i = flowStart; i < flowEnd; ++i) {
                    PsiVariable variable2;
                    Instruction instruction = (Instruction)this.val$instructions.get(i);
                    if (!(instruction instanceof WriteVariableInstruction) || !((variable2 = ((WriteVariableInstruction)instruction).variable) instanceof PsiLocalVariable) && !(variable2 instanceof PsiParameter)) continue;
                    IntList offsets = (IntList)writeOffsets.get(variable2);
                    if (offsets == null) {
                        offsets = new IntArrayList();
                        writeOffsets.put(variable2, offsets);
                    }
                    offsets.add(i);
                }
                LOG.debug("writeOffsets:", writeOffsets);
                THashMap<PsiVariable, IntList> tHashMap = writeOffsets;
                if (tHashMap == null) {
                    Worker.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            @NotNull
            private Map<PsiVariable, IntList> getVisibleReadsOffsets(@NotNull Map<PsiVariable, IntList> writeOffsets, @NotNull PsiCodeBlock tryBlock) {
                if (writeOffsets == null) {
                    Worker.$$$reportNull$$$0(1);
                }
                if (tryBlock == null) {
                    Worker.$$$reportNull$$$0(2);
                }
                THashMap<PsiVariable, IntList> visibleReadOffsets = new THashMap<PsiVariable, IntList>();
                for (PsiVariable variable2 : writeOffsets.keySet()) {
                    if (PsiTreeUtil.isAncestor(tryBlock, variable2, true)) continue;
                    visibleReadOffsets.put(variable2, new IntArrayList());
                }
                if (visibleReadOffsets.isEmpty()) {
                    THashMap<PsiVariable, IntList> tHashMap = visibleReadOffsets;
                    if (tHashMap == null) {
                        Worker.$$$reportNull$$$0(3);
                    }
                    return tHashMap;
                }
                for (int i = 0; i < this.val$instructions.size(); ++i) {
                    PsiVariable variable3;
                    IntList readOffsets;
                    Instruction instruction = (Instruction)this.val$instructions.get(i);
                    if (!(instruction instanceof ReadVariableInstruction) || (readOffsets = (IntList)visibleReadOffsets.get(variable3 = ((ReadVariableInstruction)instruction).variable)) == null) continue;
                    readOffsets.add(i);
                }
                LOG.debug("visibleReadOffsets:", visibleReadOffsets);
                THashMap<PsiVariable, IntList> tHashMap = visibleReadOffsets;
                if (tHashMap == null) {
                    Worker.$$$reportNull$$$0(4);
                }
                return tHashMap;
            }

            @NotNull
            private Map<PsiVariable, Set<PsiElement>> getReachableAfterWrite(@NotNull Map<PsiVariable, IntList> writeOffsets, @NotNull Map<PsiVariable, IntList> visibleReadOffsets) {
                if (writeOffsets == null) {
                    Worker.$$$reportNull$$$0(5);
                }
                if (visibleReadOffsets == null) {
                    Worker.$$$reportNull$$$0(6);
                }
                THashMap<PsiVariable, Set<PsiElement>> afterWrite = new THashMap<PsiVariable, Set<PsiElement>>();
                for (PsiVariable variable2 : visibleReadOffsets.keySet()) {
                    Function<Integer, BitSet> calculator = this.getReachableInstructionsCalculator();
                    BitSet collectedOffsets = new BitSet(flowEnd);
                    for (int writeOffset : writeOffsets.get(variable2).toIntArray()) {
                        LOG.assertTrue(writeOffset >= flowStart, "writeOffset");
                        BitSet reachableOffsets = calculator.fun(writeOffset);
                        collectedOffsets.or(reachableOffsets);
                    }
                    THashSet<PsiElement> throwSources = (THashSet<PsiElement>)afterWrite.get(variable2);
                    if (throwSources == null) {
                        throwSources = new THashSet<PsiElement>();
                        afterWrite.put(variable2, throwSources);
                    }
                    for (int i = flowStart; i < flowEnd; ++i) {
                        if (!collectedOffsets.get(i)) continue;
                        throwSources.add(this.val$flow.getElement(i));
                    }
                    ArrayList<PsiElement> subordinates = new ArrayList<PsiElement>();
                    for (PsiElement element : throwSources) {
                        if (!throwSources.contains(element.getParent())) continue;
                        subordinates.add(element);
                    }
                    throwSources.removeAll(subordinates);
                }
                LOG.debug("afterWrite:", afterWrite);
                THashMap<PsiVariable, Set<PsiElement>> tHashMap = afterWrite;
                if (tHashMap == null) {
                    Worker.$$$reportNull$$$0(7);
                }
                return tHashMap;
            }

            @NotNull
            private IntList getCatchOrFinallyOffsets(@NotNull List<? extends PsiTryStatement> tryStatements, @NotNull List<? extends PsiClassType> thrownExceptions) {
                if (tryStatements == null) {
                    Worker.$$$reportNull$$$0(8);
                }
                if (thrownExceptions == null) {
                    Worker.$$$reportNull$$$0(9);
                }
                IntArrayList catchOrFinallyOffsets = new IntArrayList();
                for (PsiTryStatement psiTryStatement : tryStatements) {
                    int offset2;
                    PsiCodeBlock finallyBlock = psiTryStatement.getFinallyBlock();
                    if (finallyBlock != null && (offset2 = this.val$flow.getStartOffset(finallyBlock)) >= 0) {
                        catchOrFinallyOffsets.add(offset2 - 2);
                    }
                    for (PsiCatchSection catchSection : psiTryStatement.getCatchSections()) {
                        PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                        PsiParameter parameter = catchSection.getParameter();
                        if (catchBlock == null || parameter == null) continue;
                        for (PsiClassType psiClassType : thrownExceptions) {
                            int offset3;
                            if (!ControlFlowUtil.isCaughtExceptionType(psiClassType, parameter.getType()) || (offset3 = this.val$flow.getStartOffset(catchBlock)) < 0) continue;
                            catchOrFinallyOffsets.add(offset3 - 1);
                        }
                    }
                }
                IntArrayList intArrayList = catchOrFinallyOffsets;
                if (intArrayList == null) {
                    Worker.$$$reportNull$$$0(10);
                }
                return intArrayList;
            }

            private boolean isAnyReadOffsetReachableFrom(@Nullable IntList readOffsets, @NotNull IntList fromOffsets) {
                if (fromOffsets == null) {
                    Worker.$$$reportNull$$$0(11);
                }
                if (readOffsets != null && !readOffsets.isEmpty()) {
                    int[] readOffsetsArray = readOffsets.toIntArray();
                    for (int j = 0; j < fromOffsets.size(); ++j) {
                        int fromOffset = fromOffsets.getInt(j);
                        if (!ControlFlowUtil.areInstructionsReachable(this.val$flow, readOffsetsArray, fromOffset)) continue;
                        LOG.debug("reachableFromOffset:", fromOffset);
                        return true;
                    }
                }
                return false;
            }

            @NotNull
            private Function<Integer, BitSet> getReachableInstructionsCalculator() {
                ControlFlowGraph graph2 = new ControlFlowGraph(this.val$flow.getSize()){

                    @Override
                    void addArc(int offset2, int nextOffset) {
                        if ((nextOffset = ControlFlowUtil.promoteThroughGotoChain(val$flow, nextOffset)) >= flowStart && nextOffset < flowEnd) {
                            super.addArc(offset2, nextOffset);
                        }
                    }
                };
                graph2.buildFrom(this.val$flow);
                Function<Integer, BitSet> function2 = startOffset -> {
                    BitSet visitedOffsets = new BitSet(flowEnd);
                    graph2.depthFirstSearch((int)startOffset, visitedOffsets);
                    return visitedOffsets;
                };
                if (function2 == null) {
                    Worker.$$$reportNull$$$0(12);
                }
                return function2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$1Worker";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "writeOffsets";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tryBlock";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visibleReadOffsets";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tryStatements";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "thrownExceptions";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fromOffsets";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWritesOffsets";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$1Worker";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisibleReadsOffsets";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReachableAfterWrite";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCatchOrFinallyOffsets";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReachableInstructionsCalculator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getVisibleReadsOffsets";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getReachableAfterWrite";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "getCatchOrFinallyOffsets";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "isAnyReadOffsetReachableFrom";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        if ((writeOffsets = (worker = new Worker()).getWritesOffsets()).isEmpty()) {
            return false;
        }
        PsiElement commonParent = elements.length != 1 ? PsiTreeUtil.findCommonParent(elements) : elements[0].getParent();
        List<PsiTryStatement> tryStatements = ControlFlowUtil.collectTryStatementStack(commonParent, enclosingCodeFragment);
        if (tryStatements.isEmpty()) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatements.get(0).getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        Map visibleReadOffsets = worker.getVisibleReadsOffsets(writeOffsets, tryBlock);
        if (visibleReadOffsets.isEmpty()) {
            return false;
        }
        Map afterWrite = worker.getReachableAfterWrite(writeOffsets, visibleReadOffsets);
        if (afterWrite.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : afterWrite.entrySet()) {
            PsiVariable variable2 = (PsiVariable)entry.getKey();
            PsiElement[] psiElements = ((Set)entry.getValue()).toArray(PsiElement.EMPTY_ARRAY);
            List<PsiClassType> thrownExceptions = ExceptionUtil.getThrownExceptions(psiElements);
            if (thrownExceptions.isEmpty()) continue;
            IntList catchOrFinallyOffsets = worker.getCatchOrFinallyOffsets(tryStatements, thrownExceptions);
            if (!worker.isAnyReadOffsetReachableFrom((IntList)visibleReadOffsets.get(variable2), catchOrFinallyOffsets)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiTryStatement getEnclosingTryStatementHavingCatchOrFinally(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(46);
        }
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiTryStatement tryStatement;
            PsiElement parent2;
            if (!(element instanceof PsiCodeBlock) || !((parent2 = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent2).getTryBlock() != element || tryStatement.getFinallyBlock() == null && tryStatement.getCatchBlocks().length == 0) continue;
            return tryStatement;
        }
        return null;
    }

    @NotNull
    private static List<PsiTryStatement> collectTryStatementStack(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(47);
        }
        ArrayList<PsiTryStatement> stack = new ArrayList<PsiTryStatement>();
        PsiTryStatement tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally(startElement, enclosingCodeFragment);
        while (tryStatement != null) {
            stack.add(tryStatement);
            tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally(tryStatement, enclosingCodeFragment);
        }
        ArrayList<PsiTryStatement> arrayList = stack;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @NotNull
    public static PsiElement findCodeFragment(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(49);
        }
        PsiElement codeFragment = element;
        for (PsiElement parent2 = codeFragment.getParent(); !(parent2 == null || parent2 instanceof PsiDirectory || parent2 instanceof PsiMethod || parent2 instanceof PsiField || parent2 instanceof PsiClassInitializer || parent2 instanceof DummyHolder || parent2 instanceof PsiLambdaExpression); parent2 = parent2.getParent()) {
            codeFragment = parent2;
        }
        PsiElement psiElement = codeFragment;
        if (psiElement == null) {
            ControlFlowUtil.$$$reportNull$$$0(50);
        }
        return psiElement;
    }

    private static boolean checkReferenceExpressionScope(@NotNull PsiReferenceExpression ref, @NotNull PsiElement targetClassMember) {
        JavaResolveResult resolveResult;
        PsiElement def;
        if (ref == null) {
            ControlFlowUtil.$$$reportNull$$$0(51);
        }
        if (targetClassMember == null) {
            ControlFlowUtil.$$$reportNull$$$0(52);
        }
        if ((def = (resolveResult = ref.advancedResolve(false)).getElement()) != null) {
            PsiElement commonParent;
            PsiElement parent2 = def.getParent();
            PsiElement psiElement = commonParent = parent2 == null ? null : PsiTreeUtil.findCommonParent(parent2, targetClassMember);
            if (commonParent == null) {
                parent2 = resolveResult.getCurrentFileResolveScope();
            }
            if (parent2 instanceof PsiClass) {
                PsiClass clss = (PsiClass)parent2;
                if (PsiTreeUtil.isAncestor(targetClassMember, clss, false)) {
                    return false;
                }
                for (PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class); containingClass != null; containingClass = containingClass.getContainingClass()) {
                    if (!containingClass.isInheritor(clss, true) || !PsiTreeUtil.isAncestor(targetClassMember, containingClass, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean collectOuterLocals(@NotNull List<? super PsiVariable> array2, @NotNull PsiElement scope2, @NotNull PsiElement member2, @NotNull PsiElement targetClassMember) {
        PsiJavaCodeReferenceElement qualifier;
        PsiMethodCallExpression call2;
        if (array2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(53);
        }
        if (scope2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(54);
        }
        if (member2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(55);
        }
        if (targetClassMember == null) {
            ControlFlowUtil.$$$reportNull$$$0(56);
        }
        if (scope2 instanceof PsiMethodCallExpression ? !ControlFlowUtil.checkReferenceExpressionScope((call2 = (PsiMethodCallExpression)scope2).getMethodExpression(), targetClassMember) : scope2 instanceof PsiReferenceExpression && !ControlFlowUtil.checkReferenceExpressionScope((PsiReferenceExpression)scope2, targetClassMember)) {
            return false;
        }
        if (scope2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)scope2;
            JavaResolveResult result2 = ref.advancedResolve(false);
            PsiElement refElement = result2.getElement();
            if (refElement != null) {
                PsiElement parent2 = refElement.getParent();
                PsiElement psiElement = parent2 = parent2 != null ? PsiTreeUtil.findCommonParent(parent2, member2) : null;
                if (parent2 == null) {
                    parent2 = result2.getCurrentFileResolveScope();
                }
                if (parent2 != null && !member2.equals(parent2) && targetClassMember.equals(parent2 = PsiTreeUtil.findCommonParent(parent2, targetClassMember))) {
                    if (!(refElement instanceof PsiVariable)) return false;
                    if (scope2 instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiReferenceExpression)scope2)) {
                        return false;
                    }
                    PsiVariable variable2 = (PsiVariable)refElement;
                    if (!array2.contains(variable2)) {
                        array2.add(variable2);
                    }
                }
            }
        } else if (scope2 instanceof PsiThisExpression ? (qualifier = ((PsiThisExpression)scope2).getQualifier()) == null : scope2 instanceof PsiSuperExpression && ((PsiSuperExpression)scope2).getQualifier() == null) {
            return false;
        }
        for (PsiElement child = scope2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (ControlFlowUtil.collectOuterLocals(array2, child, member2, targetClassMember)) continue;
            return false;
        }
        return true;
    }

    public static boolean returnPresent(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(57);
        }
        ReturnPresentClientVisitor visitor2 = new ReturnPresentClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (Boolean)((InstructionClientVisitor)visitor2).getResult();
    }

    public static boolean processReturns(@NotNull ControlFlow flow, @NotNull ReturnStatementsVisitor afterVisitor) throws IncorrectOperationException {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(58);
        }
        if (afterVisitor == null) {
            ControlFlowUtil.$$$reportNull$$$0(59);
        }
        ConvertReturnClientVisitor instructionsVisitor = new ConvertReturnClientVisitor(flow, afterVisitor);
        ControlFlowUtil.depthFirstSearch(flow, instructionsVisitor);
        instructionsVisitor.afterProcessing();
        return instructionsVisitor.getResult();
    }

    public static boolean returnPresentBetween(final @NotNull ControlFlow flow, final int startOffset, final int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(60);
        }
        final class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] isNormalCompletion;

            MyVisitor() {
                int i;
                this.isNormalCompletion = new boolean[flow.getSize() + 1];
                int length = flow.getSize();
                for (i = 0; i < startOffset; ++i) {
                    this.isNormalCompletion[i] = true;
                }
                for (i = endOffset; i <= length; ++i) {
                    this.isNormalCompletion[i] = true;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                boolean isNormal;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                if (throwToOffset == nextOffset) {
                    if (throwToOffset > endOffset) return;
                    isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                } else {
                    isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                }
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                    int n = offset2;
                    this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset2 + 1) {
                    return;
                }
                boolean isNormal = this.isNormalCompletion[nextOffset];
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                boolean isRethrowFromFinally = instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isRethrowFromFinally();
                boolean isNormal = !instruction.isReturn && this.isNormalCompletion[nextOffset] && !isRethrowFromFinally;
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = !this.isNormalCompletion[startOffset];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$1MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        return visitor2.getResult();
    }

    public static boolean canCompleteNormally(final @NotNull ControlFlow flow, final int startOffset, final int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(61);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] canCompleteNormally;

            MyVisitor() {
                this.canCompleteNormally = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset2, int nextOffset) {
                this.checkInstruction(offset2, nextOffset, false);
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
                this.checkInstruction(offset2, nextOffset, instruction.isReturn);
            }

            private void checkInstruction(int offset2, int nextOffset, boolean isReturn) {
                boolean isNormal;
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean bl = isNormal = nextOffset <= endOffset && !isReturn && (nextOffset == endOffset || this.canCompleteNormally[nextOffset]);
                if (isNormal && nextOffset == endOffset) {
                    PsiStatement continuedStatement;
                    PsiElement element = flow.getElement(offset2);
                    if (element instanceof PsiBreakStatement) {
                        PsiStatement exitedStatement = ((PsiBreakStatement)element).findExitedStatement();
                        if (exitedStatement == null || flow.getStartOffset(exitedStatement) < startOffset) {
                            isNormal = false;
                        }
                    } else if (element instanceof PsiContinueStatement && ((continuedStatement = ((PsiContinueStatement)element).findContinuedStatement()) == null || flow.getStartOffset(continuedStatement) < startOffset)) {
                        isNormal = false;
                    }
                }
                int n = offset2;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                boolean isNormal = throwToOffset == nextOffset ? throwToOffset <= endOffset && !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset] : this.canCompleteNormally[nextOffset];
                int n = offset2;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset];
                    int n = offset2;
                    this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset2 + 1) {
                    return;
                }
                boolean isNormal = this.canCompleteNormally[nextOffset];
                int n = offset2;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                this.checkInstruction(offset2, nextOffset, false);
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = this.canCompleteNormally[startOffset];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$2MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        return visitor2.getResult();
    }

    public static PsiElement getUnreachableStatement(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(62);
        }
        UnreachableStatementClientVisitor visitor2 = new UnreachableStatementClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (PsiElement)((InstructionClientVisitor)visitor2).getResult();
    }

    private static PsiReferenceExpression getEnclosingReferenceExpression(@NotNull PsiElement element, @NotNull PsiVariable variable2) {
        PsiReferenceExpression reference;
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(63);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(64);
        }
        if ((reference = ControlFlowUtil.findReferenceTo(element, variable2)) != null) {
            return reference;
        }
        while (element != null) {
            if (element instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)element;
            }
            if (element instanceof PsiMethod || element instanceof PsiClass) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static PsiReferenceExpression findReferenceTo(@NotNull PsiElement element, @NotNull PsiVariable variable2) {
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(65);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(66);
        }
        if (element instanceof PsiReferenceExpression && ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)element) && ((PsiReferenceExpression)element).isReferenceTo(variable2)) {
            return (PsiReferenceExpression)element;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(child, variable2);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    public static boolean isDominator(ControlFlow flow, final int maybeDominator, final int target) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final BitSet myReachedWithoutDominator = new BitSet();

            MyVisitor() {
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                super.visitInstruction(instruction, offset2, nextOffset);
                if (nextOffset != maybeDominator && (target == nextOffset || this.myReachedWithoutDominator.get(nextOffset))) {
                    this.myReachedWithoutDominator.set(offset2);
                }
            }

            @Override
            public Boolean getResult() {
                return this.myReachedWithoutDominator.get(0);
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, 0, target);
        return visitor2.getResult() == false;
    }

    public static boolean isVariableDefinitelyAssigned(@NotNull PsiVariable variable2, @NotNull ControlFlow flow) {
        PsiElement parent2;
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(67);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(68);
        }
        int variableDeclarationOffset = (parent2 = variable2.getParent()) == null ? -1 : flow.getStartOffset(parent2);
        int offset2 = variableDeclarationOffset > -1 ? variableDeclarationOffset : 0;
        boolean[] unassignedOffsets = ControlFlowUtil.getVariablePossiblyUnassignedOffsets(variable2, flow);
        return !unassignedOffsets[offset2];
    }

    public static boolean[] getVariablePossiblyUnassignedOffsets(final @NotNull PsiVariable variable2, final @NotNull ControlFlow flow) {
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(69);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(70);
        }
        if (flow.getSize() == 0) {
            return new boolean[]{true};
        }
        class MyVisitor
        extends InstructionClientVisitor<boolean[]> {
            final PsiManager psiManager;
            private final boolean[] maybeUnassigned;

            MyVisitor() {
                this.psiManager = variable2.getManager();
                this.maybeUnassigned = new boolean[flow.getSize() + 1];
                this.maybeUnassigned[this.maybeUnassigned.length - 1] = true;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
                if (this.psiManager.areElementsEquivalent(instruction.variable, variable2)) {
                    this.maybeUnassigned[offset2] = false;
                } else {
                    this.visitInstruction(instruction, offset2, nextOffset);
                }
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = offset2 == flow.getSize() - 1 || !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset2;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                this.visitInstruction(instruction, offset2, nextOffset);
                for (int i = instruction.procBegin; i < instruction.procEnd + 3; ++i) {
                    this.maybeUnassigned[i] = false;
                }
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
                if (instruction.isReturn && variable2 instanceof PsiLocalVariable) {
                    if (nextOffset > flow.getSize()) {
                        nextOffset = flow.getSize();
                    }
                    boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                    int n = offset2;
                    this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
                } else {
                    super.visitGoToInstruction(instruction, offset2, nextOffset);
                }
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset2;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = this.isLeaf(nextOffset) || this.maybeUnassigned[nextOffset];
                int n = offset2;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public boolean @NotNull [] getResult() {
                if (this.maybeUnassigned == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return this.maybeUnassigned;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$4MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    public static boolean isVariableDefinitelyNotAssigned(final @NotNull PsiVariable variable2, final @NotNull ControlFlow flow) {
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(71);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(72);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final PsiManager psiManager;
            private final boolean[] maybeAssigned;

            MyVisitor() {
                this.psiManager = variable2.getManager();
                this.maybeAssigned = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = this.psiManager.areElementsEquivalent(instruction.variable, variable2) || this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                int throwToOffset;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = (throwToOffset = instruction.offset) == nextOffset ? !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset] : this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = !this.maybeAssigned[0];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$5MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    public static boolean isValueUsedWithoutVisitingStop(final @NotNull ControlFlow flow, final int start, final int stop, final @NotNull PsiVariable variable2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(73);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(74);
        }
        if (start == stop) {
            return false;
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] maybeReferenced;
            final PsiManager psiManager;

            MyVisitor() {
                this.maybeReferenced = new boolean[flow.getSize() + 1];
                this.psiManager = variable2.getManager();
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                boolean nextState;
                if (offset2 == stop) {
                    this.maybeReferenced[offset2] = false;
                    return;
                }
                if (instruction instanceof WriteVariableInstruction && this.psiManager.areElementsEquivalent(((WriteVariableInstruction)instruction).variable, variable2)) {
                    this.maybeReferenced[offset2] = false;
                    return;
                }
                if (this.maybeReferenced[offset2]) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                this.maybeReferenced[offset2] = (nextState = this.maybeReferenced[nextOffset]) || instruction instanceof ReadVariableInstruction && this.psiManager.areElementsEquivalent(((ReadVariableInstruction)instruction).variable, variable2);
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = this.maybeReferenced[start];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$6MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, start, flow.getSize());
        return visitor2.getResult();
    }

    public static boolean isVariableAccess(@NotNull ControlFlow flow, int offset2, @NotNull PsiVariable variable2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(75);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(76);
        }
        Instruction instruction = flow.getInstructions().get(offset2);
        PsiManager psiManager = variable2.getManager();
        return instruction instanceof ReadVariableInstruction && psiManager.areElementsEquivalent(((ReadVariableInstruction)instruction).variable, variable2) || instruction instanceof WriteVariableInstruction && psiManager.areElementsEquivalent(((WriteVariableInstruction)instruction).variable, variable2);
    }

    @NotNull
    public static List<ControlFlowEdge> getEdges(@NotNull ControlFlow flow, int start) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(77);
        }
        final ArrayList<ControlFlowEdge> list2 = new ArrayList<ControlFlowEdge>();
        ControlFlowUtil.depthFirstSearch(flow, new InstructionClientVisitor<Void>(){

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                list2.add(new ControlFlowEdge(offset2, nextOffset));
            }

            @Override
            public Void getResult() {
                return null;
            }
        }, start, flow.getSize());
        ArrayList<ControlFlowEdge> arrayList = list2;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(78);
        }
        return arrayList;
    }

    public static int getMinDefinitelyReachedOffset(final @NotNull ControlFlow flow, final int sourceOffset, final @NotNull List<? extends PsiElement> references) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(79);
        }
        if (references == null) {
            ControlFlowUtil.$$$reportNull$$$0(80);
        }
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            private final TIntHashSet[] exitPoints;

            MyVisitor() {
                this.exitPoints = new TIntHashSet[flow.getSize()];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (this.exitPoints[offset2] == null) {
                    this.exitPoints[offset2] = new TIntHashSet();
                }
                if (this.isLeaf(nextOffset)) {
                    this.exitPoints[offset2].add(offset2);
                } else if (this.exitPoints[nextOffset] != null) {
                    this.exitPoints[offset2].addAll(this.exitPoints[nextOffset].toArray());
                }
            }

            @Override
            @NotNull
            public Integer getResult() {
                int minOffset = flow.getSize();
                int maxExitPoints = 0;
                block0: for (int i = sourceOffset; i < this.exitPoints.length; ++i) {
                    int size;
                    TIntHashSet exitPointSet = this.exitPoints[i];
                    int n = size = exitPointSet == null ? 0 : exitPointSet.size();
                    if (size <= maxExitPoints) continue;
                    for (PsiElement element : references) {
                        int endOffset;
                        PsiElement statement2 = PsiUtil.getEnclosingStatement(element);
                        if (statement2 == null || (endOffset = flow.getEndOffset(statement2)) == -1 || i == endOffset || ControlFlowUtil.isInstructionReachable(flow, i, endOffset)) continue;
                        continue block0;
                    }
                    minOffset = i;
                    maxExitPoints = size;
                }
                Integer n = minOffset;
                if (n == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$7MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    private static int findUnprocessed(int startOffset, int endOffset, @NotNull InstructionClientVisitor<?> visitor2) {
        if (visitor2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(81);
        }
        for (int i = startOffset; i < endOffset; ++i) {
            if (visitor2.processedInstructions[i]) continue;
            return i;
        }
        return endOffset;
    }

    private static void depthFirstSearch(@NotNull ControlFlow flow, @NotNull InstructionClientVisitor<?> visitor2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(82);
        }
        if (visitor2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(83);
        }
        ControlFlowUtil.depthFirstSearch(flow, visitor2, 0, flow.getSize());
    }

    private static void depthFirstSearch(@NotNull ControlFlow flow, @NotNull InstructionClientVisitor<?> visitor2, int startOffset, int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(84);
        }
        if (visitor2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(85);
        }
        visitor2.processedInstructions = new boolean[endOffset];
        ControlFlowUtil.internalDepthFirstSearch(flow.getInstructions(), visitor2, startOffset, endOffset);
    }

    private static void internalDepthFirstSearch(final @NotNull List<? extends Instruction> instructions, final @NotNull InstructionClientVisitor<?> clientVisitor, int startOffset, int endOffset) {
        if (instructions == null) {
            ControlFlowUtil.$$$reportNull$$$0(86);
        }
        if (clientVisitor == null) {
            ControlFlowUtil.$$$reportNull$$$0(87);
        }
        final WalkThroughStack walkThroughStack = new WalkThroughStack(instructions.size() / 2);
        walkThroughStack.push(startOffset);
        ControlFlowInstructionVisitor getNextOffsetVisitor = new ControlFlowInstructionVisitor(){

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                int i;
                int newOffset = instruction.offset;
                for (i = instruction.procBegin; i < clientVisitor.processedInstructions.length && (i < instruction.procEnd || i < instructions.size() && instructions.get(i) instanceof ReturnInstruction); ++i) {
                    clientVisitor.processedInstructions[i] = false;
                }
                clientVisitor.procedureEntered(instruction.procBegin, i);
                walkThroughStack.currentStack = new CallStackItem(walkThroughStack.currentStack, offset2 + 1);
                walkThroughStack.push(offset2, newOffset);
                walkThroughStack.push(newOffset);
            }

            @Override
            public void visitReturnInstruction(ReturnInstruction instruction, int offset2, int nextOffset) {
                int newOffset = -1;
                if (walkThroughStack.currentStack != null) {
                    newOffset = ((WalkThroughStack)walkThroughStack).currentStack.target;
                    walkThroughStack.currentStack = ((WalkThroughStack)walkThroughStack).currentStack.next;
                }
                if (instruction.offset != 0) {
                    newOffset = instruction.offset;
                }
                if (newOffset != -1) {
                    walkThroughStack.push(offset2, newOffset);
                    walkThroughStack.push(newOffset);
                }
            }

            @Override
            public void visitBranchingInstruction(BranchingInstruction instruction, int offset2, int nextOffset) {
                int newOffset = instruction.offset;
                walkThroughStack.push(offset2, newOffset);
                walkThroughStack.push(newOffset);
            }

            @Override
            public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset2, int nextOffset) {
                int newOffset = instruction.offset;
                walkThroughStack.push(offset2, newOffset);
                walkThroughStack.push(offset2, offset2 + 1);
                walkThroughStack.push(newOffset);
                walkThroughStack.push(offset2 + 1);
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                int newOffset = offset2 + 1;
                walkThroughStack.push(offset2, newOffset);
                walkThroughStack.push(newOffset);
            }
        };
        while (!walkThroughStack.isEmpty()) {
            int offset2 = walkThroughStack.peekOldOffset();
            int newOffset = walkThroughStack.popNewOffset();
            if (offset2 >= endOffset) continue;
            Instruction instruction = instructions.get(offset2);
            if (clientVisitor.processedInstructions[offset2]) {
                if (newOffset == -1) continue;
                instruction.accept(clientVisitor, offset2, newOffset);
                continue;
            }
            clientVisitor.processedInstructions[offset2] = true;
            instruction.accept(getNextOffsetVisitor, offset2, newOffset);
        }
    }

    private static boolean isInsideReturnStatement(PsiElement element) {
        while (element instanceof PsiExpression) {
            element = element.getParent();
        }
        return element instanceof PsiReturnStatement;
    }

    private static void merge(int offset2, CopyOnWriteList source, CopyOnWriteList @NotNull [] target) {
        if (target == null) {
            ControlFlowUtil.$$$reportNull$$$0(88);
        }
        if (source != null) {
            CopyOnWriteList existing = target[offset2];
            target[offset2] = existing == null ? source : existing.addAll(source);
        }
    }

    @NotNull
    public static List<PsiReferenceExpression> getReadBeforeWriteLocals(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(89);
        }
        ReadBeforeWriteClientVisitor visitor2 = new ReadBeforeWriteClientVisitor(flow, true);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        List list2 = (List)((InstructionClientVisitor)visitor2).getResult();
        if (list2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(90);
        }
        return list2;
    }

    @NotNull
    public static List<PsiReferenceExpression> getReadBeforeWrite(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(91);
        }
        return ControlFlowUtil.getReadBeforeWrite(flow, 0);
    }

    @NotNull
    private static List<PsiReferenceExpression> getReadBeforeWrite(@NotNull ControlFlow flow, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(92);
        }
        if (startOffset < 0 || startOffset >= flow.getSize()) {
            List<PsiReferenceExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                ControlFlowUtil.$$$reportNull$$$0(93);
            }
            return list2;
        }
        ReadBeforeWriteClientVisitor visitor2 = new ReadBeforeWriteClientVisitor(flow, false);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        List<PsiReferenceExpression> list3 = visitor2.getResult(startOffset);
        if (list3 == null) {
            ControlFlowUtil.$$$reportNull$$$0(94);
        }
        return list3;
    }

    public static int getCompletionReasons(final @NotNull ControlFlow flow, final int offset2, final int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(95);
        }
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            private final boolean[] normalCompletion;
            private final boolean[] returnCalled;

            MyVisitor() {
                this.normalCompletion = new boolean[endOffset];
                this.returnCalled = new boolean[endOffset];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset22, int nextOffset) {
                boolean goToReturn;
                boolean ret = nextOffset < endOffset && this.returnCalled[nextOffset];
                boolean normal = nextOffset < endOffset && this.normalCompletion[nextOffset];
                PsiElement element = flow.getElement(offset22);
                boolean bl = goToReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                if (goToReturn || ControlFlowUtil.isInsideReturnStatement(element)) {
                    ret = true;
                } else if (instruction instanceof ConditionalThrowToInstruction) {
                    int throwOffset = ((ConditionalThrowToInstruction)instruction).offset;
                    boolean normalWhenThrow = throwOffset < endOffset && this.normalCompletion[throwOffset];
                    boolean normalWhenNotThrow = offset22 == endOffset - 1 || this.normalCompletion[offset22 + 1];
                    normal = normalWhenThrow || normalWhenNotThrow;
                } else if (!(instruction instanceof ThrowToInstruction) && nextOffset >= endOffset) {
                    normal = true;
                }
                int n = offset22;
                this.returnCalled[n] = this.returnCalled[n] | ret;
                int n2 = offset22;
                this.normalCompletion[n2] = this.normalCompletion[n2] | normal;
            }

            @Override
            @NotNull
            public Integer getResult() {
                Integer n = (this.returnCalled[offset2] ? 2 : 0) | (this.normalCompletion[offset2] ? 1 : 0);
                if (n == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$8MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, offset2, endOffset);
        return visitor2.getResult();
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(96);
        }
        return ControlFlowUtil.getInitializedTwice(flow, 0, flow.getSize());
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow, int startOffset, int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(97);
        }
        while (startOffset < endOffset) {
            InitializedTwiceClientVisitor visitor2 = new InitializedTwiceClientVisitor(flow, startOffset);
            ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
            Object result2 = visitor2.getResult();
            if (!result2.isEmpty()) {
                Object object = result2;
                if (object == null) {
                    ControlFlowUtil.$$$reportNull$$$0(98);
                }
                return object;
            }
            startOffset = ControlFlowUtil.findUnprocessed(startOffset, endOffset, visitor2);
        }
        List<VariableInfo> list2 = Collections.emptyList();
        if (list2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(99);
        }
        return list2;
    }

    @NotNull
    public static Map<PsiElement, PsiVariable> getWritesBeforeReads(@NotNull ControlFlow flow, @NotNull Set<? extends PsiVariable> writeVars, @NotNull Set<? extends PsiVariable> readVars, int stopPoint) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(100);
        }
        if (writeVars == null) {
            ControlFlowUtil.$$$reportNull$$$0(101);
        }
        if (readVars == null) {
            ControlFlowUtil.$$$reportNull$$$0(102);
        }
        HashMap<PsiElement, PsiVariable> writes = new HashMap<PsiElement, PsiVariable>();
        List<Instruction> instructions = flow.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            PsiVariable writtenVar;
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction) || !writeVars.contains(writtenVar = ((WriteVariableInstruction)instruction).variable) || !ControlFlowUtil.readBeforeStopPoint(flow, readVars, i, stopPoint)) continue;
            writes.put(flow.getElement(i), writtenVar);
        }
        HashMap<PsiElement, PsiVariable> hashMap = writes;
        if (hashMap == null) {
            ControlFlowUtil.$$$reportNull$$$0(103);
        }
        return hashMap;
    }

    private static boolean readBeforeStopPoint(@NotNull ControlFlow flow, final @NotNull Set<? extends PsiVariable> readVars, int startOffset, final int stopPoint) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(104);
        }
        if (readVars == null) {
            ControlFlowUtil.$$$reportNull$$$0(105);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private boolean reachable = false;

            MyVisitor() {
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (offset2 == stopPoint || this.isWriteToReadVar(instruction)) {
                    this.reachable = false;
                    return;
                }
                boolean foundRead = instruction instanceof ReadVariableInstruction && readVars.contains(((ReadVariableInstruction)instruction).variable);
                this.reachable |= foundRead;
            }

            private boolean isWriteToReadVar(Instruction instruction) {
                return instruction instanceof WriteVariableInstruction && readVars.contains(((WriteVariableInstruction)instruction).variable);
            }

            @Override
            public Boolean getResult() {
                return this.reachable;
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, flow.getSize());
        return visitor2.getResult();
    }

    public static boolean isInstructionReachable(@NotNull ControlFlow flow, int instructionOffset, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(106);
        }
        return ControlFlowUtil.areInstructionsReachable(flow, new int[]{instructionOffset}, startOffset);
    }

    private static boolean areInstructionsReachable(@NotNull ControlFlow flow, int @NotNull [] instructionOffsets, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(107);
        }
        if (instructionOffsets == null) {
            ControlFlowUtil.$$$reportNull$$$0(108);
        }
        if (startOffset != 0 && ControlFlowUtil.hasCalls(flow)) {
            return ControlFlowUtil.areInstructionsReachableWithCalls(flow, instructionOffsets, startOffset);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private boolean reachable;
            final /* synthetic */ int[] val$instructionOffsets;

            MyVisitor(int[] nArray) {
                this.val$instructionOffsets = nArray;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                this.reachable |= ArrayUtil.indexOf(this.val$instructionOffsets, nextOffset) >= 0;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = this.reachable;
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$10MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor2 = new MyVisitor(instructionOffsets);
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, flow.getSize());
        return visitor2.getResult();
    }

    private static boolean hasCalls(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(109);
        }
        for (Instruction instruction : flow.getInstructions()) {
            if (!(instruction instanceof CallInstruction)) continue;
            return true;
        }
        return false;
    }

    private static boolean areInstructionsReachableWithCalls(@NotNull ControlFlow flow, final int @NotNull [] instructionOffsets, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(110);
        }
        if (instructionOffsets == null) {
            ControlFlowUtil.$$$reportNull$$$0(111);
        }
        ControlFlowGraph graph2 = new ControlFlowGraph(flow.getSize()){

            @Override
            boolean isComplete(int offset2, int nextOffset) {
                return ArrayUtil.indexOf(instructionOffsets, nextOffset) >= 0;
            }
        };
        graph2.buildFrom(flow);
        return graph2.depthFirstSearch(startOffset);
    }

    public static boolean isVariableAssignedInLoop(@NotNull PsiReferenceExpression expression2, @NotNull PsiElement resolved) {
        ControlFlow flow;
        if (expression2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(112);
        }
        if (resolved == null) {
            ControlFlowUtil.$$$reportNull$$$0(113);
        }
        if (!(expression2.getParent() instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)expression2.getParent()).getLExpression() != expression2) {
            return false;
        }
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return false;
        }
        if (!(resolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable2 = (PsiVariable)resolved;
        PsiElement codeBlock = PsiUtil.getVariableCodeBlock(variable2, expression2);
        if (codeBlock == null) {
            return false;
        }
        try {
            flow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow(codeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), true);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2.getParent();
        int startOffset = flow.getStartOffset(assignmentExpression);
        return startOffset != -1 && ControlFlowUtil.isInstructionReachable(flow, startOffset, startOffset);
    }

    static boolean isCaughtExceptionType(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        if (throwType == null) {
            ControlFlowUtil.$$$reportNull$$$0(114);
        }
        if (catchType == null) {
            ControlFlowUtil.$$$reportNull$$$0(115);
        }
        return catchType.isAssignableFrom(throwType) || ControlFlowUtil.mightBeAssignableFromSubclass(throwType, catchType);
    }

    private static boolean mightBeAssignableFromSubclass(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        if (throwType == null) {
            ControlFlowUtil.$$$reportNull$$$0(116);
        }
        if (catchType == null) {
            ControlFlowUtil.$$$reportNull$$$0(117);
        }
        if (catchType instanceof PsiDisjunctionType) {
            for (PsiType catchDisjunction : ((PsiDisjunctionType)catchType).getDisjunctions()) {
                if (!throwType.isAssignableFrom(catchDisjunction)) continue;
                return true;
            }
            return false;
        }
        return throwType.isAssignableFrom(catchType);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean areVariablesUnmodifiedAtLocations(@NotNull ControlFlow flow, int startOffset, int endOffset, @NotNull Set<? extends PsiVariable> variables, @NotNull Iterable<? extends PsiElement> locations) {
        void var8_10;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(118);
        }
        if (variables == null) {
            ControlFlowUtil.$$$reportNull$$$0(119);
        }
        if (locations == null) {
            ControlFlowUtil.$$$reportNull$$$0(120);
        }
        List<Instruction> instructions = flow.getInstructions();
        startOffset = Math.max(startOffset, 0);
        endOffset = Math.min(endOffset, instructions.size());
        IntArrayList locationOffsetList = new IntArrayList();
        for (PsiElement psiElement : locations) {
            int offset2 = flow.getStartOffset(psiElement);
            if (offset2 < startOffset || offset2 >= endOffset) continue;
            locationOffsetList.add(offset2);
        }
        int[] locationOffsets = locationOffsetList.toIntArray();
        int n = startOffset;
        while (var8_10 < endOffset) {
            Instruction instruction = instructions.get((int)var8_10);
            if (instruction instanceof WriteVariableInstruction && variables.contains(((WriteVariableInstruction)instruction).variable) && ControlFlowUtil.areInstructionsReachable(flow, locationOffsets, (int)var8_10)) {
                return false;
            }
            ++var8_10;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 48: 
            case 50: 
            case 78: 
            case 90: 
            case 93: 
            case 94: 
            case 98: 
            case 99: 
            case 103: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 48: 
            case 50: 
            case 78: 
            case 90: 
            case 93: 
            case 94: 
            case 98: 
            case 99: 
            case 103: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 48: 
            case 50: 
            case 78: 
            case 90: 
            case 93: 
            case 94: 
            case 98: 
            case 99: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil";
                break;
            }
            case 3: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: 
            case 39: 
            case 49: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 44: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCodeFragment";
                break;
            }
            case 25: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitPoints";
                break;
            }
            case 29: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesFilter";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitStatements";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassMember";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterVisitor";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientVisitor";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeVars";
                break;
            }
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readVars";
                break;
            }
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionOffsets";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 114: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwType";
                break;
            }
            case 115: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchType";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSSAVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrittenVariables";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedVariables";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "findExitPointsAndStatements";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTryStatementStack";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeFragment";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadBeforeWriteLocals";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadBeforeWrite";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedTwice";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritesBeforeReads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSSAVariables";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 48: 
            case 50: 
            case 78: 
            case 90: 
            case 93: 
            case 94: 
            case 98: 
            case 99: 
            case 103: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "needVariableValueAt";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWrittenVariables";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUsedVariables";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isVariableUsed";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSingleReadOffset";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSingleReadOccurrence";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isVariableReadInFinally";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInputVariables";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariables";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findExitPointsAndStatements";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processGoto";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processGotoStatement";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isElementOfClass";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "promoteThroughGotoChain";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findStatement";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasObservableThrowExitPoints";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingTryStatementHavingCatchOrFinally";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "collectTryStatementStack";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findCodeFragment";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpressionScope";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "collectOuterLocals";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "returnPresent";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processReturns";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "returnPresentBetween";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "canCompleteNormally";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getUnreachableStatement";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingReferenceExpression";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceTo";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDefinitelyAssigned";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getVariablePossiblyUnassignedOffsets";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDefinitelyNotAssigned";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isValueUsedWithoutVisitingStop";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAccess";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getEdges";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getMinDefinitelyReachedOffset";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findUnprocessed";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "depthFirstSearch";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "internalDepthFirstSearch";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getReadBeforeWriteLocals";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getReadBeforeWrite";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionReasons";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getInitializedTwice";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getWritesBeforeReads";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "readBeforeStopPoint";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isInstructionReachable";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "areInstructionsReachable";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "hasCalls";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "areInstructionsReachableWithCalls";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAssignedInLoop";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isCaughtExceptionType";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "mightBeAssignableFromSubclass";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "areVariablesUnmodifiedAtLocations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 48: 
            case 50: 
            case 78: 
            case 90: 
            case 93: 
            case 94: 
            case 98: 
            case 99: 
            case 103: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class ControlFlowGraph
    extends InstructionClientVisitor<Void> {
        final int[][] nextOffsets;

        ControlFlowGraph(int size) {
            this.nextOffsets = new int[size][];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.size()) {
                nextOffset = this.size();
            }
            this.addArc(offset2, nextOffset);
        }

        void addArc(int offset2, int nextOffset) {
            if (this.nextOffsets[offset2] == null) {
                this.nextOffsets[offset2] = new int[]{nextOffset, -1};
            } else {
                int[] targets = this.nextOffsets[offset2];
                if (ArrayUtil.indexOf(targets, nextOffset) < 0) {
                    int freeIndex = ArrayUtil.indexOf(targets, -1);
                    if (freeIndex >= 0) {
                        targets[freeIndex] = nextOffset;
                    } else {
                        int oldLength = targets.length;
                        targets = ArrayUtil.realloc(targets, oldLength * 3 / 2);
                        this.nextOffsets[offset2] = targets;
                        Arrays.fill(targets, oldLength, targets.length, -1);
                        targets[oldLength] = nextOffset;
                    }
                }
            }
        }

        int @NotNull [] getNextOffsets(int offset2) {
            int[] nArray = this.nextOffsets[offset2] != null ? this.nextOffsets[offset2] : ArrayUtilRt.EMPTY_INT_ARRAY;
            if (nArray == null) {
                ControlFlowGraph.$$$reportNull$$$0(0);
            }
            return nArray;
        }

        int size() {
            return this.nextOffsets.length;
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder();
            for (int i = 0; i < this.nextOffsets.length; ++i) {
                int[] targets = this.nextOffsets[i];
                if (targets == null || targets.length == 0 || targets[0] == -1) continue;
                if (s2.length() != 0) {
                    s2.append(' ');
                }
                s2.append('(').append(i).append("->");
                for (int j = 0; j < targets.length && targets[j] != -1; ++j) {
                    if (j != 0) {
                        s2.append(",");
                    }
                    s2.append(targets[j]);
                }
                s2.append(')');
            }
            return s2.toString();
        }

        boolean depthFirstSearch(int startOffset) {
            return this.depthFirstSearch(startOffset, new BitSet(this.size()));
        }

        boolean depthFirstSearch(int startOffset, @NotNull BitSet visitedOffsets) {
            if (visitedOffsets == null) {
                ControlFlowGraph.$$$reportNull$$$0(1);
            }
            IntStack walkThroughStack = new IntStack(Math.max(this.size() / 2, 2));
            visitedOffsets.clear();
            walkThroughStack.push(startOffset);
            while (!walkThroughStack.empty()) {
                int[] nextOffsets;
                int currentOffset = walkThroughStack.pop();
                if (currentOffset >= this.size() || visitedOffsets.get(currentOffset)) continue;
                visitedOffsets.set(currentOffset);
                for (int nextOffset : nextOffsets = this.getNextOffsets(currentOffset)) {
                    if (nextOffset == -1) break;
                    if (this.isComplete(currentOffset, nextOffset)) {
                        return true;
                    }
                    walkThroughStack.push(nextOffset);
                }
            }
            return false;
        }

        @Override
        public Void getResult() {
            return null;
        }

        boolean isComplete(int offset2, int nextOffset) {
            return false;
        }

        void buildFrom(@NotNull ControlFlow flow) {
            if (flow == null) {
                ControlFlowGraph.$$$reportNull$$$0(2);
            }
            ControlFlowUtil.depthFirstSearch(flow, this, 0, flow.getSize());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$ControlFlowGraph";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitedOffsets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOffsets";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$ControlFlowGraph";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "depthFirstSearch";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFrom";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InitializedTwiceClientVisitor
    extends InstructionClientVisitor<Collection<VariableInfo>> {
        private final CopyOnWriteList[] writtenVariables;
        private final CopyOnWriteList[] writtenTwiceVariables;
        private final ControlFlow myFlow;
        private final int myStartOffset;

        InitializedTwiceClientVisitor(@NotNull ControlFlow flow, int startOffset) {
            if (flow == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.myStartOffset = startOffset;
            this.writtenVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
            this.writtenTwiceVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            int safeNextOffset = Math.min(nextOffset, this.myFlow.getSize());
            CopyOnWriteList writeVars = this.writtenVariables[safeNextOffset];
            CopyOnWriteList writeTwiceVars = this.writtenTwiceVariables[safeNextOffset];
            if (instruction instanceof WriteVariableInstruction) {
                PsiVariable variable2 = ((WriteVariableInstruction)instruction).variable;
                PsiElement latestWriteVarExpression = InitializedTwiceClientVisitor.getLatestWriteVarExpression(writeVars, variable2);
                if (latestWriteVarExpression == null) {
                    PsiElement expression2 = InitializedTwiceClientVisitor.getExpression(this.myFlow.getElement(offset2));
                    writeVars = CopyOnWriteList.add(writeVars, new VariableInfo(variable2, expression2));
                } else {
                    writeTwiceVars = CopyOnWriteList.add(writeTwiceVars, new VariableInfo(variable2, latestWriteVarExpression));
                }
            }
            ControlFlowUtil.merge(offset2, writeVars, this.writtenVariables);
            ControlFlowUtil.merge(offset2, writeTwiceVars, this.writtenTwiceVariables);
        }

        @Nullable
        private static PsiElement getExpression(@NotNull PsiElement element) {
            if (element == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiAssignmentExpression) {
                PsiExpression target = PsiUtil.skipParenthesizedExprDown(((PsiAssignmentExpression)element).getLExpression());
                return ObjectUtils.tryCast(target, PsiReferenceExpression.class);
            }
            if (element instanceof PsiUnaryExpression) {
                PsiExpression target = PsiUtil.skipParenthesizedExprDown(((PsiUnaryExpression)element).getOperand());
                return ObjectUtils.tryCast(target, PsiReferenceExpression.class);
            }
            if (element instanceof PsiDeclarationStatement) {
                return element;
            }
            return null;
        }

        @Nullable
        private static PsiElement getLatestWriteVarExpression(@Nullable CopyOnWriteList writeVars, @NotNull PsiVariable variable2) {
            if (variable2 == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(2);
            }
            if (writeVars == null) {
                return null;
            }
            PsiManager psiManager = variable2.getManager();
            for (VariableInfo variableInfo : writeVars.getList()) {
                if (!psiManager.areElementsEquivalent(variableInfo.variable, variable2)) continue;
                return variableInfo.expression;
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<VariableInfo> getResult() {
            CopyOnWriteList writtenTwiceVariable = this.writtenTwiceVariables[this.myStartOffset];
            if (writtenTwiceVariable == null) {
                List<VariableInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    InitializedTwiceClientVisitor.$$$reportNull$$$0(3);
                }
                return list2;
            }
            List<VariableInfo> list3 = writtenTwiceVariable.getList();
            if (list3 == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(4);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLatestWriteVarExpression";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReadBeforeWriteClientVisitor
    extends InstructionClientVisitor<List<PsiReferenceExpression>> {
        private final CopyOnWriteList[] readVariables;
        private final ControlFlow myFlow;
        private final boolean localVariablesOnly;

        ReadBeforeWriteClientVisitor(@NotNull ControlFlow flow, boolean localVariablesOnly) {
            if (flow == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.localVariablesOnly = localVariablesOnly;
            this.readVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset2, int nextOffset) {
            PsiReferenceExpression expression2;
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            PsiVariable variable2 = instruction.variable;
            if (!(this.localVariablesOnly && ReadBeforeWriteClientVisitor.isImplicitlyInitialized(variable2) || (expression2 = ControlFlowUtil.getEnclosingReferenceExpression(this.myFlow.getElement(offset2), variable2)) == null)) {
                readVars = CopyOnWriteList.add(readVars, new VariableInfo(variable2, expression2));
            }
            ControlFlowUtil.merge(offset2, readVars, this.readVariables);
        }

        @Override
        public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            if (readVars == null) {
                return;
            }
            PsiVariable variable2 = instruction.variable;
            if (!this.localVariablesOnly || !ReadBeforeWriteClientVisitor.isImplicitlyInitialized(variable2)) {
                readVars = readVars.remove(new VariableInfo(variable2, null));
            }
            ControlFlowUtil.merge(offset2, readVars, this.readVariables);
        }

        private static boolean isImplicitlyInitialized(@NotNull PsiVariable variable2) {
            if (variable2 == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(1);
            }
            return ReadBeforeWriteClientVisitor.isMethodParameter(variable2) || variable2 instanceof PsiPatternVariable;
        }

        private static boolean isMethodParameter(@NotNull PsiVariable variable2) {
            if (variable2 == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(2);
            }
            if (variable2 instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable2;
                return !(parameter.getDeclarationScope() instanceof PsiForeachStatement);
            }
            return false;
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            ControlFlowUtil.merge(offset2, this.readVariables[Math.min(nextOffset, this.myFlow.getSize())], this.readVariables);
        }

        @Override
        public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
            this.visitInstruction(instruction, offset2, nextOffset);
            for (int i = instruction.procBegin; i <= instruction.procEnd; ++i) {
                this.readVariables[i] = null;
            }
        }

        @Override
        @NotNull
        public List<PsiReferenceExpression> getResult() {
            List<PsiReferenceExpression> list2 = this.getResult(0);
            if (list2 == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public List<PsiReferenceExpression> getResult(int startOffset) {
            CopyOnWriteList topReadVariables = this.readVariables[startOffset];
            if (topReadVariables == null) {
                List<PsiReferenceExpression> list2 = Collections.emptyList();
                if (list2 == null) {
                    ReadBeforeWriteClientVisitor.$$$reportNull$$$0(4);
                }
                return list2;
            }
            ArrayList<PsiReferenceExpression> result2 = new ArrayList<PsiReferenceExpression>();
            List<VariableInfo> list3 = topReadVariables.getList();
            for (VariableInfo variableInfo : list3) {
                result2.add((PsiReferenceExpression)variableInfo.expression);
            }
            ArrayList<PsiReferenceExpression> arrayList = result2;
            if (arrayList == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$ReadBeforeWriteClientVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$ReadBeforeWriteClientVisitor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isImplicitlyInitialized";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isMethodParameter";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class VariableInfo {
        private final PsiVariable variable;
        public final PsiElement expression;

        public VariableInfo(@NotNull PsiVariable variable2, @Nullable PsiElement expression2) {
            if (variable2 == null) {
                VariableInfo.$$$reportNull$$$0(0);
            }
            this.variable = variable2;
            this.expression = expression2;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof VariableInfo && this.variable.equals(((VariableInfo)o).variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$VariableInfo", "<init>"));
        }
    }

    private static class CopyOnWriteList {
        private final List<VariableInfo> list;

        @NotNull
        public CopyOnWriteList add(@NotNull VariableInfo value2) {
            if (value2 == null) {
                CopyOnWriteList.$$$reportNull$$$0(0);
            }
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            for (VariableInfo variableInfo : list2) {
                if (value2.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            newList.list.add(value2);
            CopyOnWriteList copyOnWriteList = newList;
            if (copyOnWriteList == null) {
                CopyOnWriteList.$$$reportNull$$$0(1);
            }
            return copyOnWriteList;
        }

        @NotNull
        public CopyOnWriteList remove(@NotNull VariableInfo value2) {
            if (value2 == null) {
                CopyOnWriteList.$$$reportNull$$$0(2);
            }
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            for (VariableInfo variableInfo : list2) {
                if (value2.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            CopyOnWriteList copyOnWriteList = newList;
            if (copyOnWriteList == null) {
                CopyOnWriteList.$$$reportNull$$$0(3);
            }
            return copyOnWriteList;
        }

        @NotNull
        public List<VariableInfo> getList() {
            List<VariableInfo> list2 = this.list;
            if (list2 == null) {
                CopyOnWriteList.$$$reportNull$$$0(4);
            }
            return list2;
        }

        CopyOnWriteList() {
            this(Collections.emptyList());
        }

        CopyOnWriteList(VariableInfo ... infos) {
            if (infos == null) {
                CopyOnWriteList.$$$reportNull$$$0(5);
            }
            this(Arrays.asList(infos));
        }

        CopyOnWriteList(@NotNull Collection<? extends VariableInfo> infos) {
            if (infos == null) {
                CopyOnWriteList.$$$reportNull$$$0(6);
            }
            this.list = new SmartList<VariableInfo>(infos);
        }

        @NotNull
        public CopyOnWriteList addAll(@NotNull CopyOnWriteList addList) {
            if (addList == null) {
                CopyOnWriteList.$$$reportNull$$$0(7);
            }
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            newList.list.addAll(list2);
            List<VariableInfo> toAdd = addList.getList();
            for (VariableInfo variableInfo : toAdd) {
                if (newList.list.contains(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            CopyOnWriteList copyOnWriteList = newList;
            if (copyOnWriteList == null) {
                CopyOnWriteList.$$$reportNull$$$0(8);
            }
            return copyOnWriteList;
        }

        @NotNull
        public static CopyOnWriteList add(@Nullable CopyOnWriteList list2, @NotNull VariableInfo value2) {
            if (value2 == null) {
                CopyOnWriteList.$$$reportNull$$$0(9);
            }
            CopyOnWriteList copyOnWriteList = list2 == null ? new CopyOnWriteList(value2) : list2.add(value2);
            if (copyOnWriteList == null) {
                CopyOnWriteList.$$$reportNull$$$0(10);
            }
            return copyOnWriteList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 10: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$CopyOnWriteList";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$CopyOnWriteList";
                    break;
                }
                case 1: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "remove";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addAll";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WalkThroughStack {
        private int[] oldOffsets;
        private int[] newOffsets;
        private CallStackItem[] callStacks;
        private CallStackItem currentStack;
        private int size;

        WalkThroughStack(int initialSize) {
            if (initialSize < 2) {
                initialSize = 2;
            }
            this.oldOffsets = new int[initialSize];
            this.newOffsets = new int[initialSize];
            this.callStacks = new CallStackItem[initialSize];
        }

        void push(int oldOffset, int newOffset) {
            LOG.assertTrue(oldOffset >= 0, "negative offset is pushed to walk-through stack");
            if (this.size >= this.newOffsets.length) {
                int newSize = this.size * 3 / 2;
                this.oldOffsets = Arrays.copyOf(this.oldOffsets, newSize);
                this.newOffsets = Arrays.copyOf(this.newOffsets, newSize);
                this.callStacks = Arrays.copyOf(this.callStacks, newSize);
            }
            this.oldOffsets[this.size] = oldOffset;
            this.newOffsets[this.size] = newOffset;
            this.callStacks[this.size] = this.currentStack;
            ++this.size;
        }

        void push(int offset2) {
            this.push(offset2, -1);
        }

        int peekOldOffset() {
            return this.oldOffsets[this.size - 1];
        }

        int popNewOffset() {
            this.currentStack = this.callStacks[--this.size];
            return this.newOffsets[this.size];
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                if (s2.length() != 0) {
                    s2.append(' ');
                }
                if (this.newOffsets[i] != -1) {
                    s2.append('(').append(this.oldOffsets[i]).append("->").append(this.newOffsets[i]).append(')');
                    continue;
                }
                s2.append('[').append(this.oldOffsets[i]).append(']');
            }
            return s2.toString();
        }
    }

    private static final class CallStackItem {
        final CallStackItem next;
        final int target;

        private CallStackItem(CallStackItem next, int target) {
            this.next = next;
            this.target = target;
        }
    }

    public static class ControlFlowEdge {
        public final int myFrom;
        public final int myTo;

        ControlFlowEdge(int from2, int to) {
            this.myFrom = from2;
            this.myTo = to;
        }

        public String toString() {
            return this.myFrom + "->" + this.myTo;
        }
    }

    private static class UnreachableStatementClientVisitor
    extends InstructionClientVisitor<PsiElement> {
        private final ControlFlow myFlow;

        UnreachableStatementClientVisitor(@NotNull ControlFlow flow) {
            if (flow == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
        }

        @Override
        public PsiElement getResult() {
            for (int i = 0; i < this.processedInstructions.length; ++i) {
                int startOffset;
                int endOffset;
                if (this.processedInstructions[i]) continue;
                PsiElement element = this.myFlow.getElement(i);
                PsiElement unreachableParent = UnreachableStatementClientVisitor.getUnreachableExpressionParent(element);
                if (unreachableParent != null) {
                    return unreachableParent;
                }
                if (element == null || !PsiUtil.isStatement(element) || element.getParent() instanceof PsiExpression) continue;
                while (element instanceof PsiExpression) {
                    element = element.getParent();
                }
                if (element instanceof PsiStatement && element.getParent() instanceof PsiForStatement && element == ((PsiForStatement)element.getParent()).getUpdate() || (endOffset = this.myFlow.getEndOffset(element)) != i + 1 || 0 <= (startOffset = this.myFlow.getStartOffset(element)) && startOffset < this.processedInstructions.length && this.processedInstructions[startOffset]) continue;
                PsiElement enclosingStatement = UnreachableStatementClientVisitor.getEnclosingUnreachableStatement(element);
                return enclosingStatement != null ? enclosingStatement : element;
            }
            return null;
        }

        @Nullable
        private static PsiElement getUnreachableExpressionParent(@Nullable PsiElement element) {
            PsiElement expression2;
            if (element instanceof PsiExpression && (expression2 = PsiTreeUtil.findFirstParent(element, e -> !(e.getParent() instanceof PsiParenthesizedExpression))) != null) {
                PsiElement parent2 = expression2.getParent();
                if (parent2 instanceof PsiExpressionStatement) {
                    return UnreachableStatementClientVisitor.getUnreachableStatementParent(parent2);
                }
                if (parent2 instanceof PsiIfStatement && ((PsiIfStatement)parent2).getCondition() == expression2 || parent2 instanceof PsiSwitchBlock && ((PsiSwitchBlock)parent2).getExpression() == expression2 || parent2 instanceof PsiWhileStatement && ((PsiWhileStatement)parent2).getCondition() == expression2 || parent2 instanceof PsiForeachStatement && ((PsiForeachStatement)parent2).getIteratedValue() == expression2) {
                    return parent2;
                }
            }
            return null;
        }

        @Nullable
        private static PsiElement getEnclosingUnreachableStatement(@NotNull PsiElement statement2) {
            PsiElement blockParent;
            PsiBlockStatement blockStatement;
            PsiElement parent2;
            if (statement2 == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(1);
            }
            if ((parent2 = statement2.getParent()) instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)parent2).getBody() == statement2) {
                return parent2;
            }
            if (parent2 instanceof PsiCodeBlock && PsiTreeUtil.getNextSiblingOfType(parent2.getFirstChild(), PsiStatement.class) == statement2 && (blockStatement = ObjectUtils.tryCast(parent2.getParent(), PsiBlockStatement.class)) != null && (blockParent = blockStatement.getParent()) instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)blockParent).getBody() == blockStatement) {
                return blockParent;
            }
            return UnreachableStatementClientVisitor.getUnreachableStatementParent(statement2);
        }

        @Nullable
        private static PsiElement getUnreachableStatementParent(@NotNull PsiElement statement2) {
            PsiElement parent2;
            if (statement2 == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(2);
            }
            if ((parent2 = statement2.getParent()) instanceof PsiForStatement && ((PsiForStatement)parent2).getInitialization() == statement2) {
                return parent2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$UnreachableStatementClientVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEnclosingUnreachableStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUnreachableStatementParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnPresentClientVisitor
    extends InstructionClientVisitor<Boolean> {
        private final boolean[] isNormalCompletion;
        protected final ControlFlow myFlow;

        ReturnPresentClientVisitor(@NotNull ControlFlow flow) {
            if (flow == null) {
                ReturnPresentClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.isNormalCompletion = new boolean[this.myFlow.getSize() + 1];
            this.isNormalCompletion[this.myFlow.getSize()] = true;
        }

        @Override
        public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = instruction.offset == nextOffset && nextOffset != offset2 + 1 ? !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset] : this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!instruction.isReturn && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        @NotNull
        public Boolean getResult() {
            Boolean bl = !this.isNormalCompletion[0];
            if (bl == null) {
                ReturnPresentClientVisitor.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$ReturnPresentClientVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$ReturnPresentClientVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConvertReturnClientVisitor
    extends ReturnPresentClientVisitor {
        private final List<PsiReturnStatement> myAffectedReturns;
        private final ReturnStatementsVisitor myVisitor;

        ConvertReturnClientVisitor(@NotNull ControlFlow flow, @NotNull ReturnStatementsVisitor visitor2) {
            if (flow == null) {
                ConvertReturnClientVisitor.$$$reportNull$$$0(0);
            }
            if (visitor2 == null) {
                ConvertReturnClientVisitor.$$$reportNull$$$0(1);
            }
            super(flow);
            this.myAffectedReturns = new ArrayList<PsiReturnStatement>();
            this.myVisitor = visitor2;
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
            PsiElement element;
            super.visitGoToInstruction(instruction, offset2, nextOffset);
            if (instruction.isReturn && (element = this.myFlow.getElement(offset2)) instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                this.myAffectedReturns.add(returnStatement);
            }
        }

        void afterProcessing() throws IncorrectOperationException {
            this.myVisitor.visit(this.myAffectedReturns);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visitor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ControlFlowUtil$ConvertReturnClientVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SSAInstructionState
    implements Cloneable {
        private final int myWriteCount;
        private final int myInstructionIdx;

        SSAInstructionState(int writeCount, int instructionIdx) {
            this.myWriteCount = writeCount;
            this.myInstructionIdx = instructionIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SSAInstructionState)) {
                return false;
            }
            SSAInstructionState ssaInstructionState = (SSAInstructionState)o;
            if (this.myInstructionIdx != ssaInstructionState.myInstructionIdx) {
                return false;
            }
            return Math.min(2, this.myWriteCount) == Math.min(2, ssaInstructionState.myWriteCount);
        }

        public int hashCode() {
            int result2 = Math.min(2, this.myWriteCount);
            result2 = 29 * result2 + this.myInstructionIdx;
            return result2;
        }

        int getWriteCount() {
            return this.myWriteCount;
        }

        int getInstructionIdx() {
            return this.myInstructionIdx;
        }
    }
}

