/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.progress.EmptyProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.BlockSupportImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.BooleanRunnable;
import org.jetbrains.kotlin.com.intellij.psi.impl.ChangedPsiRangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.DiffLog;
import org.jetbrains.kotlin.com.intellij.psi.impl.DocumentCommitProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.text.BlockSupport;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.BoundedTaskExecutor;
import org.jetbrains.kotlin.com.intellij.util.ui.EdtInvocationManager;

public final class DocumentCommitThread
implements Disposable,
DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance(DocumentCommitThread.class);
    private final ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor("Document Committing Pool", AppExecutorUtil.getAppExecutorService(), 1, this);
    private volatile boolean isDisposed;

    DocumentCommitThread() {
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState modality) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(1);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(2);
        }
        if (modality == null) {
            DocumentCommitThread.$$$reportNull$$$0(3);
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        assert (documentManager.isEventSystemEnabled(document)) : "Asynchronous commit is only supported for physical PSI, document=" + document + ", viewProvider=" + documentManager.getCachedViewProvider(document);
        TransactionGuard.getInstance().assertWriteSafeContext(modality);
        CommitTask task = new CommitTask(project, document, reason, modality, documentManager.getLastCommittedText(document));
        ReadAction.nonBlocking(() -> this.commitUnderProgress(task, false)).expireWhen(() -> project.isDisposed() || this.isDisposed || !documentManager.isInUncommittedSet(document) || !task.isStillValid()).coalesceBy(task).finishOnUiThread(modality, Runnable::run).submit(this.executor);
    }

    private void log(Project project, @NonNls String msg, @Nullable CommitTask task, Object ... args2) {
    }

    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            DocumentCommitThread.$$$reportNull$$$0(6);
        }
        assert (!this.isDisposed);
        if (!project.isInitialized() && !project.isDefault()) {
            @NonNls String s2 = project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            try {
                Disposer.dispose(project);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s2);
        }
        CommitTask task = new CommitTask(project, document, "Sync commit", ModalityState.defaultModalityState(), PsiDocumentManager.getInstance(project).getLastCommittedText(document));
        this.commitUnderProgress(task, true).run();
    }

    @NotNull
    private Runnable commitUnderProgress(@NotNull CommitTask task, boolean synchronously) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(7);
        }
        Document document = task.getDocument();
        Project project = task.project;
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        SmartList<BooleanRunnable> finishProcessors = new SmartList<BooleanRunnable>();
        SmartList reparseInjectedProcessors = new SmartList();
        FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
        if (viewProvider == null) {
            finishProcessors.add(this.handleCommitWithoutPsi(documentManager, task));
        } else {
            for (PsiFile file2 : viewProvider.getAllFiles()) {
                FileASTNode oldFileNode = file2.getNode();
                if (oldFileNode == null) {
                    throw new AssertionError((Object)("No node for " + file2.getClass() + " in " + file2.getViewProvider().getClass()));
                }
                ProperTextRange changedPsiRange = ChangedPsiRangeUtil.getChangedPsiRange(file2, task.document, task.myLastCommittedText, document.getImmutableCharSequence());
                if (changedPsiRange == null) continue;
                BooleanRunnable finishProcessor = DocumentCommitThread.doCommit(task, file2, oldFileNode, changedPsiRange, reparseInjectedProcessors);
                finishProcessors.add(finishProcessor);
            }
        }
        return this.createFinishCommitRunnable(task, synchronously, finishProcessors, reparseInjectedProcessors);
    }

    @NotNull
    private Runnable createFinishCommitRunnable(@NotNull CommitTask task, boolean synchronously, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(8);
        }
        if (finishProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(9);
        }
        if (reparseInjectedProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(10);
        }
        Runnable runnable = () -> {
            Document document = task.getDocument();
            Project project = task.project;
            if (project.isDisposed()) {
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
            if (documentManager.isEventSystemEnabled(document)) {
                ApplicationManager.getApplication().assertIsWriteThread();
            }
            boolean success = documentManager.finishCommit(document, finishProcessors, reparseInjectedProcessors, synchronously, task.reason);
            if (synchronously) assert (success);
            if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
            if (success) {
                this.log(project, "Commit finished", task, new Object[0]);
            } else {
                this.commitAsynchronously(project, document, "Re-added back", task.myCreationModality);
            }
        };
        if (runnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    private BooleanRunnable handleCommitWithoutPsi(@NotNull PsiDocumentManagerBase documentManager, @NotNull CommitTask task) {
        if (documentManager == null) {
            DocumentCommitThread.$$$reportNull$$$0(12);
        }
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(13);
        }
        BooleanRunnable booleanRunnable = () -> {
            this.log(task.project, "Finishing without PSI", task, new Object[0]);
            Document document = task.getDocument();
            if (!task.isStillValid() || documentManager.getCachedViewProvider(document) != null) {
                return false;
            }
            documentManager.handleCommitWithoutPsi(document);
            return true;
        };
        if (booleanRunnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(14);
        }
        return booleanRunnable;
    }

    public String toString() {
        return "Document commit thread; application: " + ApplicationManager.getApplication() + "; isDisposed: " + this.isDisposed;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public void waitForAllCommits(long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        if (timeUnit == null) {
            DocumentCommitThread.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        EdtInvocationManager.dispatchAllInvocationEvents();
        while (!((BoundedTaskExecutor)this.executor).isEmpty()) {
            void timeUnit2;
            ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(timeout, (TimeUnit)timeUnit2);
            EdtInvocationManager.dispatchAllInvocationEvents();
        }
    }

    @NotNull
    private static BooleanRunnable doCommit(@NotNull CommitTask task, @NotNull PsiFile file2, @NotNull FileASTNode oldFileNode, @NotNull ProperTextRange changedPsiRange, @NotNull List<? super BooleanRunnable> outReparseInjectedProcessors) {
        DiffLog diffLog;
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(17);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(18);
        }
        if (changedPsiRange == null) {
            DocumentCommitThread.$$$reportNull$$$0(19);
        }
        if (outReparseInjectedProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(20);
        }
        Document document = task.getDocument();
        CharSequence newDocumentText = document.getImmutableCharSequence();
        Boolean data2 = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data2 != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data2);
        }
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(task.project);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            BlockSupportImpl.ReparseResult result2 = BlockSupportImpl.reparse(file2, oldFileNode, changedPsiRange, newDocumentText, indicator, task.myLastCommittedText);
            diffLog = result2.log;
            List<BooleanRunnable> injectedRunnables = documentManager.reparseChangedInjectedFragments(document, file2, changedPsiRange, indicator, result2.oldRoot, result2.newRoot);
            outReparseInjectedProcessors.addAll(injectedRunnables);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            BooleanRunnable booleanRunnable = () -> {
                documentManager.forceReload(file2.getViewProvider().getVirtualFile(), file2.getViewProvider());
                return true;
            };
            if (booleanRunnable == null) {
                DocumentCommitThread.$$$reportNull$$$0(21);
            }
            return booleanRunnable;
        }
        BooleanRunnable booleanRunnable = () -> {
            FileViewProvider viewProvider = file2.getViewProvider();
            if (!task.isStillValid() || documentManager.getCachedViewProvider(document) != viewProvider) {
                return false;
            }
            if (!ApplicationManager.getApplication().isWriteAccessAllowed() && documentManager.isEventSystemEnabled(document)) {
                VirtualFile vFile = viewProvider.getVirtualFile();
                LOG.error("Write action expected; document=" + document + "; file=" + file2 + " of " + file2.getClass() + "; file.valid=" + file2.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + file2.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + AbstractFileViewProvider.isFreeThreaded(viewProvider));
            }
            diffLog.doActualPsiChange(file2);
            DocumentCommitThread.assertAfterCommit(document, file2, (FileElement)oldFileNode);
            return true;
        };
        if (booleanRunnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(22);
        }
        return booleanRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file2, @NotNull FileElement oldFileNode) {
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(24);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(25);
        }
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file2.getText();
            boolean sameText = Objects.equals(fileText, documentText);
            String errorMessage2 = "commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency(file2, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + file2.getName() + "; type:" + file2.getFileType() + "; lang:" + file2.getLanguage();
            PluginException.logPluginError(LOG, errorMessage2, null, file2.getLanguage().getClass());
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file2.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file2, file2.getNode(), new TextRange(0, documentText.length()), documentText, new StandardProgressIndicatorBase(), oldFileNode.getText());
                diffLog.doActualPsiChange(file2);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    PluginException.logPluginError(LOG, "PSI is broken beyond repair in: " + file2, null, file2.getLanguage().getClass());
                }
            }
            finally {
                file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparseInjectedProcessors";
                break;
            }
            case 11: 
            case 14: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedPsiRange";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outReparseInjectedProcessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFinishCommitRunnable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCommitWithoutPsi";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitAsynchronously";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commitSynchronously";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commitUnderProgress";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFinishCommitRunnable";
                break;
            }
            case 11: 
            case 14: 
            case 21: 
            case 22: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllCommits";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "assertAfterCommit";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 14: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommitTask {
        @NotNull
        private final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        final Object reason;
        @NotNull
        final ModalityState myCreationModality;
        private final CharSequence myLastCommittedText;

        CommitTask(@NotNull Project project, @NotNull Document document, @NotNull Object reason, @NotNull ModalityState modality, @NotNull CharSequence lastCommittedText) {
            if (project == null) {
                CommitTask.$$$reportNull$$$0(0);
            }
            if (document == null) {
                CommitTask.$$$reportNull$$$0(1);
            }
            if (reason == null) {
                CommitTask.$$$reportNull$$$0(2);
            }
            if (modality == null) {
                CommitTask.$$$reportNull$$$0(3);
            }
            if (lastCommittedText == null) {
                CommitTask.$$$reportNull$$$0(4);
            }
            this.document = document;
            this.project = project;
            this.reason = reason;
            this.myCreationModality = modality;
            this.myLastCommittedText = lastCommittedText;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NonNls
        public String toString() {
            Document document = this.getDocument();
            String reasonInfo = " task reason: " + StringUtil.first(String.valueOf(this.reason), 180, true) + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)document).getModificationSequence());
            String contextInfo = " modality: " + this.myCreationModality;
            return System.identityHashCode(this) + "; " + contextInfo + reasonInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return Comparing.equal(this.getDocument(), task.getDocument()) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result2 = this.getDocument().hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }

        boolean isStillValid() {
            Document document = this.getDocument();
            return ((DocumentEx)document).getModificationSequence() == this.modificationSequence;
        }

        @NotNull
        Document getDocument() {
            Document document = this.document;
            if (document == null) {
                CommitTask.$$$reportNull$$$0(5);
            }
            return document;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modality";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastCommittedText";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

