/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.DataInputOutputUtilRt;

public class BloomFilterBase {
    private final int myHashFunctionCount;
    private final int myBitsCount;
    private final long[] myElementsSet;

    protected BloomFilterBase(int _maxElementCount, double probability) {
        int bitsPerElementFactor = (int)Math.ceil(-Math.log(probability) / (Math.log(2.0) * Math.log(2.0)));
        this.myHashFunctionCount = (int)Math.ceil((double)bitsPerElementFactor * Math.log(2.0));
        int bitsCount = _maxElementCount * bitsPerElementFactor;
        if ((bitsCount & 1) == 0) {
            ++bitsCount;
        }
        while (!BloomFilterBase.isPrime(bitsCount)) {
            bitsCount += 2;
        }
        this.myBitsCount = bitsCount;
        this.myElementsSet = new long[(bitsCount >> 6) + 1];
    }

    private static boolean isPrime(int bits) {
        if ((bits & 1) == 0 || bits % 3 == 0) {
            return false;
        }
        int sqrt = (int)Math.sqrt(bits);
        for (int i = 6; i <= sqrt; i += 6) {
            if (bits % (i - 1) != 0 && bits % (i + 1) != 0) continue;
            return false;
        }
        return true;
    }

    protected final void addIt(int prime, int prime2) {
        for (int i = 0; i < this.myHashFunctionCount; ++i) {
            int abs = Math.abs((i * prime + prime2 * (this.myHashFunctionCount - i)) % this.myBitsCount);
            int n = abs >> 6;
            this.myElementsSet[n] = this.myElementsSet[n] | 1L << abs;
        }
    }

    protected final boolean maybeContains(int prime, int prime2) {
        for (int i = 0; i < this.myHashFunctionCount; ++i) {
            int abs = Math.abs((i * prime + prime2 * (this.myHashFunctionCount - i)) % this.myBitsCount);
            if ((this.myElementsSet[abs >> 6] & 1L << abs) != 0L) continue;
            return false;
        }
        return true;
    }

    protected BloomFilterBase(@NotNull DataInput input) throws IOException {
        if (input == null) {
            BloomFilterBase.$$$reportNull$$$0(0);
        }
        this.myHashFunctionCount = DataInputOutputUtilRt.readINT(input);
        this.myBitsCount = DataInputOutputUtilRt.readINT(input);
        this.myElementsSet = new long[(this.myBitsCount >> 6) + 1];
        for (int i = 0; i < this.myElementsSet.length; ++i) {
            this.myElementsSet[i] = input.readLong();
        }
    }

    protected void save(@NotNull DataOutput output2) throws IOException {
        if (output2 == null) {
            BloomFilterBase.$$$reportNull$$$0(1);
        }
        DataInputOutputUtilRt.writeINT(output2, this.myHashFunctionCount);
        DataInputOutputUtilRt.writeINT(output2, this.myBitsCount);
        for (long l : this.myElementsSet) {
            output2.writeLong(l);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/BloomFilterBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

