/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImpl;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KeepFirstErrorMessageCollector;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteExpectActualTracker;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalDataProvider;
import org.jetbrains.kotlin.daemon.RemoteIncrementalResultsConsumer;
import org.jetbrains.kotlin.daemon.RemoteLookupTrackerClient;
import org.jetbrains.kotlin.daemon.RemoteOutputStreamClient;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.JpsCompilerServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteInputStream;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;
import org.jetbrains.kotlin.daemon.common.ReplStateFacade;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.CompileServicesFacadeMessageCollector;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporter;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterKt;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterPrintStreamAdapter;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\bH\u0016J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'2\u0006\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0(H\u0016J\b\u0010-\u001a\u00020\u0013H\u0016JE\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0016\u00a2\u0006\u0002\u00107J \u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002Je\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\b\u0010E\u001a\u0004\u0018\u00010F2\u001e\u0010G\u001a\u001a\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020J0HH\u0002\u00a2\u0006\u0002\u0010KJ\u0014\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0M0'H\u0016J\u000e\u0010N\u001a\b\u0012\u0004\u0012\u00020)0'H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0016J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0016J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020)0'H\u0016J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001a0'H\u0016J\u0010\u0010R\u001a\u00020$2\u0006\u0010S\u001a\u00020$H\u0002J3\u0010T\u001a\b\u0012\u0004\u0012\u0002HU0'\"\u0004\b\u0000\u0010U2\b\b\u0002\u0010V\u001a\u00020W2\u0012\u0010G\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HU0'0\u0012H\u0082\bJ3\u0010X\u001a\b\u0012\u0004\u0012\u0002HU0'\"\u0004\b\u0000\u0010U2\b\b\u0002\u0010V\u001a\u00020W2\u0012\u0010G\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HU0'0\u0012H\u0082\bJ!\u0010Y\u001a\u00020\u00132\b\b\u0002\u0010V\u001a\u00020W2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ!\u0010Z\u001a\u00020\u00132\b\b\u0002\u0010V\u001a\u00020W2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ\b\u0010[\u001a\u00020\u0013H\u0014J\u0018\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010]\u001a\u0004\u0018\u00010)H\u0016JS\u0010^\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010]\u001a\u0004\u0018\u00010)2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u0010_\u001a\b\u0012\u0004\u0012\u00020,0M2\u0006\u0010`\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010aJ\u00a1\u0001\u0010^\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010]\u001a\u0004\u0018\u00010)2\u0006\u0010b\u001a\u00020c2\u0006\u00103\u001a\u00020;2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020,0M2\u0006\u0010`\u001a\u00020)2\u0012\u0010d\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010e\u0018\u0001002\u0018\u0010f\u001a\u0014\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020e0g\u0018\u0001002\u0006\u0010h\u001a\u00020C2\b\u0010i\u001a\u0004\u0018\u00010C2\b\u0010j\u001a\u0004\u0018\u00010C2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016\u00a2\u0006\u0002\u0010mJ\b\u0010n\u001a\u00020\u0013H\u0014J\b\u0010o\u001a\u00020\u0013H\u0014J\u0018\u0010p\u001a\b\u0012\u0004\u0012\u00020q0'2\b\u0010]\u001a\u0004\u0018\u00010)H\u0016J\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020q0'2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0016\u0010s\u001a\b\u0012\u0004\u0012\u00020q0'2\u0006\u0010*\u001a\u00020\u000eH\u0016J]\u0010t\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010b\u001a\u00020c2\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00103\u001a\u00020;2\u0006\u0010u\u001a\u00020C2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020C2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016\u00a2\u0006\u0002\u0010yJ]\u0010z\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010b\u001a\u00020c2\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00103\u001a\u00020;2\u0006\u0010u\u001a\u00020C2\u0006\u0010{\u001a\u00020w2\u0006\u0010x\u001a\u00020C2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016\u00a2\u0006\u0002\u0010yJ\u001e\u0010|\u001a\b\u0012\u0004\u0012\u00020}0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010~\u001a\u00020\u007fH\u0016J1\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010~\u001a\u00020\u007f2\u000f\u0010\u0082\u0001\u001a\n\u0012\u0004\u0012\u00020\u007f\u0018\u00010MH\u0016J1\u0010\u0083\u0001\u001a\t\u0012\u0005\u0012\u00030\u0084\u00010'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010~\u001a\u00020\u007f2\u000f\u0010\u0082\u0001\u001a\n\u0012\u0004\u0012\u00020\u007f\u0018\u00010MH\u0016J(\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020}0'2\u0006\u0010*\u001a\u00020\u000e2\u0007\u0010\u0086\u0001\u001a\u00020\u000e2\u0006\u0010~\u001a\u00020\u007fH\u0016J)\u0010\u0087\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010'2\u0006\u0010*\u001a\u00020\u000e2\u0007\u0010\u0086\u0001\u001a\u00020\u000e2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u0018\u0010\u0088\u0001\u001a\t\u0012\u0005\u0012\u00030\u0089\u00010'2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0018\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020$0'2\u0007\u0010\u008b\u0001\u001a\u00020$H\u0016J\u000f\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020q0'H\u0016J\t\u0010\u008d\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u008e\u0001\u001a\u00020\u0013H\u0002J@\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u0002HU0'\"\u0004\b\u0000\u0010U2\u0006\u0010*\u001a\u00020\u000e2 \u0010G\u001a\u001c\u0012\u0005\u0012\u00030\u0091\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002HU0'0\u0090\u0001\u00a2\u0006\u0003\b\u0092\u0001H\u0082\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0093\u0001"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "lastUsedSeconds", "", "getLastUsedSeconds", "()J", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "getRegistry", "()Ljava/rmi/registry/Registry;", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "checkCompilerId", "", "expectedCompilerId", "classesFqNamesByFiles", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "", "", "sessionId", "sourceFiles", "Ljava/io/File;", "clearJarCache", "compile", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "doCompile", "args", "compilerMessagesStreamProxy", "Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;", "serviceOutputStreamProxy", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "body", "Lkotlin/Function3;", "Ljava/io/PrintStream;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "getClients", "", "getDaemonInfo", "getDaemonOptions", "getKotlinVersion", "getUsedMemory", "gracefulShutdown", "onAnotherThread", "ifAlive", "R", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "ifAliveExclusive", "ifAliveExclusiveUnit", "ifAliveUnit", "initiateElections", "leaseCompileSession", "aliveFlagPath", "leaseReplSession", "templateClasspath", "templateClassName", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "scriptArgs", "", "scriptArgsTypes", "Ljava/lang/Class;", "compilerMessagesOutputStream", "evalOutputStream", "evalErrorStream", "evalInputStream", "Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Ljava/util/List;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "registerClient", "", "releaseCompileSession", "releaseReplSession", "remoteCompile", "compilerOutputStream", "outputFormat", "Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;", "serviceOutputStream", "(ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "remoteIncrementalCompile", "compilerOutputFormat", "remoteReplLineCheck", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "remoteReplLineCompile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "history", "remoteReplLineEval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "replCheck", "replStateId", "replCompile", "replCreateState", "Lorg/jetbrains/kotlin/daemon/common/ReplStateFacade;", "scheduleShutdown", "graceful", "shutdown", "shutdownNow", "shutdownWithDelay", "withValidRepl", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lkotlin/ExtensionFunctionType;", "kotlin-daemon"})
public final class CompileServiceImpl
extends CompileServiceImplBase
implements CompileService {
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    @NotNull
    private final Function0<Unit> onShutdown;
    @NotNull
    private final ReentrantReadWriteLock rwlock;

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(compiler, "compiler");
        Intrinsics.checkNotNullParameter(compilerId, "compilerId");
        Intrinsics.checkNotNullParameter(daemonOptions, "daemonOptions");
        Intrinsics.checkNotNullParameter(daemonJVMOptions, "daemonJVMOptions");
        Intrinsics.checkNotNullParameter(timer, "timer");
        Intrinsics.checkNotNullParameter(onShutdown, "onShutdown");
        super(daemonOptions, compilerId, port, timer);
        this.registry = registry;
        this.compiler = compiler;
        this.daemonJVMOptions = daemonJVMOptions;
        this.onShutdown = onShutdown;
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        if (remote == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        }
        CompileService stub2 = (CompileService)remote;
        this.registry.rebind("KotlinJvmCompilerService", stub2);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <R> CompileService.CallResult<R> withValidRepl(int sessionId, Function1<? super KotlinJvmReplService, ? extends CompileService.CallResult<? extends R>> body2) {
        Object object;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2;
        boolean $i$f$withValidRepl = false;
        CompileServiceImplBase this_$iv = this;
        boolean $i$f$withValidReplImpl = false;
        CompileServiceImplBase this_$iv$iv = this_$iv;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId == CompileService.Companion.getNO_SESSION()) {
            clientOrSessionProxy2 = null;
        } else {
            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get(sessionId);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                return object;
            }
            clientOrSessionProxy2 = clientOrSessionProxy;
        }
        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = clientOrSessionProxy2;
        try {
            Object object2;
            Object object3;
            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
            CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = session$iv$iv;
            boolean bl = false;
            CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy3 = session$iv;
            Object object4 = object3 = clientOrSessionProxy3 == null ? null : clientOrSessionProxy3.getData();
            if (object3 == null) {
                // empty if block
            }
            clientOrSessionProxy = (object2 = object3) == null ? (CompileService.CallResult)new CompileService.CallResult.Error(Intrinsics.stringPlus("Not a REPL session ", sessionId)) : body2.invoke((KotlinJvmReplService)object2);
            object = clientOrSessionProxy;
            return object;
        }
        finally {
            InlineMarker.finallyStart(1);
            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
            InlineMarker.finallyEnd(1);
        }
    }

    @Override
    protected long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this.get_lastUsedSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getDaemonInfo() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Dying;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<String>(Intrinsics.stringPlus("Kotlin daemon on port ", this.getPort()));
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getKotlinVersion() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl2 = false;
                    try {
                        callResult4 = new CompileService.CallResult.Good<String>(KotlinCompilerVersion.VERSION);
                    }
                    catch (Exception e) {
                        callResult4 = new CompileService.CallResult.Error("Unknown Kotlin version");
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<DaemonOptions>(this.getDaemonOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getLog().info(Intrinsics.stringPlus("getDaemonJVMOptions: ", this.getDaemonJVMOptions()));
                    callResult3 = new CompileService.CallResult.Good<DaemonJVMOptions>(this.getDaemonJVMOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getState().addClient(aliveFlagPath);
                    this.getLog().info(Intrinsics.stringPlus("Registered a client alive file: ", aliveFlagPath));
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<List<String>>(this.getState().getClientsFlagPaths());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    Integer n = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy(aliveFlagPath, null, null, 6, null));
                    int $this$leaseCompileSession_u24lambda_u2d7_u24lambda_u2d6 = ((Number)n).intValue();
                    boolean bl3 = false;
                    this.getLog().info("leased a new session " + $this$leaseCompileSession_u24lambda_u2d7_u24lambda_u2d6 + ", session alive file: " + aliveFlagPath);
                    Unit unit2 = Unit.INSTANCE;
                    Integer n2 = n;
                    callResult3 = new CompileService.CallResult.Good<Integer>(n2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    int n;
                    int n2;
                    boolean bl2 = false;
                    this.getState().getSessions().remove(sessionId);
                    this.getLog().info(Intrinsics.stringPlus("cleaning after session ", sessionId));
                    ReentrantReadWriteLock reentrantReadWriteLock2 = this.rwlock;
                    ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock2.readLock();
                    int n3 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5;
                        n2 = n5 = n4++;
                        n = 0;
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock2.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl3 = false;
                        this.clearJarCache();
                        Unit unit2 = Unit.INSTANCE;
                    }
                    finally {
                        n2 = 0;
                        while (n2 < n3) {
                            int n6 = n = n2++;
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                    callResult3 = this.postReleaseCompileSession();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expectedCompilerId, "expectedCompilerId");
        if (!(((CharSequence)this.getCompilerId().getCompilerVersion()).length() == 0)) {
            if (!Intrinsics.areEqual(this.getCompilerId().getCompilerVersion(), expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $this$all$iv = this.getCompilerId().getCompilerClasspath();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.getClasspathWatcher().isChanged()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    boolean withGC$iv = true;
                    boolean $i$f$usedMemory = false;
                    System.gc();
                    Runtime rt$iv = Runtime.getRuntime();
                    callResult3 = new CompileService.CallResult.Good<Long>(rt$iv.totalMemory() - rt$iv.freeMemory());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        CompileService.CallResult callResult;
        int n;
        int n2;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            n2 = n5 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.shutdownWithDelay();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            n2 = 0;
            while (n2 < n3) {
                int n6 = n = n2++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2;
                    boolean bl3 = false;
                    if (graceful) {
                        bl2 = this.gracefulShutdown(true);
                    } else {
                        this.shutdownWithDelay();
                        bl2 = true;
                    }
                    boolean res2 = bl2;
                    callResult3 = new CompileService.CallResult.Good<Boolean>(res2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args2, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat outputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkNotNullParameter(targetPlatform, "targetPlatform");
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(servicesFacade, "servicesFacade");
        Intrinsics.checkNotNullParameter(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkNotNullParameter(outputFormat, "outputFormat");
        Intrinsics.checkNotNullParameter(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(sessionId, args2, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManager, ? super Profiler, ? extends ExitCode>)new Function3<PrintStream, EventManager, Profiler, ExitCode>(outputFormat, this, targetPlatform, args2, servicesFacade){
            final /* synthetic */ CompileService.OutputFormat $outputFormat;
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            {
                this.$outputFormat = $outputFormat;
                this.this$0 = $receiver;
                this.$targetPlatform = $targetPlatform;
                this.$args = $args;
                this.$servicesFacade = $servicesFacade;
                super(3);
            }

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManager eventManager, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkNotNullParameter(printStream, "printStream");
                Intrinsics.checkNotNullParameter(eventManager, "eventManager");
                Intrinsics.checkNotNullParameter(profiler, "profiler");
                CompileService.OutputFormat outputFormat = this.$outputFormat;
                int n = remoteCompile.WhenMappings.$EnumSwitchMapping$0[outputFormat.ordinal()];
                switch (n) {
                    case 1: {
                        exitCode = this.this$0.getCompiler().get(this.$targetPlatform).exec(printStream, Arrays.copyOf(this.$args, this.$args.length));
                        break;
                    }
                    case 2: {
                        exitCode = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return exitCode;
            }
        });
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteIncrementalCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args2, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat compilerOutputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkNotNullParameter(targetPlatform, "targetPlatform");
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(servicesFacade, "servicesFacade");
        Intrinsics.checkNotNullParameter(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkNotNullParameter(compilerOutputFormat, "compilerOutputFormat");
        Intrinsics.checkNotNullParameter(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(sessionId, args2, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManager, ? super Profiler, ? extends ExitCode>)new Function3<PrintStream, EventManager, Profiler, ExitCode>(compilerOutputFormat, this, targetPlatform, servicesFacade, args2){
            final /* synthetic */ CompileService.OutputFormat $compilerOutputFormat;
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            final /* synthetic */ String[] $args;
            {
                this.$compilerOutputFormat = $compilerOutputFormat;
                this.this$0 = $receiver;
                this.$targetPlatform = $targetPlatform;
                this.$servicesFacade = $servicesFacade;
                this.$args = $args;
                super(3);
            }

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManager eventManager, @NotNull Profiler profiler) {
                Intrinsics.checkNotNullParameter(printStream, "printStream");
                Intrinsics.checkNotNullParameter(eventManager, "eventManager");
                Intrinsics.checkNotNullParameter(profiler, "profiler");
                CompileService.OutputFormat outputFormat = this.$compilerOutputFormat;
                int n = remoteIncrementalCompile.WhenMappings.$EnumSwitchMapping$0[outputFormat.ordinal()];
                switch (n) {
                    case 1: {
                        throw new NotImplementedError("Only XML output is supported in remote incremental compilation");
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler), Arrays.copyOf(this.$args, this.$args.length));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Set<String>> classesFqNamesByFiles(int sessionId, @NotNull Set<? extends File> sourceFiles) {
        Intrinsics.checkNotNullParameter(sourceFiles, "sourceFiles");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this);
        var6_6 = var5_5.readLock();
        var6_6.lock();
        try {
            block13: {
                block12: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = this;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block12;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    block14: {
                        $i$a$-ifAlive$default-CompileServiceImpl$classesFqNamesByFiles$1 = false;
                        this_$iv = this;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block14;
                        v1 = null;
                        ** GOTO lbl34
                    }
                    var14_17 = CompileServiceImplBase.access$getState(this_$iv).getSessions().get(sessionId);
                    if (var14_17 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                    } else {
                        v1 = var14_17;
lbl34:
                        // 2 sources

                        session$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv).incrementAndGet();
                            it = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$classesFqNamesByFiles$1$1 = false;
                            var14_17 = new CompileService.CallResult.Good<Set<String>>(ParseFileUtilsKt.classesFqNames(sourceFiles));
                            v2 = var14_17;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var18_22 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var11_14 = e$iv$iv.getMessage();
                    var18_22 = new CompileService.CallResult.Error(var11_14 == null ? "unknown" : var11_14);
                }
                v0 = var18_22;
            }
            var7_8 = v0;
        }
        finally {
            var6_6.unlock();
        }
        return var7_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults) {
        block85: {
            block84: {
                Intrinsics.checkNotNullParameter(compilerArguments, "compilerArguments");
                Intrinsics.checkNotNullParameter(compilationOptions, "compilationOptions");
                Intrinsics.checkNotNullParameter(servicesFacade, "servicesFacade");
                this_$iv = this;
                $i$f$compileImpl = false;
                $i$a$-run-CompileServiceImplBase$compileImpl$1$iv = false;
                var9_9 /* !! */  = compilationOptions;
                p0 /* !! */  = servicesFacade;
                $i$a$-compileImpl-CompileServiceImpl$compile$2 = false;
                messageCollector$iv = new CompileServicesFacadeMessageCollector(p0 /* !! */ , (CompilationOptions)p1);
                p1 = compilationOptions;
                p0 /* !! */  = servicesFacade;
                $i$a$-compileImpl-CompileServiceImpl$compile$3 = false;
                daemonReporter$iv = DaemonMessageReporterKt.DaemonMessageReporter(p0 /* !! */ , (CompilationOptions)p1);
                targetPlatform$iv = compilationOptions.getTargetPlatform();
                CompileServiceImplBase.access$getLog(this_$iv).info(Intrinsics.stringPlus("Starting compilation with args: ", ArraysKt.joinToString$default(compilerArguments, (CharSequence)" ", null, null, 0, null, null, 62, null)));
                var15_24 = targetPlatform$iv;
                var16_25 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[var15_24.ordinal()];
                switch (var16_25) {
                    case 1: {
                        v0 = new K2JVMCompiler();
                        break;
                    }
                    case 2: {
                        v0 = new K2JSCompiler();
                        break;
                    }
                    case 3: {
                        v0 = new K2MetadataCompiler();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                compiler$iv = v0;
                k2PlatformArgs$iv = (CommonCompilerArguments)compiler$iv.createArguments();
                ParseCommandLineArgumentsKt.parseCommandLineArguments(ArraysKt.asList(compilerArguments), (CommonToolArguments)k2PlatformArgs$iv);
                argumentParseError$iv = ParseCommandLineArgumentsKt.validateArguments(k2PlatformArgs$iv.getErrors());
                if (argumentParseError$iv == null) break block84;
                MessageCollector.DefaultImpls.report$default(messageCollector$iv, CompilerMessageSeverity.ERROR, argumentParseError$iv, null, 4, null);
                v1 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                break block85;
            }
            var18_28 = compilationOptions.getCompilerMode();
            var19_29 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[var18_28.ordinal()];
            block20 : switch (var19_29) {
                case 1: {
                    p0 /* !! */  = (JpsCompilerServicesFacade)servicesFacade;
                    $i$a$-compileImpl-CompileServiceImpl$compile$1 = false;
                    enabled$iv$iv = p0 /* !! */ .hasIncrementalCaches();
                    $i$f$withIC = false;
                    isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                    IncrementalCompilation.setIsEnabledForJvm(enabled$iv$iv);
                    try {
                        $i$a$-withIC-CompileServiceImplBase$compileImpl$1$1$iv = false;
                        var24_42 = this_$iv;
                        tracer$iv$iv = null;
                        $i$f$doCompile = false;
                        $this$doCompile_u24lambda_u2d12$iv$iv = var27_54 = this_$iv$iv;
                        $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl65
                        v2 = null;
                        ** GOTO lbl70
lbl65:
                        // 1 sources

                        var32_75 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                        if (var32_75 != null) ** GOTO lbl69
                        v3 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                        ** GOTO lbl171
lbl69:
                        // 1 sources

                        v2 = var32_75;
lbl70:
                        // 2 sources

                        session$iv$iv$iv = v2;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                            it$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                            var36_95 = tracer$iv$iv;
                            rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                            eventManager$iv$iv = new EventManagerImpl();
                            try {
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                $i$f$checkedCompile = false;
                                try {
                                    var41_123 = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                    obj$iv$iv$iv$iv = null;
                                    $i$f$withMeasure = false;
                                    startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                    $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                    var46_152 = rpcProfiler$iv$iv;
                                    eventManger$iv = eventManager$iv$iv;
                                    $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = false;
                                    $i$a$-compileImpl-CompileServiceImpl$compile$3 = profiler$iv;
                                    $i$a$-compileImpl-CompileServiceImpl$compile$1 = eventManger$iv;
                                    p0 /* !! */  = (CompilerCallbackServicesFacade)servicesFacade;
                                    $i$a$-compileImpl-CompileServiceImpl$compile$4 = false;
                                    services$iv = this.createCompileServices((CompilerCallbackServicesFacade)p0 /* !! */ , (EventManager)p1, (Profiler)p2);
                                    res$iv$iv$iv$iv = compiler$iv.exec(messageCollector$iv, services$iv, (CommonToolArguments)k2PlatformArgs$iv).getCode();
                                    $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                    res$iv$iv$iv = res$iv$iv$iv$iv;
                                    if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                        withGC$iv$iv$iv$iv = false;
                                        $i$f$usedMemory = false;
                                        rt$iv$iv$iv$iv = Runtime.getRuntime();
                                        v4 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                    } else {
                                        v4 = 0L;
                                    }
                                    endMem$iv$iv$iv = v4;
                                    CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(Intrinsics.stringPlus("Done with result ", res$iv$iv$iv));
                                    if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                        pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                        rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                        v5 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                        var55_187 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                        var56_190 = String.format("%+d", Arrays.copyOf(var55_187, var55_187.length));
                                        Intrinsics.checkNotNullExpressionValue(var56_190, "format(this, *args)");
                                        rt$iv$iv$iv$iv = v5.append(var56_190).append(" kb)").toString();
                                        it$iv$iv$iv = rt$iv$iv$iv$iv;
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                        daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                        CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                        for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                            obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                            counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                            it$iv$iv$iv = var58_196 = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                            $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                            daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                            CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(it$iv$iv$iv);
                                        }
                                    }
                                    v6 = res$iv$iv$iv;
                                }
                                catch (Throwable e$iv$iv$iv) {
                                    v7 = CompileServiceImplBase.access$getLog(this_$iv$iv$iv);
                                    v8 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                    res$iv$iv$iv = e$iv$iv$iv.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue(res$iv$iv$iv, "e.stackTrace");
                                    v9 = v8.append(ArraysKt.joinToString$default(res$iv$iv$iv, (CharSequence)"\n  ", null, null, 0, null, null, 62, null));
                                    if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual(e$iv$iv$iv.getCause(), e$iv$iv$iv)) {
                                        v10 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                        v11 = e$iv$iv$iv.getCause();
                                        Intrinsics.checkNotNull(v11);
                                        res$iv$iv$iv = v11.getStackTrace();
                                        Intrinsics.checkNotNullExpressionValue(res$iv$iv$iv, "e.cause!!.stackTrace");
                                        v12 = v10.append(ArraysKt.joinToString$default(res$iv$iv$iv, (CharSequence)"\n  ", null, null, 0, null, null, 62, null)).toString();
                                    } else {
                                        v12 = "";
                                    }
                                    v7.log(Level.SEVERE, v9.append(v12).toString());
                                    throw e$iv$iv$iv;
                                }
                                exitCode$iv$iv = ((Number)v6).intValue();
                                exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                            }
                            finally {
                                eventManager$iv$iv.fireCompilationFinished();
                                this_$iv$iv$iv = tracer$iv$iv;
                            }
                            var32_75 = exitCode$iv$iv;
                            v3 = var32_75;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
lbl171:
                        // 2 sources

                        var62_219 = v3;
                        v1 = var62_219;
                        break;
                    }
                    finally {
                        IncrementalCompilation.setIsEnabledForJvm(isEnabledBackup$iv$iv);
                    }
                }
                case 2: {
                    enabled$iv$iv = this_$iv;
                    tracer$iv$iv = null;
                    $i$f$doCompile = false;
                    $this$doCompile_u24lambda_u2d12$iv$iv = var23_40 = this_$iv$iv;
                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                    $i$f$withValidClientOrSessionProxy = false;
                    if (sessionId == CompileService.Companion.getNO_SESSION()) {
                        v13 = null;
                    } else {
                        $this$doCompile_u24lambda_u2d12$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                        if ($this$doCompile_u24lambda_u2d12$iv$iv == null) {
                            v1 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                            break;
                        }
                        v13 = $this$doCompile_u24lambda_u2d12$iv$iv;
                    }
                    session$iv$iv$iv = v13;
                    try {
                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                        it$iv$iv = session$iv$iv$iv;
                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                        var32_77 = tracer$iv$iv;
                        rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                        eventManager$iv$iv = new EventManagerImpl();
                        try {
                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                            $i$f$checkedCompile = false;
                            try {
                                eventManager$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                obj$iv$iv$iv$iv = null;
                                $i$f$withMeasure = false;
                                startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                obj$iv$iv$iv$iv = rpcProfiler$iv$iv;
                                $noName_0$iv = eventManager$iv$iv;
                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2$iv = false;
                                exitCode$iv = compiler$iv.exec(messageCollector$iv, Services.EMPTY, (CommonToolArguments)k2PlatformArgs$iv);
                                perfString$iv = compiler$iv.getDefaultPerformanceManager().renderCompilerPerformance();
                                eventManger$iv = compilationResults;
                                if (eventManger$iv == null) {
                                    v14 = null;
                                } else {
                                    it$iv = $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = eventManger$iv;
                                    $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1$iv = false;
                                    res$iv$iv$iv = new String[]{perfString$iv};
                                    it$iv.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf(res$iv$iv$iv));
                                    v14 = $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv;
                                }
                                res$iv$iv$iv$iv = exitCode$iv.getCode();
                                $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                res$iv$iv$iv = res$iv$iv$iv$iv;
                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                    withGC$iv$iv$iv$iv = false;
                                    $i$f$usedMemory = false;
                                    rt$iv$iv$iv$iv = Runtime.getRuntime();
                                    v15 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                } else {
                                    v15 = 0L;
                                }
                                endMem$iv$iv$iv = v15;
                                CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(Intrinsics.stringPlus("Done with result ", res$iv$iv$iv));
                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                    pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                    rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                    v16 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                    counters$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                    var58_197 = String.format("%+d", Arrays.copyOf(counters$iv$iv$iv, counters$iv$iv$iv.length));
                                    Intrinsics.checkNotNullExpressionValue(var58_197, "format(this, *args)");
                                    rt$iv$iv$iv$iv = v16.append(var58_197).append(" kb)").toString();
                                    it$iv$iv$iv = rt$iv$iv$iv$iv;
                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                    daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                    CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                    for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                        obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                        counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                        it$iv$iv$iv = $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                        daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                        CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(it$iv$iv$iv);
                                    }
                                }
                                v17 = res$iv$iv$iv;
                            }
                            catch (Throwable e$iv$iv$iv) {
                                v18 = CompileServiceImplBase.access$getLog(this_$iv$iv$iv);
                                v19 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                res$iv$iv$iv = e$iv$iv$iv.getStackTrace();
                                Intrinsics.checkNotNullExpressionValue(res$iv$iv$iv, "e.stackTrace");
                                v20 = v19.append(ArraysKt.joinToString$default(res$iv$iv$iv, (CharSequence)"\n  ", null, null, 0, null, null, 62, null));
                                if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual(e$iv$iv$iv.getCause(), e$iv$iv$iv)) {
                                    v21 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                    v22 = e$iv$iv$iv.getCause();
                                    Intrinsics.checkNotNull(v22);
                                    res$iv$iv$iv = v22.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue(res$iv$iv$iv, "e.cause!!.stackTrace");
                                    v23 = v21.append(ArraysKt.joinToString$default(res$iv$iv$iv, (CharSequence)"\n  ", null, null, 0, null, null, 62, null)).toString();
                                } else {
                                    v23 = "";
                                }
                                v18.log(Level.SEVERE, v20.append(v23).toString());
                                throw e$iv$iv$iv;
                            }
                            exitCode$iv$iv = ((Number)v17).intValue();
                            exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                        }
                        finally {
                            eventManager$iv$iv.fireCompilationFinished();
                            this_$iv$iv$iv = tracer$iv$iv;
                        }
                        $this$doCompile_u24lambda_u2d12$iv$iv = exitCode$iv$iv;
                        v1 = $this$doCompile_u24lambda_u2d12$iv$iv;
                        break;
                    }
                    finally {
                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                    }
                }
                case 3: {
                    gradleIncrementalArgs$iv = (IncrementalCompilationOptions)compilationOptions;
                    gradleIncrementalServicesFacade$iv = servicesFacade;
                    var22_38 = targetPlatform$iv;
                    var23_41 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[var22_38.ordinal()];
                    switch (var23_41) {
                        case 1: {
                            enabled$iv$iv = true;
                            $i$f$withIC = false;
                            isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                            IncrementalCompilation.setIsEnabledForJvm(enabled$iv$iv);
                            try {
                                $i$a$-withIC$default-CompileServiceImplBase$compileImpl$1$3$iv = false;
                                $this$doCompile_u24lambda_u2d12$iv$iv = this_$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u2d12$iv$iv = $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = this_$iv$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl329
                                v24 = null;
                                ** GOTO lbl334
lbl329:
                                // 1 sources

                                e$iv$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                if (e$iv$iv$iv != null) ** GOTO lbl333
                                v25 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                                ** GOTO lbl444
lbl333:
                                // 1 sources

                                v24 = e$iv$iv$iv;
lbl334:
                                // 2 sources

                                session$iv$iv$iv = v24;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    rpc$iv$iv$iv = tracer$iv$iv;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            exitCode$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1$iv = rpcProfiler$iv$iv;
                                            $noName_0$iv = eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1$iv = false;
                                            v26 = (K2JVMCompilerArguments)k2PlatformArgs$iv;
                                            v27 = compilationResults;
                                            Intrinsics.checkNotNull(v27);
                                            p2 = gradleIncrementalArgs$iv;
                                            p1 = v27;
                                            p0 /* !! */  = gradleIncrementalServicesFacade$iv;
                                            var76_239 = messageCollector$iv;
                                            var75_241 = gradleIncrementalArgs$iv;
                                            var74_243 = v26;
                                            var73_245 = this_$iv;
                                            $i$a$-compileImpl-CompileServiceImpl$compile$5 = false;
                                            v28 = b;
                                            Intrinsics.checkNotNull(v28);
                                            var77_247 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v28, (IncrementalCompilationOptions)c);
                                            res$iv$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler(var73_245, var74_243, var75_241, var76_239, var77_247).getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v29 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v29 = 0L;
                                            }
                                            endMem$iv$iv$iv = v29;
                                            CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(Intrinsics.stringPlus("Done with result ", res$iv$iv$iv));
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v30 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                obj$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                counters$iv$iv$iv = String.format("%+d", Arrays.copyOf(obj$iv$iv$iv, obj$iv$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue(counters$iv$iv$iv, "format(this, *args)");
                                                rt$iv$iv$iv$iv = v30.append(counters$iv$iv$iv).append(" kb)").toString();
                                                it$iv$iv$iv = rt$iv$iv$iv$iv;
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                    counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                    it$iv$iv$iv = it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(it$iv$iv$iv);
                                                }
                                            }
                                            v31 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v32 = CompileServiceImplBase.access$getLog(this_$iv$iv$iv);
                                            v33 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            var55_189 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue(var55_189, "e.stackTrace");
                                            v34 = v33.append(ArraysKt.joinToString$default(var55_189, (CharSequence)"\n  ", null, null, 0, null, null, 62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual(e$iv$iv$iv.getCause(), e$iv$iv$iv)) {
                                                v35 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                v36 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull(v36);
                                                var55_189 = v36.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue(var55_189, "e.cause!!.stackTrace");
                                                v37 = v35.append(ArraysKt.joinToString$default(var55_189, (CharSequence)"\n  ", null, null, 0, null, null, 62, null)).toString();
                                            } else {
                                                v37 = "";
                                            }
                                            v32.log(Level.SEVERE, v34.append(v37).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v31).intValue();
                                        var9_13 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                        this_$iv$iv$iv = tracer$iv$iv;
                                    }
                                    e$iv$iv$iv = var9_13;
                                    v25 = e$iv$iv$iv;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
lbl444:
                                // 2 sources

                                var11_19 = v25;
                                v1 = var11_19;
                                break block20;
                            }
                            finally {
                                IncrementalCompilation.setIsEnabledForJvm(isEnabledBackup$iv$iv);
                            }
                        }
                        case 2: {
                            $i$f$withJsIC = false;
                            isJsEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJs();
                            IncrementalCompilation.setIsEnabledForJs(true);
                            try {
                                $i$a$-withJsIC-CompileServiceImplBase$compileImpl$1$4$iv = false;
                                $i$a$-withIC$default-CompileServiceImplBase$compileImpl$1$3$iv = this_$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u2d12$iv$iv = var30_70 = this_$iv$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl468
                                v38 = null;
                                ** GOTO lbl473
lbl468:
                                // 1 sources

                                var35_93 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                if (var35_93 != null) ** GOTO lbl472
                                v39 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                                ** GOTO lbl583
lbl472:
                                // 1 sources

                                v38 = var35_93;
lbl473:
                                // 2 sources

                                session$iv$iv$iv = v38;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = tracer$iv$iv;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            e$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = rpcProfiler$iv$iv;
                                            $noName_0$iv = eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1$iv = false;
                                            v40 = (K2JSCompilerArguments)k2PlatformArgs$iv;
                                            v41 = compilationResults;
                                            Intrinsics.checkNotNull(v41);
                                            var70_250 = gradleIncrementalArgs$iv;
                                            var71_251 = v41;
                                            $i$a$-compileImpl-CompileServiceImpl$compile$5 = gradleIncrementalServicesFacade$iv;
                                            var76_240 = messageCollector$iv;
                                            var75_242 = gradleIncrementalArgs$iv;
                                            var74_244 = v40;
                                            var73_246 = this_$iv;
                                            $i$a$-compileImpl-CompileServiceImpl$compile$5 = false;
                                            v42 = b;
                                            Intrinsics.checkNotNull(v42);
                                            var77_248 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v42, (IncrementalCompilationOptions)c);
                                            res$iv$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler(var73_246, var74_244, var75_242, var76_240, var77_248).getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v43 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v43 = 0L;
                                            }
                                            endMem$iv$iv$iv = v43;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(Intrinsics.stringPlus("Done with result ", res$iv$iv$iv));
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v44 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                it$iv$iv$iv /* !! */  = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                it$iv$iv$iv = String.format("%+d", Arrays.copyOf(it$iv$iv$iv /* !! */ , it$iv$iv$iv /* !! */ .length));
                                                Intrinsics.checkNotNullExpressionValue(it$iv$iv$iv, "format(this, *args)");
                                                var63_226 = v44.append(it$iv$iv$iv).append(" kb)").toString();
                                                it$iv$iv$iv /* !! */  = var63_226;
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv /* !! */ );
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv /* !! */ );
                                                for (Map.Entry var57_195 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv$iv = var57_195.getKey();
                                                    counters$iv$iv$iv = (PerfCounters)var57_195.getValue();
                                                    it$iv$iv$iv = var60_213 = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                }
                                            }
                                            v45 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v46 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v47 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            var64_231 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue(var64_231, "e.stackTrace");
                                            v48 = v47.append(ArraysKt.joinToString$default(var64_231, (CharSequence)"\n  ", null, null, 0, null, null, 62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual(e$iv$iv$iv.getCause(), e$iv$iv$iv)) {
                                                v49 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                v50 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull(v50);
                                                var64_231 = v50.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue(var64_231, "e.cause!!.stackTrace");
                                                v51 = v49.append(ArraysKt.joinToString$default(var64_231, (CharSequence)"\n  ", null, null, 0, null, null, 62, null)).toString();
                                            } else {
                                                v51 = "";
                                            }
                                            v46.log(Level.SEVERE, v48.append(v51).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v45).intValue();
                                        var67_238 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                        var41_126 = tracer$iv$iv;
                                    }
                                    var35_93 = var67_238;
                                    v39 = var35_93;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
lbl583:
                                // 2 sources

                                var9_9 /* !! */  = v39;
                                v1 = var9_9 /* !! */ ;
                                break block20;
                            }
                            finally {
                                IncrementalCompilation.setIsEnabledForJs(isJsEnabledBackup$iv$iv);
                            }
                        }
                    }
                    throw new IllegalStateException(Intrinsics.stringPlus("Incremental compilation is not supported for target platform: ", targetPlatform$iv));
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus("Unknown compilation mode ", compilationOptions.getCompilerMode()));
                }
            }
        }
        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName, @Nullable Object[] scriptArgs, @Nullable Class<? extends Object>[] scriptArgsTypes, @NotNull RemoteOutputStream compilerMessagesOutputStream, @Nullable RemoteOutputStream evalOutputStream, @Nullable RemoteOutputStream evalErrorStream, @Nullable RemoteInputStream evalInputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter(targetPlatform, "targetPlatform");
        Intrinsics.checkNotNullParameter(servicesFacade, "servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, "templateClasspath");
        Intrinsics.checkNotNullParameter(templateClassName, "templateClassName");
        Intrinsics.checkNotNullParameter(compilerMessagesOutputStream, "compilerMessagesOutputStream");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl2 = false;
                    if (targetPlatform != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable()");
                        Disposable disposable2 = disposable;
                        PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(compilerMessagesOutputStream, new DummyProfiler()), 4096));
                        KeepFirstErrorMessageCollector messageCollector = new KeepFirstErrorMessageCollector(compilerMessagesStream);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, operationsTracer);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseReplSession(int sessionId) {
        return this.releaseCompileSession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> remoteReplLineCheck(int sessionId, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter(codeLine, "codeLine");
        var3_3 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var6_6 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var7_7 = var6_6.readLock();
        var7_7.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$remoteReplLineCheck$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl38
                    }
                    var19_22 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var19_22 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                    } else {
                        v1 = var19_22;
lbl38:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var23_27 = session$iv$iv;
                            v3 = var24_28 = var23_27 == null ? null : var23_27.getData();
                            if (var24_28 == null) {
                                // empty if block
                            }
                            if ((var25_29 = var24_28) == null) {
                                v4 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Not a REPL session ", sessionId));
                            } else {
                                $this$remoteReplLineCheck_u24lambda_u2d22_u24lambda_u2d21 = (KotlinJvmReplService)var25_29;
                                $i$a$-withValidRepl-CompileServiceImpl$remoteReplLineCheck$1$1 = false;
                                v4 = new CompileService.CallResult.Good<ReplCheckResult>($this$remoteReplLineCheck_u24lambda_u2d22_u24lambda_u2d21.check(codeLine));
                            }
                            var19_22 = v4;
                            v2 = var19_22;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var28_32 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var12_15 = e$iv$iv.getMessage();
                    var28_32 = new CompileService.CallResult.Error(var12_15 == null ? "unknown" : var12_15);
                }
                v0 = var28_32;
            }
            var8_9 = v0;
        }
        finally {
            var7_7.unlock();
        }
        return var8_9;
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        Services.Builder builder2 = new Services.Builder();
        if (facade.hasIncrementalCaches()) {
            builder2.register(IncrementalCompilationComponents.class, new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasLookupTracker()) {
            builder2.register(LookupTracker.class, new RemoteLookupTrackerClient(facade, eventManager, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder2.register(CompilationCanceledStatus.class, new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        if (facade.hasExpectActualTracker()) {
            builder2.register(ExpectActualTracker.class, new RemoteExpectActualTracker(facade, rpcProfiler));
        }
        if (facade.hasIncrementalResultsConsumer()) {
            builder2.register(IncrementalResultsConsumer.class, new RemoteIncrementalResultsConsumer(facade, eventManager, rpcProfiler));
        }
        if (facade.hasIncrementalDataProvider()) {
            builder2.register(IncrementalDataProvider.class, new RemoteIncrementalDataProvider(facade, rpcProfiler));
        }
        return builder2.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> remoteReplLineCompile(int sessionId, @NotNull ReplCodeLine codeLine, @Nullable List<ReplCodeLine> history) {
        Intrinsics.checkNotNullParameter(codeLine, "codeLine");
        var4_4 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var7_7 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var8_8 = var7_7.readLock();
        var8_8.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$remoteReplLineCompile$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl38
                    }
                    var20_22 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var20_22 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                    } else {
                        v1 = var20_22;
lbl38:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var24_27 = session$iv$iv;
                            v3 = var25_28 = var24_27 == null ? null : var24_27.getData();
                            if (var25_28 == null) {
                                // empty if block
                            }
                            if ((var26_29 = var25_28) == null) {
                                v4 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Not a REPL session ", sessionId));
                            } else {
                                $this$remoteReplLineCompile_u24lambda_u2d24_u24lambda_u2d23 = (KotlinJvmReplService)var26_29;
                                $i$a$-withValidRepl-CompileServiceImpl$remoteReplLineCompile$1$1 = false;
                                v4 = new CompileService.CallResult.Good<ReplCompileResult>($this$remoteReplLineCompile_u24lambda_u2d24_u24lambda_u2d23.compile(codeLine, history));
                            }
                            var20_22 = v4;
                            v2 = var20_22;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var29_32 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var31_34 = e$iv$iv.getMessage();
                    var29_32 = new CompileService.CallResult.Error(var31_34 == null ? "unknown" : var31_34);
                }
                v0 = var29_32;
            }
            var9_10 = v0;
        }
        finally {
            var8_8.unlock();
        }
        return var9_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplEvalResult> remoteReplLineEval(int sessionId, @NotNull ReplCodeLine codeLine, @Nullable List<ReplCodeLine> history) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter(codeLine, "codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Error("Eval on daemon is not supported");
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter(compilerArguments, "compilerArguments");
        Intrinsics.checkNotNullParameter(compilationOptions, "compilationOptions");
        Intrinsics.checkNotNullParameter(servicesFacade, "servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, "templateClasspath");
        Intrinsics.checkNotNullParameter(templateClassName, "templateClassName");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl2 = false;
                    if (compilationOptions.getTargetPlatform() != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable()");
                        Disposable disposable2 = disposable;
                        CompileServicesFacadeMessageCollector messageCollector = new CompileServicesFacadeMessageCollector(servicesFacade, compilationOptions);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, null);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplStateFacade> replCreateState(int sessionId) {
        var2_2 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var6_6 = var5_5.readLock();
        var6_6.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCreateState$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl37
                    }
                    var18_22 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var18_22 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                    } else {
                        v1 = var18_22;
lbl37:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var22_27 = session$iv$iv;
                            v3 = var23_28 = var22_27 == null ? null : var22_27.getData();
                            if (var23_28 == null) {
                                // empty if block
                            }
                            if ((var24_29 = var23_28) == null) {
                                v4 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Not a REPL session ", sessionId));
                            } else {
                                $this$replCreateState_u24lambda_u2d28_u24lambda_u2d27 = (KotlinJvmReplService)var24_29;
                                $i$a$-withValidRepl-CompileServiceImpl$replCreateState$1$1 = false;
                                v4 = new CompileService.CallResult.Good<RemoteReplStateFacadeServer>($this$replCreateState_u24lambda_u2d28_u24lambda_u2d27.createRemoteState(this.getPort()));
                            }
                            var18_22 = v4;
                            v2 = var18_22;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var27_32 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var12_16 = e$iv$iv.getMessage();
                    var27_32 = new CompileService.CallResult.Error(var12_16 == null ? "unknown" : var12_16);
                }
                v0 = var27_32;
            }
            var7_8 = v0;
        }
        finally {
            var6_6.unlock();
        }
        return var7_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> replCheck(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter(codeLine, "codeLine");
        var4_4 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var7_7 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var8_8 = var7_7.readLock();
        var8_8.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCheck$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl38
                    }
                    var20_22 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var20_22 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                    } else {
                        v1 = var20_22;
lbl38:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var24_27 = session$iv$iv;
                            v3 = var25_28 = var24_27 == null ? null : var24_27.getData();
                            if (var25_28 == null) {
                                // empty if block
                            }
                            if ((var26_29 = var25_28) == null) {
                                v4 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Not a REPL session ", sessionId));
                            } else {
                                $this$replCheck_u24lambda_u2d30_u24lambda_u2d29 = (KotlinJvmReplService)var26_29;
                                $i$a$-withValidRepl-CompileServiceImpl$replCheck$1$1 = false;
                                v4 = $this$replCheck_u24lambda_u2d30_u24lambda_u2d29.withValidReplState(replStateId, (Function1)new Function1<IReplStageState<?>, ReplCheckResult>($this$replCheck_u24lambda_u2d30_u24lambda_u2d29, codeLine){
                                    final /* synthetic */ KotlinJvmReplService $this_withValidRepl;
                                    final /* synthetic */ ReplCodeLine $codeLine;
                                    {
                                        this.$this_withValidRepl = $receiver;
                                        this.$codeLine = $codeLine;
                                        super(1);
                                    }

                                    @NotNull
                                    public final ReplCheckResult invoke(@NotNull IReplStageState<?> state) {
                                        Intrinsics.checkNotNullParameter(state, "state");
                                        return this.$this_withValidRepl.check(state, this.$codeLine);
                                    }
                                });
                            }
                            var20_22 = v4;
                            v2 = var20_22;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var29_32 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var31_34 = e$iv$iv.getMessage();
                    var29_32 = new CompileService.CallResult.Error(var31_34 == null ? "unknown" : var31_34);
                }
                v0 = var29_32;
            }
            var9_10 = v0;
        }
        finally {
            var8_8.unlock();
        }
        return var9_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> replCompile(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter(codeLine, "codeLine");
        var4_4 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var7_7 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var8_8 = var7_7.readLock();
        var8_8.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCompile$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl38
                    }
                    var20_22 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var20_22 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                    } else {
                        v1 = var20_22;
lbl38:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var24_27 = session$iv$iv;
                            v3 = var25_28 = var24_27 == null ? null : var24_27.getData();
                            if (var25_28 == null) {
                                // empty if block
                            }
                            if ((var26_29 = var25_28) == null) {
                                v4 = new CompileService.CallResult.Error(Intrinsics.stringPlus("Not a REPL session ", sessionId));
                            } else {
                                $this$replCompile_u24lambda_u2d32_u24lambda_u2d31 = (KotlinJvmReplService)var26_29;
                                $i$a$-withValidRepl-CompileServiceImpl$replCompile$1$1 = false;
                                v4 = $this$replCompile_u24lambda_u2d32_u24lambda_u2d31.withValidReplState(replStateId, (Function1)new Function1<IReplStageState<?>, ReplCompileResult>($this$replCompile_u24lambda_u2d32_u24lambda_u2d31, codeLine){
                                    final /* synthetic */ KotlinJvmReplService $this_withValidRepl;
                                    final /* synthetic */ ReplCodeLine $codeLine;
                                    {
                                        this.$this_withValidRepl = $receiver;
                                        this.$codeLine = $codeLine;
                                        super(1);
                                    }

                                    @NotNull
                                    public final ReplCompileResult invoke(@NotNull IReplStageState<?> state) {
                                        Intrinsics.checkNotNullParameter(state, "state");
                                        return this.$this_withValidRepl.compile(state, this.$codeLine);
                                    }
                                });
                            }
                            var20_22 = v4;
                            v2 = var20_22;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var29_32 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var31_34 = e$iv$iv.getMessage();
                    var29_32 = new CompileService.CallResult.Error(var31_34 == null ? "unknown" : var31_34);
                }
                v0 = var29_32;
            }
            var9_10 = v0;
        }
        finally {
            var8_8.unlock();
        }
        return var9_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void periodicAndAfterSessionCheck() {
        block24: {
            block23: {
                block22: {
                    block27: {
                        if (this.getState().getDelayedShutdownQueued().get()) {
                            return;
                        }
                        anyDead = this.getState().getSessions().cleanDead() != false || this.getState().cleanDeadClients() != false;
                        var2_2 = this;
                        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                        $i$f$ifAliveUnit = false;
                        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv);
                        var6_6 = var5_5.readLock();
                        var6_6.lock();
                        $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                        this_$iv$iv = this_$iv;
                        $i$f$ifAliveChecksImpl = false;
                        curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv >= minAliveness$iv.ordinal()) break block27;
                        CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                        (CompileService.CallResult)new CompileService.CallResult.Dying();
                        ** GOTO lbl62
                    }
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = false;
                    if (this.getState().getAlive().get() != CompileServiceImplBase.Aliveness.LastSession.ordinal() || !this.getState().getSessions().isEmpty()) break block22;
                    this.getLog().info("All sessions finished");
                    this.shutdownWithDelay();
                    var6_6.unlock();
                    return;
                }
                if (this.getState().getAliveClientsCount() != 0) break block23;
                this.getLog().info("No more clients left");
                this.shutdownWithDelay();
                var6_6.unlock();
                return;
            }
            if (this.getRunFile().exists()) break block24;
            this.getLog().info("Run file removed");
            this.shutdownWithDelay();
            var6_6.unlock();
            return;
        }
        try {
            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Ok();
            {
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = e$iv$iv.getMessage();
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Error($i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 == null ? "unknown" : $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1);
                }
            }
lbl62:
            // 3 sources

            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = Unit.INSTANCE;
        }
        catch (Throwable $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv) {
            throw $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv;
        }
        finally {
            var6_6.unlock();
        }
        this_$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAliveUnit = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv);
        var6_6 = var5_5.readLock();
        var6_6.lock();
        try {
            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
            this_$iv$iv = this_$iv;
            $i$f$ifAliveChecksImpl = false;
            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                (CompileService.CallResult)new CompileService.CallResult.Dying();
            } else {
                try {
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$2 = false;
                    if (this.getDaemonOptions().getAutoshutdownUnusedSeconds() != 0 && this.getCompilationsCounter().get() == 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownUnusedSeconds()) {
                        this.getLog().info("Unused timeout exceeded " + this.getDaemonOptions().getAutoshutdownUnusedSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (this.getDaemonOptions().getAutoshutdownIdleSeconds() != 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownIdleSeconds()) {
                        this.getLog().info("Idle timeout exceeded " + this.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (anyDead) {
                        this.clearJarCache();
                    }
                    var11_19 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var14_25 = e$iv$iv.getMessage();
                    var11_17 = new CompileService.CallResult.Error(var14_25 == null ? "unknown" : var14_25);
                }
            }
            var7_11 = Unit.INSTANCE;
        }
        finally {
            var6_6.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void periodicSeldomCheck() {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (this.getClasspathWatcher().isChanged()) {
                        this.getLog().info("Compiler changed.");
                        this.gracefulShutdown(false);
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initiateElections() {
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    this.getLog().info("initiate elections");
                    List<DaemonWithMetadata> aliveWithOpts2 = SequencesKt.toList(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.getDaemonOptions())), this.getCompilerId(), this.getRunFile(), (Function2<? super File, ? super Integer, Boolean>)new Function2<File, Integer, Boolean>(this){
                        final /* synthetic */ CompileServiceImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull File $noName_0, int p) {
                            Intrinsics.checkNotNullParameter($noName_0, "$noName_0");
                            return p != this.this$0.getPort();
                        }
                    }, (Function2<? super DaemonReportCategory, ? super String, Unit>)new Function2<DaemonReportCategory, String, Unit>(this){
                        final /* synthetic */ CompileServiceImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2);
                        }

                        public final void invoke(@NotNull DaemonReportCategory $noName_0, @NotNull String msg) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$noName_0), "$noName_0");
                            Intrinsics.checkNotNullParameter(msg, "msg");
                            this.this$0.getLog().info(msg);
                        }
                    }));
                    Object object = new DaemonJVMOptionsMemoryComparator();
                    object = new Comparator((Comparator)object){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = $comparator;
                        }

                        public final int compare(T a, T b) {
                            DaemonWithMetadata it;
                            Comparator comparator = this.$comparator;
                            DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                            Comparator comparator2 = comparator;
                            boolean bl = false;
                            DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                            it = (DaemonWithMetadata)a;
                            bl = false;
                            DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                            return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
                        }
                    };
                    Object object2 = new FileAgeComparator();
                    Comparator comparator = new Comparator((Comparator)object, (Comparator)object2){
                        final /* synthetic */ Comparator $this_thenBy;
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$this_thenBy = $receiver;
                            this.$comparator = $comparator;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenBy.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                DaemonWithMetadata it;
                                Comparator comparator = this.$comparator;
                                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                                Comparator comparator2 = comparator;
                                boolean bl = false;
                                File file2 = it.getRunFile();
                                it = (DaemonWithMetadata)b;
                                bl = false;
                                File file3 = it.getRunFile();
                                n = comparator2.compare(file2, file3);
                            }
                            return n;
                        }
                    };
                    object = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithOpts2, comparator);
                    if (object != null) {
                        Object bestDaemonWithMetadata = object2 = object;
                        boolean bl4 = false;
                        DaemonJVMOptions fattestOpts = ((DaemonWithMetadata)bestDaemonWithMetadata).getJvmOptions();
                        if (DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.getDaemonJVMOptions()) && new FileAgeComparator().compare(((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile(), this.getRunFile()) < 0) {
                            this.getLog().info("Assuming other daemons have lower prio, taking clients from them and schedule them to shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().getName() + " (" + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().lastModified() + ')');
                            Iterable $this$forEach$iv = aliveWithOpts2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                DaemonWithMetadata $dstr$daemon$runFile$_u24__u24 = (DaemonWithMetadata)element$iv;
                                boolean bl5 = false;
                                CompileService daemon = $dstr$daemon$runFile$_u24__u24.component1();
                                File runFile = $dstr$daemon$runFile$_u24__u24.component2();
                                try {
                                    CompileService.CallResult<List<String>> callResult;
                                    CompileService.CallResult<List<String>> callResult2;
                                    CompileService.CallResult<List<String>> it = callResult2 = daemon.getClients();
                                    boolean bl6 = false;
                                    CompileService.CallResult<List<String>> callResult3 = callResult = it.isGood() ? callResult2 : null;
                                    if (callResult != null) {
                                        it = callResult2 = callResult;
                                        boolean bl7 = false;
                                        Iterable $this$forEach$iv2 = it.get();
                                        boolean $i$f$forEach2 = false;
                                        for (Object element$iv2 : $this$forEach$iv2) {
                                            String clientAliveFile = (String)element$iv2;
                                            boolean bl8 = false;
                                            this.registerClient(clientAliveFile);
                                        }
                                    }
                                    daemon.scheduleShutdown(true);
                                }
                                catch (Throwable e) {
                                    this.getLog().info("Cannot connect to a daemon, assuming dying ('" + runFile.getCanonicalPath() + "'): " + e.getMessage());
                                }
                            }
                        } else if (DaemonParamsKt.memorywiseFitsInto(this.getDaemonJVMOptions(), fattestOpts) && new FileAgeComparator().compare(((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile(), this.getRunFile()) > 0) {
                            CompileService.CallResult<List<String>> callResult;
                            CompileService.CallResult<List<String>> callResult4;
                            this.getLog().info("Assuming other daemons have higher prio, handover clients to it and schedule shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().getName() + " (" + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().lastModified() + ')');
                            CompileService.CallResult<List<String>> it = callResult4 = this.getClients();
                            boolean bl9 = false;
                            CompileService.CallResult<List<String>> callResult5 = callResult = it.isGood() ? callResult4 : null;
                            if (callResult != null) {
                                it = callResult4 = callResult;
                                boolean bl10 = false;
                                Iterable $this$forEach$iv = it.get();
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    String it2 = (String)element$iv;
                                    boolean bl11 = false;
                                    ((DaemonWithMetadata)bestDaemonWithMetadata).getDaemon().registerClient(it2);
                                }
                            }
                            this.scheduleShutdown(true);
                        } else {
                            this.getLog().info("Assuming other daemons have equal prio, continue: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().getName() + " (" + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().lastModified() + ')');
                        }
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string2 = e$iv$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private final void shutdownNow() {
        Handler[] handlerArray;
        this.getLog().info("Shutdown started");
        Handler[] $this$shutdownNow_u24lambda_u2d47 = handlerArray = Runtime.getRuntime();
        boolean bl = false;
        this.getLog().info("Memory stats: total: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2d47.totalMemory()) + "mb, free: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2d47.freeMemory()) + "mb, max: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2d47.maxMemory()) + "mb");
        this.getState().getAlive().set(CompileServiceImplBase.Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.onShutdown.invoke();
        handlerArray = this.getLog().getHandlers();
        Intrinsics.checkNotNullExpressionValue(handlerArray, "log.handlers");
        Object[] $this$forEach$iv = handlerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler it = (Handler)element$iv;
            boolean bl2 = false;
            it.flush();
        }
    }

    private final void shutdownWithDelay() {
        this.getState().getDelayedShutdownQueued().set(true);
        int currentClientsCount = this.getState().getClientsCounter();
        int currentSessionId = this.getState().getSessions().getLastSessionId();
        int currentCompilationsCount = this.getCompilationsCounter().get();
        this.getLog().info("Delayed shutdown in " + this.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
        Timer timer = this.getTimer();
        long l = this.getDaemonOptions().getShutdownDelayMilliseconds();
        TimerTask timerTask2 = new TimerTask(this, currentClientsCount, currentCompilationsCount, currentSessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentClientsCount$inlined;
            final /* synthetic */ int $currentCompilationsCount$inlined;
            final /* synthetic */ int $currentSessionId$inlined;
            {
                this.this$0 = compileServiceImpl;
                this.$currentClientsCount$inlined = n;
                this.$currentCompilationsCount$inlined = n2;
                this.$currentSessionId$inlined = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                TimerTask $this$shutdownWithDelay_u24lambda_u2d50 = this;
                boolean bl = false;
                this.this$0.getState().getDelayedShutdownQueued().set(false);
                if (this.$currentClientsCount$inlined == this.this$0.getState().getClientsCounter() && this.$currentCompilationsCount$inlined == this.this$0.getCompilationsCounter().get() && this.$currentSessionId$inlined == this.this$0.getState().getSessions().getLastSessionId()) {
                    int n;
                    int n2;
                    void this_$iv;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5;
                        n2 = n5 = n4++;
                        n = 0;
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl3 = false;
                                boolean bl4 = false;
                                this.this$0.getLog().fine("Execute delayed shutdown");
                                CompileServiceImpl.access$shutdownNow(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                String string2 = e$iv$iv.getMessage();
                                callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                            }
                        }
                        Unit unit2 = Unit.INSTANCE;
                    }
                    finally {
                        n2 = 0;
                        while (n2 < n3) {
                            int n6 = n = n2++;
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
                this.this$0.getLog().info("Cancel delayed shutdown due to a new activity");
            }
        };
        timer.schedule(timerTask2, l);
    }

    private final boolean gracefulShutdown(boolean onAnotherThread) {
        if (!this.getState().getAlive().compareAndSet(CompileServiceImplBase.Aliveness.Alive.ordinal(), CompileServiceImplBase.Aliveness.LastSession.ordinal())) {
            this.getLog().info(Intrinsics.stringPlus("Invalid state for graceful shutdown: ", this.toAlivenessName(this.getState().getAlive().get())));
            return false;
        }
        this.getLog().info("Graceful shutdown signalled");
        if (!onAnotherThread) {
            CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this);
        } else {
            Timer timer = this.getTimer();
            long l = 1L;
            TimerTask timerTask2 = new TimerTask(this){
                final /* synthetic */ CompileServiceImpl this$0;
                {
                    this.this$0 = compileServiceImpl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void run() {
                    int n;
                    int n2;
                    void this_$iv;
                    TimerTask $this$gracefulShutdown_u24lambda_u2d52 = this;
                    boolean bl = false;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5;
                        n2 = n5 = n4++;
                        n = 0;
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl3 = false;
                                boolean bl4 = false;
                                CompileServiceImpl.access$gracefulShutdown$shutdownIfIdle(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                String string2 = e$iv$iv.getMessage();
                                callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                            }
                        }
                        Unit unit2 = Unit.INSTANCE;
                    }
                    finally {
                        n2 = 0;
                        while (n2 < n3) {
                            int n6 = n = n2++;
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
            };
            timer.schedule(timerTask2, l);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult<Integer> doCompile(int sessionId, String[] args2, RemoteOutputStream compilerMessagesStreamProxy, RemoteOutputStream serviceOutputStreamProxy, RemoteOperationsTracer operationsTracer, Function3<? super PrintStream, ? super EventManager, ? super Profiler, ? extends ExitCode> body2) {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block27: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block26: {
                    boolean bl = false;
                    this_$iv$iv = this;
                    boolean $i$f$ifAliveChecksImpl = false;
                    int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block26;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block27;
                }
                try {
                    Object object;
                    block24: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2;
                        CompileServiceImplBase this_$iv;
                        block29: {
                            block30: {
                                block28: {
                                    boolean bl = false;
                                    this_$iv = this;
                                    boolean $i$f$withValidClientOrSessionProxy = false;
                                    if (sessionId != CompileService.Companion.getNO_SESSION()) break block28;
                                    clientOrSessionProxy2 = null;
                                    break block29;
                                }
                                clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv).getSessions().get(sessionId);
                                if (clientOrSessionProxy != null) break block30;
                                object = new CompileService.CallResult.Error(Intrinsics.stringPlus("Unknown or invalid session ", sessionId));
                                break block24;
                            }
                            clientOrSessionProxy2 = clientOrSessionProxy;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = clientOrSessionProxy2;
                        try {
                            Unit unit2;
                            RemoteOperationsTracer remoteOperationsTracer;
                            CompileService.CallResult.Good<Integer> good;
                            block23: {
                                Unit unit3;
                                CompileServiceImplBase.access$getCompilationsCounter(this_$iv).incrementAndGet();
                                CompileServiceImplBase.ClientOrSessionProxy<Object> it = session$iv;
                                boolean bl = false;
                                RemoteOperationsTracer remoteOperationsTracer2 = operationsTracer;
                                if (remoteOperationsTracer2 == null) {
                                    unit3 = null;
                                } else {
                                    remoteOperationsTracer2.before("compile");
                                    unit3 = Unit.INSTANCE;
                                }
                                Profiler rpcProfiler = this.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                EventManagerImpl eventManger = new EventManagerImpl();
                                PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(compilerMessagesStreamProxy, rpcProfiler), 4096));
                                PrintStream serviceOutputStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(serviceOutputStreamProxy, rpcProfiler), 4096));
                                try {
                                    Integer n;
                                    DaemonMessageReporterPrintStreamAdapter compileServiceReporter = new DaemonMessageReporterPrintStreamAdapter(serviceOutputStream);
                                    if (ArraysKt.none(args2)) {
                                        throw new IllegalArgumentException("Error: empty arguments list.");
                                    }
                                    this.getLog().info(Intrinsics.stringPlus("Starting compilation with args: ", ArraysKt.joinToString$default(args2, (CharSequence)" ", null, null, 0, null, null, 62, null)));
                                    CompileServiceImplBase this_$iv2 = this;
                                    boolean $i$f$checkedCompile = false;
                                    try {
                                        long l;
                                        void $this$withMeasure$iv$iv;
                                        Profiler profiler$iv;
                                        Profiler profiler = profiler$iv = this_$iv2.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                        Object obj$iv$iv = null;
                                        boolean $i$f$withMeasure = false;
                                        List<Long> startState$iv$iv = $this$withMeasure$iv$iv.beginMeasure(obj$iv$iv);
                                        boolean bl2 = false;
                                        Integer res$iv$iv = body2.invoke(compilerMessagesStream, eventManger, rpcProfiler).getCode();
                                        $this$withMeasure$iv$iv.endMeasure(obj$iv$iv, startState$iv$iv);
                                        Integer res$iv = res$iv$iv;
                                        if (this_$iv2.getDaemonOptions().getReportPerf()) {
                                            boolean withGC$iv$iv = false;
                                            boolean $i$f$usedMemory = false;
                                            Runtime rt$iv$iv = Runtime.getRuntime();
                                            l = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
                                        } else {
                                            l = 0L;
                                        }
                                        long endMem$iv = l;
                                        CompileServiceImplBase.access$getLog(this_$iv2).info(Intrinsics.stringPlus("Done with result ", res$iv));
                                        if (this_$iv2.getDaemonOptions().getReportPerf()) {
                                            PerfCounters pc$iv = profiler$iv.getTotalCounters();
                                            PerfCounters rpc$iv = rpcProfiler.getTotalCounters();
                                            StringBuilder stringBuilder2 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv2.ms(pc$iv.getTime())).append(" ms; thread: user ").append(this_$iv2.ms(pc$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv2.ms(pc$iv.getThreadTime() - pc$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv.getCount()).append(" calls, ").append(this_$iv2.ms(rpc$iv.getTime())).append(" ms, thread ").append(this_$iv2.ms(rpc$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv2.kb(endMem$iv)).append(" kb (");
                                            Object[] object22 = new Object[]{this_$iv2.kb(pc$iv.getMemory())};
                                            String string2 = String.format("%+d", Arrays.copyOf(object22, object22.length));
                                            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                                            String string3 = stringBuilder2.append(string2).append(" kb)").toString();
                                            String string4 = string3;
                                            boolean bl3 = false;
                                            ((DaemonMessageReporter)compileServiceReporter).report(ReportSeverity.INFO, string4);
                                            CompileServiceImplBase.access$getLog(this_$iv2).info(string4);
                                            for (Map.Entry entry : rpcProfiler.getCounters().entrySet()) {
                                                String string5;
                                                Object obj$iv = entry.getKey();
                                                PerfCounters counters$iv = (PerfCounters)entry.getValue();
                                                String it$iv2 = string5 = "PERF: rpc by " + obj$iv + ": " + counters$iv.getCount() + " calls, " + this_$iv2.ms(counters$iv.getTime()) + " ms, thread " + this_$iv2.ms(counters$iv.getThreadTime()) + " ms";
                                                boolean bl4 = false;
                                                ((DaemonMessageReporter)compileServiceReporter).report(ReportSeverity.INFO, it$iv2);
                                                CompileServiceImplBase.access$getLog(this_$iv2).info(it$iv2);
                                            }
                                        }
                                        n = res$iv;
                                    }
                                    catch (Throwable e$iv) {
                                        String string6;
                                        Logger logger = CompileServiceImplBase.access$getLog(this_$iv2);
                                        StringBuilder stringBuilder3 = new StringBuilder().append("Exception: ").append(e$iv).append("\n  ");
                                        StackTraceElement[] stackTraceElementArray = e$iv.getStackTrace();
                                        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
                                        StringBuilder stringBuilder4 = stringBuilder3.append(ArraysKt.joinToString$default(stackTraceElementArray, (CharSequence)"\n  ", null, null, 0, null, null, 62, null));
                                        if (e$iv.getCause() != null && !Intrinsics.areEqual(e$iv.getCause(), e$iv)) {
                                            StringBuilder stringBuilder5 = new StringBuilder().append("\nCaused by: ").append(e$iv.getCause()).append("\n  ");
                                            Throwable throwable = e$iv.getCause();
                                            Intrinsics.checkNotNull(throwable);
                                            stackTraceElementArray = throwable.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.cause!!.stackTrace");
                                            string6 = stringBuilder5.append(ArraysKt.joinToString$default(stackTraceElementArray, (CharSequence)"\n  ", null, null, 0, null, null, 62, null)).toString();
                                        } else {
                                            string6 = "";
                                        }
                                        logger.log(Level.SEVERE, stringBuilder4.append(string6).toString());
                                        throw e$iv;
                                    }
                                    int exitCode = ((Number)n).intValue();
                                    good = new CompileService.CallResult.Good<Integer>(exitCode);
                                    serviceOutputStream.flush();
                                    compilerMessagesStream.flush();
                                    eventManger.fireCompilationFinished();
                                    remoteOperationsTracer = operationsTracer;
                                    if (remoteOperationsTracer != null) break block23;
                                    unit2 = null;
                                }
                                catch (Throwable throwable) {
                                    Unit unit4;
                                    serviceOutputStream.flush();
                                    compilerMessagesStream.flush();
                                    eventManger.fireCompilationFinished();
                                    RemoteOperationsTracer remoteOperationsTracer3 = operationsTracer;
                                    if (remoteOperationsTracer3 == null) {
                                        unit4 = null;
                                    } else {
                                        remoteOperationsTracer3.after("compile");
                                        unit4 = Unit.INSTANCE;
                                    }
                                    throw throwable;
                                }
                            }
                            remoteOperationsTracer.after("compile");
                            unit2 = Unit.INSTANCE;
                            clientOrSessionProxy = good;
                            object = clientOrSessionProxy;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = object;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string7 = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string7 == null ? "unknown" : string7);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    @Override
    public void clearJarCache() {
        CoreJarFileSystem coreJarFileSystem;
        ZipHandler.clearFileAccessorCache();
        KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
        VirtualFileSystem virtualFileSystem = kotlinCoreApplicationEnvironment == null ? null : kotlinCoreApplicationEnvironment.getJarFileSystem();
        CoreJarFileSystem coreJarFileSystem2 = coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
        if (coreJarFileSystem != null) {
            coreJarFileSystem.clearHandlersCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAlive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body2) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = body2.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart(1);
            readLock.unlock();
            InlineMarker.finallyEnd(1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body2, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAlive = false;
        object = this_.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body2.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart(1);
            readLock.unlock();
            InlineMarker.finallyEnd(1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body2) {
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    body2.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart(1);
            readLock.unlock();
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveUnit$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body2, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveUnit = false;
        object = this_.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    body2.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart(1);
            readLock.unlock();
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body2) {
        CompileService.CallResult callResult;
        int n;
        int n2;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            n2 = n5 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = body2.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart(1);
            n2 = 0;
            while (n2 < n3) {
                int n6 = n = n2++;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd(1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAliveExclusive$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body2, int n, Object object) {
        CompileService.CallResult callResult;
        int n2;
        int n3;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusive = false;
        object = this_.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n4 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        int n5 = 0;
        while (n5 < n4) {
            int n6;
            n3 = n6 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body2.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart(1);
            n3 = 0;
            while (n3 < n4) {
                int n7 = n2 = n3++;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd(1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveExclusiveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body2) {
        int n;
        int n2;
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            n2 = n5 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl2 = false;
                    body2.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart(1);
            n2 = 0;
            while (n2 < n3) {
                int n6 = n = n2++;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveExclusiveUnit$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body2, int n, Object object) {
        int n2;
        int n3;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusiveUnit = false;
        object = this_.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n4 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        int n5 = 0;
        while (n5 < n4) {
            int n6;
            n3 = n6 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl2 = false;
                    body2.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string2 = e$iv.getMessage();
                    callResult = new CompileService.CallResult.Error(string2 == null ? "unknown" : string2);
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart(1);
            n3 = 0;
            while (n3 < n4) {
                int n7 = n2 = n3++;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd(1);
        }
    }

    private static final long shutdownNow$mb(long $this$shutdownNow_u24mb) {
        return $this$shutdownNow_u24mb / (long)0x100000;
    }

    private static final void gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        if (this$0.getState().getSessions().isEmpty()) {
            this$0.shutdownWithDelay();
        } else {
            this$0.getDaemonOptions().setAutoshutdownIdleSeconds((int)TimeUnit.MILLISECONDS.toSeconds(this$0.getDaemonOptions().getForceShutdownTimeoutMilliseconds()));
            this$0.getDaemonOptions().setAutoshutdownUnusedSeconds(this$0.getDaemonOptions().getAutoshutdownIdleSeconds());
            this$0.getLog().info("Some sessions are active, waiting for them to finish");
            this$0.getLog().info("Unused/idle timeouts are set to " + this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + '/' + this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
        }
    }

    public static final /* synthetic */ Services access$createCompileServices(CompileServiceImpl $this, CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        return $this.createCompileServices(facade, eventManager, rpcProfiler);
    }

    public static final /* synthetic */ void access$shutdownNow(CompileServiceImpl $this) {
        $this.shutdownNow();
    }

    public static final /* synthetic */ void access$gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this$0);
    }
}

