/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0014\u0010\u0015\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantVisibilityModifierSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "()V", "containingPropertyVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getContainingPropertyVisibility", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "checkLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "context", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findFunctionVisibility", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "implicitVisibility", "checkers"})
public final class RedundantVisibilityModifierSyntaxChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final RedundantVisibilityModifierSyntaxChecker INSTANCE = new RedundantVisibilityModifierSyntaxChecker();

    private RedundantVisibilityModifierSyntaxChecker() {
    }

    @Override
    public void checkLightTree(@NotNull FirDeclaration element, @NotNull FirSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        Visibility visibility2;
        FirElement firElement;
        Visibility implicitVisibility;
        Visibility explicitVisibility;
        block18: {
            LighterASTNode visibilityModifier;
            LighterASTNode lighterASTNode2;
            block19: {
                block20: {
                    Intrinsics.checkNotNullParameter(element, "element");
                    Intrinsics.checkNotNullParameter(source, "source");
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    if (element instanceof FirConstructor && source.getKind() instanceof FirFakeSourceElementKind) {
                        return;
                    }
                    if (source instanceof FirFakeSourceElement) {
                        return;
                    }
                    if (element instanceof FirMemberDeclaration) break block19;
                    if (!(element instanceof FirPropertyAccessor)) break block20;
                    FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)((Object)element);
                    boolean $i$f$getVisibility = false;
                    if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), this.getContainingPropertyVisibility(context2))) break block19;
                }
                return;
            }
            IElementType iElementType = (lighterASTNode2 = (visibilityModifier = LightTreePositioningStrategiesKt.visibilityModifier(source.getTreeStructure(), source.getLighterASTNode()))) == null ? null : lighterASTNode2.getTokenType();
            KtModifierKeywordToken ktModifierKeywordToken = iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
            explicitVisibility = ktModifierKeywordToken == null ? null : FirHelpersKt.toVisibilityOrNull(ktModifierKeywordToken);
            implicitVisibility = this.implicitVisibility(element, context2);
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirElement firElement3;
                FirElement firElement4;
                FirDeclaration firDeclaration2 = it$iv;
                if (!(firDeclaration2 instanceof FirMemberDeclaration)) {
                    firDeclaration2 = null;
                }
                if ((firElement4 = (FirElement)((FirMemberDeclaration)((Object)firDeclaration2))) == null) {
                    firElement3 = null;
                } else {
                    FirElement firElement5;
                    FirElement firElement6;
                    FirElement it = firElement6 = (firElement5 = firElement4);
                    firElement3 = firElement2 = true ? firElement5 : null;
                }
                if (firElement2 == null) continue;
                firElement = firElement2;
                break block18;
            }
            firElement = null;
        }
        FirMemberDeclaration containingMemberDeclaration = (FirMemberDeclaration)firElement;
        if (!(containingMemberDeclaration == null ? true : containingMemberDeclaration instanceof FirDeclaration)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (Intrinsics.areEqual(explicitVisibility, implicitVisibility)) {
            visibility2 = implicitVisibility;
        } else if (Intrinsics.areEqual(explicitVisibility, Visibilities.Internal.INSTANCE) && ((firDeclaration = (FirDeclaration)((Object)containingMemberDeclaration)) == null ? false : FirDeclarationCheckerUtilsKt.isLocalMember(firDeclaration))) {
            visibility2 = Visibilities.Internal.INSTANCE;
        } else {
            return;
        }
        Visibility redundantVisibility = visibility2;
        if (Intrinsics.areEqual(redundantVisibility, Visibilities.Public.INSTANCE) && element instanceof FirProperty && LightTreePositioningStrategiesKt.overrideModifier(source.getTreeStructure(), source.getLighterASTNode()) != null && ((FirProperty)element).isVar()) {
            Visibility visibility3;
            firDeclaration = ((FirProperty)element).getSetter();
            if (firDeclaration == null) {
                visibility3 = null;
            } else {
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)((Object)firDeclaration);
                boolean $i$f$getVisibility = false;
                visibility3 = $this$visibility$iv.getStatus().getVisibility();
            }
            if (Intrinsics.areEqual(visibility3, Visibilities.Public.INSTANCE)) {
                return;
            }
        }
        DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER(), context2, null, 8, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Visibility implicitVisibility(FirDeclaration $this$implicitVisibility, CheckerContext context2) {
        FirElement firElement;
        Visibility visibility2;
        block11: {
            Iterator<FirDeclaration> iterator2;
            block13: {
                block14: {
                    block15: {
                        block16: {
                            block12: {
                                if ($this$implicitVisibility instanceof FirPropertyAccessor && ((FirPropertyAccessor)$this$implicitVisibility).isSetter() && ((FirPropertyAccessor)$this$implicitVisibility).getStatus().isOverride()) {
                                    FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)((Object)$this$implicitVisibility);
                                    boolean $i$f$getVisibility = false;
                                    visibility2 = $this$visibility$iv.getStatus().getVisibility();
                                    return visibility2;
                                }
                                if (!($this$implicitVisibility instanceof FirPropertyAccessor)) break block12;
                                CheckerContext $this$findClosest_u24default$iv = context2;
                                boolean $i$f$findClosest = false;
                                iterator2 = CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations()).iterator();
                                break block13;
                            }
                            if (!($this$implicitVisibility instanceof FirConstructor)) break block14;
                            FirClassLikeSymbol<?> classSymbol = FirHelpersKt.getContainingClassSymbol($this$implicitVisibility, context2.getSession());
                            if (!(classSymbol instanceof FirRegularClassSymbol)) break block15;
                            FirClassSymbol $this$isEnumClass$iv = (FirClassSymbol)classSymbol;
                            boolean $i$f$isEnumClass = false;
                            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                            boolean $i$f$isEnumClass2 = false;
                            if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) break block16;
                            FirRegularClassSymbol $this$isSealed$iv = (FirRegularClassSymbol)classSymbol;
                            boolean $i$f$isSealed = false;
                            if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) break block15;
                        }
                        visibility2 = Visibilities.Private.INSTANCE;
                        return visibility2;
                    }
                    visibility2 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
                    return visibility2;
                }
                if ($this$implicitVisibility instanceof FirSimpleFunction && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClass) {
                    FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)((Object)$this$implicitVisibility);
                    boolean $i$f$isOverride = false;
                    if ($this$isOverride$iv.getStatus().isOverride()) {
                        visibility2 = this.findFunctionVisibility((FirSimpleFunction)$this$implicitVisibility, context2);
                        return visibility2;
                    }
                }
                visibility2 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
                return visibility2;
            }
            while (iterator2.hasNext()) {
                FirElement firElement2;
                FirElement firElement3;
                FirElement firElement4;
                FirDeclaration it$iv = iterator2.next();
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirProperty)) {
                    firDeclaration = null;
                }
                if ((firElement4 = (FirElement)((FirProperty)firDeclaration)) == null) {
                    firElement3 = null;
                } else {
                    FirElement firElement5;
                    FirElement firElement6;
                    FirElement it = firElement6 = (firElement5 = firElement4);
                    firElement3 = firElement2 = firElement5;
                }
                if (firElement2 == null) continue;
                firElement = firElement2;
                break block11;
            }
            firElement = null;
        }
        FirProperty $this$visibility$iv = (FirProperty)firElement;
        if ($this$visibility$iv == null) {
            visibility2 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
            return visibility2;
        }
        FirMemberDeclaration $this$visibility$iv2 = $this$visibility$iv;
        boolean $i$f$getVisibility = false;
        visibility2 = $this$visibility$iv2.getStatus().getVisibility();
        return visibility2;
    }

    private final Visibility findFunctionVisibility(FirSimpleFunction function2, CheckerContext context2) {
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Visibilities.Unknown.INSTANCE;
        }
        FirClass currentClass = firClass;
        List<FirFunctionSymbol<?>> overriddenFunctions2 = FirHelpersKt.overriddenFunctions(function2, currentClass, context2);
        Visibility visibility2 = Visibilities.Private.INSTANCE;
        for (FirFunctionSymbol<?> func : overriddenFunctions2) {
            FirCallableSymbol $this$visibility$iv = func;
            boolean $i$f$getVisibility = false;
            Visibility currentVisibility = $this$visibility$iv.getResolvedStatus().getVisibility();
            Integer compareResult = Visibilities.INSTANCE.compare(currentVisibility, visibility2);
            if (compareResult == null || compareResult <= 0) continue;
            visibility2 = currentVisibility;
        }
        return visibility2;
    }

    private final Visibility getContainingPropertyVisibility(CheckerContext $this$containingPropertyVisibility) {
        Visibility visibility2;
        FirProperty firProperty;
        FirDeclaration firDeclaration = CollectionsKt.last($this$containingPropertyVisibility.getContainingDeclarations());
        FirProperty firProperty2 = firProperty = firDeclaration instanceof FirProperty ? (FirProperty)firDeclaration : null;
        if (firProperty == null) {
            visibility2 = null;
        } else {
            FirMemberDeclaration $this$visibility$iv = firProperty;
            boolean $i$f$getVisibility = false;
            visibility2 = $this$visibility$iv.getStatus().getVisibility();
        }
        return visibility2;
    }
}

