/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedFilesKt;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangeInfo;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImpl;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.incremental.SerializedJavaClassWithSource;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a,\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001ad\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u001a@\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010!\u001a\u00020\"2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f\u001a:\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00072\u0006\u0010!\u001a\u00020\"2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f\u001a\u0010\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0001H\u0002\u001a.\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00072\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104\u001a\"\u00105\u001a\b\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u00106\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a \u00107\u001a\u000208*\u0002022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010!\u001a\u00020\"\u001a.\u00109\u001a\u00020,*\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"DELETE_MODULE_FILE_PROPERTY", "", "isSealed", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "caches", "", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "makeCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/modules/TargetId;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "compilationCanceledStatus", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "makeModuleFile", "Ljava/io/File;", "name", "isTest", "outputDir", "sourcesToCompile", "commonSources", "javaSourceRoots", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "classpath", "friendDirs", "mapClassesFqNamesToFiles", "", "classesFqNames", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "excludes", "mapLookupSymbolsToFiles", "lookupStorage", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "lookupSymbols", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "sanitizeJavaIdentifier", "string", "updateIncrementalCache", "", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "cache", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "javaChangesTracker", "Lorg/jetbrains/kotlin/incremental/JavaClassesTrackerImpl;", "withSubtypes", "typeFqName", "getDirtyData", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "update", "filesToCompile", "removedFiles", "kotlin-build-common"})
public final class BuildUtilKt {
    @NotNull
    public static final String DELETE_MODULE_FILE_PROPERTY = "kotlin.delete.module.file.after.build";

    @NotNull
    public static final File makeModuleFile(@NotNull String name, boolean isTest, @NotNull File outputDir2, @NotNull Iterable<? extends File> sourcesToCompile, @NotNull Iterable<? extends File> commonSources, @NotNull Iterable<JvmSourceRoot> javaSourceRoots, @NotNull Iterable<? extends File> classpath, @NotNull Iterable<? extends File> friendDirs) {
        Collection<File> collection;
        Object object;
        File it;
        boolean bl;
        Iterable iterable;
        Iterable<? extends File> $this$mapTo$iv$iv;
        Iterable<? extends File> $this$map$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(outputDir2, "outputDir");
        Intrinsics.checkNotNullParameter(sourcesToCompile, "sourcesToCompile");
        Intrinsics.checkNotNullParameter(commonSources, "commonSources");
        Intrinsics.checkNotNullParameter(javaSourceRoots, "javaSourceRoots");
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        Intrinsics.checkNotNullParameter(friendDirs, "friendDirs");
        KotlinModuleXmlBuilder builder2 = new KotlinModuleXmlBuilder();
        Object object2 = outputDir2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(object2, "outputDir.absolutePath");
        String string2 = object2;
        object2 = sourcesToCompile;
        String string3 = string2;
        String string4 = name;
        KotlinModuleXmlBuilder kotlinModuleXmlBuilder = builder2;
        boolean $i$f$map = false;
        void var11_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            File file2 = (File)t;
            iterable = destination$iv$iv;
            bl = false;
            object = it.getAbsoluteFile();
            iterable.add(object);
        }
        iterable = (List)destination$iv$iv;
        $this$map$iv = commonSources;
        Iterable<? extends File> iterable2 = classpath;
        object = javaSourceRoots;
        iterable = iterable;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object object3 : $this$mapTo$iv$iv) {
            it = (File)object3;
            collection = destination$iv$iv;
            bl = false;
            File file3 = it.getAbsoluteFile();
            collection.add(file3);
        }
        collection = (List)destination$iv$iv;
        kotlinModuleXmlBuilder.addModule(string4, string3, iterable, (Iterable<JvmSourceRoot>)object, iterable2, (Iterable<? extends File>)collection, null, "java-production", isTest, SetsKt.setOf(outputDir2), friendDirs);
        File scriptFile = Files.createTempFile("kjps", Intrinsics.stringPlus(BuildUtilKt.sanitizeJavaIdentifier(name), ".script.xml"), new FileAttribute[0]).toFile();
        Intrinsics.checkNotNullExpressionValue(scriptFile, "scriptFile");
        FilesKt.writeText$default(scriptFile, ((Object)builder2.asText()).toString(), null, 2, null);
        return scriptFile;
    }

    private static final String sanitizeJavaIdentifier(String string2) {
        StringBuilder stringBuilder2;
        StringBuilder $this$sanitizeJavaIdentifier_u24lambda_u2d2 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        String string3 = string2;
        int n = 0;
        int n2 = string3.length();
        while (n < n2) {
            char c = string3.charAt(n);
            ++n;
            if (!Character.isJavaIdentifierPart(c)) continue;
            if ($this$sanitizeJavaIdentifier_u24lambda_u2d2.length() == 0 && !Character.isJavaIdentifierStart(c)) {
                $this$sanitizeJavaIdentifier_u24lambda_u2d2.append('_');
            }
            $this$sanitizeJavaIdentifier_u24lambda_u2d2.append(c);
        }
        String string4 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    @NotNull
    public static final Services makeCompileServices(@NotNull Map<TargetId, ? extends IncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @Nullable CompilationCanceledStatus compilationCanceledStatus) {
        Services.Builder builder2;
        Intrinsics.checkNotNullParameter(incrementalCaches, "incrementalCaches");
        Intrinsics.checkNotNullParameter(lookupTracker, "lookupTracker");
        Services.Builder $this$makeCompileServices_u24lambda_u2d4 = builder2 = new Services.Builder();
        boolean bl = false;
        $this$makeCompileServices_u24lambda_u2d4.register(LookupTracker.class, lookupTracker);
        $this$makeCompileServices_u24lambda_u2d4.register(IncrementalCompilationComponents.class, new IncrementalCompilationComponentsImpl(incrementalCaches));
        CompilationCanceledStatus compilationCanceledStatus2 = compilationCanceledStatus;
        if (compilationCanceledStatus2 != null) {
            CompilationCanceledStatus compilationCanceledStatus3;
            CompilationCanceledStatus it = compilationCanceledStatus3 = compilationCanceledStatus2;
            boolean bl2 = false;
            $this$makeCompileServices_u24lambda_u2d4.register(CompilationCanceledStatus.class, it);
        }
        return $this$makeCompileServices_u24lambda_u2d4.build();
    }

    public static final void updateIncrementalCache(@NotNull Iterable<? extends GeneratedFile> generatedFiles, @NotNull IncrementalJvmCache cache2, @NotNull ChangesCollector changesCollector, @Nullable JavaClassesTrackerImpl javaChangesTracker) {
        Intrinsics.checkNotNullParameter(generatedFiles, "generatedFiles");
        Intrinsics.checkNotNullParameter(cache2, "cache");
        Intrinsics.checkNotNullParameter(changesCollector, "changesCollector");
        for (GeneratedFile collection : generatedFiles) {
            if (collection instanceof GeneratedJvmClass) {
                cache2.saveFileToCache((GeneratedJvmClass)collection, changesCollector);
                continue;
            }
            if (!GeneratedFilesKt.isModuleMappingFile(collection.getOutputFile())) continue;
            cache2.saveModuleMappingToCache((Collection<? extends File>)collection.getSourceFiles(), collection.getOutputFile());
        }
        JavaClassesTrackerImpl javaClassesTrackerImpl = javaChangesTracker;
        if (javaClassesTrackerImpl != null) {
            Collection<SerializedJavaClassWithSource> collection = javaClassesTrackerImpl.getJavaClassesUpdates();
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SerializedJavaClassWithSource $dstr$source$serializedJavaClass = (SerializedJavaClassWithSource)element$iv;
                boolean bl = false;
                File source = $dstr$source$serializedJavaClass.component1();
                SerializedJavaClass serializedJavaClass = $dstr$source$serializedJavaClass.component2();
                cache2.saveJavaClassProto(source, serializedJavaClass, changesCollector);
            }
        }
        cache2.clearCacheForRemovedClasses(changesCollector);
    }

    public static final void update(@NotNull LookupStorage $this$update, @NotNull LookupTracker lookupTracker, @NotNull Iterable<? extends File> filesToCompile, @NotNull Iterable<? extends File> removedFiles) {
        Intrinsics.checkNotNullParameter($this$update, "<this>");
        Intrinsics.checkNotNullParameter(lookupTracker, "lookupTracker");
        Intrinsics.checkNotNullParameter(filesToCompile, "filesToCompile");
        Intrinsics.checkNotNullParameter(removedFiles, "removedFiles");
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw new AssertionError((Object)Intrinsics.stringPlus("Lookup tracker is expected to be LookupTrackerImpl, got ", lookupTracker.getClass()));
        }
        $this$update.removeLookupsFrom(SequencesKt.plus(CollectionsKt.asSequence(filesToCompile), CollectionsKt.asSequence(removedFiles)));
        MultiMap<LookupSymbol, String> multiMap = ((LookupTrackerImpl)lookupTracker).getLookups();
        Set<String> set = ((LookupTrackerImpl)lookupTracker).getPathInterner().getValues();
        Intrinsics.checkNotNullExpressionValue(set, "lookupTracker.pathInterner.values");
        $this$update.addAll(multiMap, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DirtyData getDirtyData(@NotNull ChangesCollector $this$getDirtyData, @NotNull Iterable<? extends IncrementalCacheCommon> caches, @NotNull ICReporter reporter) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        HashSet hashSet;
        Intrinsics.checkNotNullParameter($this$getDirtyData, "<this>");
        Intrinsics.checkNotNullParameter(caches, "caches");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        HashSet<LookupSymbol> dirtyLookupSymbols = new HashSet<LookupSymbol>();
        HashSet<FqName> dirtyClassesFqNames = new HashSet<FqName>();
        HashMap<FqName, Set<FqName>> sealedParents = new HashMap<FqName, Set<FqName>>();
        HashSet<FqName> notSealedParents = new HashSet<FqName>();
        for (ChangeInfo change : $this$getDirtyData.changes()) {
            Object object;
            Collection<FqName> fqNames;
            reporter.reportVerbose(new Function0<String>(change){
                final /* synthetic */ ChangeInfo $change;
                {
                    this.$change = $change;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus("Process ", this.$change);
                }
            });
            if (change instanceof ChangeInfo.SignatureChanged) {
                fqNames = !((ChangeInfo.SignatureChanged)change).getAreSubclassesAffected() ? (Collection)CollectionsKt.listOf(change.getFqName()) : (Collection)BuildUtilKt.withSubtypes(change.getFqName(), caches);
                dirtyClassesFqNames.addAll(fqNames);
                for (FqName classFqName : fqNames) {
                    boolean bl;
                    boolean bl2 = bl = !classFqName.isRoot();
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-BuildUtilKt$getDirtyData$32 = false;
                        String $i$a$-assert-BuildUtilKt$getDirtyData$32 = classFqName + " is root when processing " + change;
                        throw new AssertionError((Object)$i$a$-assert-BuildUtilKt$getDirtyData$32);
                    }
                    String $i$a$-assert-BuildUtilKt$getDirtyData$32 = classFqName.parent().asString();
                    Intrinsics.checkNotNullExpressionValue($i$a$-assert-BuildUtilKt$getDirtyData$32, "classFqName.parent().asString()");
                    String scope2 = $i$a$-assert-BuildUtilKt$getDirtyData$32;
                    object = classFqName.shortName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue(object, "classFqName.shortName().identifier");
                    Object name = object;
                    dirtyLookupSymbols.add(new LookupSymbol((String)name, scope2));
                }
                continue;
            }
            if (change instanceof ChangeInfo.MembersChanged) {
                LookupSymbol lookupSymbol;
                String it;
                Collection collection;
                fqNames = BuildUtilKt.withSubtypes(change.getFqName(), caches);
                dirtyClassesFqNames.addAll(fqNames);
                for (String name : ((ChangeInfo.MembersChanged)change).getNames()) {
                    Iterable $this$mapTo$iv = fqNames;
                    boolean $i$f$mapTo = false;
                    object = $this$mapTo$iv.iterator();
                    while (object.hasNext()) {
                        Object item$iv = object.next();
                        FqName fqName2 = (FqName)item$iv;
                        collection = dirtyLookupSymbols;
                        boolean bl = false;
                        String string2 = ((FqName)((Object)it)).asString();
                        Intrinsics.checkNotNullExpressionValue(string2, "it.asString()");
                        lookupSymbol = new LookupSymbol(name, string2);
                        collection.add(lookupSymbol);
                    }
                }
                Iterable $this$mapTo$iv = fqNames;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it2;
                    object = (FqName)item$iv;
                    collection = dirtyLookupSymbols;
                    boolean bl = false;
                    it = SamConversionResolverKt.getSAM_LOOKUP_NAME().asString();
                    Intrinsics.checkNotNullExpressionValue(it, "SAM_LOOKUP_NAME.asString()");
                    String string3 = it;
                    it = it2.asString();
                    Intrinsics.checkNotNullExpressionValue(it, "it.asString()");
                    lookupSymbol = new LookupSymbol(string3, it);
                    collection.add(lookupSymbol);
                }
                continue;
            }
            if (!(change instanceof ChangeInfo.ParentsChanged)) continue;
            Iterable $this$forEach$iv = ((ChangeInfo.ParentsChanged)change).getParentsChanged();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object2;
                FqName parent2 = (FqName)element$iv;
                boolean bl4 = false;
                if (!BuildUtilKt.getDirtyData$isSealed(parent2, notSealedParents, sealedParents, caches)) continue;
                Map $this$getOrPut$iv = sealedParents;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(parent2);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(parent2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).add(change.getFqName());
            }
        }
        HashSet $this$getDirtyData_u24lambda_u2d13 = hashSet = new HashSet();
        boolean bl = false;
        $this$getDirtyData_u24lambda_u2d13.addAll(sealedParents.keySet());
        Iterable<Object> $i$f$mapTo = sealedParents.keySet();
        Intrinsics.checkNotNullExpressionValue($i$f$mapTo, "sealedParents.keys");
        $i$f$mapTo = $i$f$mapTo;
        HashSet hashSet2 = $this$getDirtyData_u24lambda_u2d13;
        boolean $i$f$flatMap = false;
        void bl4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Iterable list$iv$iv = BuildUtilKt.withSubtypes(it, caches);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        hashSet2.addAll(list2);
        Collection<Set<FqName>> collection = sealedParents.values();
        Intrinsics.checkNotNullExpressionValue(collection, "sealedParents.values");
        $this$getDirtyData_u24lambda_u2d13.addAll(CollectionsKt.flatten((Iterable)collection));
        HashSet forceRecompile = hashSet;
        return new DirtyData((Collection<LookupSymbol>)dirtyLookupSymbols, (Collection<FqName>)dirtyClassesFqNames, forceRecompile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> mapLookupSymbolsToFiles(@NotNull LookupStorage lookupStorage, @NotNull Iterable<LookupSymbol> lookupSymbols, @NotNull ICReporter reporter, @NotNull Set<? extends File> excludes) {
        Intrinsics.checkNotNullParameter(lookupStorage, "lookupStorage");
        Intrinsics.checkNotNullParameter(lookupSymbols, "lookupSymbols");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(excludes, "excludes");
        HashSet dirtyFiles = new HashSet();
        for (LookupSymbol lookup2 : lookupSymbols) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = lookupStorage.get(lookup2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file2 = new File((String)p0);
                collection.add(file2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!(!excludes.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List affectedFiles = (List)destination$iv$iv;
            reporter.reportMarkDirtyMember(affectedFiles, lookup2.getScope(), lookup2.getName());
            dirtyFiles.addAll(affectedFiles);
        }
        return dirtyFiles;
    }

    public static /* synthetic */ Set mapLookupSymbolsToFiles$default(LookupStorage lookupStorage, Iterable iterable, ICReporter iCReporter, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return BuildUtilKt.mapLookupSymbolsToFiles(lookupStorage, iterable, iCReporter, set);
    }

    @NotNull
    public static final Set<File> mapClassesFqNamesToFiles(@NotNull Iterable<? extends IncrementalCacheCommon> caches, @NotNull Iterable<FqName> classesFqNames, @NotNull ICReporter reporter, @NotNull Set<? extends File> excludes) {
        Intrinsics.checkNotNullParameter(caches, "caches");
        Intrinsics.checkNotNullParameter(classesFqNames, "classesFqNames");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(excludes, "excludes");
        HashMap fqNameToAffectedFiles = new HashMap();
        for (IncrementalCacheCommon entry : caches) {
            for (FqName classFqName : classesFqNames) {
                Object object;
                File srcFile = entry.getSourceFileIfClass(classFqName);
                if (srcFile == null || excludes.contains(srcFile) || FileUtilsKt.isJavaFile(srcFile)) continue;
                Map $this$getOrPut$iv = fqNameToAffectedFiles;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(classFqName);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(classFqName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(srcFile);
            }
        }
        for (Map.Entry entry : ((Map)fqNameToAffectedFiles).entrySet()) {
            FqName classFqName = (FqName)entry.getKey();
            Set affectedFiles = (Set)entry.getValue();
            Iterable iterable = affectedFiles;
            String string2 = classFqName.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "classFqName.asString()");
            reporter.reportMarkDirtyClass(iterable, string2);
        }
        Collection collection = fqNameToAffectedFiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, "fqNameToAffectedFiles.values");
        return (Set)AddToStdlibKt.flattenTo(collection, (Collection)new HashSet());
    }

    public static /* synthetic */ Set mapClassesFqNamesToFiles$default(Iterable iterable, Iterable iterable2, ICReporter iCReporter, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return BuildUtilKt.mapClassesFqNamesToFiles(iterable, iterable2, iCReporter, set);
    }

    public static final boolean isSealed(@NotNull FqName fqName2, @NotNull Iterable<? extends IncrementalCacheCommon> caches) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(fqName2, "fqName");
            Intrinsics.checkNotNullParameter(caches, "caches");
            Iterable<? extends IncrementalCacheCommon> $this$any$iv = caches;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends IncrementalCacheCommon> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    IncrementalCacheCommon element$iv;
                    IncrementalCacheCommon it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Boolean bl3 = it.isSealed(fqName2);
                    if (!(bl3 == null ? false : bl3)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<FqName> withSubtypes(@NotNull FqName typeFqName2, @NotNull Iterable<? extends IncrementalCacheCommon> caches) {
        Intrinsics.checkNotNullParameter(typeFqName2, "typeFqName");
        Intrinsics.checkNotNullParameter(caches, "caches");
        LinkedHashSet<FqName> typesToProccess = new LinkedHashSet<FqName>((Collection)CollectionsKt.listOf(typeFqName2));
        HashSet<FqName> proccessedTypes = new HashSet<FqName>();
        while (!((Collection)typesToProccess).isEmpty()) {
            void $this$forEach$iv;
            Iterator iterator2 = typesToProccess.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "typesToProccess.iterator()");
            Iterator iterator3 = iterator2;
            FqName unprocessedType = (FqName)iterator3.next();
            iterator3.remove();
            Sequence sequence2 = SequencesKt.filter(SequencesKt.flatMap(CollectionsKt.asSequence(caches), (Function1)new Function1<IncrementalCacheCommon, Sequence<? extends FqName>>(unprocessedType){
                final /* synthetic */ FqName $unprocessedType;
                {
                    this.$unprocessedType = $unprocessedType;
                    super(1);
                }

                @NotNull
                public final Sequence<FqName> invoke(@NotNull IncrementalCacheCommon it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    FqName fqName2 = this.$unprocessedType;
                    Intrinsics.checkNotNullExpressionValue(fqName2, "unprocessedType");
                    return it.getSubtypesOf(fqName2);
                }
            }), (Function1)new Function1<FqName, Boolean>(proccessedTypes){
                final /* synthetic */ HashSet<FqName> $proccessedTypes;
                {
                    this.$proccessedTypes = $proccessedTypes;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FqName it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return !this.$proccessedTypes.contains(it);
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FqName it = (FqName)element$iv;
                boolean bl = false;
                typesToProccess.add(it);
            }
            proccessedTypes.add(unprocessedType);
        }
        return proccessedTypes;
    }

    private static final boolean getDirtyData$isSealed(FqName $this$getDirtyData_u24isSealed, HashSet<FqName> notSealedParents, HashMap<FqName, Set<FqName>> sealedParents, Iterable<? extends IncrementalCacheCommon> $caches) {
        boolean bl;
        if (notSealedParents.contains($this$getDirtyData_u24isSealed)) {
            return false;
        }
        if (sealedParents.containsKey($this$getDirtyData_u24isSealed)) {
            return true;
        }
        boolean sealed = bl = BuildUtilKt.isSealed($this$getDirtyData_u24isSealed, $caches);
        boolean bl2 = false;
        if (sealed) {
            Map map = sealedParents;
            HashSet hashSet = new HashSet();
            map.put($this$getDirtyData_u24isSealed, hashSet);
        } else {
            notSealedParents.add($this$getDirtyData_u24isSealed);
        }
        return bl;
    }
}

