/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil;

public class HashCommon {
    public static int mix(int x) {
        int h2 = x * -1640531527;
        return h2 ^ h2 >>> 16;
    }

    public static long mix(long x) {
        long h2 = x * -7046029254386353131L;
        h2 ^= h2 >>> 32;
        return h2 ^ h2 >>> 16;
    }

    public static int double2int(double d) {
        long l = Double.doubleToRawLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public static int long2int(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    public static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    public static int arraySize(int expected, float f) {
        long s2 = Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s2 > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s2;
    }
}

