/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.HashCommon;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleListIterator;

public abstract class AbstractDoubleList
extends AbstractDoubleCollection
implements DoubleList {
    protected AbstractDoubleList() {
    }

    protected void ensureIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index2, double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(double k) {
        this.add(this.size(), k);
        return true;
    }

    @Override
    public double removeDouble(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double set(int index2, double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Double> c) {
        this.ensureIndex(index2);
        Iterator<? extends Double> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, (double)i.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public DoubleListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public DoubleListIterator listIterator(final int index2) {
        this.ensureIndex(index2);
        return new DoubleListIterator(){
            int pos;
            int last;
            {
                this.pos = index2;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractDoubleList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractDoubleList.this.getDouble(this.last);
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractDoubleList.this.getDouble(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(double k) {
                AbstractDoubleList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(double k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.removeDouble(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(double k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public int indexOf(double k) {
        DoubleListIterator i = this.listIterator();
        while (i.hasNext()) {
            double e = i.nextDouble();
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(e)) continue;
            return i.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double k) {
        DoubleListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            double e = i.previousDouble();
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(e)) continue;
            return i.nextIndex();
        }
        return -1;
    }

    @Override
    public DoubleList subList(int from2, int to) {
        this.ensureIndex(from2);
        this.ensureIndex(to);
        if (from2 > to) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        return new DoubleSubList(this, from2, to);
    }

    @Override
    public void removeElements(int from2, int to) {
        this.ensureIndex(to);
        DoubleListIterator i = this.listIterator(from2);
        int n = to - from2;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.nextDouble();
            i.remove();
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public int hashCode() {
        DoubleListIterator i = this.iterator();
        int h2 = 1;
        int s2 = this.size();
        while (s2-- != 0) {
            double k = i.nextDouble();
            h2 = 31 * h2 + HashCommon.double2int(k);
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s2 = this.size();
        if (s2 != l.size()) {
            return false;
        }
        if (l instanceof DoubleList) {
            DoubleListIterator i1 = this.listIterator();
            DoubleListIterator i2 = ((DoubleList)l).listIterator();
            while (s2-- != 0) {
                if (i1.nextDouble() == i2.nextDouble()) continue;
                return false;
            }
            return true;
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s2-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Double> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof DoubleList) {
            DoubleListIterator i1 = this.listIterator();
            DoubleListIterator i2 = ((DoubleList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                double e2;
                double e1 = i1.nextDouble();
                int r = Double.compare(e1, e2 = i2.nextDouble());
                if (r == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator<? extends Double> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(double k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeDouble(index2);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        DoubleListIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s2.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            double k = i.nextDouble();
            s2.append(String.valueOf(k));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class DoubleSubList
    extends AbstractDoubleList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList l;
        protected final int from;
        protected int to;

        public DoubleSubList(DoubleList l, int from2, int to) {
            this.l = l;
            this.from = from2;
            this.to = to;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(double k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int index2, double k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int index2, Collection<? extends Double> c) {
            this.ensureIndex(index2);
            this.to += c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public double getDouble(int index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getDouble(this.from + index2);
        }

        @Override
        public double removeDouble(int index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeDouble(this.from + index2);
        }

        @Override
        public double set(int index2, double k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void removeElements(int from2, int to) {
            this.ensureIndex(from2);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from2, this.from + to);
            this.to -= to - from2;
            assert (this.assertRange());
        }

        @Override
        public DoubleListIterator listIterator(final int index2) {
            this.ensureIndex(index2);
            return new DoubleListIterator(){
                int pos;
                int last;
                {
                    this.pos = index2;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public double nextDouble() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return l.getDouble(from + this.last);
                }

                @Override
                public double previousDouble() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return l.getDouble(from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(double k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.add(this.pos++, k);
                    this.last = -1;
                    assert (this.assertRange());
                }

                @Override
                public void set(double k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.removeDouble(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                    assert (this.assertRange());
                }
            };
        }

        @Override
        public DoubleList subList(int from2, int to) {
            this.ensureIndex(from2);
            this.ensureIndex(to);
            if (from2 > to) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to + ")");
            }
            return new DoubleSubList(this, from2, to);
        }

        @Override
        public boolean rem(double k) {
            int index2 = this.indexOf(k);
            if (index2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeDouble(this.from + index2);
            assert (this.assertRange());
            return true;
        }
    }
}

