/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleListIterator;

public class DoubleArrayList
extends AbstractDoubleList
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = -7046029254386353130L;
    protected transient double[] a;
    protected int size;

    public DoubleArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0 ? DoubleArrays.EMPTY_ARRAY : new double[capacity];
    }

    public DoubleArrayList() {
        this.a = DoubleArrays.DEFAULT_EMPTY_ARRAY;
    }

    public DoubleArrayList(double[] a) {
        this(a, 0, a.length);
    }

    public DoubleArrayList(double[] a, int offset2, int length) {
        this(length);
        System.arraycopy(a, offset2, this.a, 0, length);
        this.size = length;
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != DoubleArrays.DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = DoubleArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    @Override
    public void add(int index2, double k) {
        this.ensureIndex(index2);
        this.grow(this.size + 1);
        if (index2 != this.size) {
            System.arraycopy(this.a, index2, this.a, index2 + 1, this.size - index2);
        }
        this.a[index2] = k;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    @Override
    public boolean add(double k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public double getDouble(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index2];
    }

    @Override
    public int indexOf(double k) {
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(this.a[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double k) {
        int i = this.size;
        while (i-- != 0) {
            if (Double.doubleToLongBits(k) != Double.doubleToLongBits(this.a[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double removeDouble(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        double old = this.a[index2];
        --this.size;
        if (index2 != this.size) {
            System.arraycopy(this.a, index2 + 1, this.a, index2, this.size - index2);
        }
        assert (this.size <= this.a.length);
        return old;
    }

    @Override
    public boolean rem(double k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeDouble(index2);
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public double set(int index2, double k) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        double old = this.a[index2];
        this.a[index2] = k;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void removeElements(int from2, int to) {
        Arrays.ensureFromTo(this.size, from2, to);
        System.arraycopy(this.a, to, this.a, from2, this.size - to);
        this.size -= to - from2;
    }

    @Override
    public void setElements(int index2, double[] a, int offset2, int length) {
        this.ensureIndex(index2);
        DoubleArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(a, offset2, this.a, index2, length);
    }

    @Override
    public double[] toArray(double[] a) {
        if (a == null || a.length < this.size) {
            a = new double[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        double[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public DoubleListIterator listIterator(final int index2) {
        this.ensureIndex(index2);
        return new DoubleListIterator(){
            int pos;
            int last;
            {
                this.pos = index2;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < DoubleArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return DoubleArrayList.this.a[this.last];
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return DoubleArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(double k) {
                DoubleArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(double k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                DoubleArrayList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                DoubleArrayList.this.removeDouble(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public void sort(DoubleComparator comp) {
        if (comp == null) {
            DoubleArrays.stableSort(this.a, 0, this.size);
        } else {
            DoubleArrays.stableSort(this.a, 0, this.size, comp);
        }
    }

    public DoubleArrayList clone() {
        DoubleArrayList c = new DoubleArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }
}

