/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.util.AbstractCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterators;

public abstract class AbstractLongCollection
extends AbstractCollection<Long>
implements LongCollection {
    protected AbstractLongCollection() {
    }

    @Override
    public abstract LongIterator iterator();

    @Override
    public boolean add(long k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(long k) {
        LongIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextLong()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(long k) {
        LongIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextLong()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Long key) {
        return LongCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return LongCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return LongCollection.super.remove(key);
    }

    public long[] toArray(long[] a) {
        if (a == null || a.length < this.size()) {
            a = new long[this.size()];
        }
        LongIterators.unwrap(this.iterator(), a);
        return a;
    }

    @Override
    public long[] toLongArray() {
        return this.toArray((long[])null);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        LongIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            long k = i.nextLong();
            s2.append(String.valueOf(k));
        }
        s2.append("}");
        return s2.toString();
    }
}

