/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObject2ShortFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ShortMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ShortMaps;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortIterator;

public abstract class AbstractObject2ShortMap<K>
extends AbstractObject2ShortFunction<K>
implements Object2ShortMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractObject2ShortMap() {
    }

    @Override
    public boolean containsValue(short v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(Object k) {
        Iterator i = this.object2ShortEntrySet().iterator();
        while (i.hasNext()) {
            if (((Object2ShortMap.Entry)i.next()).getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new AbstractObjectSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractObject2ShortMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractObject2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2ShortMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Object2ShortMap.Entry<K>> i;
                    {
                        this.i = Object2ShortMaps.fastIterator(AbstractObject2ShortMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Object2ShortMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ShortCollection values() {
        return new AbstractShortCollection(){

            @Override
            public boolean contains(short k) {
                return AbstractObject2ShortMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractObject2ShortMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2ShortMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Object2ShortMap.Entry<K>> i;
                    {
                        this.i = Object2ShortMaps.fastIterator(AbstractObject2ShortMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Object2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Short> m3) {
        if (m3 instanceof Object2ShortMap) {
            ObjectIterator i = Object2ShortMaps.fastIterator((Object2ShortMap)m3);
            while (i.hasNext()) {
                Object2ShortMap.Entry e = (Object2ShortMap.Entry)i.next();
                this.put(e.getKey(), e.getShortValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<K, Short>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<K, Short> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = Object2ShortMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Object2ShortMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.object2ShortEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = Object2ShortMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Object2ShortMap.Entry e = (Object2ShortMap.Entry)i.next();
            if (this == e.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e.getShortValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry<K>
    implements Object2ShortMap.Entry<K> {
        protected K key;
        protected short value;

        public BasicEntry() {
        }

        public BasicEntry(K key, short value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public short getShortValue() {
            return this.value;
        }

        @Override
        public short setValue(short value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2ShortMap.Entry) {
                Object2ShortMap.Entry e = (Object2ShortMap.Entry)o;
                return Objects.equals(this.key, e.getKey()) && this.value == e.getShortValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Short)) {
                return false;
            }
            return Objects.equals(this.key, key) && this.value == (Short)value2;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

