/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.serialization;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.serialization.StringTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\u00020\u0017*\u00020\u000fH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0007`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u000ej\b\u0012\u0004\u0012\u00020\u000b`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/metadata/serialization/StringTable;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "(Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "localNames", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "map", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "records", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/metadata/jvm/JvmProtoBuf$StringTableTypes$Record$Builder;", "Lkotlin/collections/ArrayList;", "strings", "getStrings", "()Ljava/util/ArrayList;", "getQualifiedClassNameIndex", "className", "isLocal", "", "getStringIndex", "string", "serializeTo", "", "output", "Ljava/io/OutputStream;", "isTrivial", "metadata.jvm"})
public class JvmStringTable
implements StringTable {
    @NotNull
    private final ArrayList<String> strings;
    @NotNull
    private final ArrayList<JvmProtoBuf.StringTableTypes.Record.Builder> records;
    @NotNull
    private final HashMap<String, Integer> map;
    @NotNull
    private final LinkedHashSet<Integer> localNames;

    /*
     * WARNING - void declaration
     */
    public JvmStringTable(@Nullable JvmNameResolver nameResolver2) {
        this.strings = new ArrayList();
        this.records = new ArrayList();
        this.map = new HashMap();
        this.localNames = new LinkedHashSet();
        if (nameResolver2 != null) {
            Serializable serializable;
            void $this$mapTo$iv;
            CollectionsKt.addAll((Collection)this.strings, nameResolver2.getStrings());
            Iterable<JvmProtoBuf.StringTableTypes.Record> iterable = nameResolver2.getTypes().getRecordList();
            Intrinsics.checkNotNullExpressionValue(iterable, "nameResolver.types.recordList");
            iterable = iterable;
            Collection destination$iv = this.records;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                serializable = (JvmProtoBuf.StringTableTypes.Record)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                JvmProtoBuf.StringTableTypes.Record.Builder builder2 = p0.toBuilder();
                collection.add(builder2);
            }
            int n = 0;
            int n2 = this.strings.size();
            while (n < n2) {
                int index2 = n++;
                Map map = this.map;
                String string2 = nameResolver2.getString(index2);
                serializable = Integer.valueOf(index2);
                map.put(string2, serializable);
            }
            this.localNames.addAll((Collection<Integer>)nameResolver2.getTypes().getLocalNameList());
        }
    }

    public /* synthetic */ JvmStringTable(JvmNameResolver jvmNameResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jvmNameResolver = null;
        }
        this(jvmNameResolver);
    }

    @NotNull
    public final ArrayList<String> getStrings() {
        return this.strings;
    }

    @Override
    public int getStringIndex(@NotNull String string2) {
        Object object;
        Intrinsics.checkNotNullParameter(string2, "string");
        Map $this$getOrPut$iv = this.map;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(string2);
        if (value$iv == null) {
            int n;
            boolean bl = false;
            int $this$getStringIndex_u24lambda_u2d1_u24lambda_u2d0 = n = this.getStrings().size();
            boolean bl2 = false;
            this.getStrings().add(string2);
            JvmProtoBuf.StringTableTypes.Record.Builder lastRecord = (JvmProtoBuf.StringTableTypes.Record.Builder)CollectionsKt.lastOrNull((List)this.records);
            if (lastRecord != null && this.isTrivial(lastRecord)) {
                lastRecord.setRange(lastRecord.getRange() + 1);
            } else {
                this.records.add(JvmProtoBuf.StringTableTypes.Record.newBuilder());
            }
            Integer answer$iv = n;
            $this$getOrPut$iv.put(string2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).intValue();
    }

    private final boolean isTrivial(JvmProtoBuf.StringTableTypes.Record.Builder $this$isTrivial) {
        return !$this$isTrivial.hasPredefinedIndex() && !$this$isTrivial.hasOperation() && $this$isTrivial.getSubstringIndexCount() == 0 && $this$isTrivial.getReplaceCharCount() == 0;
    }

    @Override
    public int getQualifiedClassNameIndex(@NotNull String className2, boolean isLocal) {
        Intrinsics.checkNotNullParameter(className2, "className");
        Integer n = this.map.get(className2);
        if (n != null) {
            Integer n2;
            Integer recordedIndex = n2 = n;
            boolean bl = false;
            if (isLocal == this.localNames.contains(recordedIndex)) {
                return recordedIndex;
            }
        }
        int index2 = this.strings.size();
        if (isLocal) {
            this.localNames.add(index2);
        }
        JvmProtoBuf.StringTableTypes.Record.Builder record2 = JvmProtoBuf.StringTableTypes.Record.newBuilder();
        if (isLocal || StringsKt.contains$default((CharSequence)className2, '$', false, 2, null)) {
            this.strings.add(className2);
        } else {
            Integer predefinedIndex = JvmNameResolver.Companion.getPredefinedStringIndex(className2);
            if (predefinedIndex != null) {
                record2.setPredefinedIndex(predefinedIndex);
                this.strings.add("");
            } else {
                record2.setOperation(JvmProtoBuf.StringTableTypes.Record.Operation.DESC_TO_CLASS_ID);
                this.strings.add('L' + StringsKt.replace$default(className2, '.', '$', false, 4, null) + ';');
            }
        }
        this.records.add(record2);
        Map map = this.map;
        Integer n3 = index2;
        map.put(className2, n3);
        return index2;
    }

    /*
     * WARNING - void declaration
     */
    public final void serializeTo(@NotNull OutputStream output2) {
        Collection<JvmProtoBuf.StringTableTypes.Record> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JvmProtoBuf.StringTableTypes.Builder builder2;
        Intrinsics.checkNotNullParameter(output2, "output");
        JvmProtoBuf.StringTableTypes.Builder $this$serializeTo_u24lambda_u2d4 = builder2 = JvmProtoBuf.StringTableTypes.newBuilder();
        boolean bl = false;
        Iterable iterable = this.records;
        JvmProtoBuf.StringTableTypes.Builder builder3 = $this$serializeTo_u24lambda_u2d4;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmProtoBuf.StringTableTypes.Record.Builder builder4 = (JvmProtoBuf.StringTableTypes.Record.Builder)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            JvmProtoBuf.StringTableTypes.Record record2 = it.build();
            collection.add(record2);
        }
        collection = (List)destination$iv$iv;
        builder3.addAllRecord((Iterable<? extends JvmProtoBuf.StringTableTypes.Record>)collection);
        $this$serializeTo_u24lambda_u2d4.addAllLocalName((Iterable<? extends Integer>)this.localNames);
        $this$serializeTo_u24lambda_u2d4.build().writeDelimitedTo(output2);
    }

    public JvmStringTable() {
        this(null, 1, null);
    }
}

