/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.keymap;

import java.io.IOError;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.kotlin.org.jline.keymap.KeyMap;
import org.jetbrains.kotlin.org.jline.reader.EndOfFileException;
import org.jetbrains.kotlin.org.jline.utils.ClosedException;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingReader;

public class BindingReader {
    protected final NonBlockingReader reader;
    protected final StringBuilder opBuffer = new StringBuilder();
    protected final Deque<Integer> pushBackChar = new ArrayDeque<Integer>();
    protected String lastBinding;

    public BindingReader(NonBlockingReader reader) {
        this.reader = reader;
    }

    public <T> T readBinding(KeyMap<T> keys2) {
        return this.readBinding(keys2, null, true);
    }

    public <T> T readBinding(KeyMap<T> keys2, KeyMap<T> local) {
        return this.readBinding(keys2, local, true);
    }

    public <T> T readBinding(KeyMap<T> keys2, KeyMap<T> local, boolean block) {
        this.lastBinding = null;
        T o = null;
        int[] remaining = new int[1];
        boolean hasRead = false;
        while (true) {
            if (local != null) {
                o = local.getBound(this.opBuffer, remaining);
            }
            if (o == null && (local == null || remaining[0] >= 0)) {
                o = keys2.getBound(this.opBuffer, remaining);
            }
            if (o != null) {
                if (remaining[0] >= 0) {
                    this.runMacro(this.opBuffer.substring(this.opBuffer.length() - remaining[0]));
                    this.opBuffer.setLength(this.opBuffer.length() - remaining[0]);
                } else {
                    long ambiguousTimeout = keys2.getAmbiguousTimeout();
                    if (ambiguousTimeout > 0L && this.peekCharacter(ambiguousTimeout) != -2) {
                        o = null;
                    }
                }
                if (o != null) {
                    this.lastBinding = this.opBuffer.toString();
                    this.opBuffer.setLength(0);
                    return o;
                }
            } else if (remaining[0] > 0) {
                int cp = this.opBuffer.codePointAt(0);
                String rem = this.opBuffer.substring(Character.charCount(cp));
                this.lastBinding = this.opBuffer.substring(0, Character.charCount(cp));
                o = cp >= 128 ? keys2.getUnicode() : keys2.getNomatch();
                this.opBuffer.setLength(0);
                this.opBuffer.append(rem);
                if (o != null) {
                    return o;
                }
            }
            if (!block && hasRead) break;
            int c = this.readCharacter();
            if (c == -1) {
                return null;
            }
            this.opBuffer.appendCodePoint(c);
            hasRead = true;
        }
        return null;
    }

    public int readCharacter() {
        if (!this.pushBackChar.isEmpty()) {
            return this.pushBackChar.pop();
        }
        try {
            int c = -2;
            int s2 = 0;
            while (c == -2) {
                c = this.reader.read(100L);
                if (c < 0 || !Character.isHighSurrogate((char)c)) continue;
                s2 = c;
                c = -2;
            }
            return s2 != 0 ? Character.toCodePoint((char)s2, (char)c) : c;
        }
        catch (ClosedException e) {
            throw new EndOfFileException(e);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public int peekCharacter(long timeout) {
        if (!this.pushBackChar.isEmpty()) {
            return this.pushBackChar.peek();
        }
        try {
            return this.reader.peek(timeout);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void runMacro(String macro) {
        macro.codePoints().forEachOrdered(this.pushBackChar::addLast);
    }

    public String getLastBinding() {
        return this.lastBinding;
    }
}

