/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl.jna.win;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.List;

interface Kernel32
extends StdCallLibrary {
    public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary("kernel32", Kernel32.class, W32APIOptions.UNICODE_OPTIONS);
    public static final Pointer INVALID_HANDLE_VALUE = Pointer.createConstant(-1L);

    public Pointer GetStdHandle(int var1);

    public int GetConsoleOutputCP();

    public void FillConsoleOutputCharacter(Pointer var1, char var2, int var3, COORD var4, IntByReference var5) throws LastErrorException;

    public void FillConsoleOutputAttribute(Pointer var1, short var2, int var3, COORD var4, IntByReference var5) throws LastErrorException;

    public void GetConsoleMode(Pointer var1, IntByReference var2) throws LastErrorException;

    public void GetConsoleScreenBufferInfo(Pointer var1, CONSOLE_SCREEN_BUFFER_INFO var2) throws LastErrorException;

    public void ReadConsoleInput(Pointer var1, INPUT_RECORD[] var2, int var3, IntByReference var4) throws LastErrorException;

    public void SetConsoleCursorPosition(Pointer var1, COORD var2) throws LastErrorException;

    public void SetConsoleMode(Pointer var1, int var2) throws LastErrorException;

    public void SetConsoleTextAttribute(Pointer var1, short var2) throws LastErrorException;

    public void SetConsoleTitle(String var1) throws LastErrorException;

    public void ScrollConsoleScreenBuffer(Pointer var1, SMALL_RECT var2, SMALL_RECT var3, COORD var4, CHAR_INFO var5) throws LastErrorException;

    public static class UnionChar
    extends Union {
        public char UnicodeChar;

        public UnionChar() {
        }

        public UnionChar(char c) {
            this.setType(Character.TYPE);
            this.UnicodeChar = c;
        }
    }

    public static class SMALL_RECT
    extends Structure {
        public short Left;
        public short Top;
        public short Right;
        public short Bottom;
        private static String[] fieldOrder = new String[]{"Left", "Top", "Right", "Bottom"};

        public SMALL_RECT() {
        }

        public SMALL_RECT(SMALL_RECT org) {
            this(org.Top, org.Left, org.Bottom, org.Right);
        }

        public SMALL_RECT(short Top, short Left, short Bottom2, short Right) {
            this.Top = Top;
            this.Left = Left;
            this.Bottom = Bottom2;
            this.Right = Right;
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }

        public short width() {
            return (short)(this.Right - this.Left);
        }

        public short height() {
            return (short)(this.Bottom - this.Top);
        }
    }

    public static class WINDOW_BUFFER_SIZE_RECORD
    extends Structure {
        private static String[] fieldOrder = new String[]{"dwSize"};

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }
    }

    public static class MOUSE_EVENT_RECORD
    extends Structure {
        public COORD dwMousePosition;
        public int dwButtonState;
        public int dwEventFlags;
        private static String[] fieldOrder = new String[]{"dwMousePosition", "dwButtonState", "dwControlKeyState", "dwEventFlags"};

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }
    }

    public static class KEY_EVENT_RECORD
    extends Structure {
        public boolean bKeyDown;
        public short wRepeatCount;
        public short wVirtualKeyCode;
        public UnionChar uChar;
        public int dwControlKeyState;
        private static String[] fieldOrder = new String[]{"bKeyDown", "wRepeatCount", "wVirtualKeyCode", "wVirtualScanCode", "uChar", "dwControlKeyState"};

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }
    }

    public static class INPUT_RECORD
    extends Structure {
        public short EventType;
        public EventUnion Event;
        private static String[] fieldOrder = new String[]{"EventType", "Event"};

        @Override
        public void read() {
            this.readField("EventType");
            switch (this.EventType) {
                case 1: {
                    this.Event.setType(KEY_EVENT_RECORD.class);
                    break;
                }
                case 2: {
                    this.Event.setType(MOUSE_EVENT_RECORD.class);
                    break;
                }
                case 4: {
                    this.Event.setType(WINDOW_BUFFER_SIZE_RECORD.class);
                }
            }
            super.read();
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }

        public static class EventUnion
        extends Union {
            public KEY_EVENT_RECORD KeyEvent;
            public MOUSE_EVENT_RECORD MouseEvent;
        }
    }

    public static class COORD
    extends Structure
    implements Structure.ByValue {
        public short X;
        public short Y;
        private static String[] fieldOrder = new String[]{"X", "Y"};

        public COORD() {
        }

        public COORD(short X, short Y) {
            this.X = X;
            this.Y = Y;
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }
    }

    public static class CONSOLE_SCREEN_BUFFER_INFO
    extends Structure {
        public COORD dwSize;
        public COORD dwCursorPosition;
        public short wAttributes;
        public SMALL_RECT srWindow;
        private static String[] fieldOrder = new String[]{"dwSize", "dwCursorPosition", "wAttributes", "srWindow", "dwMaximumWindowSize"};

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }

        public int windowWidth() {
            return this.srWindow.width() + 1;
        }

        public int windowHeight() {
            return this.srWindow.height() + 1;
        }
    }

    public static class CHAR_INFO
    extends Structure {
        public UnionChar uChar;
        public short Attributes;
        private static String[] fieldOrder = new String[]{"uChar", "Attributes"};

        public CHAR_INFO() {
        }

        public CHAR_INFO(char c, short attr) {
            this.uChar = new UnionChar(c);
            this.Attributes = attr;
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList(fieldOrder);
        }
    }
}

