/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/ClassIdCalculator;", "", "()V", "calculateClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "psi"})
public final class ClassIdCalculator {
    @NotNull
    public static final ClassIdCalculator INSTANCE = new ClassIdCalculator();

    private ClassIdCalculator() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassId calculateClassId(@NotNull KtClassLikeDeclaration declaration2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        KtFile ktFile = null;
        List containingClasses = new ArrayList();
        for (PsiElement element = (PsiElement)declaration2; element != null; element = element.getParent()) {
            PsiElement psiElement = element;
            if (psiElement instanceof KtEnumEntry) {
                return null;
            }
            if (psiElement instanceof KtClassLikeDeclaration) {
                ((Collection)containingClasses).add(element);
                continue;
            }
            if (psiElement instanceof KtObjectLiteralExpression) {
                return null;
            }
            if (psiElement instanceof KtFile) {
                ktFile = (KtFile)element;
                break;
            }
            if (!(psiElement instanceof KtDeclaration)) continue;
            return null;
        }
        if (ktFile == null) {
            return null;
        }
        Iterable $this$map$iv = CollectionsKt.reversed(containingClasses);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void containingClass;
            KtClassLikeDeclaration ktClassLikeDeclaration = (KtClassLikeDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = containingClass.getName();
            String string3 = string2 == null ? SpecialNames.NO_NAME_PROVIDED.asString() : string2;
            collection.add(string3);
        }
        FqName fqName2 = FqName.fromSegments((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue(fqName2, "fromSegments(\n          \u2026)\n            }\n        )");
        FqName relativeClassName = fqName2;
        return new ClassId(ktFile.getPackageFqName(), relativeClassName, false);
    }
}

