/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsKt;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.PlatformClassesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAliasExpander;
import org.jetbrains.kotlin.types.TypeAliasExpansion;
import org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\u0018\u0000 \u007f2\u00020\u0001:\u0005\u007f\u0080\u0001\u0081\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aH\u0002J:\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001a2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aH\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J&\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001a2\u0006\u0010.\u001a\u00020/H\u0002JB\u00100\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u001a\u0012\f\u0012\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001a\u0018\u0001012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u001aH\u0002J&\u00109\u001a\u00020:2\u0006\u00103\u001a\u0002042\f\u0010;\u001a\b\u0012\u0004\u0012\u0002020\u001a2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020B2\u0006\u00103\u001a\u0002042\u0006\u0010C\u001a\u00020\u001fH\u0002J\u0010\u0010D\u001a\u00020\u00182\u0006\u00105\u001a\u000206H\u0002J\u001e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010.\u001a\u00020/J(\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010G\u001a\u00020H2\u0006\u0010M\u001a\u00020N2\u0006\u0010.\u001a\u00020/2\u0006\u0010O\u001a\u00020\u0018J&\u0010P\u001a\u00020Q2\u0006\u0010G\u001a\u00020H2\u0006\u0010M\u001a\u00020N2\u0006\u0010.\u001a\u00020/2\u0006\u0010O\u001a\u00020\u0018J\u000e\u0010R\u001a\u00020F2\u0006\u0010S\u001a\u00020'J\u0016\u0010T\u001a\u00020:2\u0006\u00103\u001a\u0002042\u0006\u0010I\u001a\u00020JJ\u0018\u0010U\u001a\u00020@2\u0006\u00103\u001a\u0002042\u0006\u0010I\u001a\u00020JH\u0002J&\u0010U\u001a\u00020@2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010.\u001a\u00020/2\u0006\u0010V\u001a\u00020\u0018J\u001c\u0010W\u001a\u00020X2\u0006\u00103\u001a\u0002042\n\u0010Y\u001a\u0006\u0012\u0002\b\u00030ZH\u0002J,\u0010[\u001a\u00020:2\u0006\u00103\u001a\u0002042\u0006\u0010\\\u001a\u00020X2\b\u0010]\u001a\u0004\u0018\u00010^2\b\u0010*\u001a\u0004\u0018\u00010_H\u0002J0\u0010`\u001a\u00020:2\u0006\u00103\u001a\u0002042\u0006\u0010\\\u001a\u00020X2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020QH\u0002J.\u0010f\u001a\u00020:2\u0006\u00103\u001a\u0002042\u0006\u0010&\u001a\u00020L2\u0006\u0010e\u001a\u00020Q2\u0006\u0010c\u001a\u00020d2\u0006\u0010\\\u001a\u00020XJ0\u0010g\u001a\u00020:2\u0006\u00103\u001a\u0002042\u0006\u0010\\\u001a\u00020X2\u0006\u0010&\u001a\u00020'2\u0006\u0010?\u001a\u00020d2\u0006\u0010e\u001a\u00020QH\u0002J2\u0010h\u001a\u00020@2\u0006\u00103\u001a\u0002042\u0006\u0010\\\u001a\u00020X2\u0006\u0010i\u001a\u00020\u001f2\u0006\u0010j\u001a\u00020k2\b\u0010l\u001a\u0004\u0018\u00010mH\u0002J*\u0010n\u001a\b\u0012\u0004\u0012\u00020!0\u001a2\u0006\u00103\u001a\u0002042\u0006\u0010o\u001a\u00020=2\f\u0010p\u001a\b\u0012\u0004\u0012\u0002020\u001aJ.\u0010q\u001a\b\u0012\u0004\u0012\u00020!0\u001a2\u0006\u00103\u001a\u0002042\f\u0010p\u001a\b\u0012\u0004\u0012\u0002020\u001a2\b\b\u0002\u0010r\u001a\u00020sH\u0002J\u0018\u0010t\u001a\u00020\u00182\u0006\u00103\u001a\u0002042\u0006\u0010u\u001a\u00020@H\u0002J\u000e\u0010v\u001a\u00020\u0018*\u0004\u0018\u00010_H\u0002J\u0014\u0010w\u001a\b\u0012\u0004\u0012\u0002060\u001a*\u0004\u0018\u00010LH\u0002J\u001c\u0010x\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001a*\u00020H2\u0006\u0010y\u001a\u00020bH\u0002J\u001f\u0010z\u001a\n\u0012\u0006\b\u0001\u0012\u00020|0{*\u0006\u0012\u0002\b\u00030ZH\u0000\u00a2\u0006\u0004\b}\u0010~R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0082\u0001\u00b2\u0006\u000e\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "typeTransformerForTests", "Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "dynamicTypesSettings", "Lorg/jetbrains/kotlin/types/DynamicTypesSettings;", "dynamicCallableDescriptors", "Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "platformToKotlinClassMapper", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;Lorg/jetbrains/kotlin/types/DynamicTypesSettings;Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "isNonParenthesizedAnnotationsOnFunctionalTypesEnabled", "", "appendDefaultArgumentsForLocalClassifier", "", "Lorg/jetbrains/kotlin/types/TypeProjectionImpl;", "fromIndex", "", "constructorParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "buildFinalArgumentList", "Lorg/jetbrains/kotlin/types/TypeProjection;", "argumentsFromUserType", "argumentsForOuterClass", "parameters", "canBeUsedAsBareType", "descriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkNonParenthesizedAnnotationsOnFunctionalType", "", "typeElement", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "annotationEntries", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "collectArgumentsForClassifierTypeConstructor", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "c", "Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "qualifierParts", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$ExpressionQualifierPart;", "createErrorTypeForTypeConstructor", "Lorg/jetbrains/kotlin/resolve/PossiblyBareType;", "arguments", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "forceResolveTypeContents", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getScopeForTypeParameter", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "typeParameterDescriptor", "isPossibleToSpecifyTypeArgumentsFor", "resolveAbbreviatedType", "Lorg/jetbrains/kotlin/types/SimpleType;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "isDebuggerContext", "resolveDescriptorForType", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "resolveExpandedTypeForTypeAlias", "typeAliasDescriptor", "resolvePossiblyBareType", "resolveType", "checkBounds", "resolveTypeAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "modifierListsOwner", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "resolveTypeElement", "annotations", "outerModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "resolveTypeForClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "qualifierResolutionResult", "resolveTypeForClassifier", "resolveTypeForTypeAlias", "resolveTypeForTypeParameter", "typeParameter", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "typeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "resolveTypeProjections", "constructor", "argumentElements", "resolveTypeProjectionsWithErrorConstructor", "message", "", "shouldCheckBounds", "inType", "canHaveFunctionTypeModifiers", "classifierDescriptorsFromInnerToOuter", "findImplicitOuterClassArguments", "outerClass", "getAllModifierLists", "", "Lorg/jetbrains/kotlin/psi/KtDeclarationModifierList;", "getAllModifierLists$frontend", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;)[Lorg/jetbrains/kotlin/psi/KtDeclarationModifierList;", "Companion", "TracingTypeAliasExpansionReportStrategy", "TypeTransformerForTests", "frontend", "suspendModifier", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;"})
public final class TypeResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final TypeTransformerForTests typeTransformerForTests;
    @NotNull
    private final DynamicTypesSettings dynamicTypesSettings;
    @NotNull
    private final DynamicCallableDescriptors dynamicCallableDescriptors;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final PlatformToKotlinClassMapper platformToKotlinClassMapper;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    private final boolean isNonParenthesizedAnnotationsOnFunctionalTypesEnabled;

    public TypeResolver(@NotNull AnnotationResolver annotationResolver, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull TypeTransformerForTests typeTransformerForTests, @NotNull DynamicTypesSettings dynamicTypesSettings, @NotNull DynamicCallableDescriptors dynamicCallableDescriptors, @NotNull IdentifierChecker identifierChecker, @NotNull PlatformToKotlinClassMapper platformToKotlinClassMapper, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter(annotationResolver, "annotationResolver");
        Intrinsics.checkNotNullParameter(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(typeTransformerForTests, "typeTransformerForTests");
        Intrinsics.checkNotNullParameter(dynamicTypesSettings, "dynamicTypesSettings");
        Intrinsics.checkNotNullParameter(dynamicCallableDescriptors, "dynamicCallableDescriptors");
        Intrinsics.checkNotNullParameter(identifierChecker, "identifierChecker");
        Intrinsics.checkNotNullParameter(platformToKotlinClassMapper, "platformToKotlinClassMapper");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(upperBoundChecker, "upperBoundChecker");
        this.annotationResolver = annotationResolver;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.typeTransformerForTests = typeTransformerForTests;
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.dynamicCallableDescriptors = dynamicCallableDescriptors;
        this.identifierChecker = identifierChecker;
        this.platformToKotlinClassMapper = platformToKotlinClassMapper;
        this.languageVersionSettings = languageVersionSettings;
        this.upperBoundChecker = upperBoundChecker;
        this.isNonParenthesizedAnnotationsOnFunctionalTypesEnabled = this.languageVersionSettings.getFeatureSupport(LanguageFeature.NonParenthesizedAnnotationsOnFunctionalTypes) == LanguageFeature.State.ENABLED;
    }

    @NotNull
    public final KotlinType resolveType(@NotNull LexicalScope scope2, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace, boolean checkBounds) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        Intrinsics.checkNotNullParameter(trace, "trace");
        return this.resolveType(new TypeResolutionContext(scope2, trace, checkBounds, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference), false), typeReference);
    }

    @NotNull
    public final SimpleType resolveAbbreviatedType(@NotNull LexicalScope scope2, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace) {
        SimpleType simpleType2;
        UnwrappedType resolvedType;
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        Intrinsics.checkNotNullParameter(trace, "trace");
        UnwrappedType unwrappedType = resolvedType = this.resolveType(new TypeResolutionContext(scope2, trace, true, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference), true), typeReference).unwrap();
        if (unwrappedType instanceof DynamicType) {
            trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), resolvedType));
            SimpleType simpleType3 = ErrorUtils.createErrorType("dynamic type in wrong context");
            Intrinsics.checkNotNullExpressionValue(simpleType3, "{\n                trace.\u2026g context\")\n            }");
            simpleType2 = simpleType3;
        } else if (unwrappedType instanceof SimpleType) {
            simpleType2 = (SimpleType)resolvedType;
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Unexpected type: ", resolvedType).toString());
        }
        return simpleType2;
    }

    @NotNull
    public final SimpleType resolveExpandedTypeForTypeAlias(@NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        SimpleType expandedType2 = TypeAliasExpander.Companion.getNON_REPORTING().expandWithoutAbbreviation(typeAliasExpansion, Annotations.Companion.getEMPTY());
        return expandedType2;
    }

    private final KotlinType resolveType(TypeResolutionContext c, KtTypeReference typeReference) {
        boolean bl;
        boolean bl2 = bl = !c.allowBareTypes;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Use resolvePossiblyBareType() when bare types are allowed";
            throw new AssertionError((Object)string2);
        }
        KotlinType kotlinType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "resolvePossiblyBareType(\u2026typeReference).actualType");
        return kotlinType;
    }

    @NotNull
    public final PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        KotlinType cachedType = (KotlinType)c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(cachedType)");
            return possiblyBareType;
        }
        WritableSlice<KtTypeReference, KotlinType> resolvedTypeSlice = c.abbreviated ? BindingContext.ABBREVIATED_TYPE : BindingContext.TYPE;
        Annotations annotations2 = this.resolveTypeAnnotations(c, typeReference);
        PossiblyBareType type2 = this.resolveTypeElement(c, annotations2, typeReference.getModifierList(), typeReference.getTypeElement());
        Iterator<TypeProjection> iterator2 = c.trace;
        Intrinsics.checkNotNullExpressionValue(iterator2, "c.trace");
        BindingTrace bindingTrace = iterator2;
        iterator2 = c.scope;
        Intrinsics.checkNotNullExpressionValue(iterator2, "c.scope");
        BindingContextUtilsKt.recordScope(bindingTrace, (LexicalScope)((Object)iterator2), typeReference);
        if (!type2.isBare()) {
            for (TypeProjection argument2 : type2.getActualType().getArguments()) {
                KotlinType kotlinType = argument2.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "argument.type");
                this.forceResolveTypeContents(kotlinType);
            }
            c.trace.record(resolvedTypeSlice, typeReference, type2.getActualType());
        }
        return type2;
    }

    @NotNull
    public final KtDeclarationModifierList[] getAllModifierLists$frontend(@NotNull KtElementImplStub<?> $this$getAllModifierLists) {
        Intrinsics.checkNotNullParameter($this$getAllModifierLists, "<this>");
        PsiElement[] psiElementArray = $this$getAllModifierLists.getStubOrPsiChildren(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.getArrayFactory());
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getStubOrPsiChildren(KtS\u2026DIFIER_LIST.arrayFactory)");
        return (KtDeclarationModifierList[])psiElementArray;
    }

    private final void checkNonParenthesizedAnnotationsOnFunctionalType(KtFunctionType typeElement, List<? extends KtAnnotationEntry> annotationEntries, BindingTrace trace) {
        PsiElement psiElement;
        ASTNode aSTNode;
        PsiElement psiElement2;
        KtAnnotationEntry lastAnnotationEntry = CollectionsKt.lastOrNull(annotationEntries);
        KtAnnotationEntry ktAnnotationEntry = lastAnnotationEntry;
        boolean isAnnotationsGroupedUsingBrackets = Intrinsics.areEqual(ktAnnotationEntry == null ? null : ((psiElement2 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(ktAnnotationEntry, false, 1, null)) == null ? null : ((aSTNode = psiElement2.getNode()) == null ? null : aSTNode.getElementType())), KtTokens.RBRACKET);
        psiElement2 = lastAnnotationEntry;
        boolean hasAnnotationParentheses = (psiElement2 == null ? null : ((KtAnnotationEntry)psiElement2).getValueArgumentList()) != null;
        boolean isFunctionalTypeStartingWithParentheses = typeElement.getFirstChild() instanceof KtParameterList;
        PsiElement $this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u2d1 = psiElement = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default(typeElement, false, 1, null);
        boolean bl = false;
        boolean hasSuspendModifierBeforeParentheses = $this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u2d1 instanceof KtDeclarationModifierList && PsiUtilsKt.hasSuspendModifier((KtModifierList)$this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u2d1);
        if (lastAnnotationEntry != null && isFunctionalTypeStartingWithParentheses && !hasAnnotationParentheses && !isAnnotationsGroupedUsingBrackets && !hasSuspendModifierBeforeParentheses) {
            trace.report(Errors.NON_PARENTHESIZED_ANNOTATIONS_ON_FUNCTIONAL_TYPES.on(lastAnnotationEntry));
        }
    }

    private final Annotations resolveTypeAnnotations(TypeResolutionContext c, KtElementImplStub<?> modifierListsOwner) {
        KtDeclarationModifierList[] modifierLists = this.getAllModifierLists$frontend(modifierListsOwner);
        Annotations result2 = Annotations.Companion.getEMPTY();
        boolean isSplitModifierList = false;
        if (!this.isNonParenthesizedAnnotationsOnFunctionalTypesEnabled) {
            List<KtAnnotationEntry> annotationEntries;
            KtModifierList ktModifierList;
            KtElementImplStub<?> ktElementImplStub = modifierListsOwner;
            KtTypeElement targetType = ktElementImplStub instanceof KtNullableType ? ((KtNullableType)modifierListsOwner).getInnerType() : (ktElementImplStub instanceof KtTypeReference ? ((KtTypeReference)modifierListsOwner).getTypeElement() : null);
            KtElementImplStub<?> ktElementImplStub2 = modifierListsOwner;
            Object object = ktElementImplStub2 instanceof KtNullableType ? ((ktModifierList = ((KtNullableType)modifierListsOwner).getModifierList()) == null ? null : ktModifierList.getAnnotationEntries()) : (annotationEntries = ktElementImplStub2 instanceof KtTypeReference ? ((KtTypeReference)modifierListsOwner).getAnnotationEntries() : null);
            if (targetType instanceof KtFunctionType && ((KtFunctionType)targetType).getStub() == null && annotationEntries != null) {
                KtFunctionType ktFunctionType = (KtFunctionType)targetType;
                ktElementImplStub2 = c.trace;
                Intrinsics.checkNotNullExpressionValue(ktElementImplStub2, "c.trace");
                this.checkNonParenthesizedAnnotationsOnFunctionalType(ktFunctionType, annotationEntries, (BindingTrace)((Object)ktElementImplStub2));
            }
        }
        KtDeclarationModifierList[] ktDeclarationModifierListArray = modifierLists;
        int n = 0;
        int n2 = ktDeclarationModifierListArray.length;
        while (n < n2) {
            KtDeclarationModifierList modifierList2 = ktDeclarationModifierListArray[n];
            ++n;
            if (isSplitModifierList) {
                c.trace.report(Errors.MODIFIER_LIST_NOT_ALLOWED.on((KtModifierList)((PsiElement)modifierList2)));
            }
            Object object = c.scope;
            Intrinsics.checkNotNullExpressionValue(object, "c.scope");
            LexicalScope lexicalScope = object;
            object = modifierList2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(object, "modifierList.annotationEntries");
            Object object2 = object;
            object = c.trace;
            Intrinsics.checkNotNullExpressionValue(object, "c.trace");
            Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(lexicalScope, (List<KtAnnotationEntry>)object2, (BindingTrace)object);
            result2 = AnnotationsKt.composeAnnotations(result2, annotations2);
            isSplitModifierList = true;
        }
        return result2;
    }

    private final void forceResolveTypeContents(KotlinType type2) {
        type2.getAnnotations();
        if (FlexibleTypesKt.isFlexible(type2)) {
            this.forceResolveTypeContents(FlexibleTypesKt.asFlexibleType(type2).getLowerBound());
            this.forceResolveTypeContents(FlexibleTypesKt.asFlexibleType(type2).getUpperBound());
        } else {
            type2.getConstructor();
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "projection.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
    }

    private final PossiblyBareType resolveTypeElement(TypeResolutionContext c, Annotations annotations2, KtModifierList outerModifierList, KtTypeElement typeElement) {
        Object object;
        Object object2;
        Ref.ObjectRef<PossiblyBareType> result2 = new Ref.ObjectRef<PossiblyBareType>();
        KtModifierList ktModifierList = outerModifierList;
        boolean hasSuspendModifier = ktModifierList == null ? false : ktModifierList.hasModifier(KtTokens.SUSPEND_KEYWORD);
        Lazy suspendModifier$delegate = LazyKt.lazy((Function0)new Function0<PsiElement>(outerModifierList){
            final /* synthetic */ KtModifierList $outerModifierList;
            {
                this.$outerModifierList = $outerModifierList;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                KtModifierList ktModifierList = this.$outerModifierList;
                return ktModifierList == null ? null : ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD);
            }
        });
        if (hasSuspendModifier && !this.canHaveFunctionTypeModifiers(typeElement)) {
            BindingTrace bindingTrace = c.trace;
            PsiElement psiElement = TypeResolver.resolveTypeElement$lambda-2(suspendModifier$delegate);
            Intrinsics.checkNotNull(psiElement);
            bindingTrace.report(Errors.WRONG_MODIFIER_TARGET.on(psiElement, KtTokens.SUSPEND_KEYWORD, "non-functional type"));
        } else if (hasSuspendModifier) {
            object2 = c.trace;
            Intrinsics.checkNotNullExpressionValue(object2, "c.trace");
            DiagnosticSink diagnosticSink = (DiagnosticSink)object2;
            PsiElement psiElement = TypeResolver.resolveTypeElement$lambda-2(suspendModifier$delegate);
            Intrinsics.checkNotNull(psiElement);
            object2 = psiElement;
            Intrinsics.checkNotNullExpressionValue(object2, "suspendModifier!!");
            CoroutineCallCheckerKt.checkCoroutinesFeature(this.languageVersionSettings, diagnosticSink, (PsiElement)object2);
        }
        object2 = typeElement;
        if (object2 != null) {
            object2.accept(new KtVisitorVoid(this, c, result2, annotations2, outerModifierList, hasSuspendModifier){
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ Ref.ObjectRef<PossiblyBareType> $result;
                final /* synthetic */ Annotations $annotations;
                final /* synthetic */ KtModifierList $outerModifierList;
                final /* synthetic */ boolean $hasSuspendModifier;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                    this.$result = $result;
                    this.$annotations = $annotations;
                    this.$outerModifierList = $outerModifierList;
                    this.$hasSuspendModifier = $hasSuspendModifier;
                }

                public void visitUserType(@NotNull KtUserType type2) {
                    Intrinsics.checkNotNullParameter(type2, "type");
                    Object object = this.$c.scope;
                    Intrinsics.checkNotNullExpressionValue(object, "c.scope");
                    LexicalScope lexicalScope = object;
                    object = this.$c.trace;
                    Intrinsics.checkNotNullExpressionValue(object, "c.trace");
                    QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult = this.this$0.resolveDescriptorForType(lexicalScope, type2, (BindingTrace)object, this.$c.isDebuggerContext);
                    ClassifierDescriptor classifier2 = qualifierResolutionResult.getClassifierDescriptor();
                    if (classifier2 == null) {
                        List<TypeProjection> arguments2 = this.this$0.resolveTypeProjections(this.$c, ErrorUtils.createErrorType("No type").getConstructor(), qualifierResolutionResult.getAllProjections());
                        this.$result.element = PossiblyBareType.type(ErrorUtils.createUnresolvedType(DebugTextUtilKt.getDebugText(type2), arguments2));
                        return;
                    }
                    KtSimpleNameExpression ktSimpleNameExpression = type2.getReferenceExpression();
                    if (ktSimpleNameExpression == null) {
                        return;
                    }
                    Object object2 = ktSimpleNameExpression;
                    KtSimpleNameExpression referenceExpression = object2;
                    object2 = this.$c.trace;
                    Intrinsics.checkNotNullExpressionValue(object2, "c.trace");
                    ReservedCheckingKt.checkReservedYield(referenceExpression, (DiagnosticSink)object2);
                    this.$c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifier2);
                    this.$result.element = this.this$0.resolveTypeForClassifier(this.$c, classifier2, qualifierResolutionResult, type2, this.$annotations);
                }

                public void visitNullableType(@NotNull KtNullableType nullableType) {
                    Intrinsics.checkNotNullParameter(nullableType, "nullableType");
                    KtTypeElement innerType = nullableType.getInnerType();
                    PossiblyBareType baseType2 = this.createTypeFromInner(nullableType, nullableType.getModifierList(), innerType);
                    if (!baseType2.isBare() && baseType2.getActualType() instanceof DefinitelyNotNullType) {
                        this.$c.trace.report(Errors.NULLABLE_ON_DEFINITELY_NOT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    if (baseType2.isNullable() || innerType instanceof KtNullableType || innerType instanceof KtDynamicType) {
                        this.$c.trace.report(Errors.REDUNDANT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    this.$result.element = baseType2.makeNullable();
                }

                private final PossiblyBareType createTypeFromInner(KtTypeElement typeElement, KtModifierList innerModifierList, KtTypeElement innerType) {
                    if (innerModifierList != null && this.$outerModifierList != null) {
                        this.$c.trace.report(Errors.MODIFIER_LIST_NOT_ALLOWED.on((KtModifierList)((PsiElement)innerModifierList)));
                    }
                    Annotations innerAnnotations = AnnotationsKt.composeAnnotations(this.$annotations, TypeResolver.access$resolveTypeAnnotations(this.this$0, this.$c, (KtElementImplStub)((Object)typeElement)));
                    KtModifierList ktModifierList = this.$outerModifierList;
                    return TypeResolver.access$resolveTypeElement(this.this$0, this.$c, innerAnnotations, ktModifierList == null ? innerModifierList : ktModifierList, innerType);
                }

                public void visitIntersectionType(@NotNull KtIntersectionType intersectionType2) {
                    Intrinsics.checkNotNullParameter(intersectionType2, "intersectionType");
                    Object object = intersectionType2.getLeftTypeRef();
                    if (object == null) {
                        return;
                    }
                    Object it = object = this.this$0.resolvePossiblyBareType(this.$c, (KtTypeReference)object);
                    boolean bl = false;
                    if (((PossiblyBareType)it).isBare()) {
                        throw new IllegalStateException("There should not be bare types for intersections".toString());
                    }
                    KotlinType kotlinType = ((PossiblyBareType)it).getActualType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "resolvePossiblyBareType(\u2026      }\n                }");
                    KotlinType leftType = kotlinType;
                    this.$result.element = PossiblyBareType.type(leftType);
                    Object object2 = intersectionType2.getRightTypeRef();
                    if (object2 == null) {
                        return;
                    }
                    Object it2 = object2 = this.this$0.resolvePossiblyBareType(this.$c, (KtTypeReference)object2);
                    boolean bl2 = false;
                    if (((PossiblyBareType)it2).isBare()) {
                        throw new IllegalStateException("There should not be bare types for intersections".toString());
                    }
                    object = ((PossiblyBareType)it2).getActualType();
                    Intrinsics.checkNotNullExpressionValue(object, "resolvePossiblyBareType(\u2026      }\n                }");
                    Object rightType = object;
                    if (!TypeResolver.access$getLanguageVersionSettings$p(this.this$0).supportsFeature(LanguageFeature.DefinitelyNonNullableTypes)) {
                        this.$c.trace.report(Errors.UNSUPPORTED_FEATURE.on(intersectionType2, TuplesKt.to(LanguageFeature.DefinitelyNonNullableTypes, TypeResolver.access$getLanguageVersionSettings$p(this.this$0))));
                        return;
                    }
                    if (!TypeUtilsKt.isTypeParameter(leftType) || leftType.isMarkedNullable() || !TypeUtils.isNullableType(leftType)) {
                        BindingTrace bindingTrace = this.$c.trace;
                        KtTypeReference ktTypeReference = intersectionType2.getLeftTypeRef();
                        Intrinsics.checkNotNull(ktTypeReference);
                        bindingTrace.report(Errors.INCORRECT_LEFT_COMPONENT_OF_INTERSECTION.on((KtTypeReference)((PsiElement)ktTypeReference)));
                        return;
                    }
                    if (!TypeUtilsKt.isAny((KotlinType)rightType)) {
                        BindingTrace bindingTrace = this.$c.trace;
                        KtTypeReference ktTypeReference = intersectionType2.getRightTypeRef();
                        Intrinsics.checkNotNull(ktTypeReference);
                        bindingTrace.report(Errors.INCORRECT_RIGHT_COMPONENT_OF_INTERSECTION.on((KtTypeReference)((PsiElement)ktTypeReference)));
                        return;
                    }
                    object2 = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, leftType.unwrap(), false, 2, null);
                    if (object2 == null) {
                        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(leftType);
                        Intrinsics.checkNotNull(typeParameterDescriptor);
                        throw new IllegalStateException(Intrinsics.stringPlus("Definitely not-nullable type is not created for type parameter with nullable upper bound ", typeParameterDescriptor).toString());
                    }
                    Object definitelyNotNullType = object2;
                    this.$result.element = PossiblyBareType.type((KotlinType)definitelyNotNullType);
                }

                public void visitFunctionType(@NotNull KtFunctionType type2) {
                    Object object;
                    Object object2;
                    VariableDescriptor it;
                    Collection<KotlinType> collection;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    KotlinType kotlinType;
                    Object object3;
                    KotlinType kotlinType2;
                    Intrinsics.checkNotNullParameter(type2, "type");
                    KtTypeReference receiverTypeRef = type2.getReceiverTypeReference();
                    if (receiverTypeRef == null) {
                        kotlinType2 = null;
                    } else {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue(typeResolutionContext, "c.noBareTypes()");
                        kotlinType2 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, receiverTypeRef);
                    }
                    KotlinType receiverType = kotlinType2;
                    List<KtParameter> list2 = type2.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, "type.parameters");
                    List<VariableDescriptor> parameterDescriptors = this.resolveParametersOfFunctionType(list2);
                    this.checkParametersOfFunctionType(parameterDescriptors);
                    KtTypeReference returnTypeRef = type2.getReturnTypeReference();
                    if (returnTypeRef != null) {
                        object3 = this.$c.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue(object3, "c.noBareTypes()");
                        kotlinType = TypeResolver.access$resolveType(this.this$0, (TypeResolutionContext)object3, returnTypeRef);
                    } else {
                        object3 = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType();
                        Intrinsics.checkNotNullExpressionValue(object3, "moduleDescriptor.builtIns.unitType");
                        kotlinType = (KotlinType)object3;
                    }
                    KotlinType returnType2 = kotlinType;
                    KtParameterList parameterList = type2.getParameterList();
                    Object object4 = parameterList;
                    if ((object4 == null ? null : (KotlinPlaceHolderStub)((StubBasedPsiElementBase)object4).getStub()) == null) {
                        object4 = parameterList;
                        PsiElement psiElement = object4 == null ? null : ((KtParameterList)object4).getTrailingComma();
                        object4 = this.$c.trace;
                        Intrinsics.checkNotNullExpressionValue(object4, "c.trace");
                        TrailingCommaChecker.INSTANCE.check(psiElement, (BindingTrace)object4, TypeResolver.access$getLanguageVersionSettings$p(this.this$0));
                    }
                    object4 = parameterDescriptors;
                    KotlinType kotlinType3 = receiverType;
                    Annotations annotations2 = this.$annotations;
                    KotlinBuiltIns kotlinBuiltIns = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns();
                    Ref.ObjectRef<PossiblyBareType> objectRef = this.$result;
                    boolean $i$f$map = false;
                    void var10_14 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        VariableDescriptor variableDescriptor = (VariableDescriptor)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getType();
                        Intrinsics.checkNotNullExpressionValue(object2, "it.type");
                        object = object2;
                        collection.add((KotlinType)object);
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = parameterDescriptors;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (VariableDescriptor)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getName();
                        Intrinsics.checkNotNullExpressionValue(object2, "it.name");
                        Object object5 = object2;
                        object.add(object5);
                    }
                    object = (List)destination$iv$iv;
                    objectRef.element = PossiblyBareType.type(FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType3, collection, (List<Name>)object, returnType2, this.$hasSuspendModifier));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParametersOfFunctionType(List<? extends VariableDescriptor> parameterDescriptors) {
                    Object list$iv$iv;
                    void $this$groupByTo$iv$iv;
                    VariableDescriptor it;
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = parameterDescriptors;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (VariableDescriptor)element$iv$iv;
                        boolean bl = false;
                        if (!(!it.getName().isSpecial())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$groupBy$iv = (List)destination$iv$iv;
                    boolean $i$f$groupBy = false;
                    $this$filterTo$iv$iv = $this$groupBy$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    Iterator<T> iterator2 = $this$groupByTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object object;
                        T element$iv$iv;
                        element$iv$iv = iterator2.next();
                        it = (VariableDescriptor)element$iv$iv;
                        boolean bl = false;
                        Name key$iv$iv = it.getName();
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Object parametersByName = destination$iv$iv;
                    for (List parametersGroup : parametersByName.values()) {
                        if (parametersGroup.size() < 2) continue;
                        for (VariableDescriptor parameter : parametersGroup) {
                            Object object;
                            list$iv$iv = parameter.getSource();
                            Intrinsics.checkNotNullExpressionValue(list$iv$iv, "parameter.source");
                            PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)list$iv$iv);
                            if (psiElement == null) {
                                object = null;
                            } else {
                                PsiElement $this$safeAs$iv = psiElement;
                                boolean $i$f$safeAs = false;
                                PsiElement psiElement2 = $this$safeAs$iv;
                                if (!(psiElement2 instanceof KtParameter)) {
                                    psiElement2 = null;
                                }
                                object = iterator2 = (KtParameter)psiElement2;
                            }
                            if (iterator2 == null) continue;
                            Iterator<T> ktParameter = iterator2;
                            this.$c.trace.report(Errors.DUPLICATE_PARAMETER_NAME_IN_FUNCTION_TYPE.on((KtParameter)((PsiElement)((Object)ktParameter))));
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private final List<VariableDescriptor> resolveParametersOfFunctionType(List<? extends KtParameter> parameters2) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable $this$forEach$iv;
                    Iterable iterable = parameters2;
                    TypeResolver typeResolver = this.this$0;
                    TypeResolutionContext typeResolutionContext = this.$c;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl = false;
                        IdentifierChecker identifierChecker = TypeResolver.access$getIdentifierChecker$p(typeResolver);
                        KtDeclaration ktDeclaration = it;
                        BindingTrace bindingTrace = typeResolutionContext.trace;
                        Intrinsics.checkNotNullExpressionValue(bindingTrace, "c.trace");
                        identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
                        this.checkParameterInFunctionType(it);
                    }
                    $this$forEach$iv = parameters2;
                    typeResolver = this.this$0;
                    typeResolutionContext = this.$c;
                    boolean $i$f$map = false;
                    Iterator<T> iterator2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void parameter;
                        KtParameter ktParameter = (KtParameter)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Object object = typeResolutionContext.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue(object, "c.noBareTypes()");
                        TypeResolutionContext typeResolutionContext2 = object;
                        KtTypeReference ktTypeReference = parameter.getTypeReference();
                        Intrinsics.checkNotNull(ktTypeReference);
                        object = ktTypeReference;
                        Intrinsics.checkNotNullExpressionValue(object, "parameter.typeReference!!");
                        KotlinType parameterType = TypeResolver.access$resolveType(typeResolver, typeResolutionContext2, (KtTypeReference)object);
                        DeclarationDescriptor declarationDescriptor = typeResolutionContext.scope.getOwnerDescriptor();
                        AnnotationResolver annotationResolver = TypeResolver.access$getAnnotationResolver$p(typeResolver);
                        Object object2 = typeResolutionContext.scope;
                        Intrinsics.checkNotNullExpressionValue(object2, "c.scope");
                        LexicalScope lexicalScope = object2;
                        KtModifierList ktModifierList = parameter.getModifierList();
                        object2 = typeResolutionContext.trace;
                        Intrinsics.checkNotNullExpressionValue(object2, "c.trace");
                        Annotations annotations2 = annotationResolver.resolveAnnotationsWithoutArguments(lexicalScope, ktModifierList, (BindingTrace)object2);
                        object2 = parameter.getNameAsSafeName();
                        Intrinsics.checkNotNullExpressionValue(object2, "parameter.nameAsSafeName");
                        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000S\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ5\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"org/jetbrains/kotlin/resolve/TypeResolver$resolveTypeElement$1$resolveParametersOfFunctionType$ParameterOfFunctionTypeDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorImpl;", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "name", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/SourceElement;)V", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getCompileTimeInitializer", "", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "isLateInit", "", "isVar", "substitute", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "frontend"})
                        public final class ParameterOfFunctionTypeDescriptor
                        extends VariableDescriptorImpl {
                            public ParameterOfFunctionTypeDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @NotNull KotlinType type2, @NotNull SourceElement source) {
                                Intrinsics.checkNotNullParameter(containingDeclaration, "containingDeclaration");
                                Intrinsics.checkNotNullParameter(annotations2, "annotations");
                                Intrinsics.checkNotNullParameter(name, "name");
                                Intrinsics.checkNotNullParameter(type2, "type");
                                Intrinsics.checkNotNullParameter(source, "source");
                                super(containingDeclaration, annotations2, name, type2, source);
                            }

                            @NotNull
                            public DescriptorVisibility getVisibility() {
                                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
                                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "LOCAL");
                                return descriptorVisibility;
                            }

                            @Nullable
                            public VariableDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
                                Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
                                throw new UnsupportedOperationException(Intrinsics.stringPlus("Should not be called for descriptor of type ", this.getClass()));
                            }

                            public boolean isVar() {
                                return false;
                            }

                            public boolean isLateInit() {
                                return false;
                            }

                            @Nullable
                            public Void getCompileTimeInitializer() {
                                return null;
                            }

                            public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
                                Intrinsics.checkNotNullParameter(visitor2, "visitor");
                                return visitor2.visitVariableDescriptor(this, data2);
                            }
                        }
                        ParameterOfFunctionTypeDescriptor descriptor2 = new ParameterOfFunctionTypeDescriptor(declarationDescriptor, annotations2, (Name)object2, parameterType, KotlinSourceElementKt.toSourceElement((KtPureElement)parameter));
                        typeResolutionContext.trace.record(BindingContext.VALUE_PARAMETER, parameter, descriptor2);
                        ParameterOfFunctionTypeDescriptor parameterOfFunctionTypeDescriptor = descriptor2;
                        collection.add(parameterOfFunctionTypeDescriptor);
                    }
                    return (List)destination$iv$iv;
                }

                public void visitDynamicType(@NotNull KtDynamicType type2) {
                    Intrinsics.checkNotNullParameter(type2, "type");
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getDynamicCallableDescriptors$p(this.this$0).getDynamicType().replaceAnnotations(this.$annotations));
                    if (!TypeResolver.access$getDynamicTypesSettings$p(this.this$0).getDynamicTypesAllowed()) {
                        this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Dynamic types are not supported in this context"));
                    }
                }

                public void visitSelfType(@NotNull KtSelfType type2) {
                    Intrinsics.checkNotNullParameter(type2, "type");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Self-types are not supported"));
                }

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(element, "Self-types are not supported yet"));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParameterInFunctionType(KtParameter param) {
                    PsiElement psiElement;
                    Object object;
                    KtModifierList modifierList2;
                    if (param.hasDefaultValue()) {
                        BindingTrace bindingTrace = this.$c.trace;
                        KtExpression ktExpression = param.getDefaultValue();
                        Intrinsics.checkNotNull(ktExpression);
                        bindingTrace.report(Errors.UNSUPPORTED.on(ktExpression, "default value of parameter in function type"));
                    }
                    if (param.getName() != null) {
                        for (KtAnnotationEntry psiElement2 : param.getAnnotationEntries()) {
                            this.$c.trace.report(Errors.UNSUPPORTED.on(psiElement2, "annotation on parameter in function type"));
                        }
                    }
                    if ((modifierList2 = param.getModifierList()) != null) {
                        void $this$mapNotNullTo$iv$iv;
                        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
                        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordTokenArray, "MODIFIER_KEYWORDS_ARRAY");
                        Object[] objectArray = ktModifierKeywordTokenArray;
                        boolean $i$f$mapNotNull = false;
                        Object[] objectArray2 = objectArray;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                            PsiElement psiElement3;
                            void element$iv$iv = element$iv$iv$iv;
                            boolean bl = false;
                            KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
                            boolean bl2 = false;
                            PsiElement psiElement4 = modifierList2.getModifier(it);
                            if (psiElement4 == null) continue;
                            PsiElement it$iv$iv = psiElement3 = psiElement4;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        Iterable iterable = (List)destination$iv$iv;
                        object = this.$c;
                        boolean $i$f$forEach2 = false;
                        for (E element$iv : iterable) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl = false;
                            ((TypeResolutionContext)object).trace.report(Errors.UNSUPPORTED.on(it, "modifier on parameter in function type"));
                        }
                    }
                    if ((psiElement = param.getValOrVarKeyword()) != null) {
                        object = psiElement;
                        TypeResolutionContext typeResolutionContext = this.$c;
                        PsiElement it = object;
                        boolean bl = false;
                        typeResolutionContext.trace.report(Errors.UNSUPPORTED.on(it, "val or var on parameter in function type"));
                    }
                }
            });
        }
        object2 = (PossiblyBareType)result2.element;
        if (object2 == null) {
            KtTypeElement ktTypeElement = typeElement;
            PossiblyBareType possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorType(ktTypeElement == null ? "No type element" : DebugTextUtilKt.getDebugText(ktTypeElement)));
            Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(ErrorUtils.createEr\u2026() ?: \"No type element\"))");
            object = possiblyBareType;
        } else {
            object = object2;
        }
        return object;
    }

    private final boolean canHaveFunctionTypeModifiers(KtTypeElement $this$canHaveFunctionTypeModifiers) {
        return $this$canHaveFunctionTypeModifiers instanceof KtFunctionType;
    }

    private final KotlinType resolveTypeForTypeParameter(TypeResolutionContext c, Annotations annotations2, TypeParameterDescriptor typeParameter, KtSimpleNameExpression referenceExpression, KtTypeArgumentList typeArgumentList) {
        KotlinType kotlinType;
        MemberScope scopeForTypeParameter = this.getScopeForTypeParameter(c, typeParameter);
        if (typeArgumentList != null) {
            TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
            List<KtTypeProjection> list2 = typeArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "typeArgumentList.arguments");
            this.resolveTypeProjections(c, typeConstructor2, list2);
            c.trace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)typeArgumentList), "for type parameters"));
        }
        Object object = typeParameter.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(object, "typeParameter.containingDeclaration");
        DeclarationDescriptor containing = object;
        if (containing instanceof ClassDescriptor) {
            DescriptorResolver.checkHasOuterClassInstance(c.scope, c.trace, referenceExpression, (ClassDescriptor)containing);
        }
        if (scopeForTypeParameter instanceof ErrorUtils.ErrorScope) {
            object = ErrorUtils.createErrorType("?");
            Intrinsics.checkNotNullExpressionValue(object, "createErrorType(\"?\")");
            kotlinType = (KotlinType)object;
        } else {
            object = typeParameter.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(object, "typeParameter.typeConstructor");
            kotlinType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, (TypeConstructor)object, CollectionsKt.emptyList(), false, scopeForTypeParameter);
        }
        return kotlinType;
    }

    private final MemberScope getScopeForTypeParameter(TypeResolutionContext c, TypeParameterDescriptor typeParameterDescriptor) {
        return c.checkBounds ? TypeIntersector.getUpperBoundsAsType(typeParameterDescriptor).getMemberScope() : (MemberScope)new LazyScopeAdapter(null, new Function0<MemberScope>(typeParameterDescriptor){
            final /* synthetic */ TypeParameterDescriptor $typeParameterDescriptor;
            {
                this.$typeParameterDescriptor = $typeParameterDescriptor;
                super(0);
            }

            @NotNull
            public final MemberScope invoke() {
                return TypeIntersector.getUpperBoundsAsType(this.$typeParameterDescriptor).getMemberScope();
            }
        }, 1, null);
    }

    @NotNull
    public final PossiblyBareType resolveTypeForClassifier(@NotNull TypeResolutionContext c, @NotNull ClassifierDescriptor descriptor2, @NotNull QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult, @NotNull KtElement element, @NotNull Annotations annotations2) {
        PossiblyBareType possiblyBareType;
        Object object;
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(qualifierResolutionResult, "qualifierResolutionResult");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        List<QualifiedExpressionResolver.ExpressionQualifierPart> qualifierParts = qualifierResolutionResult.getQualifierParts();
        if (element instanceof KtUserType && ((KtUserType)element).getStub() == null) {
            object = ((KtUserType)element).getTypeArgumentList();
            PsiElement psiElement = object == null ? null : ((KtTypeArgumentList)object).getTrailingComma();
            object = c.trace;
            Intrinsics.checkNotNullExpressionValue(object, "c.trace");
            TrailingCommaChecker.INSTANCE.check(psiElement, (BindingTrace)object, this.languageVersionSettings);
        }
        if ((object = descriptor2) instanceof TypeParameterDescriptor) {
            boolean bl;
            boolean bl2 = bl = qualifierParts.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Type parameter can be resolved only by it's short name, but '" + element.getText() + "' is contradiction with " + qualifierParts.size() + " qualifier parts";
                throw new AssertionError((Object)string2);
            }
            QualifiedExpressionResolver.ExpressionQualifierPart qualifierPart = CollectionsKt.single(qualifierParts);
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(this.resolveTypeForTypeParameter(c, annotations2, (TypeParameterDescriptor)descriptor2, qualifierPart.getExpression(), qualifierPart.getTypeArguments()));
            Intrinsics.checkNotNullExpressionValue(possiblyBareType2, "{\n                assert\u2026Arguments))\n            }");
            possiblyBareType = possiblyBareType2;
        } else if (object instanceof ClassDescriptor) {
            possiblyBareType = this.resolveTypeForClass(c, annotations2, (ClassDescriptor)descriptor2, element, qualifierResolutionResult);
        } else if (object instanceof TypeAliasDescriptor) {
            possiblyBareType = this.resolveTypeForTypeAlias(c, annotations2, (TypeAliasDescriptor)descriptor2, element, qualifierResolutionResult);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Unexpected classifier type: ", descriptor2.getClass()).toString());
        }
        return possiblyBareType;
    }

    private final PossiblyBareType resolveTypeForClass(TypeResolutionContext c, Annotations annotations2, ClassDescriptor classDescriptor, KtElement element, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        boolean bl;
        boolean bl2;
        TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "classDescriptor.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair = typeConstructor3.getParameters();
        Intrinsics.checkNotNullExpressionValue(pair, "typeConstructor.parameters");
        List<TypeParameterDescriptor> parameters2 = pair;
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && this.isPossibleToSpecifyTypeArgumentsFor(classDescriptor)) {
            pair = PossiblyBareType.bare(typeConstructor3, false);
            Intrinsics.checkNotNullExpressionValue(pair, "bare(typeConstructor, false)");
            return pair;
        }
        if (ErrorUtils.isError(classDescriptor)) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair2 = this.collectArgumentsForClassifierTypeConstructor(c, classDescriptor, qualifierResolutionResult.getQualifierParts());
        if (pair2 == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        pair = pair2;
        List<KtTypeProjection> collectedArgumentAsTypeProjections = pair.component1();
        List<TypeProjection> argumentsForOuterClass = pair.component2();
        boolean bl3 = bl2 = collectedArgumentAsTypeProjections.size() <= parameters2.size();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-TypeResolver$resolveTypeForClass$32 = false;
            String $i$a$-assert-TypeResolver$resolveTypeForClass$32 = "Collected arguments count should be not greater then parameters count, but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + element.getText();
            throw new AssertionError((Object)$i$a$-assert-TypeResolver$resolveTypeForClass$32);
        }
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, collectedArgumentAsTypeProjections);
        List<TypeProjection> arguments2 = this.buildFinalArgumentList(argumentsFromUserType, argumentsForOuterClass, parameters2);
        boolean bl4 = bl = arguments2.size() == parameters2.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TypeResolver$resolveTypeForClass$42 = false;
            String $i$a$-assert-TypeResolver$resolveTypeForClass$42 = "Collected arguments count should be equal to parameters count, but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + element.getText();
            throw new AssertionError((Object)$i$a$-assert-TypeResolver$resolveTypeForClass$42);
        }
        SimpleType resultingType = KotlinTypeFactory.simpleNotNullType(annotations2, classDescriptor, arguments2);
        KotlinType $i$a$-assert-TypeResolver$resolveTypeForClass$42 = this.typeTransformerForTests.transformType(resultingType);
        if ($i$a$-assert-TypeResolver$resolveTypeForClass$42 != null) {
            KotlinType kotlinType;
            KotlinType it = kotlinType = $i$a$-assert-TypeResolver$resolveTypeForClass$42;
            boolean bl5 = false;
            PossiblyBareType possiblyBareType = PossiblyBareType.type(it);
            Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(it)");
            return possiblyBareType;
        }
        if (this.shouldCheckBounds(c, resultingType)) {
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(resultingType);
            Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(resultingType)");
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            int n = 0;
            int n2 = parameters2.size();
            while (n < n2) {
                int i = n++;
                TypeParameterDescriptor parameter = parameters2.get(i);
                KotlinType kotlinType = arguments2.get(i).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "arguments[i].type");
                KotlinType argument2 = kotlinType;
                Object object = CollectionsKt.getOrNull(collectedArgumentAsTypeProjections, i);
                KtTypeReference typeReference = object == null ? null : ((KtTypeProjection)object).getTypeReference();
                if (typeReference == null) continue;
                Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                object = c.trace;
                Intrinsics.checkNotNullExpressionValue(object, "c.trace");
                UpperBoundChecker.checkBounds$default(this.upperBoundChecker, typeReference, argument2, parameter, substitutor2, (BindingTrace)object, null, 32, null);
            }
        }
        if (TypeUtilsKt.isArrayOfNothing(resultingType)) {
            c.trace.report(Errors.UNSUPPORTED.on(element, "Array<Nothing> is illegal"));
        }
        PossiblyBareType possiblyBareType = PossiblyBareType.type(resultingType);
        Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(resultingType)");
        return possiblyBareType;
    }

    private final List<TypeProjection> buildFinalArgumentList(List<? extends TypeProjection> argumentsFromUserType, List<? extends TypeProjection> argumentsForOuterClass, List<? extends TypeParameterDescriptor> parameters2) {
        List<? extends TypeProjection> list2 = argumentsForOuterClass;
        return CollectionsKt.plus((Collection)argumentsFromUserType, (Iterable)(list2 == null ? this.appendDefaultArgumentsForLocalClassifier(argumentsFromUserType.size(), parameters2) : list2));
    }

    private final boolean shouldCheckBounds(TypeResolutionContext c, KotlinType inType) {
        if (!c.checkBounds) {
            return false;
        }
        if (TypeUtilsKt.containsTypeAliasParameters(inType)) {
            return false;
        }
        return !c.abbreviated || !TypeUtilsKt.containsTypeAliases(inType);
    }

    private final PossiblyBareType resolveTypeForTypeAlias(TypeResolutionContext c, Annotations annotations2, TypeAliasDescriptor descriptor2, KtElement type2, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        Object object;
        ClassDescriptor classDescriptor;
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "descriptor.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        if (ErrorUtils.isError(descriptor2)) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            c.trace.report(Errors.UNSUPPORTED_FEATURE.on(type2, TuplesKt.to(LanguageFeature.TypeAliases, this.languageVersionSettings)));
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        List<TypeParameterDescriptor> list2 = typeConstructor3.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "typeConstructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list2;
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && this.isPossibleToSpecifyTypeArgumentsFor(descriptor2) && (classDescriptor = descriptor2.getClassDescriptor()) != null && this.canBeUsedAsBareType(descriptor2)) {
            ClassDescriptor classDescriptor2 = descriptor2.getClassDescriptor();
            Intrinsics.checkNotNull(classDescriptor2);
            PossiblyBareType possiblyBareType = PossiblyBareType.bare(classDescriptor2.getTypeConstructor(), TypeUtils.isNullableType(descriptor2.getExpandedType()));
            Intrinsics.checkNotNullExpressionValue(possiblyBareType, "bare(descriptor.classDes\u2026descriptor.expandedType))");
            return possiblyBareType;
        }
        Object object2 = CollectionsKt.lastOrNull(qualifierResolutionResult.getQualifierParts());
        if (object2 == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        QualifiedExpressionResolver.ExpressionQualifierPart typeAliasQualifierPart = object2;
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair = this.collectArgumentsForClassifierTypeConstructor(c, descriptor2, qualifierResolutionResult.getQualifierParts());
        if (pair == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        object2 = pair;
        List argumentElementsFromUserType = (List)((Pair)object2).component1();
        List argumentsForOuterClass = (List)((Pair)object2).component2();
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, argumentElementsFromUserType);
        List<TypeProjection> arguments2 = this.buildFinalArgumentList(argumentsFromUserType, argumentsForOuterClass, parameters2);
        Object object3 = c.trace;
        Intrinsics.checkNotNullExpressionValue(object3, "c.trace");
        BindingTrace bindingTrace = object3;
        object3 = typeAliasQualifierPart.getTypeArguments();
        KtElement ktElement = object3 == null ? (KtElement)typeAliasQualifierPart.getExpression() : (KtElement)object3;
        object3 = descriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(object3, "descriptor.declaredTypeParameters");
        TracingTypeAliasExpansionReportStrategy reportStrategy = new TracingTypeAliasExpansionReportStrategy(bindingTrace, type2, ktElement, descriptor2, (List<? extends TypeParameterDescriptor>)object3, argumentElementsFromUserType, this.upperBoundChecker);
        if (parameters2.size() != arguments2.size()) {
            reportStrategy.wrongNumberOfTypeArguments(descriptor2, parameters2.size());
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        if (c.abbreviated) {
            TypeConstructor typeConstructor4 = descriptor2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor4, "descriptor.typeConstructor");
            SimpleType abbreviatedType = KotlinTypeFactory.simpleType$default(annotations2, typeConstructor4, arguments2, false, null, 16, null);
            object3 = PossiblyBareType.type(abbreviatedType);
            Intrinsics.checkNotNullExpressionValue(object3, "{\n            val abbrev\u2026bbreviatedType)\n        }");
            object = object3;
        } else {
            TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.create(null, descriptor2, arguments2);
            SimpleType expandedType2 = new TypeAliasExpander(reportStrategy, c.checkBounds).expand(typeAliasExpansion, annotations2);
            object3 = PossiblyBareType.type(expandedType2);
            Intrinsics.checkNotNullExpressionValue(object3, "{\n            val typeAl\u2026e(expandedType)\n        }");
            object = object3;
        }
        return object;
    }

    private final boolean canBeUsedAsBareType(TypeAliasDescriptor descriptor2) {
        SimpleType expandedType2 = descriptor2.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return false;
        }
        ClassDescriptor classDescriptor = descriptor2.getClassDescriptor();
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (!this.isPossibleToSpecifyTypeArgumentsFor(classDescriptor2)) {
            return false;
        }
        LinkedHashSet<TypeParameterDescriptor> usedTypeParameters = new LinkedHashSet<TypeParameterDescriptor>();
        for (TypeProjection argument2 : expandedType2.getArguments()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (argument2.isStarProjection()) continue;
            if (argument2.getProjectionKind() != Variance.INVARIANT) {
                return false;
            }
            ClassifierDescriptor classifierDescriptor = argument2.getType().getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
            if (typeParameterDescriptor == null) {
                return false;
            }
            TypeParameterDescriptor argumentTypeDescriptor = typeParameterDescriptor;
            if (!Intrinsics.areEqual(argumentTypeDescriptor.getContainingDeclaration(), descriptor2)) {
                return false;
            }
            if (usedTypeParameters.contains(argumentTypeDescriptor)) {
                return false;
            }
            usedTypeParameters.add(argumentTypeDescriptor);
        }
        return true;
    }

    private final PossiblyBareType createErrorTypeForTypeConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> arguments2, TypeConstructor typeConstructor2) {
        String string2;
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            string2 = typeConstructor2.toString();
        } else {
            Name name = classifierDescriptor.getName();
            string2 = name.asString();
        }
        PossiblyBareType possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(string2, TypeResolver.resolveTypeProjectionsWithErrorConstructor$default(this, c, arguments2, null, 4, null)));
        Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(\n            ErrorU\u2026)\n            )\n        )");
        return possiblyBareType;
    }

    private final boolean isPossibleToSpecifyTypeArgumentsFor(ClassifierDescriptorWithTypeParameters classifierDescriptor) {
        List<TypeParameterDescriptor> list2 = classifierDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "classifierDescriptor.typeConstructor.parameters");
        TypeParameterDescriptor typeParameterDescriptor = CollectionsKt.firstOrNull(list2);
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor firstTypeParameter = typeParameterDescriptor;
        return firstTypeParameter.getOriginal().getContainingDeclaration() instanceof ClassifierDescriptorWithTypeParameters;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<KtTypeProjection>, List<TypeProjection>> collectArgumentsForClassifierTypeConstructor(TypeResolutionContext c, ClassifierDescriptorWithTypeParameters classifierDescriptor, List<QualifiedExpressionResolver.ExpressionQualifierPart> qualifierParts) {
        Object typeArguments2;
        Object declaredTypeParameters;
        List<ClassifierDescriptorWithTypeParameters> classifierDescriptorChain = this.classifierDescriptorsFromInnerToOuter(classifierDescriptor);
        List<QualifiedExpressionResolver.ExpressionQualifierPart> reversedQualifierParts = CollectionsKt.asReversed(qualifierParts);
        boolean wasStatic = false;
        SmartList result2 = new SmartList();
        int n = 0;
        int classifierChainLastIndex = Math.min(classifierDescriptorChain.size(), reversedQualifierParts.size()) - 1;
        if (n <= classifierChainLastIndex) {
            int index2;
            do {
                List<Object> currentParameters;
                QualifiedExpressionResolver.ExpressionQualifierPart expressionQualifierPart;
                KtTypeArgumentList ktTypeArgumentList;
                List<Object> list2 = (ktTypeArgumentList = (expressionQualifierPart = reversedQualifierParts.get(index2 = n++)).getTypeArguments()) == null ? null : ktTypeArgumentList.getArguments();
                List<Object> currentArguments = list2 == null ? CollectionsKt.emptyList() : list2;
                list2 = classifierDescriptorChain.get(index2).getDeclaredTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "classifierDescriptorChai\u2026x].declaredTypeParameters");
                declaredTypeParameters = list2;
                List<Object> list3 = currentParameters = wasStatic ? CollectionsKt.emptyList() : declaredTypeParameters;
                if (wasStatic && !((Collection)currentArguments).isEmpty() && !((Collection)declaredTypeParameters).isEmpty()) {
                    BindingTrace bindingTrace = c.trace;
                    KtTypeArgumentList ktTypeArgumentList2 = expressionQualifierPart.getTypeArguments();
                    Intrinsics.checkNotNull(ktTypeArgumentList2);
                    bindingTrace.report(Errors.TYPE_ARGUMENTS_FOR_OUTER_CLASS_WHEN_NESTED_REFERENCED.on((KtTypeArgumentList)((PsiElement)ktTypeArgumentList2)));
                    return null;
                }
                if (currentArguments.size() != currentParameters.size()) {
                    KtTypeArgumentList ktTypeArgumentList3 = expressionQualifierPart.getTypeArguments();
                    c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)(ktTypeArgumentList3 == null ? (KtElement)expressionQualifierPart.getExpression() : (KtElement)ktTypeArgumentList3)), currentParameters.size(), classifierDescriptorChain.get(index2)));
                    return null;
                }
                result2.addAll(currentArguments);
                boolean bl = wasStatic = wasStatic || !classifierDescriptorChain.get(index2).isInner();
            } while (index2 != classifierChainLastIndex);
        }
        List<QualifiedExpressionResolver.ExpressionQualifierPart> nonClassQualifierParts = reversedQualifierParts.subList(Math.min(classifierChainLastIndex + 1, reversedQualifierParts.size()), reversedQualifierParts.size());
        for (QualifiedExpressionResolver.ExpressionQualifierPart expressionQualifierPart : nonClassQualifierParts) {
            typeArguments2 = expressionQualifierPart.component3();
            if (typeArguments2 == null) continue;
            c.trace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)typeArguments2), "here"));
            return null;
        }
        List<TypeParameterDescriptor> list4 = classifierDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list4, "classifierDescriptor.typeConstructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list4;
        if (result2.size() < parameters2.size()) {
            boolean bl;
            declaredTypeParameters = parameters2.get(result2.size()).getOriginal().getContainingDeclaration();
            Object object = typeArguments2 = declaredTypeParameters instanceof ClassDescriptor ? (ClassDescriptor)declaredTypeParameters : null;
            if (typeArguments2 == null) {
                return new Pair(result2, null);
            }
            Object object2 = typeArguments2;
            declaredTypeParameters = c.scope;
            Intrinsics.checkNotNullExpressionValue(declaredTypeParameters, "c.scope");
            List<TypeProjection> restArguments = this.findImplicitOuterClassArguments((LexicalScope)declaredTypeParameters, (ClassDescriptor)object2);
            List<TypeParameterDescriptor> restParameters = parameters2.subList(result2.size(), parameters2.size());
            Iterable iterable = this.classifierDescriptorsFromInnerToOuter(classifierDescriptor);
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)t;
                int n3 = n2;
                boolean bl2 = false;
                int n4 = it.getDeclaredTypeParameters().size();
                n2 = n3 + n4;
            }
            int typeArgumentsCanBeSpecifiedCount = n2;
            if (restArguments == null && typeArgumentsCanBeSpecifiedCount > result2.size()) {
                c.trace.report(Errors.OUTER_CLASS_ARGUMENTS_REQUIRED.on((KtElement)((PsiElement)CollectionsKt.first(qualifierParts).getExpression()), (ClassDescriptor)object2));
                return null;
            }
            if (restArguments == null) {
                boolean bl2;
                boolean bl3 = bl2 = typeArgumentsCanBeSpecifiedCount == result2.size();
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$332 = false;
                    String $i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$332 = "Number of type arguments that can be specified (" + typeArgumentsCanBeSpecifiedCount + ") should be equal to actual arguments number " + result2.size() + ", (classifier: " + classifierDescriptor + ')';
                    throw new AssertionError((Object)$i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$332);
                }
                return new Pair(result2, null);
            }
            boolean bl4 = bl = restParameters.size() == restArguments.size();
            if (_Assertions.ENABLED && !bl) {
                boolean bl6 = false;
                String string2 = "Number of type of restParameters should be equal to " + restParameters.size() + ", but " + restArguments.size() + " were found for " + classifierDescriptor + '/' + object2;
                throw new AssertionError((Object)string2);
            }
            return new Pair<List<KtTypeProjection>, List<TypeProjection>>(result2, restArguments);
        }
        return new Pair(result2, null);
    }

    private final List<ClassifierDescriptorWithTypeParameters> classifierDescriptorsFromInnerToOuter(ClassifierDescriptor $this$classifierDescriptorsFromInnerToOuter) {
        return SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<ClassifierDescriptorWithTypeParameters>($this$classifierDescriptorsFromInnerToOuter){
            final /* synthetic */ ClassifierDescriptor $this_classifierDescriptorsFromInnerToOuter;
            {
                this.$this_classifierDescriptorsFromInnerToOuter = $receiver;
                super(0);
            }

            @Nullable
            public final ClassifierDescriptorWithTypeParameters invoke() {
                ClassifierDescriptor classifierDescriptor = this.$this_classifierDescriptorsFromInnerToOuter;
                return classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            }
        }, (Function1)classifierDescriptorsFromInnerToOuter.2.INSTANCE));
    }

    private final List<TypeProjection> resolveTypeProjectionsWithErrorConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> argumentElements, String message2) {
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructor(message2);
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "createErrorTypeConstructor(message)");
        return this.resolveTypeProjections(c, typeConstructor2, argumentElements);
    }

    static /* synthetic */ List resolveTypeProjectionsWithErrorConstructor$default(TypeResolver typeResolver, TypeResolutionContext typeResolutionContext, List list2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "Error type for resolving type projections";
        }
        return typeResolver.resolveTypeProjectionsWithErrorConstructor(typeResolutionContext, list2, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjectionImpl> appendDefaultArgumentsForLocalClassifier(int fromIndex, List<? extends TypeParameterDescriptor> constructorParameters) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = constructorParameters.subList(fromIndex, constructorParameters.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(it.getOriginal().getDefaultType());
            collection.add(typeProjectionImpl);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeProjection> resolveTypeProjections(@NotNull TypeResolutionContext c, @NotNull TypeConstructor constructor2, @NotNull List<? extends KtTypeProjection> argumentElements) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(argumentElements, "argumentElements");
        Iterable $this$mapIndexed$iv = argumentElements;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            TypeProjection typeProjection;
            Object parameterDescriptor;
            void i;
            void argumentElement;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtTypeProjection ktTypeProjection = (KtTypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = argumentElement.getProjectionKind();
            Intrinsics.checkNotNullExpressionValue(object, "argumentElement.projectionKind");
            KtProjectionKind projectionKind = object;
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)argumentElement;
            object = c.trace;
            Intrinsics.checkNotNullExpressionValue(object, "c.trace");
            ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, (BindingTrace)object, null, this.languageVersionSettings);
            if (projectionKind == KtProjectionKind.STAR) {
                List<TypeParameterDescriptor> list2 = constructor2.getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "constructor.parameters");
                List<TypeParameterDescriptor> parameters2 = list2;
                if (parameters2.size() > i) {
                    parameterDescriptor = parameters2.get((int)i);
                    typeProjection = TypeUtils.makeStarProjection((TypeParameterDescriptor)parameterDescriptor);
                } else {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*"));
                }
            } else {
                parameterDescriptor = c.noBareTypes();
                Intrinsics.checkNotNullExpressionValue(parameterDescriptor, "c.noBareTypes()");
                TypeResolutionContext typeResolutionContext = parameterDescriptor;
                KtTypeReference ktTypeReference = argumentElement.getTypeReference();
                Intrinsics.checkNotNull(ktTypeReference);
                parameterDescriptor = ktTypeReference;
                Intrinsics.checkNotNullExpressionValue(parameterDescriptor, "argumentElement.typeReference!!");
                KotlinType type2 = this.resolveType(typeResolutionContext, (KtTypeReference)parameterDescriptor);
                Variance kind = Companion.resolveProjectionKind(projectionKind);
                if (constructor2.getParameters().size() > i) {
                    TypeParameterDescriptor parameterDescriptor2 = constructor2.getParameters().get((int)i);
                    if (kind != Variance.INVARIANT && parameterDescriptor2.getVariance() != Variance.INVARIANT) {
                        if (kind == parameterDescriptor2.getVariance()) {
                            BindingTrace bindingTrace = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            ClassifierDescriptor classifierDescriptor = constructor2.getDeclarationDescriptor();
                            Intrinsics.checkNotNull(classifierDescriptor);
                            bindingTrace.report(Errors.REDUNDANT_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        } else {
                            BindingTrace bindingTrace = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            ClassifierDescriptor classifierDescriptor = constructor2.getDeclarationDescriptor();
                            Intrinsics.checkNotNull(classifierDescriptor);
                            bindingTrace.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        }
                    }
                }
                typeProjection = new TypeProjectionImpl(kind, type2);
            }
            TypeProjection typeProjection2 = typeProjection;
            collection.add(typeProjection2);
        }
        return (List)destination$iv$iv;
    }

    private final List<TypeProjection> findImplicitOuterClassArguments(LexicalScope $this$findImplicitOuterClassArguments, ClassDescriptor outerClass2) {
        ClassDescriptor classDescriptor;
        block3: {
            ClassDescriptor classDescriptor2;
            HierarchicalScope $this$findFirstFromMeAndParent$iv = $this$findImplicitOuterClassArguments;
            boolean $i$f$findFirstFromMeAndParent = false;
            HierarchicalScope $this$processForMeAndParent$iv$iv = $this$findFirstFromMeAndParent$iv;
            boolean $i$f$processForMeAndParent = false;
            HierarchicalScope currentScope$iv$iv = $this$processForMeAndParent$iv$iv;
            while (true) {
                HierarchicalScope it$iv = currentScope$iv$iv;
                boolean bl = false;
                HierarchicalScope scope2 = it$iv;
                boolean bl2 = false;
                ClassDescriptor classDescriptor3 = scope2 instanceof LexicalScope && ((LexicalScope)scope2).getKind() == LexicalScopeKind.CLASS_MEMBER_SCOPE ? (ClassDescriptor)((LexicalScope)scope2).getOwnerDescriptor() : null;
                if (classDescriptor3 != null) {
                    ClassDescriptor classDescriptor4;
                    ClassDescriptor it$iv2 = classDescriptor4 = classDescriptor3;
                    boolean bl3 = false;
                    classDescriptor2 = it$iv2;
                    break block3;
                }
                HierarchicalScope hierarchicalScope = currentScope$iv$iv.getParent();
                if (hierarchicalScope == null) break;
                currentScope$iv$iv = hierarchicalScope;
            }
            classDescriptor2 = classDescriptor = null;
        }
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor enclosingClass = classDescriptor;
        return DescriptorUtilsKt.findImplicitOuterClassArguments(enclosingClass, outerClass2);
    }

    @Nullable
    public final ClassifierDescriptor resolveClass(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(userType, "userType");
        Intrinsics.checkNotNullParameter(trace, "trace");
        return this.resolveDescriptorForType(scope2, userType, trace, isDebuggerContext).getClassifierDescriptor();
    }

    @NotNull
    public final QualifiedExpressionResolver.TypeQualifierResolutionResult resolveDescriptorForType(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Object object;
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(userType, "userType");
        Intrinsics.checkNotNullParameter(trace, "trace");
        if (userType.getQualifier() != null) {
            KtUserType ktUserType = userType.getQualifier();
            Intrinsics.checkNotNull(ktUserType);
            object = ktUserType.getTypeArguments().iterator();
            while (object.hasNext()) {
                KtTypeReference ktTypeReference;
                KtTypeProjection typeArgument = (KtTypeProjection)object.next();
                KtTypeReference ktTypeReference2 = typeArgument.getTypeReference();
                if (ktTypeReference2 == null) continue;
                KtTypeReference it = ktTypeReference = ktTypeReference2;
                boolean bl = false;
                this.forceResolveTypeContents(this.resolveType(scope2, it, trace, false));
            }
        }
        Object $this$resolveDescriptorForType_u24lambda_u2d14 = object = this.qualifiedExpressionResolver.resolveDescriptorForType(userType, scope2, trace, isDebuggerContext);
        boolean bl = false;
        if (((QualifiedExpressionResolver.TypeQualifierResolutionResult)$this$resolveDescriptorForType_u24lambda_u2d14).getClassifierDescriptor() != null) {
            PlatformClassesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(this.platformToKotlinClassMapper, trace, userType, ((QualifiedExpressionResolver.TypeQualifierResolutionResult)$this$resolveDescriptorForType_u24lambda_u2d14).getClassifierDescriptor());
        }
        return object;
    }

    private static final PsiElement resolveTypeElement$lambda-2(Lazy<? extends PsiElement> suspendModifier$delegate) {
        Lazy<? extends PsiElement> lazy = suspendModifier$delegate;
        Object var2_2 = null;
        Object var3_3 = null;
        return lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
        return Companion.resolveProjectionKind(projectionKind);
    }

    public static final /* synthetic */ Annotations access$resolveTypeAnnotations(TypeResolver $this, TypeResolutionContext c, KtElementImplStub modifierListsOwner) {
        return $this.resolveTypeAnnotations(c, modifierListsOwner);
    }

    public static final /* synthetic */ PossiblyBareType access$resolveTypeElement(TypeResolver $this, TypeResolutionContext c, Annotations annotations2, KtModifierList outerModifierList, KtTypeElement typeElement) {
        return $this.resolveTypeElement(c, annotations2, outerModifierList, typeElement);
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(TypeResolver $this) {
        return $this.languageVersionSettings;
    }

    public static final /* synthetic */ KotlinType access$resolveType(TypeResolver $this, TypeResolutionContext c, KtTypeReference typeReference) {
        return $this.resolveType(c, typeReference);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(TypeResolver $this) {
        return $this.moduleDescriptor;
    }

    public static final /* synthetic */ DynamicCallableDescriptors access$getDynamicCallableDescriptors$p(TypeResolver $this) {
        return $this.dynamicCallableDescriptors;
    }

    public static final /* synthetic */ DynamicTypesSettings access$getDynamicTypesSettings$p(TypeResolver $this) {
        return $this.dynamicTypesSettings;
    }

    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(TypeResolver $this) {
        return $this.identifierChecker;
    }

    public static final /* synthetic */ AnnotationResolver access$getAnnotationResolver$p(TypeResolver $this) {
        return $this.annotationResolver;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "", "()V", "transformType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlinType", "frontend"})
    public static class TypeTransformerForTests {
        @Nullable
        public KotlinType transformType(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u000bH\u0016J\"\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020!H\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0016R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$TracingTypeAliasExpansionReportStrategy;", "Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "type", "Lorg/jetbrains/kotlin/psi/KtElement;", "typeArgumentsOrTypeName", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "typeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "mappedArguments", "", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getType", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getTypeAliasDescriptor", "()Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "getTypeArgumentsOrTypeName", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "boundsViolationInSubstitution", "", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "unsubstitutedArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "argument", "typeParameter", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "frontend"})
    private static final class TracingTypeAliasExpansionReportStrategy
    implements TypeAliasExpansionReportStrategy {
        @NotNull
        private final BindingTrace trace;
        @Nullable
        private final KtElement type;
        @Nullable
        private final KtElement typeArgumentsOrTypeName;
        @NotNull
        private final TypeAliasDescriptor typeAliasDescriptor;
        @NotNull
        private final UpperBoundChecker upperBoundChecker;
        @NotNull
        private final Map<TypeParameterDescriptor, KtTypeProjection> mappedArguments;

        public TracingTypeAliasExpansionReportStrategy(@NotNull BindingTrace trace, @Nullable KtElement type2, @Nullable KtElement typeArgumentsOrTypeName, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull List<? extends TypeParameterDescriptor> typeParameters2, @NotNull List<? extends KtTypeProjection> typeArguments2, @NotNull UpperBoundChecker upperBoundChecker) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
            Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
            Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
            Intrinsics.checkNotNullParameter(upperBoundChecker, "upperBoundChecker");
            this.trace = trace;
            this.type = type2;
            this.typeArgumentsOrTypeName = typeArgumentsOrTypeName;
            this.typeAliasDescriptor = typeAliasDescriptor;
            this.upperBoundChecker = upperBoundChecker;
            this.mappedArguments = MapsKt.toMap(CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments2));
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @Nullable
        public final KtElement getType() {
            return this.type;
        }

        @Nullable
        public final KtElement getTypeArgumentsOrTypeName() {
            return this.typeArgumentsOrTypeName;
        }

        @NotNull
        public final TypeAliasDescriptor getTypeAliasDescriptor() {
            return this.typeAliasDescriptor;
        }

        @NotNull
        public final UpperBoundChecker getUpperBoundChecker() {
            return this.upperBoundChecker;
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            if (this.typeArgumentsOrTypeName != null) {
                this.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)this.typeArgumentsOrTypeName), numberOfParameters, this.typeAliasDescriptor));
            }
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            KtTypeProjection ktTypeProjection;
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            Intrinsics.checkNotNullParameter(substitutedArgument, "substitutedArgument");
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            if (typeParameterDescriptor == null) {
                ktTypeProjection = null;
            } else {
                TypeParameterDescriptor typeParameterDescriptor2;
                TypeParameterDescriptor it = typeParameterDescriptor2 = typeParameterDescriptor;
                boolean bl = false;
                ktTypeProjection = this.mappedArguments.get(it);
            }
            KtTypeProjection argumentElement = ktTypeProjection;
            if (argumentElement != null) {
                this.trace.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)((PsiElement)argumentElement), typeParameter));
            } else if (this.type != null) {
                this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.type), this.typeAliasDescriptor.getUnderlyingType()));
            }
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            if (this.type != null) {
                this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.type), typeAlias));
            }
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull TypeSubstitutor substitutor2, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument2, @NotNull TypeParameterDescriptor typeParameter) {
            KtTypeProjection argumentElement;
            Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
            Intrinsics.checkNotNullParameter(unsubstitutedArgument, "unsubstitutedArgument");
            Intrinsics.checkNotNullParameter(argument2, "argument");
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            ClassifierDescriptor descriptorForUnsubstitutedArgument = unsubstitutedArgument.getConstructor().getDeclarationDescriptor();
            Map<TypeParameterDescriptor, KtTypeProjection> map = this.mappedArguments;
            KtTypeProjection ktTypeProjection = argumentElement = map.get(descriptorForUnsubstitutedArgument);
            KtTypeReference argumentTypeReferenceElement = ktTypeProjection == null ? null : ktTypeProjection.getTypeReference();
            this.upperBoundChecker.checkBounds(argumentTypeReferenceElement, argument2, typeParameter, substitutor2, this.trace, this.type);
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            KtAnnotationEntry ktAnnotationEntry;
            Intrinsics.checkNotNullParameter(annotation2, "annotation");
            SourceElement sourceElement = annotation2.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement = kotlinSourceElement == null ? null : kotlinSourceElement.getPsi();
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry = ktElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)ktElement : null;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$Companion;", "", "()V", "resolveProjectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "projectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
            Variance variance;
            Intrinsics.checkNotNullParameter((Object)projectionKind, "projectionKind");
            KtProjectionKind ktProjectionKind = projectionKind;
            int n = WhenMappings.$EnumSwitchMapping$0[ktProjectionKind.ordinal()];
            switch (n) {
                case 1: {
                    variance = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus("Illegal projection kind:", (Object)projectionKind));
                }
            }
            return variance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KtProjectionKind.values().length];
                nArray[KtProjectionKind.IN.ordinal()] = 1;
                nArray[KtProjectionKind.OUT.ordinal()] = 2;
                nArray[KtProjectionKind.NONE.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

