/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.AbsentDescriptorHandler;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.LockBasedLazyResolveStorageManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001d\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b%J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020$J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u000200H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;", "", "globalContext", "Lorg/jetbrains/kotlin/context/GlobalContext;", "delegationTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "absentDescriptorHandler", "Lorg/jetbrains/kotlin/resolve/lazy/AbsentDescriptorHandler;", "(Lorg/jetbrains/kotlin/context/GlobalContext;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;Lorg/jetbrains/kotlin/resolve/lazy/AbsentDescriptorHandler;)V", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "scopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;", "getScopeProvider", "()Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;", "setScopeProvider", "(Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;)V", "trace", "findClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classObjectOrScript", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "findClassDescriptorIfAny", "getClassDescriptor", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getClassDescriptorIfAny", "getMemberScopeDeclaredIn", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMemberScopeDeclaredIn$frontend", "getScriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "resolveToDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "track", "", "setDeclarationScopeProvider", "", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl;", "frontend"})
public class LazyDeclarationResolver {
    @NotNull
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    @NotNull
    private final AbsentDescriptorHandler absentDescriptorHandler;
    @NotNull
    private final BindingTrace trace;
    protected DeclarationScopeProvider scopeProvider;

    public LazyDeclarationResolver(@NotNull GlobalContext globalContext, @NotNull BindingTrace delegationTrace, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull AbsentDescriptorHandler absentDescriptorHandler) {
        Intrinsics.checkNotNullParameter(globalContext, "globalContext");
        Intrinsics.checkNotNullParameter(delegationTrace, "delegationTrace");
        Intrinsics.checkNotNullParameter(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkNotNullParameter(absentDescriptorHandler, "absentDescriptorHandler");
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        this.absentDescriptorHandler = absentDescriptorHandler;
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
    }

    @NotNull
    protected final DeclarationScopeProvider getScopeProvider() {
        DeclarationScopeProvider declarationScopeProvider = this.scopeProvider;
        if (declarationScopeProvider != null) {
            return declarationScopeProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException("scopeProvider");
        return null;
    }

    protected final void setScopeProvider(@NotNull DeclarationScopeProvider declarationScopeProvider) {
        Intrinsics.checkNotNullParameter(declarationScopeProvider, "<set-?>");
        this.scopeProvider = declarationScopeProvider;
    }

    private final BindingContext getBindingContext() {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        return bindingContext;
    }

    @Inject
    public final void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl scopeProvider) {
        Intrinsics.checkNotNullParameter(scopeProvider, "scopeProvider");
        this.setScopeProvider(scopeProvider);
    }

    @Nullable
    public ClassDescriptor getClassDescriptorIfAny(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Intrinsics.checkNotNullParameter(location2, "location");
        return this.findClassDescriptorIfAny(classOrObject, location2);
    }

    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Intrinsics.checkNotNullParameter(location2, "location");
        return this.findClassDescriptor(classOrObject, location2);
    }

    @NotNull
    public final ClassDescriptorWithResolutionScopes getScriptDescriptor(@NotNull KtScript script, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter(script, "script");
        Intrinsics.checkNotNullParameter(location2, "location");
        return (ClassDescriptorWithResolutionScopes)this.findClassDescriptor(script, location2);
    }

    private final ClassDescriptor findClassDescriptorIfAny(KtNamedDeclaration classObjectOrScript, LookupLocation location2) {
        MemberScope scope2 = this.getMemberScopeDeclaredIn$frontend(classObjectOrScript, location2);
        Name name = classObjectOrScript.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue(name, "classObjectOrScript.nameAsSafeName");
        scope2.getContributedClassifier(name, location2);
        DeclarationDescriptor descriptor2 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classObjectOrScript);
        return descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
    }

    private final ClassDescriptor findClassDescriptor(KtNamedDeclaration classObjectOrScript, LookupLocation location2) {
        ClassDescriptor classDescriptor = this.findClassDescriptorIfAny(classObjectOrScript, location2);
        return classDescriptor == null ? (ClassDescriptor)this.absentDescriptorHandler.diagnoseDescriptorNotFound(classObjectOrScript) : classDescriptor;
    }

    @NotNull
    public final DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        DeclarationDescriptor declarationDescriptor = this.resolveToDescriptor(declaration2, true);
        return declarationDescriptor == null ? this.absentDescriptorHandler.diagnoseDescriptorNotFound(declaration2) : declarationDescriptor;
    }

    private final DeclarationDescriptor resolveToDescriptor(KtDeclaration declaration2, boolean track) {
        return (DeclarationDescriptor)declaration2.accept(new KtVisitor(track, this){
            final /* synthetic */ boolean $track;
            final /* synthetic */ LazyDeclarationResolver this$0;
            {
                this.$track = $track;
                this.this$0 = $receiver;
            }

            private final LookupLocation lookupLocationFor(KtDeclaration declaration2, boolean isTopLevel) {
                return isTopLevel && this.$track ? (LookupLocation)new KotlinLookupLocation(declaration2) : (LookupLocation)NoLookupLocation.WHEN_RESOLVE_DECLARATION;
            }

            @Nullable
            public DeclarationDescriptor visitClass(@NotNull KtClass klass, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(klass, "klass");
                return this.this$0.getClassDescriptorIfAny(klass, this.lookupLocationFor(klass, klass.isTopLevel()));
            }

            @Nullable
            public DeclarationDescriptor visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return this.this$0.getClassDescriptorIfAny(declaration2, this.lookupLocationFor(declaration2, declaration2.isTopLevel()));
            }

            @Nullable
            public DeclarationDescriptor visitTypeParameter(@NotNull KtTypeParameter parameter, @Nullable Void data2) {
                Object v1;
                Object name;
                Object object;
                Object ownerDescriptor;
                block8: {
                    List<TypeParameterDescriptor> list2;
                    Intrinsics.checkNotNullParameter(parameter, "parameter");
                    Object object2 = PsiTreeUtil.getParentOfType((PsiElement)parameter, KtTypeParameterListOwner.class);
                    if (object2 == null) {
                        throw new IllegalStateException(Intrinsics.stringPlus("Owner not found for type parameter: ", parameter.getText()).toString());
                    }
                    Object object3 = object2;
                    KtTypeParameterListOwner ownerElement = object3;
                    if ((object2 = LazyDeclarationResolver.access$resolveToDescriptor(this.this$0, ownerElement, false)) == null) {
                        return null;
                    }
                    ownerDescriptor = object2;
                    List<TypeParameterDescriptor> typeParameters2 = null;
                    Object object4 = ownerDescriptor;
                    if (object4 instanceof CallableDescriptor) {
                        object = ((CallableDescriptor)ownerDescriptor).getTypeParameters();
                        Intrinsics.checkNotNullExpressionValue(object, "ownerDescriptor.typeParameters");
                        list2 = object;
                    } else if (object4 instanceof ClassifierDescriptorWithTypeParameters) {
                        object = ((ClassifierDescriptorWithTypeParameters)ownerDescriptor).getTypeConstructor().getParameters();
                        Intrinsics.checkNotNullExpressionValue(object, "ownerDescriptor.typeConstructor.parameters");
                        list2 = object;
                    } else {
                        throw new IllegalStateException(Intrinsics.stringPlus("Unknown owner kind for a type parameter: ", ownerDescriptor));
                    }
                    typeParameters2 = list2;
                    object = parameter.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue(object, "parameter.nameAsSafeName");
                    name = object;
                    Iterable $this$firstOrNull$iv = typeParameters2;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getName(), name)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                object = v1;
                if (object == null) {
                    throw new IllegalStateException("Type parameter " + name + " not found for " + ownerDescriptor);
                }
                return (DeclarationDescriptor)object;
            }

            @Nullable
            public DeclarationDescriptor visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(function2, "function");
                LookupLocation location2 = this.lookupLocationFor(function2, function2.isTopLevel());
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(function2, location2);
                Name name = function2.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue(name, "function.nameAsSafeName");
                scopeForDeclaration.getContributedFunctions(name, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            }

            @Nullable
            public DeclarationDescriptor visitParameter(@NotNull KtParameter parameter, @Nullable Void data2) {
                PsiElement grandFather;
                Intrinsics.checkNotNullParameter(parameter, "parameter");
                PsiElement psiElement = grandFather = parameter.getParent().getParent();
                if (psiElement instanceof KtPrimaryConstructor) {
                    DeclarationDescriptor declarationDescriptor;
                    KtClassOrObject jetClass = ((KtPrimaryConstructor)grandFather).getContainingClassOrObject();
                    ClassDescriptor classDescriptor = this.this$0.getClassDescriptorIfAny(jetClass, this.lookupLocationFor(jetClass, false));
                    if (classDescriptor == null) {
                        declarationDescriptor = null;
                    } else if (parameter.hasValOrVar()) {
                        MemberScope memberScope2 = classDescriptor.getDefaultType().getMemberScope();
                        Name name = parameter.getNameAsSafeName();
                        Intrinsics.checkNotNullExpressionValue(name, "parameter.nameAsSafeName");
                        memberScope2.getContributedVariables(name, this.lookupLocationFor(parameter, false));
                        declarationDescriptor = (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    } else {
                        ClassConstructorDescriptor classConstructorDescriptor;
                        ClassConstructorDescriptor classConstructorDescriptor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
                        if (classConstructorDescriptor2 == null) {
                            throw new IllegalStateException("There are constructor parameters found, so a constructor should also exist".toString());
                        }
                        ClassConstructorDescriptor constructor2 = classConstructorDescriptor = classConstructorDescriptor2;
                        constructor2.getValueParameters();
                        declarationDescriptor = (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.VALUE_PARAMETER, parameter);
                    }
                    return declarationDescriptor;
                }
                if (psiElement instanceof KtNamedFunction) {
                    Intrinsics.checkNotNullExpressionValue(grandFather, "grandFather");
                    DeclarationDescriptor declarationDescriptor = this.visitNamedFunction((KtNamedFunction)grandFather, data2);
                    FunctionDescriptor function2 = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                    declarationDescriptor = function2;
                    if (declarationDescriptor != null) {
                        declarationDescriptor.getValueParameters();
                    }
                    return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (psiElement instanceof KtSecondaryConstructor) {
                    Intrinsics.checkNotNullExpressionValue(grandFather, "grandFather");
                    DeclarationDescriptor declarationDescriptor = this.visitSecondaryConstructor((KtSecondaryConstructor)grandFather, data2);
                    ConstructorDescriptor constructorDescriptor = declarationDescriptor instanceof ConstructorDescriptor ? (ConstructorDescriptor)declarationDescriptor : null;
                    declarationDescriptor = constructorDescriptor;
                    if (declarationDescriptor != null) {
                        declarationDescriptor.getValueParameters();
                    }
                    return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data2);
            }

            @Nullable
            public DeclarationDescriptor visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(constructor2, "constructor");
                PsiElement psiElement = constructor2.getParent().getParent();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                }
                ClassDescriptor classDescriptor = this.this$0.getClassDescriptorIfAny((KtClassOrObject)psiElement, this.lookupLocationFor(constructor2, false));
                if (classDescriptor != null) {
                    classDescriptor.getConstructors();
                }
                return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.CONSTRUCTOR, constructor2);
            }

            @Nullable
            public DeclarationDescriptor visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor2, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(constructor2, "constructor");
                ClassDescriptor classDescriptor = this.this$0.getClassDescriptorIfAny(constructor2.getContainingClassOrObject(), this.lookupLocationFor(constructor2, false));
                if (classDescriptor != null) {
                    classDescriptor.getConstructors();
                }
                return (DeclarationDescriptor)LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.CONSTRUCTOR, constructor2);
            }

            @Nullable
            public DeclarationDescriptor visitProperty(@NotNull KtProperty property2, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(property2, "property");
                LookupLocation location2 = this.lookupLocationFor(property2, property2.isTopLevel());
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(property2, location2);
                Name name = property2.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue(name, "property.nameAsSafeName");
                scopeForDeclaration.getContributedVariables(name, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
            }

            @Nullable
            public DeclarationDescriptor visitDestructuringDeclarationEntry(@NotNull KtDestructuringDeclarationEntry destructuringDeclarationEntry, @Nullable Void data2) {
                KtDestructuringDeclaration ktDestructuringDeclaration;
                Intrinsics.checkNotNullParameter(destructuringDeclarationEntry, "destructuringDeclarationEntry");
                LookupLocation location2 = this.lookupLocationFor(destructuringDeclarationEntry, false);
                Object object = destructuringDeclarationEntry.getParent();
                KtDestructuringDeclaration ktDestructuringDeclaration2 = ktDestructuringDeclaration = object instanceof KtDestructuringDeclaration ? (KtDestructuringDeclaration)object : null;
                if (ktDestructuringDeclaration == null) {
                    return null;
                }
                KtDestructuringDeclaration destructuringDeclaration = ktDestructuringDeclaration;
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(destructuringDeclaration, location2);
                object = destructuringDeclarationEntry.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue(object, "destructuringDeclarationEntry.nameAsSafeName");
                scopeForDeclaration.getContributedVariables((Name)object, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, destructuringDeclarationEntry);
            }

            @Nullable
            public DeclarationDescriptor visitTypeAlias(@NotNull KtTypeAlias typeAlias, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
                LookupLocation location2 = this.lookupLocationFor(typeAlias, typeAlias.isTopLevel());
                MemberScope scopeForDeclaration = this.this$0.getMemberScopeDeclaredIn$frontend(typeAlias, location2);
                Name name = typeAlias.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue(name, "typeAlias.nameAsSafeName");
                scopeForDeclaration.getContributedClassifier(name, location2);
                return LazyDeclarationResolver.access$getBindingContext(this.this$0).get(BindingContext.DECLARATION_TO_DESCRIPTOR, typeAlias);
            }

            @NotNull
            public DeclarationDescriptor visitScript(@NotNull KtScript script, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(script, "script");
                return this.this$0.getScriptDescriptor(script, this.lookupLocationFor(script, true));
            }

            @Nullable
            public DeclarationDescriptor visitKtElement(@NotNull KtElement element, @Nullable Void data2) {
                Intrinsics.checkNotNullParameter(element, "element");
                throw new IllegalArgumentException("Unsupported declaration type: " + element + ' ' + PsiUtilsKt.getElementTextWithContext(element));
            }
        }, null);
    }

    @NotNull
    public final MemberScope getMemberScopeDeclaredIn$frontend(@NotNull KtDeclaration declaration2, @NotNull LookupLocation location2) {
        MemberScope memberScope2;
        boolean isTopLevel;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(location2, "location");
        KtDeclaration parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(declaration2);
        boolean bl = isTopLevel = parentDeclaration == null;
        if (isTopLevel) {
            PsiFile psiFile = declaration2.getContainingFile();
            if (psiFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            }
            KtFile ktFile = (KtFile)psiFile;
            FqName fqName2 = ktFile.getPackageFqName();
            this.topLevelDescriptorProvider.assertValid();
            LazyPackageDescriptor packageDescriptor = this.topLevelDescriptorProvider.getPackageFragmentOrDiagnoseFailure(fqName2, ktFile);
            MemberScope memberScope3 = packageDescriptor.getMemberScope();
            Intrinsics.checkNotNullExpressionValue(memberScope3, "packageDescriptor.getMemberScope()");
            return memberScope3;
        }
        KtDeclaration ktDeclaration = parentDeclaration;
        if (ktDeclaration instanceof KtClassOrObject) {
            MemberScope memberScope4 = this.getClassDescriptor((KtClassOrObject)parentDeclaration, location2).getUnsubstitutedMemberScope();
            Intrinsics.checkNotNullExpressionValue(memberScope4, "getClassDescriptor(paren\u2026.unsubstitutedMemberScope");
            memberScope2 = memberScope4;
        } else if (ktDeclaration instanceof KtScript) {
            MemberScope memberScope5 = this.getScriptDescriptor((KtScript)parentDeclaration, location2).getUnsubstitutedMemberScope();
            Intrinsics.checkNotNullExpressionValue(memberScope5, "getScriptDescriptor(pare\u2026.unsubstitutedMemberScope");
            memberScope2 = memberScope5;
        } else {
            throw new IllegalStateException("Don't call this method for local declarations: " + declaration2 + '\n' + PsiUtilsKt.getElementTextWithContext(declaration2));
        }
        return memberScope2;
    }

    public static final /* synthetic */ DeclarationDescriptor access$resolveToDescriptor(LazyDeclarationResolver $this, KtDeclaration declaration2, boolean track) {
        return $this.resolveToDescriptor(declaration2, track);
    }

    public static final /* synthetic */ BindingContext access$getBindingContext(LazyDeclarationResolver $this) {
        return $this.getBindingContext();
    }
}

