/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u0007\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/facebook/ktfmt/format/TrailingCommas;", "", "()V", "extractManagedList", "Lcom/facebook/ktfmt/format/TrailingCommas$ManagedList;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "leftLeafIgnoringCommentsAndWhitespace", "Detector", "ManagedList", "Suggestor", "ktfmt"})
public final class TrailingCommas {
    @NotNull
    public static final TrailingCommas INSTANCE = new TrailingCommas();

    private TrailingCommas() {
    }

    private final ManagedList extractManagedList(PsiElement element) {
        ManagedList managedList;
        PsiElement psiElement = element;
        if (psiElement instanceof KtValueArgumentList) {
            List list = ((KtValueArgumentList)element).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.arguments");
            managedList = new ManagedList(list, ((KtValueArgumentList)element).getTrailingComma());
        } else if (psiElement instanceof KtParameterList) {
            List list = ((KtParameterList)element).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.parameters");
            managedList = new ManagedList(list, ((KtParameterList)element).getTrailingComma());
        } else if (psiElement instanceof KtTypeArgumentList) {
            List list = ((KtTypeArgumentList)element).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.arguments");
            managedList = new ManagedList(list, ((KtTypeArgumentList)element).getTrailingComma());
        } else if (psiElement instanceof KtTypeParameterList) {
            List list = ((KtTypeParameterList)element).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.parameters");
            managedList = new ManagedList(list, ((KtTypeParameterList)element).getTrailingComma());
        } else if (psiElement instanceof KtCollectionLiteralExpression) {
            managedList = new ManagedList(((KtCollectionLiteralExpression)element).getInnerExpressions(), ((KtCollectionLiteralExpression)element).getTrailingComma());
        } else if (psiElement instanceof KtWhenEntry) {
            KtWhenCondition[] ktWhenConditionArray = ((KtWhenEntry)element).getConditions();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"element.conditions");
            managedList = new ManagedList(ArraysKt.toList((Object[])ktWhenConditionArray), ((KtWhenEntry)element).getTrailingComma());
        } else {
            managedList = null;
        }
        return managedList;
    }

    private final PsiElement leftLeafIgnoringCommentsAndWhitespace(PsiElement $this$leftLeafIgnoringCommentsAndWhitespace) {
        for (PsiElement child = $this$leftLeafIgnoringCommentsAndWhitespace.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
                continue;
            }
            return this.leftLeafIgnoringCommentsAndWhitespace(child);
        }
        return $this$leftLeafIgnoringCommentsAndWhitespace;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/ktfmt/format/TrailingCommas$Detector;", "", "()V", "trailingCommas", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getTrailingCommaElements", "", "isTrailingComma", "", "element", "takeElement", "", "ktfmt"})
    public static final class Detector {
        @NotNull
        private final List<PsiElement> trailingCommas = new ArrayList();

        @NotNull
        public final List<PsiElement> getTrailingCommaElements() {
            return this.trailingCommas;
        }

        public final void takeElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (this.isTrailingComma(element)) {
                ((Collection)this.trailingCommas).add(element);
            }
        }

        private final boolean isTrailingComma(PsiElement element) {
            if (!Intrinsics.areEqual((Object)element.getText(), (Object)",")) {
                return false;
            }
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
            ManagedList managedList = INSTANCE.extractManagedList(psiElement);
            return Intrinsics.areEqual((Object)(managedList != null ? managedList.getTrailingComma() : null), (Object)element);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/facebook/ktfmt/format/TrailingCommas$ManagedList;", "", "items", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "trailingComma", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "(Ljava/util/List;Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;)V", "getItems", "()Ljava/util/List;", "getTrailingComma", "()Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "ktfmt"})
    private static final class ManagedList {
        @NotNull
        private final List<KtElement> items;
        @Nullable
        private final PsiElement trailingComma;

        public ManagedList(@NotNull List<? extends KtElement> items, @Nullable PsiElement trailingComma) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items = items;
            this.trailingComma = trailingComma;
        }

        @NotNull
        public final List<KtElement> getItems() {
            return this.items;
        }

        @Nullable
        public final PsiElement getTrailingComma() {
            return this.trailingComma;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/ktfmt/format/TrailingCommas$Suggestor;", "", "()V", "suggestionElements", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getTrailingCommaSuggestions", "", "takeElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "ktfmt"})
    public static final class Suggestor {
        @NotNull
        private final List<PsiElement> suggestionElements = new ArrayList();

        @NotNull
        public final List<PsiElement> getTrailingCommaSuggestions() {
            return this.suggestionElements;
        }

        public final void takeElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                return;
            }
            KtElement ktElement = element;
            if (ktElement instanceof KtWhenEntry) {
                return;
            }
            if (ktElement instanceof KtParameterList && ((KtParameterList)element).getParent() instanceof KtFunctionLiteral && ((KtParameterList)element).getParent().getParent() instanceof KtLambdaExpression) {
                return;
            }
            ManagedList managedList = INSTANCE.extractManagedList((PsiElement)element);
            if (managedList == null) {
                return;
            }
            ManagedList list = managedList;
            if (list.getItems().size() <= 1) {
                return;
            }
            if (list.getTrailingComma() != null) {
                return;
            }
            this.suggestionElements.add(INSTANCE.leftLeafIgnoringCommentsAndWhitespace((PsiElement)CollectionsKt.last(list.getItems())));
        }
    }
}

