/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.cli;

import com.facebook.ktfmt.cli.Main;
import com.facebook.ktfmt.cli.ParsedArgs;
import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.ParseError;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/ktfmt/cli/Main;", "", "input", "Ljava/io/InputStream;", "out", "Ljava/io/PrintStream;", "err", "args", "", "", "(Ljava/io/InputStream;Ljava/io/PrintStream;Ljava/io/PrintStream;[Ljava/lang/String;)V", "parsedArgs", "Lcom/facebook/ktfmt/cli/ParsedArgs;", "format", "", "file", "Ljava/io/File;", "run", "", "Companion", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ncom/facebook/ktfmt/cli/Main\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public final class Main {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream input;
    @NotNull
    private final PrintStream out;
    @NotNull
    private final PrintStream err;
    @NotNull
    private final ParsedArgs parsedArgs;

    public Main(@NotNull InputStream input, @NotNull PrintStream out, @NotNull PrintStream err, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.input = input;
        this.out = out;
        this.err = err;
        this.parsedArgs = ParsedArgs.Companion.processArgs(this.err, args);
    }

    public final int run() {
        if (this.parsedArgs.getFileNames().isEmpty()) {
            this.err.println("Usage: ktfmt [--dropbox-style | --google-style | --kotlinlang-style] [--dry-run] [--set-exit-if-changed] [--stdin-name=<name>] [--do-not-remove-unused-imports] File1.kt File2.kt ...");
            this.err.println("Or: ktfmt @file");
            return 1;
        }
        if (this.parsedArgs.getFileNames().size() == 1 && Intrinsics.areEqual((Object)this.parsedArgs.getFileNames().get(0), (Object)"-")) {
            int alreadyFormatted;
            try {
                alreadyFormatted = this.format(null);
                alreadyFormatted = alreadyFormatted == 0 && this.parsedArgs.getSetExitIfChanged() ? 1 : 0;
            }
            catch (Exception e) {
                alreadyFormatted = 1;
            }
            return alreadyFormatted;
        }
        if (this.parsedArgs.getStdinName() != null) {
            this.err.println("Error: --stdin-name can only be used with stdin");
            return 1;
        }
        List<File> files = null;
        try {
            files = Companion.expandArgsToFileNames(this.parsedArgs.getFileNames());
        }
        catch (IllegalStateException e) {
            this.err.println(e.getMessage());
            return 1;
        }
        if (files.isEmpty()) {
            this.err.println("Error: no .kt files found");
            return 1;
        }
        AtomicInteger retval = new AtomicInteger(0);
        files.parallelStream().forEach(arg_0 -> Main.run$lambda$0((Function1)new Function1<File, Unit>(this, retval){
            final /* synthetic */ Main this$0;
            final /* synthetic */ AtomicInteger $retval;
            {
                this.this$0 = $receiver;
                this.$retval = $retval;
                super(1);
            }

            public final void invoke(File it) {
                try {
                    if (!Main.access$format(this.this$0, it) && Main.access$getParsedArgs$p(this.this$0).getSetExitIfChanged()) {
                        this.$retval.set(1);
                    }
                }
                catch (Exception e) {
                    this.$retval.set(1);
                }
            }
        }, arg_0));
        return retval.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean format(File file) {
        Object object = file;
        if ((object == null || (object = ((File)object).toString()) == null) && (object = this.parsedArgs.getStdinName()) == null) {
            object = "<stdin>";
        }
        Object fileName = object;
        try {
            InputStream bytes = file == null ? this.input : (InputStream)new FileInputStream(file);
            String code = TextStreamsKt.readText((Reader)new BufferedReader(new InputStreamReader(bytes, StandardCharsets.UTF_8)));
            String formattedCode = Formatter.format(this.parsedArgs.getFormattingOptions(), code);
            boolean alreadyFormatted = Intrinsics.areEqual((Object)code, (Object)formattedCode);
            if (file == null) {
                if (this.parsedArgs.getDryRun()) {
                    if (!alreadyFormatted) {
                        this.out.println((String)fileName);
                    }
                } else {
                    Closeable closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)this.out, StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        BufferedWriter it = (BufferedWriter)closeable;
                        boolean bl = false;
                        it.write(formattedCode);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return alreadyFormatted;
            }
            if (this.parsedArgs.getDryRun()) {
                if (!alreadyFormatted) {
                    this.out.println((String)fileName);
                }
            } else {
                if (!alreadyFormatted) {
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    FilesKt.writeText((File)file, (String)formattedCode, (Charset)charset);
                }
                this.err.println("Done formatting " + (String)fileName);
            }
            return alreadyFormatted;
        }
        catch (IOException e) {
            this.err.println("Error formatting " + (String)fileName + ": " + e.getMessage() + "; skipping.");
            throw e;
        }
        catch (ParseError e) {
            this.err.println((String)fileName + ':' + e.getMessage());
            throw e;
        }
        catch (FormattingError e) {
            for (FormatterDiagnostic diagnostic : e.diagnostics()) {
                this.err.println((String)fileName + ':' + diagnostic);
            }
            e.printStackTrace(this.err);
            throw e;
        }
    }

    private static final void run$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    public static final /* synthetic */ boolean access$format(Main $this, File file) {
        return $this.format(file);
    }

    public static final /* synthetic */ ParsedArgs access$getParsedArgs$p(Main $this) {
        return $this.parsedArgs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004J\u001b\u0010\b\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/facebook/ktfmt/cli/Main$Companion;", "", "()V", "expandArgsToFileNames", "", "Ljava/io/File;", "args", "", "main", "", "", "([Ljava/lang/String;)V", "ktfmt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            PrintStream printStream2 = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"err");
            System.exit(new Main(inputStream, printStream, printStream2, args).run());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        @NotNull
        public final List<File> expandArgsToFileNames(@NotNull List<String> args) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            if (args.size() == 1 && new File(args.get(0)).isFile()) {
                return CollectionsKt.listOf((Object)new File(args.get(0)));
            }
            List result2 = new ArrayList();
            for (String arg : args) {
                if (Intrinsics.areEqual((Object)arg, (Object)"-")) {
                    throw new IllegalStateException("Error: '-', which causes ktfmt to read from stdin, should not be mixed with file name".toString());
                }
                CollectionsKt.addAll((Collection)result2, (Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)new File(arg))), (Function1)expandArgsToFileNames.1.INSTANCE));
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

