/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.facebook.ktfmt.format.KotlinTok;
import com.facebook.ktfmt.format.WhitespaceTombstones;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/facebook/ktfmt/format/Tokenizer;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "fileText", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "<set-?>", "", "index", "getIndex", "()I", "toks", "", "Lcom/facebook/ktfmt/format/KotlinTok;", "getToks", "()Ljava/util/List;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Companion", "ktfmt"})
public final class Tokenizer
extends KtTreeVisitorVoid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileText;
    @NotNull
    private final KtFile file;
    @NotNull
    private final List<KotlinTok> toks;
    private int index;
    @NotNull
    private static final Pattern WHITESPACE_NEWLINE_REGEX;

    public Tokenizer(@NotNull String fileText, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileText = fileText;
        this.file = file;
        this.toks = new ArrayList();
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    @NotNull
    public final List<KotlinTok> getToks() {
        return this.toks;
    }

    public final int getIndex() {
        return this.index;
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int startIndex = PsiUtilsKt.getStartOffset((PsiElement)element);
        int endIndex = PsiUtilsKt.getEndOffset((PsiElement)element);
        String elementText = element.getText();
        String string = this.fileText.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String originalText = string;
        PsiElement psiElement = element;
        if (psiElement instanceof PsiComment) {
            Intrinsics.checkNotNullExpressionValue((Object)elementText, (String)"elementText");
            KtToken ktToken = KtTokens.EOF;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
            this.toks.add(new KotlinTok(this.index, originalText, elementText, startIndex, 0, false, ktToken));
            int n = this.index;
            this.index = n + 1;
            return;
        }
        if (psiElement instanceof KtStringTemplateExpression) {
            String string2 = WhitespaceTombstones.INSTANCE.replaceTrailingWhitespaceWithTombstone(originalText);
            Intrinsics.checkNotNullExpressionValue((Object)elementText, (String)"elementText");
            KtToken ktToken = KtTokens.EOF;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
            this.toks.add(new KotlinTok(this.index, string2, elementText, startIndex, 0, true, ktToken));
            int n = this.index;
            this.index = n + 1;
            return;
        }
        if (psiElement instanceof LeafPsiElement) {
            if (element instanceof PsiWhiteSpace) {
                Matcher matcher = WHITESPACE_NEWLINE_REGEX.matcher(elementText);
                while (matcher.find()) {
                    String text = matcher.group();
                    String string3 = this.fileText.substring(startIndex + matcher.start(), startIndex + matcher.end());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                    int n = startIndex + matcher.start();
                    KtToken ktToken = KtTokens.EOF;
                    Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
                    this.toks.add(new KotlinTok(-1, string3, text, n, 0, false, ktToken));
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)elementText, (String)"elementText");
                KtToken ktToken = KtTokens.EOF;
                Intrinsics.checkNotNullExpressionValue((Object)ktToken, (String)"EOF");
                this.toks.add(new KotlinTok(this.index, originalText, elementText, startIndex, 0, true, ktToken));
                int n = this.index;
                this.index = n + 1;
            }
        }
        super.visitElement(element);
    }

    static {
        Pattern pattern = Pattern.compile("\\R|( )+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"\\\\R|( )+\")");
        WHITESPACE_NEWLINE_REGEX = pattern;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/ktfmt/format/Tokenizer$Companion;", "", "()V", "WHITESPACE_NEWLINE_REGEX", "Ljava/util/regex/Pattern;", "ktfmt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

