/*
 * Copyright (c) Tor Norbye.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.facebook.ktfmt.kdoc

/**
 * A list of paragraphs. Each paragraph should start on a new line and end with a newline. In
 * addition, if a paragraph is marked with "separate=true", we'll insert an extra blank line in
 * front of it.
 */
class ParagraphList(private val paragraphs: List<Paragraph>) : Iterable<Paragraph> {
  fun isSingleParagraph() = paragraphs.size <= 1

  override fun iterator(): Iterator<Paragraph> = paragraphs.iterator()

  override fun toString(): String = paragraphs.joinToString { it.content }
}
