/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.cli;

import com.facebook.ktfmt.cli.ParseResult;
import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.FormattingOptions;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003JC\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/facebook/ktfmt/cli/ParsedArgs;", "", "fileNames", "", "", "formattingOptions", "Lcom/facebook/ktfmt/format/FormattingOptions;", "dryRun", "", "setExitIfChanged", "stdinName", "(Ljava/util/List;Lcom/facebook/ktfmt/format/FormattingOptions;ZZLjava/lang/String;)V", "getDryRun", "()Z", "getFileNames", "()Ljava/util/List;", "getFormattingOptions", "()Lcom/facebook/ktfmt/format/FormattingOptions;", "getSetExitIfChanged", "getStdinName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "ktfmt"})
public final class ParsedArgs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> fileNames;
    @NotNull
    private final FormattingOptions formattingOptions;
    private final boolean dryRun;
    private final boolean setExitIfChanged;
    @Nullable
    private final String stdinName;
    @NotNull
    private static final String HELP_TEXT = "ktfmt - command line Kotlin source code pretty-printer\n\nUsage:\n  ktfmt [OPTIONS] <File1.kt> <File2.kt> ...\n  ktfmt @ARGFILE\n\nktfmt formats Kotlin source code files in-place, reporting for each file whether the\nformatting succeeded or failed on standard error. If none of the style options are\npassed, Meta's style is used.\n\nAlternatively, ktfmt can read Kotlin source code from standard input and write the \nformatted result on standard output.\n\nExample:\n     $ ktfmt --kotlinlang-style Main.kt src/Parser.kt\n     Done formatting Main.kt\n     Error formatting src/Parser.kt: @@@ERROR@@@; skipping.\n    \nCommands options:\n  -h, --help                        Show this help message\n  -n, --dry-run                     Don't write to files, only report files which \n                                        would have changed\n  --meta-style                      Use 2-space block indenting (default)\n  --google-style                    Google internal style (2 spaces)\n  --kotlinlang-style                Kotlin language guidelines style (4 spaces)\n  --stdin-name=<name>               Name to report when formatting code from stdin\n  --set-exit-if-changed             Sets exit code to 1 if any input file was not \n                                        formatted/touched\n  --do-not-remove-unused-imports    Leaves all imports in place, even if not used\n  \nARGFILE:\n  If the only argument begins with '@', the remainder of the argument is treated\n  as the name of a file to read options and arguments from, one per line.\n  \n  e.g.\n      $ cat arg-file.txt\n      --google-style\n      -n\n      File1.kt\n      File2.kt\n      $ ktfmt @arg-file1.txt\n      Done formatting File1.kt\n      Done formatting File2.kt\n";

    public ParsedArgs(@NotNull List<String> fileNames, @NotNull FormattingOptions formattingOptions, boolean dryRun, boolean setExitIfChanged, @Nullable String stdinName) {
        Intrinsics.checkNotNullParameter(fileNames, (String)"fileNames");
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
        this.fileNames = fileNames;
        this.formattingOptions = formattingOptions;
        this.dryRun = dryRun;
        this.setExitIfChanged = setExitIfChanged;
        this.stdinName = stdinName;
    }

    @NotNull
    public final List<String> getFileNames() {
        return this.fileNames;
    }

    @NotNull
    public final FormattingOptions getFormattingOptions() {
        return this.formattingOptions;
    }

    public final boolean getDryRun() {
        return this.dryRun;
    }

    public final boolean getSetExitIfChanged() {
        return this.setExitIfChanged;
    }

    @Nullable
    public final String getStdinName() {
        return this.stdinName;
    }

    @NotNull
    public final List<String> component1() {
        return this.fileNames;
    }

    @NotNull
    public final FormattingOptions component2() {
        return this.formattingOptions;
    }

    public final boolean component3() {
        return this.dryRun;
    }

    public final boolean component4() {
        return this.setExitIfChanged;
    }

    @Nullable
    public final String component5() {
        return this.stdinName;
    }

    @NotNull
    public final ParsedArgs copy(@NotNull List<String> fileNames, @NotNull FormattingOptions formattingOptions, boolean dryRun, boolean setExitIfChanged, @Nullable String stdinName) {
        Intrinsics.checkNotNullParameter(fileNames, (String)"fileNames");
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
        return new ParsedArgs(fileNames, formattingOptions, dryRun, setExitIfChanged, stdinName);
    }

    public static /* synthetic */ ParsedArgs copy$default(ParsedArgs parsedArgs, List list, FormattingOptions formattingOptions, boolean bl, boolean bl2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = parsedArgs.fileNames;
        }
        if ((n & 2) != 0) {
            formattingOptions = parsedArgs.formattingOptions;
        }
        if ((n & 4) != 0) {
            bl = parsedArgs.dryRun;
        }
        if ((n & 8) != 0) {
            bl2 = parsedArgs.setExitIfChanged;
        }
        if ((n & 0x10) != 0) {
            string = parsedArgs.stdinName;
        }
        return parsedArgs.copy(list, formattingOptions, bl, bl2, string);
    }

    @NotNull
    public String toString() {
        return "ParsedArgs(fileNames=" + this.fileNames + ", formattingOptions=" + this.formattingOptions + ", dryRun=" + this.dryRun + ", setExitIfChanged=" + this.setExitIfChanged + ", stdinName=" + this.stdinName + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.fileNames).hashCode();
        result2 = result2 * 31 + this.formattingOptions.hashCode();
        int n = this.dryRun ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        int n2 = this.setExitIfChanged ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        result2 = result2 * 31 + (this.stdinName == null ? 0 : this.stdinName.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsedArgs)) {
            return false;
        }
        ParsedArgs parsedArgs = (ParsedArgs)other;
        if (!Intrinsics.areEqual(this.fileNames, parsedArgs.fileNames)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.formattingOptions, (Object)parsedArgs.formattingOptions)) {
            return false;
        }
        if (this.dryRun != parsedArgs.dryRun) {
            return false;
        }
        if (this.setExitIfChanged != parsedArgs.setExitIfChanged) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stdinName, (Object)parsedArgs.stdinName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u001b\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\r\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u000f\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/facebook/ktfmt/cli/ParsedArgs$Companion;", "", "()V", "HELP_TEXT", "", "getHELP_TEXT", "()Ljava/lang/String;", "parseKeyValueArg", "key", "arg", "parseOptions", "Lcom/facebook/ktfmt/cli/ParseResult;", "args", "", "([Ljava/lang/String;)Lcom/facebook/ktfmt/cli/ParseResult;", "processArgs", "ktfmt"})
    @SourceDebugExtension(value={"SMAP\nParsedArgs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParsedArgs.kt\ncom/facebook/ktfmt/cli/ParsedArgs$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n37#2,2:166\n1#3:168\n*S KotlinDebug\n*F\n+ 1 ParsedArgs.kt\ncom/facebook/ktfmt/cli/ParsedArgs$Companion\n*L\n44#1:166,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParseResult processArgs(@NotNull String[] args) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length == 1 && StringsKt.startsWith$default((String)args[0], (String)"@", (boolean)false, (int)2, null)) {
                String string = args[0].substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                File file = new File(string);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Collection $this$toTypedArray$iv = FilesKt.readLines((File)file, (Charset)charset);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            } else {
                stringArray = args;
            }
            String[] arguments = stringArray;
            return this.parseOptions(arguments);
        }

        @NotNull
        public final String getHELP_TEXT() {
            return HELP_TEXT;
        }

        @NotNull
        public final ParseResult parseOptions(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            List fileNames = new ArrayList();
            FormattingOptions formattingOptions = Formatter.META_FORMAT;
            boolean dryRun = false;
            boolean setExitIfChanged = false;
            boolean removeUnusedImports = true;
            String stdinName = null;
            if (ArraysKt.contains((Object[])args, (Object)"--help") || ArraysKt.contains((Object[])args, (Object)"-h")) {
                return new ParseResult.ShowMessage(this.getHELP_TEXT());
            }
            for (String arg : args) {
                if (Intrinsics.areEqual((Object)arg, (Object)"--meta-style")) {
                    formattingOptions = Formatter.META_FORMAT;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)"--google-style")) {
                    formattingOptions = Formatter.GOOGLE_FORMAT;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)"--kotlinlang-style")) {
                    formattingOptions = Formatter.KOTLINLANG_FORMAT;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)"--dry-run") || Intrinsics.areEqual((Object)arg, (Object)"-n")) {
                    dryRun = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)"--set-exit-if-changed")) {
                    setExitIfChanged = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)"--do-not-remove-unused-imports")) {
                    removeUnusedImports = false;
                    continue;
                }
                if (StringsKt.startsWith$default((String)arg, (String)"--stdin-name=", (boolean)false, (int)2, null)) {
                    if (this.parseKeyValueArg("--stdin-name", arg) != null) continue;
                    return new ParseResult.Error("Found option '" + arg + "', expected '--stdin-name=<value>'");
                }
                if (StringsKt.startsWith$default((String)arg, (String)"--", (boolean)false, (int)2, null)) {
                    return new ParseResult.Error("Unexpected option: " + arg);
                }
                if (StringsKt.startsWith$default((String)arg, (String)"@", (boolean)false, (int)2, null)) {
                    return new ParseResult.Error("Unexpected option: " + arg);
                }
                fileNames.add(arg);
            }
            if (fileNames.contains("-")) {
                if (fileNames.size() > 1) {
                    List filesExceptStdin = CollectionsKt.minus((Iterable)fileNames, (Object)"-");
                    return new ParseResult.Error("Cannot read from stdin and files in same run. Found stdin specifier '-' and files " + CollectionsKt.joinToString$default((Iterable)filesExceptStdin, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ' ');
                }
            } else if (stdinName != null) {
                return new ParseResult.Error("--stdin-name can only be specified when reading from stdin");
            }
            return new ParseResult.Ok(new ParsedArgs(fileNames, FormattingOptions.copy$default(formattingOptions, 0, 0, 0, false, removeUnusedImports, false, 47, null), dryRun, setExitIfChanged, stdinName));
        }

        private final String parseKeyValueArg(String key, String arg) {
            Object object = new char[]{'='};
            List parts = StringsKt.split$default((CharSequence)arg, (char[])object, (boolean)false, (int)2, (int)2, null);
            object = parts.get(1);
            String it = (String)object;
            boolean bl = false;
            return (String)((char[])(Intrinsics.areEqual(parts.get(0), (Object)key) || parts.size() == 2 ? object : null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

